/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.forms;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.forms.JunAbstractFormTriangulation;
import jp.co.sra.jun.geometry.forms.JunForm2dRegion;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessor;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

public class JunFormTriangulation1
extends JunAbstractFormTriangulation {
    protected Jun2dTriangle[] normalDelaunayTriangles;
    protected Jun2dTriangle[] insideTriangles;
    protected Jun2dTriangle[] outsideTriangles;

    public JunFormTriangulation1() {
    }

    public JunFormTriangulation1(Jun2dPoint[] jun2dPointArray) {
        super(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.normalDelaunayTriangles = null;
        this.insideTriangles = null;
        this.outsideTriangles = null;
    }

    public void points_(Jun2dPoint[] jun2dPointArray) {
        super.points_(jun2dPointArray);
        this.normalDelaunayTriangles = null;
        this.insideTriangles = null;
        this.outsideTriangles = null;
    }

    public Jun2dTriangle[] triangles() {
        return this.trianglesInterim_(null);
    }

    public Jun2dTriangle[] trianglesInterim_(StBlockClosure stBlockClosure) {
        if (this.pointsWithoutLast().length < 3) {
            return new Jun2dTriangle[0];
        }
        return this.normalDelaunayTrianglesInterim_(stBlockClosure);
    }

    protected Jun2dTriangle[] normalDelaunayTrianglesInterim_(StBlockClosure stBlockClosure) {
        if (this.normalDelaunayTriangles == null) {
            Jun2dTriangle[] jun2dTriangleArray = null;
            if (stBlockClosure == null) {
                JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(this.pointsWithoutLast());
                junVoronoi2dProcessor.compute();
                jun2dTriangleArray = this._triangles(junVoronoi2dProcessor.triangles());
            } else {
                stBlockClosure.value_value_value_((Object)new Jun2dTriangle[0], null, null);
                ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
                Jun2dPoint[] jun2dPointArray = this.pointsWithoutLast();
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    arrayList.add(jun2dPointArray[i]);
                    if (i < 2) continue;
                    JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(arrayList.toArray(new Jun2dPoint[arrayList.size()]));
                    junVoronoi2dProcessor.compute();
                    jun2dTriangleArray = this._triangles(junVoronoi2dProcessor.triangles());
                    stBlockClosure.value_value_value_((Object)jun2dTriangleArray, null, null);
                }
            }
            this.normalDelaunayTriangles = jun2dTriangleArray;
            this.computeInsideAndOutsideTriangles_interim_(this.normalDelaunayTriangles, stBlockClosure);
        }
        return this.insideTriangles;
    }

    private void computeInsideAndOutsideTriangles_interim_(Jun2dTriangle[] jun2dTriangleArray, StBlockClosure stBlockClosure) {
        ArrayList<Jun2dTriangle> arrayList = new ArrayList<Jun2dTriangle>();
        ArrayList<Jun2dTriangle> arrayList2 = new ArrayList<Jun2dTriangle>();
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dTriangleArray[i].p1();
            Jun2dPoint jun2dPoint2 = jun2dTriangleArray[i].p2();
            Jun2dPoint jun2dPoint3 = jun2dTriangleArray[i].p3();
            Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, jun2dPoint2);
            Jun2dLine jun2dLine2 = new Jun2dLine(jun2dPoint2, jun2dPoint3);
            Jun2dLine jun2dLine3 = new Jun2dLine(jun2dPoint3, jun2dPoint);
            Jun2dLine[] jun2dLineArray = this.segments();
            for (int j = 0; j < jun2dLineArray.length; ++j) {
                if (jun2dLine != null && (jun2dLineArray[j].equals((Object)jun2dLine) || jun2dLineArray[j].equals((Object)jun2dLine.reversed()))) {
                    jun2dLine = null;
                }
                if (jun2dLine2 != null && (jun2dLineArray[j].equals((Object)jun2dLine2) || jun2dLineArray[j].equals((Object)jun2dLine2.reversed()))) {
                    jun2dLine2 = null;
                }
                if (jun2dLine3 == null || !jun2dLineArray[j].equals((Object)jun2dLine3) && !jun2dLineArray[j].equals((Object)jun2dLine3.reversed())) continue;
                jun2dLine3 = null;
            }
            if (!(jun2dLine != null && !this.containsLineSegment_(jun2dLine) || jun2dLine2 != null && !this.containsLineSegment_(jun2dLine2) || jun2dLine3 != null && !this.containsLineSegment_(jun2dLine3))) {
                arrayList.add(jun2dTriangleArray[i]);
            } else {
                arrayList2.add(jun2dTriangleArray[i]);
            }
            if (stBlockClosure == null) continue;
            stBlockClosure.value_value_value_((Object)jun2dTriangleArray, (Object)arrayList.toArray(new Jun2dTriangle[arrayList.size()]), (Object)arrayList2.toArray(new Jun2dTriangle[arrayList2.size()]));
        }
        this.insideTriangles = arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
        this.outsideTriangles = arrayList2.toArray(new Jun2dTriangle[arrayList2.size()]);
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.displayOn_at_triangles_color_insides_color_outsides_color_(graphics, point, this.triangles(), Color.red, null, Color.green, null, Color.blue);
    }

    public void displayOn_triangles_(Graphics graphics, Jun2dTriangle[] jun2dTriangleArray) {
        this.displayOn_at_triangles_color_insides_color_outsides_color_(graphics, new Point(0, 0), jun2dTriangleArray, Color.red, null, null, null, null);
    }

    public void displayOn_triangles_insides_outsides_(Graphics2D graphics2D, Jun2dTriangle[] jun2dTriangleArray, Jun2dTriangle[] jun2dTriangleArray2, Jun2dTriangle[] jun2dTriangleArray3) {
        this.displayOn_at_triangles_color_insides_color_outsides_color_(graphics2D, new Point(0, 0), jun2dTriangleArray, Color.red, jun2dTriangleArray2, Color.green, jun2dTriangleArray3, Color.blue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void displayOn_at_triangles_color_insides_color_outsides_color_(Graphics graphics, Point point, Jun2dTriangle[] jun2dTriangleArray, Color color, Jun2dTriangle[] jun2dTriangleArray2, Color color2, Jun2dTriangle[] jun2dTriangleArray3, Color color3) {
        Rectangle rectangle = this.boundingBox().asRectangle();
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        Graphics2D graphics2D = (Graphics2D)graphics;
        try {
            GeneralPath generalPath;
            JunForm2dRegion junForm2dRegion;
            int n3;
            graphics2D.translate(n, n2);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2D.setColor(Color.gray);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            for (n3 = 0; n3 < jun2dTriangleArray.length; ++n3) {
                junForm2dRegion = new JunForm2dRegion(jun2dTriangleArray[n3].asPointArray());
                generalPath = junForm2dRegion.toGeneralPath();
                graphics2D.setColor(StColorValue.Blend((Color)color, (Color)Color.white));
                graphics2D.fill(generalPath);
                graphics2D.setColor(color);
                graphics2D.draw(generalPath);
            }
            if (jun2dTriangleArray2 != null) {
                for (n3 = 0; n3 < jun2dTriangleArray2.length; ++n3) {
                    junForm2dRegion = new JunForm2dRegion(jun2dTriangleArray2[n3].asPointArray());
                    generalPath = junForm2dRegion.toGeneralPath();
                    graphics2D.setColor(StColorValue.Blend((Color)color2, (Color)Color.white));
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(color2);
                    graphics2D.draw(generalPath);
                }
            }
            if (jun2dTriangleArray3 != null) {
                for (n3 = 0; n3 < jun2dTriangleArray3.length; ++n3) {
                    junForm2dRegion = new JunForm2dRegion(jun2dTriangleArray3[n3].asPointArray());
                    generalPath = junForm2dRegion.toGeneralPath();
                    graphics2D.setColor(StColorValue.Blend((Color)color3, (Color)Color.white));
                    graphics2D.fill(generalPath);
                    graphics2D.setColor(color3);
                    graphics2D.draw(generalPath);
                }
            }
            graphics2D.setColor(Color.black);
            graphics2D.draw(this.toGeneralPath());
        }
        finally {
            graphics2D.translate(-n, -n2);
        }
    }

    private Jun2dTriangle[] _triangles(Jun2dPoint[][] jun2dPointArray) {
        if (jun2dPointArray == null) {
            return null;
        }
        Jun2dTriangle[] jun2dTriangleArray = new Jun2dTriangle[jun2dPointArray.length];
        for (int i = 0; i < jun2dTriangleArray.length; ++i) {
            jun2dTriangleArray[i] = new Jun2dTriangle(jun2dPointArray[i][0], jun2dPointArray[i][1], jun2dPointArray[i][2]);
        }
        return jun2dTriangleArray;
    }
}

