/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun2dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessor;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

public class Jun2dPolygon
extends JunGeometry {
    protected Jun2dPoint[] points;
    protected double signedArea = Double.NaN;
    protected Jun2dBoundingBox bounds;

    public Jun2dPolygon(Jun2dPoint[] jun2dPointArray) {
        this.setPoints_(jun2dPointArray);
    }

    public Jun2dPolygon(Collection collection) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[collection.size()];
        collection.toArray(jun2dPointArray);
        this.setPoints_(jun2dPointArray);
    }

    public static double AreaForPoints_(Jun2dPoint[] jun2dPointArray) {
        return Math.abs(Jun2dPolygon.SignedAreaForPoints_(jun2dPointArray));
    }

    public static double AreaForTriangle_and_and_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        return Math.abs(Jun2dPolygon.SignedAreaForTriangle_and_and_(jun2dPoint, jun2dPoint2, jun2dPoint3));
    }

    public static double SignedAreaForPoints_(Jun2dPoint[] jun2dPointArray) {
        int n = jun2dPointArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Jun2dPoint jun2dPoint = jun2dPointArray[i];
            Jun2dPoint jun2dPoint2 = jun2dPointArray[(i + 1) % n];
            d += (jun2dPoint.y() + jun2dPoint2.y()) * (jun2dPoint.x() - jun2dPoint2.x());
        }
        return d / 2.0;
    }

    public static double SignedAreaForPoints_(Jun3dPoint[] jun3dPointArray) {
        int n = jun3dPointArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Jun3dPoint jun3dPoint = jun3dPointArray[i];
            Jun3dPoint jun3dPoint2 = jun3dPointArray[(i + 1) % n];
            d += (jun3dPoint.y() + jun3dPoint2.y()) * (jun3dPoint.x() - jun3dPoint2.x());
        }
        return d / 2.0;
    }

    public static double SignedAreaForTriangle_and_and_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2, Jun2dPoint jun2dPoint3) {
        return ((jun2dPoint.y() + jun2dPoint2.y()) * (jun2dPoint.x() - jun2dPoint2.x()) + (jun2dPoint2.y() + jun2dPoint3.y()) * (jun2dPoint2.x() - jun2dPoint3.x()) + (jun2dPoint3.y() + jun2dPoint.y()) * (jun2dPoint3.x() - jun2dPoint.x())) / 2.0;
    }

    protected static boolean IsConsistentPolygonFromPoints_(Jun2dPoint[] jun2dPointArray) {
        final Jun2dPoint[] jun2dPointArray2 = new Jun2dPolygon(jun2dPointArray).asPositivePolygon().points();
        final int n = jun2dPointArray2.length;
        StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint;
                Jun2dPoint jun2dPoint2;
                int n2 = ((Number)object).intValue();
                Jun2dPoint jun2dPoint3 = jun2dPointArray2[(n2 - 1) % n];
                return new Boolean(Jun2dPolygon.SignedAreaForTriangle_and_and_(jun2dPoint3, jun2dPoint2 = jun2dPointArray2[n2], jun2dPoint = jun2dPointArray2[(n2 + 1) % n]) + 1.0E-12 <= 0.0);
            }
        };
        StBlockClosure stBlockClosure2 = new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint;
                Jun2dPoint jun2dPoint2;
                int n2 = ((Number)object).intValue();
                Jun2dPoint jun2dPoint3 = jun2dPointArray2[(n2 - 1) % n];
                return new Boolean(Jun2dPolygon.SignedAreaForTriangle_and_and_(jun2dPoint3, jun2dPoint2 = jun2dPointArray2[n2], jun2dPoint = jun2dPointArray2[(n2 + 1) % n]) + 1.0E-12 >= 0.0);
            }
        };
        StBlockClosure stBlockClosure3 = new StBlockClosure(){

            public Object value_(Object object) {
                int n = ((Number)object).intValue();
                Jun2dPoint jun2dPoint = jun2dPointArray2[n];
                ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
                for (int i = 0; i < jun2dPointArray2.length; ++i) {
                    if (jun2dPoint.equals((Object)jun2dPointArray2[i])) continue;
                    arrayList.add(jun2dPointArray2[i]);
                }
                Jun2dPoint[] jun2dPointArray = new Jun2dPoint[arrayList.size()];
                arrayList.toArray(jun2dPointArray);
                return new Boolean(Jun2dPolygon.PolygonFromPoints_containsPoint_(jun2dPointArray, jun2dPoint));
            }
        };
        for (int i = 0; i < n; ++i) {
            Integer n2 = new Integer(i);
            boolean bl = (Boolean)stBlockClosure3.value_((Object)n2);
            if (((Boolean)stBlockClosure.value_((Object)n2)).booleanValue() && !bl) {
                return false;
            }
            if (!((Boolean)stBlockClosure2.value_((Object)n2)).booleanValue() || !bl) continue;
            return false;
        }
        return true;
    }

    protected static boolean PolygonFromPoints_containsPoint_(Jun2dPoint[] jun2dPointArray, Jun2dPoint jun2dPoint) {
        int n = jun2dPointArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            Jun2dPoint jun2dPoint2 = jun2dPointArray[i];
            Jun2dPoint jun2dPoint3 = jun2dPointArray[(i + 1) % n];
            d += jun2dPoint.angleBetween_and_(jun2dPoint2, jun2dPoint3).rad();
        }
        return Math.abs(d) > 0.7853981633974483;
    }

    public double area() {
        return Math.abs(this.signedArea());
    }

    public Jun2dPoint pointAt_(int n) {
        return this.points[n];
    }

    public Jun2dPoint[] points() {
        return this.points;
    }

    public int pointsSize() {
        return this.points.length;
    }

    public double signedArea() {
        if (Double.isNaN(this.signedArea)) {
            this.signedArea = Jun2dPolygon.SignedAreaForPoints_(this.points);
        }
        return this.signedArea;
    }

    public Jun2dBoundingBox boundingBox() {
        if (this.bounds == null) {
            Jun2dPoint jun2dPoint = this.points[0];
            Jun2dPoint jun2dPoint2 = this.points[0];
            for (int i = 1; i < this.points.length; ++i) {
                jun2dPoint = jun2dPoint.min_(this.points[i]);
                jun2dPoint2 = jun2dPoint2.max_(this.points[i]);
            }
            this.bounds = Jun2dBoundingBox.Origin_corner_(jun2dPoint, jun2dPoint2);
        }
        return this.bounds;
    }

    public Jun2dPoint extent() {
        return this.boundingBox().extent();
    }

    public double height() {
        return this.extent().y();
    }

    public double width() {
        return this.extent().x();
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolygon jun2dPolygon = (Jun2dPolygon)((Object)object);
        int n = this.pointsSize();
        if (n != jun2dPolygon.pointsSize()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.pointAt_(i).equal_((Object)jun2dPolygon.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun2dPolygon jun2dPolygon = (Jun2dPolygon)((Object)object);
        int n = this.pointsSize();
        if (n != jun2dPolygon.pointsSize()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.pointAt_(i).equals((Object)jun2dPolygon.pointAt_(i))) continue;
            return false;
        }
        return true;
    }

    public Jun2dPolygon[] asArrayOfConvexPolygons() {
        final ArrayList arrayList = new ArrayList();
        this.asConvexPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new Jun2dPolygon[arrayList.size()]);
    }

    public Jun2dLine[] asArrayOfLines() {
        return this.asArrayOf2dLines();
    }

    public Jun2dLine[] asArrayOf2dLines() {
        Jun2dPoint[] jun2dPointArray = this.points();
        boolean bl = jun2dPointArray[0].equal_((Object)jun2dPointArray[jun2dPointArray.length - 1]);
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[bl ? jun2dPointArray.length : jun2dPointArray.length + 1];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray2[i] = new Jun2dPoint(jun2dPointArray[i]);
        }
        if (!bl) {
            jun2dPointArray2[jun2dPointArray2.length - 1] = new Jun2dPoint(jun2dPointArray[0]);
        }
        Jun2dPolyline jun2dPolyline = new Jun2dPolyline(jun2dPointArray2);
        return jun2dPolyline.asArrayOfLines();
    }

    public Jun2dPoint[] asArrayOfPoints() {
        return this.points();
    }

    public JunOpenGL3dObject asJunOpenGL3dObject() {
        final ArrayList arrayList = new ArrayList();
        this.asJunOpenGL3dObjectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        JunOpenGL3dObject junOpenGL3dObject = arrayList.size() == 1 ? (JunOpenGL3dObject)((Object)arrayList.get(0)) : new JunOpenGL3dCompoundObject(arrayList);
        junOpenGL3dObject.objectsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                ((JunOpenGL3dObject)((Object)object)).paint_alpha_(Jun2dPolygon.this.defaultColor(), Float.NaN);
                return null;
            }
        });
        return junOpenGL3dObject;
    }

    public Jun2dPolygon asNegativePolygon() {
        if (this.signedArea() <= 0.0) {
            return this;
        }
        return this.reversed();
    }

    public Jun2dPoint[] asPointArray() {
        return this.points();
    }

    public Jun2dPolygon asPositivePolygon() {
        if (this.signedArea() >= 0.0) {
            return this;
        }
        return this.reversed();
    }

    public Jun2dTriangle[] asTriangles() {
        final ArrayList arrayList = new ArrayList();
        this.asTrianglesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                arrayList.add(object);
                return null;
            }
        });
        return arrayList.toArray(new Jun2dTriangle[arrayList.size()]);
    }

    public Jun2dPolygon reversed() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = this.points[this.points.length - i - 1];
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    public Jun2dPolygon transposed() {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = new Jun2dPoint(this.points[i].y(), this.points[i].x());
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    public void displayOn_(Graphics graphics) {
        int n = this.pointsSize();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)this.points[i].x();
            nArray2[i] = (int)this.points[i].y();
        }
        graphics.drawPolygon(new Polygon(nArray, nArray2, n));
    }

    public Object asConvexPolygonsDo_(final StBlockClosure stBlockClosure) {
        Object object;
        ArrayList<Object> arrayList;
        int n;
        double d;
        Jun2dPoint jun2dPoint;
        Jun2dPoint jun2dPoint2;
        int n2;
        int n3;
        Object object2;
        if (this.isNegative()) {
            return this.asPositivePolygon().asConvexPolygonsDo_(new StBlockClosure(){

                public Object value_(Object object) {
                    Jun2dPolygon jun2dPolygon = (Jun2dPolygon)((Object)object);
                    return stBlockClosure.value_((Object)jun2dPolygon.asNegativePolygon());
                }
            });
        }
        if (this.isConvex()) {
            return stBlockClosure.value_((Object)this);
        }
        int n4 = this.pointsSize();
        int n5 = this.indexOfFirstConcaveVertex();
        Jun2dPoint jun2dPoint3 = this.pointAt_(n5);
        Jun2dPoint jun2dPoint4 = jun2dPoint3.minus_(this.pointAt_((n5 - 1 + n4) % n4)).unitVector();
        if (Math.abs((jun2dPoint4 = jun2dPoint4.plus_(jun2dPoint3.minus_(this.pointAt_((n5 + 1) % n4)).unitVector())).x()) > Math.abs(jun2dPoint4.y())) {
            if (jun2dPoint4.x() > 0.0) {
                object2 = null;
                n3 = -1;
                for (n2 = n5; n2 <= n5 + n4 - 3; ++n2) {
                    jun2dPoint2 = this.pointAt_((n2 + 1) % n4);
                    jun2dPoint = this.pointAt_((n2 + 2) % n4);
                    if (!(jun2dPoint2.y() < jun2dPoint.y()) || !(jun2dPoint2.y() < jun2dPoint3.y()) || !(jun2dPoint.y() >= jun2dPoint3.y())) continue;
                    d = (jun2dPoint3.y() - jun2dPoint2.y()) * (jun2dPoint.x() - jun2dPoint2.x()) / (jun2dPoint.y() - jun2dPoint2.y()) + jun2dPoint2.x();
                    if (!(jun2dPoint3.x() < d) || object2 != null && !(d <= ((Jun2dPoint)((Object)object2)).x())) continue;
                    object2 = new Jun2dPoint(d, jun2dPoint3.y());
                    n3 = (n2 + 1) % n4;
                }
                if (n3 < 0) {
                    throw SmalltalkException.Error((String)"internal error");
                }
                n = n3;
                arrayList = object2;
            } else {
                object2 = null;
                n3 = -1;
                for (n2 = n5; n2 <= n5 + n4 - 3; ++n2) {
                    jun2dPoint2 = this.pointAt_((n2 + 1) % n4);
                    jun2dPoint = this.pointAt_((n2 + 2) % n4);
                    if (!(jun2dPoint2.y() > jun2dPoint.y()) || !(jun2dPoint2.y() > jun2dPoint3.y()) || !(jun2dPoint.y() <= jun2dPoint3.y())) continue;
                    d = (jun2dPoint3.y() - jun2dPoint2.y()) * (jun2dPoint.x() - jun2dPoint2.x()) / (jun2dPoint.y() - jun2dPoint2.y()) + jun2dPoint2.x();
                    if (!(jun2dPoint3.x() > d) || object2 != null && !(d >= ((Jun2dPoint)((Object)object2)).x())) continue;
                    object2 = new Jun2dPoint(d, jun2dPoint3.y());
                    n3 = (n2 + 1) % n4;
                }
                if (n3 < 0) {
                    throw SmalltalkException.Error((String)"internal error");
                }
                n = n3;
                arrayList = object2;
            }
        } else if (jun2dPoint4.y() > 0.0) {
            object2 = null;
            n3 = -1;
            for (n2 = n5; n2 <= n5 + n4 - 3; ++n2) {
                jun2dPoint2 = this.pointAt_((n2 + 1) % n4);
                jun2dPoint = this.pointAt_((n2 + 2) % n4);
                if (!(jun2dPoint2.x() > jun2dPoint.x()) || !(jun2dPoint2.x() > jun2dPoint3.x()) || !(jun2dPoint.x() <= jun2dPoint3.x())) continue;
                d = (jun2dPoint3.x() - jun2dPoint2.x()) * (jun2dPoint.y() - jun2dPoint2.y()) / (jun2dPoint.x() - jun2dPoint2.x()) + jun2dPoint2.y();
                if (!(jun2dPoint3.y() < d) || object2 != null && !(d <= ((Jun2dPoint)((Object)object2)).y())) continue;
                object2 = new Jun2dPoint(jun2dPoint3.x(), d);
                n3 = (n2 + 1) % n4;
            }
            if (n3 < 0) {
                throw SmalltalkException.Error((String)"internal error");
            }
            n = n3;
            arrayList = object2;
        } else {
            object2 = null;
            n3 = -1;
            for (n2 = n5; n2 <= n5 + n4 - 3; ++n2) {
                jun2dPoint2 = this.pointAt_((n2 + 1) % n4);
                jun2dPoint = this.pointAt_((n2 + 2) % n4);
                if (!(jun2dPoint2.x() < jun2dPoint.x()) || !(jun2dPoint2.x() < jun2dPoint3.x()) || !(jun2dPoint.x() >= jun2dPoint3.x())) continue;
                d = (jun2dPoint3.x() - jun2dPoint2.x()) * (jun2dPoint.y() - jun2dPoint2.y()) / (jun2dPoint.x() - jun2dPoint2.x()) + jun2dPoint2.y();
                if (!(jun2dPoint3.y() > d) || object2 != null && !(d >= ((Jun2dPoint)((Object)object2)).y())) continue;
                object2 = new Jun2dPoint(jun2dPoint3.x(), d);
                n3 = (n2 + 1) % n4;
            }
            if (n3 < 0) {
                throw SmalltalkException.Error((String)"internal error");
            }
            n = n3;
            arrayList = object2;
        }
        object2 = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        if (n < n5) {
            for (n2 = 0; n2 <= n; ++n2) {
                object2.add((Object)((Object)this.pointAt_(n2)));
            }
            if (!((Jun2dPoint)((Object)arrayList)).equals((Object)this.pointAt_(n))) {
                object2.add(arrayList);
            }
            for (n2 = n5; n2 < n4; ++n2) {
                object2.add((Object)((Object)this.pointAt_(n2)));
            }
            if (!((Jun2dPoint)((Object)arrayList)).equals((Object)this.pointAt_((n + 1) % n4))) {
                arrayList2.add(arrayList);
            }
            for (n2 = n + 1; n2 <= n5; ++n2) {
                arrayList2.add((Object)this.pointAt_(n2));
            }
        } else {
            for (n2 = 0; n2 <= n5; ++n2) {
                object2.add((Object)((Object)this.pointAt_(n2)));
            }
            if (!((Jun2dPoint)((Object)arrayList)).equals((Object)this.pointAt_((n + 1) % n4))) {
                object2.add(arrayList);
            }
            for (n2 = n + 1; n2 < n4; ++n2) {
                object2.add((Object)((Object)this.pointAt_(n2)));
            }
            for (n2 = n5; n2 <= n; ++n2) {
                arrayList2.add((Object)this.pointAt_(n2));
            }
            if (!((Jun2dPoint)((Object)arrayList)).equals((Object)this.pointAt_(n))) {
                arrayList2.add(arrayList);
            }
        }
        if ((object = new Jun2dPolygon((Collection)object2).asConvexPolygonsDo_(stBlockClosure)) != null) {
            return object;
        }
        object = new Jun2dPolygon(arrayList2).asConvexPolygonsDo_(stBlockClosure);
        if (object != null) {
            return object;
        }
        return null;
    }

    public Object asJunOpenGL3dObjectsDo_(final StBlockClosure stBlockClosure) {
        return this.asConvexPolygonsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPolygon jun2dPolygon = (Jun2dPolygon)((Object)object);
                Jun2dPoint[] jun2dPointArray = jun2dPolygon.points();
                Jun3dPoint[] jun3dPointArray = new Jun3dPoint[jun2dPointArray.length];
                for (int i = 0; i < jun2dPointArray.length; ++i) {
                    jun3dPointArray[i] = new Jun3dPoint(jun2dPointArray[i], 0.0);
                }
                return stBlockClosure.value_((Object)new JunOpenGL3dPolygon(jun3dPointArray));
            }
        });
    }

    public Object asTrianglesDo_(StBlockClosure stBlockClosure) {
        boolean bl = this.isPositive();
        JunVoronoi2dProcessor junVoronoi2dProcessor = new JunVoronoi2dProcessor(this.points());
        junVoronoi2dProcessor.compute();
        Jun2dPoint[][] jun2dPointArray = junVoronoi2dProcessor.triangles();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            Jun2dPoint jun2dPoint = jun2dPointArray[i][0];
            Jun2dPoint jun2dPoint2 = jun2dPointArray[i][1];
            Jun2dPoint jun2dPoint3 = jun2dPointArray[i][2];
            if (!(Jun2dPolygon.AreaForTriangle_and_and_(jun2dPoint, jun2dPoint2, jun2dPoint3) > Jun2dPolygon.Accuracy()) || !this.absContainsPoint_(jun2dPoint.plus_(jun2dPoint2).plus_(jun2dPoint3).dividedBy_(3.0))) continue;
            Jun2dPolygon jun2dPolygon = new Jun2dPolygon(jun2dPointArray[i]);
            stBlockClosure.value_((Object)jun2dPolygon.asPositivePolygon_(bl));
        }
        return null;
    }

    public Object edgesDo_(StBlockClosure stBlockClosure) {
        for (int i = 0; i < this.points.length; ++i) {
            Object object = stBlockClosure.value_value_((Object)this.points[i], (Object)this.points[(i + 1) % this.points.length]);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public Jun2dPoint nearestPointFromPoint_(Jun2dPoint jun2dPoint) {
        if (this.containsPoint_(jun2dPoint)) {
            return jun2dPoint;
        }
        return this.nearestPointOnEdgeFromPoint_(jun2dPoint);
    }

    public Jun2dPoint nearestPointOnEdgeFromPoint_(Jun2dPoint jun2dPoint) {
        final Jun2dPoint jun2dPoint2 = new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y());
        final StValueHolder stValueHolder = new StValueHolder(null);
        final StValueHolder stValueHolder2 = new StValueHolder(Double.POSITIVE_INFINITY);
        this.edgesDo_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                Jun2dPoint jun2dPoint22 = (Jun2dPoint)((Object)object2);
                if (!jun2dPoint.equals((Object)jun2dPoint22)) {
                    Jun2dLine jun2dLine = new Jun2dLine(jun2dPoint, jun2dPoint22);
                    Jun2dPoint jun2dPoint3 = jun2dLine.lineSegmentNearestPointFromPoint_(jun2dPoint2);
                    double d = jun2dPoint2.distance_(jun2dPoint3);
                    if (stValueHolder2._doubleValue() > d) {
                        stValueHolder2.value_(d);
                        stValueHolder.value_((Object)jun2dPoint3);
                    }
                }
                return null;
            }
        });
        return (Jun2dPoint)((Object)stValueHolder.value());
    }

    public boolean absContainsLineSegmentFrom_to_(final Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        final double d = jun2dPoint2.x() - jun2dPoint.x();
        final double d2 = jun2dPoint2.y() - jun2dPoint.y();
        final StBlockClosure stBlockClosure = new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                double d4;
                Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object);
                Jun2dPoint jun2dPoint2 = (Jun2dPoint)((Object)object2);
                double d22 = jun2dPoint2.x() - jun2dPoint3.x();
                double d3 = d22 * d2 - d * (d4 = jun2dPoint2.y() - jun2dPoint3.y());
                if (d3 < 1.0E-12) {
                    return null;
                }
                return new Double((d22 * (jun2dPoint3.y() - jun2dPoint.y()) - d4 * (jun2dPoint3.x() - jun2dPoint.x())) / d3);
            }
        };
        final TreeSet<Double> treeSet = new TreeSet<Double>(new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Number)object).doubleValue() <= ((Number)object2).doubleValue() ? -1 : 1;
            }
        });
        treeSet.add(new Double(0.0));
        treeSet.add(new Double(1.0));
        this.edgesDo_(new StBlockClosure(){

            public Object value_value_(Object object, Object object2) {
                Double d = (Double)stBlockClosure.value_value_(object, object2);
                if (d != null && 0.0 < d && d < 1.0) {
                    treeSet.add(d);
                }
                return null;
            }
        });
        if (treeSet.size() == 2) {
            return this.absContainsPoint_(jun2dPoint.plus_(jun2dPoint2).dividedBy_(2.0));
        }
        Double[] doubleArray = treeSet.toArray(new Double[treeSet.size()]);
        for (int i = 0; i < doubleArray.length - 1; ++i) {
            double d3 = doubleArray[i];
            double d4 = doubleArray[i + 1];
            double d5 = (d3 + d4) / 2.0;
            Jun2dPoint jun2dPoint3 = jun2dPoint2.minus_(jun2dPoint).multipliedBy_(d5).plus_(jun2dPoint);
            if (this.absContainsPoint_(jun2dPoint3)) continue;
            return false;
        }
        return true;
    }

    public boolean absContainsPoint_(Jun2dPoint jun2dPoint) {
        StValueHolder stValueHolder;
        double d;
        if (!this.boundingBox().containsOrTouchesPoint_(jun2dPoint)) {
            return false;
        }
        final double d2 = jun2dPoint.x();
        Object object = this.edgesDo_(new StBlockClosure(d = jun2dPoint.y(), stValueHolder = new StValueHolder(0)){
            private final /* synthetic */ double val$y;
            private final /* synthetic */ StValueHolder val$count;
            {
                this.val$y = d22;
                this.val$count = stValueHolder;
            }

            public Object value_value_(Object object, Object object2) {
                Jun2dPoint jun2dPoint;
                Jun2dPoint jun2dPoint2;
                Jun2dPoint jun2dPoint3 = (Jun2dPoint)((Object)object);
                Jun2dPoint jun2dPoint4 = (Jun2dPoint)((Object)object2);
                if (Math.abs(jun2dPoint3.x() - d2) < 1.0E-12 && Math.abs(jun2dPoint3.y() - this.val$y) < 1.0E-12) {
                    return Boolean.TRUE;
                }
                if (jun2dPoint3.x() <= jun2dPoint4.x()) {
                    jun2dPoint2 = jun2dPoint3;
                    jun2dPoint = jun2dPoint4;
                } else {
                    jun2dPoint2 = jun2dPoint4;
                    jun2dPoint = jun2dPoint3;
                }
                if (jun2dPoint2.x() <= d2 && d2 < jun2dPoint.x()) {
                    double d = (d2 - jun2dPoint2.x()) / (jun2dPoint.x() - jun2dPoint2.x()) * (jun2dPoint.y() - jun2dPoint2.y()) + jun2dPoint2.y();
                    if (Math.abs(d - this.val$y) < 1.0E-12) {
                        return Boolean.TRUE;
                    }
                    if (d >= this.val$y) {
                        this.val$count.value_(this.val$count._intValue() + 1);
                    }
                }
                return null;
            }
        });
        if (object != null) {
            return true;
        }
        return stValueHolder._intValue() % 2 == 1;
    }

    public boolean absIsConvex() {
        return this.asPositivePolygon().isConvex();
    }

    public boolean containsPoint_(Jun2dPoint jun2dPoint) {
        return this.absContainsPoint_(jun2dPoint) != this.isNegative();
    }

    public boolean is2d() {
        return true;
    }

    public boolean isConsistent() {
        return Jun2dPolygon.IsConsistentPolygonFromPoints_(this.points());
    }

    public boolean isConvex() {
        if (this.isPositive()) {
            return this.indexOfFirstConcaveVertex() < 0;
        }
        return this.asPositivePolygon().indexOfFirstConcaveVertex() < 0;
    }

    public boolean isNegative() {
        return !this.isPositive();
    }

    public boolean isPositive() {
        return this.signedArea() + 1.0E-12 >= 0.0;
    }

    public Jun2dPolygon rotatedBy_(JunAngle junAngle) {
        return this.transform_(Jun2dTransformation.Rotate_(junAngle));
    }

    public Jun2dPolygon scaledBy_(double d) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = this.points[i].scaledBy_(d);
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    public Jun2dPolygon scaledBy_(Jun2dPoint jun2dPoint) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = this.points[i].scaledBy_(jun2dPoint);
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    public Jun2dPolygon transform_(Jun2dTransformation jun2dTransformation) {
        Jun2dPoint[] jun2dPointArray = this.points();
        Jun2dPoint[] jun2dPointArray2 = new Jun2dPoint[jun2dPointArray.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray2[i] = jun2dTransformation.applyToPoint_(jun2dPointArray[i]);
        }
        return new Jun2dPolygon(jun2dPointArray2);
    }

    public Jun2dPolygon translatedBy_(double d) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = this.points[i].translatedBy_(d);
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    public Jun2dPolygon translatedBy_(Jun2dPoint jun2dPoint) {
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            jun2dPointArray[i] = this.points[i].translatedBy_(jun2dPoint);
        }
        return new Jun2dPolygon(jun2dPointArray);
    }

    protected Jun2dPolygon asPositivePolygon_(boolean bl) {
        return bl ? this.asPositivePolygon() : this.asNegativePolygon();
    }

    protected int indexOfFirstConcaveVertex() {
        int n = this.pointsSize();
        for (int i = 0; i < n; ++i) {
            Jun2dPoint jun2dPoint;
            Jun2dPoint jun2dPoint2;
            Jun2dPoint jun2dPoint3 = this.pointAt_((i - 1 + n) % n);
            if (!(Jun2dPolygon.SignedAreaForTriangle_and_and_(jun2dPoint3, jun2dPoint2 = this.pointAt_(i), jun2dPoint = this.pointAt_((i + 1) % n)) + 1.0E-12 < 0.0)) continue;
            return i;
        }
        return -1;
    }

    protected void setPoints_(Jun2dPoint[] jun2dPointArray) {
        int n = jun2dPointArray.length;
        this.points = new Jun2dPoint[n];
        System.arraycopy(jun2dPointArray, 0, this.points, 0, n);
        this.signedArea = Double.NaN;
    }
}

