/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.surfaces;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.JunLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;

public abstract class JunTriangle
extends JunSurface {
    protected abstract JunPoint _p1();

    protected abstract JunPoint _p2();

    protected abstract JunPoint _p3();

    public JunPlane[] asArrayOfPlanes() {
        return new JunPlane[]{this.asPlane()};
    }

    public abstract JunPlane asPlane();

    public JunAngle angleWithLine_(JunLine junLine) {
        return this.asPlane().angleWithLine_(junLine);
    }

    public JunAngle angleWithLine_(JunPlane junPlane) {
        return this.asPlane().angleWithPlane_(junPlane);
    }

    public JunAngle angleWithTriangle_(JunTriangle junTriangle) {
        return this.asPlane().angleWithTriangle_(junTriangle);
    }

    public abstract double areaWithSign();

    public void printOn_(Writer writer) throws IOException {
        writer.write(40);
        this._p1().printOn_(writer);
        writer.write(" triangle: ");
        this._p2().printOn_(writer);
        writer.write(" and: ");
        this._p3().printOn_(writer);
        writer.write(41);
    }

    public void storeOn_(Writer writer) throws IOException {
        writer.write(40);
        writer.write(this._className().toString());
        writer.write(" on: ");
        this._p1().storeOn_(writer);
        writer.write(" on: ");
        this._p2().storeOn_(writer);
        writer.write(" on: ");
        this._p3().storeOn_(writer);
        writer.write(41);
    }

    public boolean hasArea() {
        return !(this._p1().equal_((Object)this._p2()) || this._p2().equal_((Object)this._p3()) || this._p3().equal_((Object)this._p1()));
    }

    public boolean isTriangle() {
        return true;
    }

    public int whichSideOf_(JunPlane junPlane) {
        boolean bl;
        boolean bl2;
        int n;
        JunPoint[] junPointArray = new JunPoint[]{this._p1(), this._p2(), this._p3()};
        int[] nArray = new int[junPointArray.length];
        for (n = 0; n < junPointArray.length; ++n) {
            nArray[n] = junPointArray[n].whichSideOf_(junPlane);
        }
        n = Arrays.binarySearch(nArray, 1) != -1 ? 1 : 0;
        boolean bl3 = bl2 = Arrays.binarySearch(nArray, -1) != -1;
        if (n != 0 && bl2) {
            return 0;
        }
        boolean bl4 = bl = Arrays.binarySearch(nArray, 0) != -1;
        if (bl) {
            return 0;
        }
        if (bl2 && n == 0) {
            return -1;
        }
        return 1;
    }
}

