/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.geometry.transformations;

import java.io.IOException;
import java.io.Writer;
import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunLinearEquations;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.JunLine;
import jp.co.sra.jun.geometry.transformations.JunTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

public class Jun3dTransformation
extends JunTransformation {
    protected double a;
    protected double b;
    protected double c;
    protected double p;
    protected double d;
    protected double e;
    protected double f;
    protected double q;
    protected double g;
    protected double h;
    protected double i;
    protected double r;
    protected double l;
    protected double m;
    protected double n;
    protected double s;

    public static Jun3dTransformation Align_with_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return Jun3dTransformation.Translate_(jun3dPoint2.minus_(jun3dPoint));
    }

    public static Jun3dTransformation AlignPoints_(Jun3dPoint[][] jun3dPointArray) {
        Object object;
        double[] dArray;
        int n = jun3dPointArray.length;
        double[] dArray2 = new double[n * 5];
        double[] dArray3 = new double[n * 5];
        double[] dArray4 = new double[n * 5];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            dArray = jun3dPointArray[i][0].asArray();
            dArray3[n2] = dArray4[n2] = dArray[0];
            dArray2[n2] = dArray4[n2];
            dArray3[++n2] = dArray4[n2] = dArray[1];
            dArray2[n2] = dArray4[n2];
            dArray3[++n2] = dArray4[n2] = dArray[2];
            dArray2[n2] = dArray4[n2];
            dArray4[++n2] = 1.0;
            dArray3[n2] = 1.0;
            dArray2[n2] = 1.0;
            object = (Object)jun3dPointArray[i][1];
            dArray2[++n2] = -((Jun3dPoint)((Object)object)).x();
            dArray3[n2] = -((Jun3dPoint)((Object)object)).y();
            dArray4[n2] = -((Jun3dPoint)((Object)object)).z();
            ++n2;
        }
        double[] dArray5 = new JunLinearEquations(n, 5, dArray2).solution();
        dArray = new JunLinearEquations(n, 5, dArray3).solution();
        object = new JunLinearEquations(n, 5, dArray4).solution();
        Jun3dTransformation jun3dTransformation = new Jun3dTransformation();
        jun3dTransformation.a = dArray5[0];
        jun3dTransformation.b = dArray[0];
        jun3dTransformation.c = object[0];
        jun3dTransformation.d = dArray5[1];
        jun3dTransformation.e = dArray[1];
        jun3dTransformation.f = object[1];
        jun3dTransformation.g = dArray5[2];
        jun3dTransformation.h = dArray[2];
        jun3dTransformation.i = object[2];
        jun3dTransformation.l = dArray5[3];
        jun3dTransformation.m = dArray[3];
        jun3dTransformation.n = (double)object[3];
        jun3dTransformation.p = 0.0;
        jun3dTransformation.q = 0.0;
        jun3dTransformation.r = 0.0;
        jun3dTransformation.s = 1.0;
        return jun3dTransformation;
    }

    public static Jun3dTransformation AlignVector_to_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        if (jun3dPoint.minus_(jun3dPoint2).length() < 1.0E-12) {
            return Jun3dTransformation.Unity();
        }
        Jun3dPoint jun3dPoint3 = Jun3dPoint.Zero();
        Jun3dPoint jun3dPoint4 = jun3dPoint.product_(jun3dPoint2).unitVector();
        Jun3dPoint jun3dPoint5 = jun3dPoint.product_(jun3dPoint4);
        Jun3dPoint jun3dPoint6 = jun3dPoint2.product_(jun3dPoint4);
        return Jun3dTransformation.AlignPoints_(new Jun3dPoint[][]{{jun3dPoint, jun3dPoint2}, {jun3dPoint4, jun3dPoint4}, {jun3dPoint5, jun3dPoint6}, {jun3dPoint3, jun3dPoint3}});
    }

    public static Jun3dTransformation AlignVector_withVector_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.AlignVector_to_(jun3dPoint, jun3dPoint2);
        return jun3dTransformation;
    }

    public static Jun3dTransformation FromArray_(double[] dArray) {
        Jun3dTransformation jun3dTransformation = new Jun3dTransformation();
        jun3dTransformation.a = dArray[0];
        jun3dTransformation.b = dArray[1];
        jun3dTransformation.c = dArray[2];
        jun3dTransformation.p = dArray[3];
        jun3dTransformation.d = dArray[4];
        jun3dTransformation.e = dArray[5];
        jun3dTransformation.f = dArray[6];
        jun3dTransformation.q = dArray[7];
        jun3dTransformation.g = dArray[8];
        jun3dTransformation.h = dArray[9];
        jun3dTransformation.i = dArray[10];
        jun3dTransformation.r = dArray[11];
        jun3dTransformation.l = dArray[12];
        jun3dTransformation.m = dArray[13];
        jun3dTransformation.n = dArray[14];
        jun3dTransformation.s = dArray[15];
        return jun3dTransformation;
    }

    public static Jun3dTransformation MirrorX() {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = -1.0;
        return jun3dTransformation;
    }

    public static Jun3dTransformation MirrorY() {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.e = -1.0;
        return jun3dTransformation;
    }

    public static Jun3dTransformation MirrorZ() {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.i = -1.0;
        return jun3dTransformation;
    }

    public static Jun3dTransformation Perspective_(Jun3dPoint jun3dPoint) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = -jun3dPoint.z();
        jun3dTransformation.e = -jun3dPoint.z();
        jun3dTransformation.g = jun3dPoint.x();
        jun3dTransformation.h = jun3dPoint.y();
        jun3dTransformation.i = -1.0;
        jun3dTransformation.r = 1.0;
        jun3dTransformation.s = -jun3dPoint.z();
        return jun3dTransformation;
    }

    public static Jun3dTransformation Rotate_(JunAngle junAngle) {
        return Jun3dTransformation.RotateZ_(junAngle);
    }

    public static Jun3dTransformation Rotate_around_(JunAngle junAngle, JunLine junLine) {
        JunGeometry junGeometry;
        JunAngle junAngle2 = (JunAngle)junAngle.copy();
        Jun3dPoint jun3dPoint = null;
        Jun3dPoint jun3dPoint2 = null;
        if (junLine instanceof Jun3dLine) {
            junGeometry = (Jun3dLine)junLine;
            jun3dPoint = (Jun3dPoint)((Jun3dLine)junGeometry).first().copy();
            jun3dPoint2 = (Jun3dPoint)((Jun3dLine)junGeometry).last().copy();
        } else {
            junGeometry = (Jun2dLine)junLine;
            jun3dPoint = Jun3dPoint.Coerce_(((Jun2dLine)junGeometry).first());
            jun3dPoint2 = Jun3dPoint.Coerce_(((Jun2dLine)junGeometry).last());
        }
        junGeometry = jun3dPoint2.minus_(jun3dPoint);
        double d = ((Jun3dPoint)junGeometry).x();
        double d2 = ((Jun3dPoint)junGeometry).y();
        double d3 = ((Jun3dPoint)junGeometry).z();
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Translate_(jun3dPoint.negated());
        Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Unity();
        if (d4 != 0.0) {
            jun3dTransformation2.e = d3 / d4;
            jun3dTransformation2.f = d2 / d4;
            jun3dTransformation2.h = -d2 / d4;
            jun3dTransformation2.i = d3 / d4;
        }
        Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.Unity();
        if (d5 != 0.0) {
            jun3dTransformation3.a = d4 / d5;
            jun3dTransformation3.c = d / d5;
            jun3dTransformation3.g = -d / d5;
            jun3dTransformation3.i = d4 / d5;
        }
        Jun3dTransformation jun3dTransformation4 = Jun3dTransformation.Rotate_(junAngle2);
        Jun3dTransformation jun3dTransformation5 = Jun3dTransformation.Unity();
        if (d5 != 0.0) {
            jun3dTransformation5.a = d4 / d5;
            jun3dTransformation5.c = -d / d5;
            jun3dTransformation5.g = d / d5;
            jun3dTransformation5.i = d4 / d5;
        }
        Jun3dTransformation jun3dTransformation6 = Jun3dTransformation.Unity();
        if (d4 != 0.0) {
            jun3dTransformation6.e = d3 / d4;
            jun3dTransformation6.f = -d2 / d4;
            jun3dTransformation6.h = d2 / d4;
            jun3dTransformation6.i = d3 / d4;
        }
        Jun3dTransformation jun3dTransformation7 = Jun3dTransformation.Translate_(jun3dPoint);
        Jun3dTransformation jun3dTransformation8 = jun3dTransformation.product_(jun3dTransformation2);
        jun3dTransformation8 = jun3dTransformation8.product_(jun3dTransformation3);
        jun3dTransformation8 = jun3dTransformation8.product_(jun3dTransformation4);
        jun3dTransformation8 = jun3dTransformation8.product_(jun3dTransformation5);
        jun3dTransformation8 = jun3dTransformation8.product_(jun3dTransformation6);
        jun3dTransformation8 = jun3dTransformation8.product_(jun3dTransformation7);
        return jun3dTransformation8;
    }

    public static Jun3dTransformation RotateX_(JunAngle junAngle) {
        double d = junAngle.cos();
        double d2 = junAngle.sin();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.e = d;
        jun3dTransformation.f = d2;
        jun3dTransformation.h = -d2;
        jun3dTransformation.i = d;
        return jun3dTransformation;
    }

    public static Jun3dTransformation RotateX_(double d) {
        return Jun3dTransformation.RotateX_(JunAngle.FromRad_(d));
    }

    public static Jun3dTransformation RotateY_(JunAngle junAngle) {
        double d = junAngle.cos();
        double d2 = junAngle.sin();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = d;
        jun3dTransformation.c = -d2;
        jun3dTransformation.g = d2;
        jun3dTransformation.i = d;
        return jun3dTransformation;
    }

    public static Jun3dTransformation RotateY_(double d) {
        return Jun3dTransformation.RotateY_(JunAngle.FromRad_(d));
    }

    public static Jun3dTransformation RotateZ_(JunAngle junAngle) {
        double d = junAngle.cos();
        double d2 = junAngle.sin();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = d;
        jun3dTransformation.b = d2;
        jun3dTransformation.d = -d2;
        jun3dTransformation.e = d;
        return jun3dTransformation;
    }

    public static Jun3dTransformation RotateZ_(double d) {
        return Jun3dTransformation.RotateZ_(JunAngle.FromRad_(d));
    }

    public static Jun3dTransformation Scale_(double d) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = d;
        jun3dTransformation.e = d;
        jun3dTransformation.i = d;
        return jun3dTransformation;
    }

    public static Jun3dTransformation Scale_(Jun3dPoint jun3dPoint) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.a = jun3dPoint.x();
        jun3dTransformation.e = jun3dPoint.y();
        jun3dTransformation.i = jun3dPoint.z();
        return jun3dTransformation;
    }

    public static Jun3dTransformation Translate_(double d) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.l = d;
        jun3dTransformation.m = d;
        jun3dTransformation.n = d;
        return jun3dTransformation;
    }

    public static Jun3dTransformation Translate_(Jun3dPoint jun3dPoint) {
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        jun3dTransformation.l = jun3dPoint.x();
        jun3dTransformation.m = jun3dPoint.y();
        jun3dTransformation.n = jun3dPoint.z();
        return jun3dTransformation;
    }

    public static Jun3dTransformation Unity() {
        Jun3dTransformation jun3dTransformation = new Jun3dTransformation();
        jun3dTransformation.a = 1.0;
        jun3dTransformation.b = 0.0;
        jun3dTransformation.c = 0.0;
        jun3dTransformation.p = 0.0;
        jun3dTransformation.d = 0.0;
        jun3dTransformation.e = 1.0;
        jun3dTransformation.f = 0.0;
        jun3dTransformation.q = 0.0;
        jun3dTransformation.g = 0.0;
        jun3dTransformation.h = 0.0;
        jun3dTransformation.i = 1.0;
        jun3dTransformation.r = 0.0;
        jun3dTransformation.l = 0.0;
        jun3dTransformation.m = 0.0;
        jun3dTransformation.n = 0.0;
        jun3dTransformation.s = 1.0;
        return jun3dTransformation;
    }

    public static Jun3dTransformation Zero() {
        Jun3dTransformation jun3dTransformation = new Jun3dTransformation();
        jun3dTransformation.a = 0.0;
        jun3dTransformation.b = 0.0;
        jun3dTransformation.c = 0.0;
        jun3dTransformation.p = 0.0;
        jun3dTransformation.d = 0.0;
        jun3dTransformation.e = 0.0;
        jun3dTransformation.f = 0.0;
        jun3dTransformation.q = 0.0;
        jun3dTransformation.g = 0.0;
        jun3dTransformation.h = 0.0;
        jun3dTransformation.i = 0.0;
        jun3dTransformation.r = 0.0;
        jun3dTransformation.l = 0.0;
        jun3dTransformation.m = 0.0;
        jun3dTransformation.n = 0.0;
        jun3dTransformation.s = 0.0;
        return jun3dTransformation;
    }

    public double a() {
        return this.a;
    }

    public double b() {
        return this.b;
    }

    public double c() {
        return this.c;
    }

    public double d() {
        return this.d;
    }

    public double e() {
        return this.e;
    }

    public double f() {
        return this.f;
    }

    public double g() {
        return this.g;
    }

    public double h() {
        return this.h;
    }

    public double i() {
        return this.i;
    }

    public double l() {
        return this.l;
    }

    public double m() {
        return this.m;
    }

    public double n() {
        return this.n;
    }

    public double p() {
        return this.p;
    }

    public double q() {
        return this.q;
    }

    public double r() {
        return this.r;
    }

    public double s() {
        return this.s;
    }

    public Jun3dPoint applyTo_(Jun3dPoint jun3dPoint) {
        return jun3dPoint.transform_(this);
    }

    public JunOpenGL3dObject applyTo_(JunOpenGL3dObject junOpenGL3dObject) {
        return junOpenGL3dObject.transform_(this);
    }

    public Jun3dPoint applyToPoint_(JunPoint junPoint) {
        Jun3dPoint jun3dPoint = junPoint instanceof Jun3dPoint ? (Jun3dPoint)junPoint : Jun3dPoint.Coerce_(junPoint);
        double d = jun3dPoint.x() * this.a + jun3dPoint.y() * this.d + jun3dPoint.z() * this.g + this.l;
        double d2 = jun3dPoint.x() * this.b + jun3dPoint.y() * this.e + jun3dPoint.z() * this.h + this.m;
        double d3 = jun3dPoint.x() * this.c + jun3dPoint.y() * this.f + jun3dPoint.z() * this.i + this.n;
        double d4 = jun3dPoint.x() * this.p + jun3dPoint.y() * this.q + jun3dPoint.z() * this.r + this.s;
        if (d4 == 0.0) {
            d4 = 1.0E-12;
        }
        return new Jun3dPoint(d / d4, d2 / d4, d3 / d4);
    }

    public double[] asArray() {
        double[] dArray = new double[]{this.a, this.b, this.c, this.p, this.d, this.e, this.f, this.q, this.g, this.h, this.i, this.r, this.l, this.m, this.n, this.s};
        return dArray;
    }

    public JunDoubleMatrix asMatrix() {
        return new JunDoubleMatrix(4, this.asArray());
    }

    public JunDoubleMatrix asRotationMatrix() {
        double[] dArray = new double[]{this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i};
        return new JunDoubleMatrix(3, dArray);
    }

    public Jun3dPoint asTranslation() {
        return new Jun3dPoint(this.l, this.m, this.n);
    }

    public boolean equal_(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dTransformation jun3dTransformation = (Jun3dTransformation)((Object)object);
        return this.isEqualNumber_to_(this.a, jun3dTransformation.a) && this.isEqualNumber_to_(this.b, jun3dTransformation.b) && this.isEqualNumber_to_(this.c, jun3dTransformation.c) && this.isEqualNumber_to_(this.p, jun3dTransformation.p) && this.isEqualNumber_to_(this.d, jun3dTransformation.d) && this.isEqualNumber_to_(this.e, jun3dTransformation.e) && this.isEqualNumber_to_(this.f, jun3dTransformation.f) && this.isEqualNumber_to_(this.q, jun3dTransformation.q) && this.isEqualNumber_to_(this.g, jun3dTransformation.g) && this.isEqualNumber_to_(this.h, jun3dTransformation.h) && this.isEqualNumber_to_(this.i, jun3dTransformation.i) && this.isEqualNumber_to_(this.r, jun3dTransformation.r) && this.isEqualNumber_to_(this.l, jun3dTransformation.l) && this.isEqualNumber_to_(this.m, jun3dTransformation.m) && this.isEqualNumber_to_(this.n, jun3dTransformation.n) && this.isEqualNumber_to_(this.s, jun3dTransformation.s);
    }

    public boolean equals(Object object) {
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        Jun3dTransformation jun3dTransformation = (Jun3dTransformation)((Object)object);
        return this.a == jun3dTransformation.a && this.b == jun3dTransformation.b && this.c == jun3dTransformation.c && this.p == jun3dTransformation.p && this.d == jun3dTransformation.d && this.e == jun3dTransformation.e && this.f == jun3dTransformation.f && this.q == jun3dTransformation.q && this.g == jun3dTransformation.g && this.h == jun3dTransformation.h && this.i == jun3dTransformation.i && this.r == jun3dTransformation.r && this.l == jun3dTransformation.l && this.m == jun3dTransformation.m && this.n == jun3dTransformation.n && this.s == jun3dTransformation.s;
    }

    public Jun3dTransformation inverse() {
        return Jun3dTransformation.FromArray_(this.asMatrix().inverse().asArrayOfDouble());
    }

    public JunTransformation _inverse() {
        return this.inverse();
    }

    public boolean is3d() {
        return true;
    }

    public void printOn_(Writer writer) throws IOException {
        writer.write("3dTransformation (");
        writer.write(this.a + " " + this.b + " " + this.c + " " + this.p);
        writer.write(" ,  ");
        writer.write(this.d + " " + this.e + " " + this.f + " " + this.q);
        writer.write(" ,  ");
        writer.write(this.g + " " + this.h + " " + this.i + " " + this.r);
        writer.write(" ,  ");
        writer.write(this.l + " " + this.m + " " + this.n + " " + this.s);
        writer.write(41);
    }

    public Jun3dTransformation product_(Jun3dTransformation jun3dTransformation) {
        Jun3dTransformation jun3dTransformation2 = new Jun3dTransformation();
        jun3dTransformation2.a = this.a * jun3dTransformation.a + this.b * jun3dTransformation.d + this.c * jun3dTransformation.g + this.p * jun3dTransformation.l;
        jun3dTransformation2.b = this.a * jun3dTransformation.b + this.b * jun3dTransformation.e + this.c * jun3dTransformation.h + this.p * jun3dTransformation.m;
        jun3dTransformation2.c = this.a * jun3dTransformation.c + this.b * jun3dTransformation.f + this.c * jun3dTransformation.i + this.p * jun3dTransformation.n;
        jun3dTransformation2.p = this.a * jun3dTransformation.p + this.b * jun3dTransformation.q + this.c * jun3dTransformation.r + this.p * jun3dTransformation.s;
        jun3dTransformation2.d = this.d * jun3dTransformation.a + this.e * jun3dTransformation.d + this.f * jun3dTransformation.g + this.q * jun3dTransformation.l;
        jun3dTransformation2.e = this.d * jun3dTransformation.b + this.e * jun3dTransformation.e + this.f * jun3dTransformation.h + this.q * jun3dTransformation.m;
        jun3dTransformation2.f = this.d * jun3dTransformation.c + this.e * jun3dTransformation.f + this.f * jun3dTransformation.i + this.q * jun3dTransformation.n;
        jun3dTransformation2.q = this.d * jun3dTransformation.p + this.e * jun3dTransformation.q + this.f * jun3dTransformation.r + this.q * jun3dTransformation.s;
        jun3dTransformation2.g = this.g * jun3dTransformation.a + this.h * jun3dTransformation.d + this.i * jun3dTransformation.g + this.r * jun3dTransformation.l;
        jun3dTransformation2.h = this.g * jun3dTransformation.b + this.h * jun3dTransformation.e + this.i * jun3dTransformation.h + this.r * jun3dTransformation.m;
        jun3dTransformation2.i = this.g * jun3dTransformation.c + this.h * jun3dTransformation.f + this.i * jun3dTransformation.i + this.r * jun3dTransformation.n;
        jun3dTransformation2.r = this.g * jun3dTransformation.p + this.h * jun3dTransformation.q + this.i * jun3dTransformation.r + this.r * jun3dTransformation.s;
        jun3dTransformation2.l = this.l * jun3dTransformation.a + this.m * jun3dTransformation.d + this.n * jun3dTransformation.g + this.s * jun3dTransformation.l;
        jun3dTransformation2.m = this.l * jun3dTransformation.b + this.m * jun3dTransformation.e + this.n * jun3dTransformation.h + this.s * jun3dTransformation.m;
        jun3dTransformation2.n = this.l * jun3dTransformation.c + this.m * jun3dTransformation.f + this.n * jun3dTransformation.i + this.s * jun3dTransformation.n;
        jun3dTransformation2.s = this.l * jun3dTransformation.p + this.m * jun3dTransformation.q + this.n * jun3dTransformation.r + this.s * jun3dTransformation.s;
        return jun3dTransformation2;
    }

    public JunAngle rotationAngle() {
        return JunAngle.FromRad_(Math.acos((this.a + this.e + this.i - 1.0) / 2.0));
    }

    public Jun3dPoint rotationVector() {
        double d = Math.sqrt((this.f - this.h) * (this.f - this.h) + (this.c - this.g) * (this.c - this.g) + (this.b - this.d) * (this.b - this.d));
        return new Jun3dPoint((this.h - this.f) / d, (this.c - this.g) / d, (this.d - this.b) / d);
    }

    public Jun3dTransformation transform_(Jun3dTransformation jun3dTransformation) {
        return this.product_(jun3dTransformation);
    }
}

