/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.bulletinboard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoard;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardController;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StController;

public class JunBulletinBoardViewAwt
extends JunAbstractViewCanvas
implements JunBulletinBoardView {
    protected int displaySpeed;
    protected Point displayPoint;

    public JunBulletinBoardViewAwt(JunBulletinBoard junBulletinBoard) {
        super(junBulletinBoard);
    }

    public static Frame OpenOn_(JunBulletinBoard junBulletinBoard) {
        final JunBulletinBoardViewAwt junBulletinBoardViewAwt = new JunBulletinBoardViewAwt(junBulletinBoard){

            public Dimension getMinimumSize() {
                return DefaultWindowSize;
            }
        };
        Panel panel = StApplicationModel._PanelWithBorder();
        panel.setLayout(new BorderLayout());
        panel.add((Component)((Object)junBulletinBoardViewAwt), "Center");
        Frame frame = new Frame("Bulletin Board");
        frame.setLayout(new BorderLayout());
        frame.add((Component)panel, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                ((JunBulletinBoardController)junBulletinBoardViewAwt.controller()).resume();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((JunBulletinBoardController)junBulletinBoardViewAwt.controller()).terminate();
                windowEvent.getWindow().dispose();
            }
        });
        frame.pack();
        StApplicationModel._ShowAtMousePoint((Window)frame);
        return frame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        try {
            this.displayOn_(graphics);
        }
        finally {
            graphics.dispose();
        }
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        BufferedImage bufferedImage = this.getBulletinBoard().imageLocation_width_(this.displayPoint().x, this.getBounds().width);
        int n = (this.getBounds().height - bufferedImage.getHeight()) / 2;
        graphics.drawImage(bufferedImage, 0, n, null);
        Thread.yield();
    }

    public Point displayPoint() {
        int n = this.getBulletinBoard().width();
        int n2 = this.getBounds().width * -1;
        if (this.displayPoint == null) {
            this.displayPoint = new Point(n2, 0);
        } else {
            this.displayPoint.x += this.displaySpeed();
        }
        if (this.displayPoint.x > n) {
            this.displayPoint = new Point(n2, 0);
        }
        return this.displayPoint;
    }

    public int displaySpeed() {
        return this.displaySpeed;
    }

    public void displaySpeed_(int n) {
        this.displaySpeed = Math.max(1, Math.min(n, this.getBulletinBoard().width()));
    }

    public JunBulletinBoard getBulletinBoard() {
        return (JunBulletinBoard)this.model();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        JunBulletinBoard junBulletinBoard = this.getBulletinBoard();
        Rectangle rectangle = junBulletinBoard.bounds();
        junBulletinBoard.fontHeight_(Math.round((float)n4 * 0.8f));
        Rectangle rectangle2 = junBulletinBoard.bounds();
        if (this.displayPoint != null) {
            this.displayPoint.x = this.displayPoint.x * rectangle2.width / rectangle.width;
        }
    }

    protected void buildComponent() {
        this.setSize(JunBulletinBoardViewAwt.DefaultWindowSize.width, 48);
        this.setBackground(this.getBulletinBoard().backgroundColor());
    }

    protected StController defaultController() {
        return new JunBulletinBoardController();
    }

    protected void initialize() {
        super.initialize();
        this.displaySpeed = 2;
        this.displayPoint = null;
    }
}

