/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.button;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.goodies.button.JunButtonController;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.button.JunButtonView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StDisplayable;

public class JunButtonViewAwt
extends JunAbstractViewCanvas
implements JunButtonView {
    public JunButtonViewAwt() {
    }

    public JunButtonViewAwt(JunButtonModel junButtonModel) {
        super(junButtonModel);
    }

    public JunButtonViewAwt(JunButtonModel junButtonModel, Dimension dimension) {
        super(junButtonModel);
        this.setSize(dimension);
    }

    protected void buildComponent() {
        this.setSize(100, 100);
    }

    public JunButtonModel getButtonModel() {
        return (JunButtonModel)this.model();
    }

    protected StController defaultController() {
        return new JunButtonController();
    }

    public void displayOn_(Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        if (this.getButtonModel().value()) {
            this.displayTrueOn_(graphics);
        } else {
            this.displayFalseOn_(graphics);
        }
    }

    public void displayTrueOn_(Graphics graphics) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Gray30);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        StDisplayable stDisplayable = this.getButtonModel().visual();
        Rectangle rectangle2 = stDisplayable.bounds();
        stDisplayable.displayOn_at_(graphics, new Point((rectangle.width - rectangle2.width) / 2, (rectangle.height - rectangle2.height) / 2));
        graphics.setColor(Gray20);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(Gray80);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        if (!this.getButtonModel().isActive()) {
            graphics.setColor(Gray90);
            Dimension dimension = this.getSize();
            for (int i = 0; i < dimension.height; ++i) {
                for (int j = 0; j < dimension.width; ++j) {
                    if ((j + i) % 2 != 1) continue;
                    graphics.drawRect(j, i, 0, 0);
                }
            }
        }
    }

    public void displayFalseOn_(Graphics graphics) {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Gray70);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        StDisplayable stDisplayable = this.getButtonModel().visual();
        Rectangle rectangle2 = stDisplayable.bounds();
        stDisplayable.displayOn_at_(graphics, new Point((rectangle.width - rectangle2.width) / 2, (rectangle.height - rectangle2.height) / 2));
        graphics.setColor(Gray80);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.setColor(Gray20);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        if (!this.getButtonModel().isActive()) {
            graphics.setColor(Gray90);
            Dimension dimension = this.getSize();
            for (int i = 0; i < dimension.height; ++i) {
                for (int j = 0; j < dimension.width; ++j) {
                    if ((j + i) % 2 != 1) continue;
                    graphics.drawRect(j, i, 0, 0);
                }
            }
        }
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        if (dependentEvent.getAspect() == JunButtonViewAwt.$((String)"visual")) {
            this.repaint();
            return;
        }
        super.update_(dependentEvent);
    }
}

