/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.util.Map;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunRectangularElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.SystemResourceSupport;

public class JunTextElement
extends JunRectangularElement {
    protected String text;
    protected String fontName;
    protected int fontSize;
    protected int fontStyle;
    protected Color foregroundColor;
    protected transient Font font;
    protected transient StComposedText composedText;
    protected transient JunTextPropertiesModel propertiesModel;
    protected static transient Dimension DefaultMinimumExtent = null;
    public static DataFlavor DataFlavor = new DataFlavor(JunTextElement.class, "JunTextElement");

    public JunTextElement() {
    }

    public JunTextElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        boolean bl = System.getProperty("os.name").toLowerCase().matches(".*mac.*os.*x.*");
        this.text = null;
        this.fontName = bl ? "Osaka-Mono" : "Monospaced";
        this.fontSize = bl ? 12 : SystemResourceSupport.getFont().getSize();
        this.fontStyle = 0;
        this.foregroundColor = Color.black;
        this.font = null;
        this.composedText = null;
        this.propertiesModel = null;
    }

    public void release() {
        super.release();
        if (this.propertiesModel != null) {
            this.propertiesModel.closeRequest();
            this.propertiesModel = null;
        }
    }

    public String text() {
        return this.text;
    }

    public void text_(String string) {
        this.text = string;
        this.flushBounds();
    }

    protected StComposedText composedText() {
        if (this.composedText == null) {
            this.composedText = new StComposedText(this.text(), this.font());
            if (this.composedText.width() > this.width()) {
                this.composedText = new StComposedText(this.text(), this.width());
            }
        }
        return this.composedText;
    }

    public JunDrawingVisual postCopy(Map map) {
        super.postCopy(map);
        if (this.text != null) {
            this.text_(new String(this.text));
        }
        if (this.fontName != null) {
            this.fontName_(new String(this.fontName));
        }
        this.foregroundColor_(new Color(this.foregroundColor.getRGB(), true));
        this.font = null;
        this.composedText = null;
        this.propertiesModel = null;
        return this;
    }

    public Dimension defaultExtent() {
        return new Dimension(96, this.defaultMinimumExtent().height + 4);
    }

    public Dimension defaultMinimumExtent() {
        if (DefaultMinimumExtent == null) {
            FontMetrics fontMetrics = SystemResourceSupport.getFontMetrics((Font)SystemResourceSupport.getFont());
            DefaultMinimumExtent = new Dimension(fontMetrics.getWidths()[0] * 2, fontMetrics.getHeight());
        }
        return DefaultMinimumExtent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && !rectangle.intersects(this.bounds())) {
            return;
        }
        Graphics graphics2 = graphics.create();
        try {
            StComposedText stComposedText = this.composedText();
            int n = stComposedText.width() == this.width() ? 0 : (this.width() - stComposedText.width()) / 2;
            int n2 = (this.height() - stComposedText.height()) / 2;
            rectangle = rectangle == null ? this.bounds() : this.bounds().intersection(rectangle);
            graphics2.setClip(rectangle);
            graphics2.setColor(this.foregroundColor());
            stComposedText.displayOn_at_(graphics2, new Point(this.x() + n, this.y() + n2));
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    public Font font() {
        if (this.font == null) {
            this.font = new Font(this.fontName(), this.fontStyle(), this.fontSize());
        }
        return this.font;
    }

    protected void flushBounds() {
        super.flushBounds();
        if (this.composedText != null) {
            if (this.text() == null && this.composedText.string() != null || !(this.text() != null && this.text().equals(this.composedText.string()))) {
                this.composedText = null;
            } else if (this.composedText.numberOfLines() == 1 && this.width() < this.composedText.width()) {
                this.composedText = null;
            } else if (this.composedText.numberOfLines() > 1 && this.width() != this.composedText.width()) {
                this.composedText = null;
            }
        }
    }

    protected void flushFont() {
        this.font = null;
        this.composedText = null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor};
    }

    public String fontName() {
        return this.fontName;
    }

    public void fontName_(String string) {
        this.fontName = string;
        this.flushFont();
    }

    public int fontSize() {
        return this.fontSize;
    }

    public void fontSize_(int n) {
        this.fontSize = n;
        this.flushFont();
    }

    public int fontStyle() {
        return this.fontStyle;
    }

    public void fontStyle_(int n) {
        this.fontStyle = n;
        this.flushFont();
    }

    public Color foregroundColor() {
        return this.foregroundColor;
    }

    public void foregroundColor_(Color color) {
        this.foregroundColor = color;
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new JunTextPropertiesModel(this);
        }
        return this.propertiesModel;
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons;
        JunLispCons junLispCons2;
        JunLispCons junLispCons3;
        JunLispCons junLispCons4;
        JunLispCons junLispCons5 = super.toLispList();
        JunLispCons junLispCons6 = this.textToLispList();
        if (junLispCons6 != null) {
            junLispCons5.add_((Object)junLispCons6);
        }
        if ((junLispCons4 = this.fontNameToLispList()) != null) {
            junLispCons5.add_((Object)junLispCons4);
        }
        if ((junLispCons3 = this.fontSizeToLispList()) != null) {
            junLispCons5.add_((Object)junLispCons3);
        }
        if ((junLispCons2 = this.fontStyleToLispList()) != null) {
            junLispCons5.add_((Object)junLispCons2);
        }
        if ((junLispCons = this.foregroundColorToLispList()) != null) {
            junLispCons5.add_((Object)junLispCons);
        }
        return junLispCons5;
    }

    protected JunLispCons textToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunTextElement.$((String)"text"));
        junLispCons.tail_(this.text());
        return junLispCons;
    }

    protected JunLispCons fontNameToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunTextElement.$((String)"fontName"));
        junLispCons.tail_(this.fontName());
        return junLispCons;
    }

    protected JunLispCons fontSizeToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunTextElement.$((String)"fontSize"));
        junLispCons.tail_(new Integer(this.fontSize()));
        return junLispCons;
    }

    protected JunLispCons fontStyleToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunTextElement.$((String)"fontStyle"));
        junLispCons.tail_(new Integer(this.fontStyle()));
        return junLispCons;
    }

    protected JunLispCons foregroundColorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunTextElement.$((String)"foregroundColor"));
        junLispCons.tail_(this.foregroundColor());
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.textFromLispList_(junLispList);
        this.fontNameFromLispList_(junLispList);
        this.fontSizeFromLispList_(junLispList);
        this.fontStyleFromLispList_(junLispList);
        this.foregroundColorFromLispList_(junLispList);
    }

    protected void textFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"text"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.text_((String)junLispList2.tail());
    }

    protected void fontNameFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"fontName"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.fontName_((String)junLispList2.tail());
    }

    protected void fontSizeFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"fontSize"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.fontSize_(((Number)junLispList2.tail()).intValue());
    }

    protected void fontStyleFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 4.$((String)"fontStyle"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.fontStyle_(((Number)junLispList2.tail()).intValue());
    }

    protected void foregroundColorFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 5.$((String)"foregroundColor"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.foregroundColor_((Color)junLispList2.tail());
    }
}

