/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.element;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel;
import jp.co.sra.jun.goodies.drawing.properties.JunVertexesPropertiesModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunVertexesElement
extends JunNodeElement {
    protected List points;
    protected Color foregroundColor;
    protected int lineWidth;
    protected transient Rectangle preferredBounds;
    protected transient Rectangle pointBounds;
    protected transient Shape[] shapes;
    protected transient BasicStroke stroke;
    protected transient JunVertexesPropertiesModel propertiesModel;
    public static final StSymbol CONTROLL_POINT_BEGIN = JunVertexesElement.$((String)"begin");
    public static final StSymbol CONTROLL_POINT_END = JunVertexesElement.$((String)"end");
    public static final int MIN_LINE_WIDTH = 1;
    public static final int MAX_LINE_WIDTH = 10;

    public JunVertexesElement() {
    }

    public JunVertexesElement(JunLispList junLispList) {
        super(junLispList);
    }

    protected void initialize() {
        super.initialize();
        this.points = null;
        this.foregroundColor = Color.black;
        this.lineWidth = 1;
        this.preferredBounds = null;
        this.pointBounds = null;
        this.shapes = null;
        this.stroke = null;
        this.propertiesModel = null;
    }

    public void release() {
        super.release();
        if (this.propertiesModel != null) {
            this.propertiesModel.closeRequest();
            this.propertiesModel = null;
        }
    }

    public List points() {
        if (this.points == null) {
            this.points = new ArrayList();
        }
        return this.points;
    }

    public void points_(List list) {
        this.points = list;
        this.flushBounds();
    }

    public Point[] _points() {
        Point[] pointArray = new Point[this.points().size()];
        this.points().toArray(pointArray);
        return pointArray;
    }

    public void at_put_(int n, Point point) {
        if (n < 0 || this.points().size() < n) {
            throw new IndexOutOfBoundsException();
        }
        Point point2 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        if (!this.points().get(n).equals(point2)) {
            this.points().set(n, point2);
            this.flushBounds();
        }
    }

    public Point pointAt_(int n) {
        if (this.points().isEmpty()) {
            return null;
        }
        if (n < 0 || this.points().size() <= n) {
            return null;
        }
        return (Point)this.points().get(n);
    }

    public int pointIndexOf_(Point point) {
        return this.points().indexOf(point);
    }

    public Point begin() {
        return this.pointAt_(0);
    }

    public void begin_(Point point) {
        this.at_put_(0, point);
    }

    public Point end() {
        return this.pointAt_(this.points().size() - 1);
    }

    public void end_(Point point) {
        this.at_put_(this.points().size() - 1, point);
    }

    public Point add_(Point point) {
        Point point2 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        this.points().add(point2);
        this.flushBounds();
        return point2;
    }

    public Point add_at_(Point point, int n) {
        Point point2 = new Point(Math.max(point.x, 0), Math.max(point.y, 0));
        this.points().add(n, point2);
        this.flushBounds();
        return point2;
    }

    public Point add_after_(Point point, Point point2) {
        int n = this.points().indexOf(point2);
        if (n < 0) {
            return null;
        }
        return this.add_at_(point, n + 1);
    }

    public Rectangle preferredBounds() {
        if (this.preferredBounds == null) {
            Shape[] shapeArray = this.shapes();
            for (int i = 0; i < shapeArray.length; ++i) {
                Rectangle rectangle;
                Rectangle rectangle2 = rectangle = shapeArray[i] instanceof Polygon || shapeArray[i] instanceof Ellipse2D ? shapeArray[i].getBounds() : this.stroke().createStrokedShape(shapeArray[i]).getBounds();
                if (this.preferredBounds != null) {
                    this.preferredBounds.add(rectangle);
                    continue;
                }
                this.preferredBounds = rectangle;
            }
            this.preferredBounds.setSize(this.preferredBounds.width + 1, this.preferredBounds.height + 1);
        }
        return this.preferredBounds;
    }

    protected Rectangle pointBounds() {
        if (this.pointBounds == null) {
            Point[] pointArray = this._points();
            for (int i = 0; i < pointArray.length; ++i) {
                if (this.pointBounds == null) {
                    this.pointBounds = new Rectangle(pointArray[i].x, pointArray[i].y, 1, 1);
                    continue;
                }
                this.pointBounds.add(pointArray[i]);
            }
            this.pointBounds.setSize(this.pointBounds.width + 1, this.pointBounds.height + 1);
        }
        return this.pointBounds;
    }

    public JunDrawingVisual postCopy(Map map) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point[] pointArray = this._points();
        for (int i = 0; i < pointArray.length; ++i) {
            arrayList.add(new Point(pointArray[i]));
        }
        super.postCopy(map);
        this.points_(arrayList);
        this.foregroundColor_(new Color(this.foregroundColor.getRGB(), true));
        this.preferredBounds = null;
        this.pointBounds = null;
        this.shapes = null;
        this.stroke = null;
        this.propertiesModel = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle != null && !rectangle.intersects(this.bounds())) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            graphics2D.setColor(this.foregroundColor());
            graphics2D.setStroke(this.stroke());
            Shape[] shapeArray = this.shapes();
            for (int i = 0; i < shapeArray.length; ++i) {
                if (shapeArray[i] instanceof Polygon || shapeArray[i] instanceof Ellipse2D) {
                    graphics2D.fill(shapeArray[i]);
                    continue;
                }
                graphics2D.draw(shapeArray[i]);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    protected void flushBounds() {
        this.preferredBounds = null;
        this.pointBounds = null;
        this.shapes = null;
        this.stroke = null;
    }

    public Point pointInControllPoint_(Point point) {
        StSymbol stSymbol = this.controllPointAreaName_(point);
        if (stSymbol == null) {
            return null;
        }
        if (stSymbol == CONTROLL_POINT_BEGIN) {
            return this.begin();
        }
        if (stSymbol == CONTROLL_POINT_END) {
            return this.end();
        }
        String string = stSymbol.toString().substring(stSymbol.toString().indexOf(95) + 1);
        return this.pointAt_(Integer.parseInt(string));
    }

    public Point removeAt_(int n) {
        if (n < 0 || this.points().size() < n || this.points.size() <= 2) {
            return null;
        }
        Point point = (Point)this.points().remove(n);
        this.flushBounds();
        return point;
    }

    public Point remove_(Point point) {
        if (!this.points().contains(point) || this.points.size() <= 2) {
            return null;
        }
        this.points().remove(point);
        this.flushBounds();
        return point;
    }

    public boolean isVertexes() {
        return true;
    }

    public boolean containsPoint_(Point point) {
        if (!super.containsPoint_(point)) {
            return false;
        }
        Shape[] shapeArray = this.shapes();
        for (int i = 0; i < shapeArray.length; ++i) {
            if (!(shapeArray[i] instanceof Polygon ? shapeArray[i].contains(point) : this.stroke().createStrokedShape(shapeArray[i]).contains(point))) continue;
            return true;
        }
        return false;
    }

    public boolean intersects_(Rectangle rectangle) {
        if (!super.intersects_(rectangle)) {
            return false;
        }
        Shape[] shapeArray = this.shapes();
        for (int i = 0; i < shapeArray.length; ++i) {
            if (!(shapeArray[i] instanceof Polygon ? shapeArray[i].intersects(rectangle) : this.stroke().createStrokedShape(shapeArray[i]).intersects(rectangle))) continue;
            return true;
        }
        return false;
    }

    public int lineWidth() {
        return this.lineWidth;
    }

    public void lineWidth_(int n) {
        this.lineWidth = Math.min(Math.max(n, 1), 10);
        this.flushBounds();
    }

    public Color foregroundColor() {
        return this.foregroundColor;
    }

    public void foregroundColor_(Color color) {
        if (color != null) {
            this.foregroundColor = color;
        }
    }

    public JunDrawingElementPropertiesModel propertiesModel() {
        if (this.propertiesModel == null) {
            this.propertiesModel = new JunVertexesPropertiesModel(this);
        }
        return this.propertiesModel;
    }

    protected abstract Shape[] shapes();

    protected abstract BasicStroke stroke();

    public JunLispCons toLispList() {
        JunLispCons junLispCons = super.toLispList();
        junLispCons.add_((Object)this.pointsToLispList());
        junLispCons.add_((Object)this.foregroundColorToLispList());
        junLispCons.add_((Object)this.lineWidthToLispList());
        return junLispCons;
    }

    protected JunLispCons pointsToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunVertexesElement.$((String)"points"));
        Iterator iterator = this.points().iterator();
        while (iterator.hasNext()) {
            junLispCons.add_((Object)new Jun2dPoint((Point)iterator.next()));
        }
        return junLispCons;
    }

    protected JunLispCons foregroundColorToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunVertexesElement.$((String)"foregroundColor"));
        junLispCons.tail_(this.foregroundColor());
        return junLispCons;
    }

    protected JunLispCons lineWidthToLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(JunVertexesElement.$((String)"lineWidth"));
        junLispCons.tail_(new Integer(this.lineWidth()));
        return junLispCons;
    }

    public void fromLispList_(JunLispList junLispList) {
        super.fromLispList_(junLispList);
        this.pointsFromLispList_(junLispList);
        this.foregroundColorFromLispList_(junLispList);
        this.lineWidthFromLispList_(junLispList);
    }

    protected void pointsFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 1.$((String)"points"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        Object[] objectArray = ((JunLispList)((Object)junLispList2.tail())).asArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.add_(((Jun2dPoint)((Object)objectArray[i]))._toPoint());
        }
    }

    protected void foregroundColorFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 2.$((String)"foregroundColor"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.foregroundColor_((Color)junLispList2.tail());
    }

    protected void lineWidthFromLispList_(JunLispList junLispList) {
        JunLispList junLispList2 = (JunLispList)((Object)junLispList.detect_ifNone_(new StBlockClosure(){

            public Object value_(Object object) {
                return new Boolean(object instanceof JunLispCons && ((JunLispCons)((Object)object)).head() == 3.$((String)"lineWidth"));
            }
        }, new StBlockClosure()));
        if (junLispList2 == null) {
            return;
        }
        this.lineWidth_(((Number)junLispList2.tail()).intValue());
    }
}

