/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.drawing.map;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.calendar.JunCalendarModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunEllipseElement;
import jp.co.sra.jun.goodies.drawing.element.JunFreehandElement;
import jp.co.sra.jun.goodies.drawing.element.JunImageElement;
import jp.co.sra.jun.goodies.drawing.element.JunLabelElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunNodeElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangleElement;
import jp.co.sra.jun.goodies.drawing.element.JunRoundRectangleElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextboxElement;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMap;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapController;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapViewAwt;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapViewSwing;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunDrawingMapModel
extends JunApplicationModel
implements ClipboardOwner {
    protected JunDrawingMap mapObject;
    protected Jun2dPoint scalePoint;
    protected HashMap popupMenuTable;
    protected StMenuBar _menuBar;
    protected transient File fileName;
    public static final String DefaultHeader = "% Jun Drawing Map";

    public static JunDrawingMapModel FromUser_(File file) {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunDrawingMapModel.$String((String)"<1p> files", null, (Object)"DRW"), new String[]{"*.drw", "*.DRW"})};
        File file2 = file == null ? null : file;
        file2 = JunFileRequesterDialog.Request(JunDrawingMapModel.$String((String)"Select a <1p> file.", null, (Object)"DRW"), file2, fileTypeArray, fileTypeArray[0], null, null);
        if (file2 == null) {
            return null;
        }
        JunDrawingMapModel junDrawingMapModel = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file2)));
            String string = bufferedReader.readLine();
            if (string.length() < DefaultHeader.length()) {
                JunDialog.Warn_(JunDrawingMapModel.$String((String)"<1p> files", null, (Object)file2.getName()) + JunDrawingMapModel.$String((String)" can not read."));
                JunDrawingMapModel junDrawingMapModel2 = null;
                return junDrawingMapModel2;
            }
            String string2 = string.substring(0, DefaultHeader.length());
            if (!string2.equals(DefaultHeader)) {
                JunDialog.Warn_(JunDrawingMapModel.$String((String)"<1p> files", null, (Object)file2.getName()) + JunDrawingMapModel.$String((String)" can not read."));
                JunDrawingMapModel junDrawingMapModel3 = null;
                return junDrawingMapModel3;
            }
            bufferedReader.close();
            bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), System.getProperty("file.encoding")));
            StringWriter stringWriter = new StringWriter();
            String string3 = (String)System.getProperties().get("line.separator");
            while ((string = bufferedReader.readLine()) != null) {
                stringWriter.write(string);
                stringWriter.write(string3);
            }
            bufferedReader.close();
            bufferedReader = null;
            JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_(new StReadStream(stringWriter.toString())));
            junDrawingMapModel = new JunDrawingMapModel(new JunDrawingMap(junLispCons));
            junDrawingMapModel.fileName_(file2);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    throw new SmalltalkException((Exception)iOException);
                }
            }
        }
        return junDrawingMapModel;
    }

    public JunDrawingMapModel(JunDrawingMap junDrawingMap) {
        this.mapObject_(junDrawingMap);
    }

    protected void initialize() {
        super.initialize();
        this.mapObject = null;
        this.scalePoint = null;
        this.popupMenuTable = null;
        this._menuBar = null;
        this.fileName = null;
    }

    public void release() {
        super.release();
        this.mapObject_(null);
    }

    public StDisplayable displayObject() {
        return this.mapObject();
    }

    public JunDrawingMap mapObject() {
        return this.mapObject;
    }

    public void mapObject_(JunDrawingMap junDrawingMap) {
        if (this.mapObject != null) {
            this.mapObject.removeDependentListener((DependentListener)this);
        }
        this.mapObject = junDrawingMap;
        if (this.mapObject != null) {
            this.mapObject.addDependentListener((DependentListener)this);
        }
    }

    public Jun2dPoint scalePoint() {
        if (this.scalePoint == null) {
            this.scalePoint = Jun2dPoint.Unity();
        }
        return this.scalePoint;
    }

    public void scalePoint_(Jun2dPoint jun2dPoint) {
        if (jun2dPoint != null) {
            double d = Math.max(0.01, Math.min((double)Math.round(jun2dPoint.x() * 100.0) / 100.0, 100.0));
            double d2 = Math.max(0.01, Math.min((double)Math.round(jun2dPoint.y() * 100.0) / 100.0, 100.0));
            this.scalePoint = new Jun2dPoint(d, d2);
        } else {
            this.scalePoint = null;
        }
        this.mapObject().flushBounds();
        this.changed_(JunDrawingMapModel.$((String)"zoom"));
    }

    public void scalePoint_(double d) {
        this.scalePoint_(d, d);
    }

    public void scalePoint_(double d, double d2) {
        this.scalePoint_(new Jun2dPoint(d, d2));
    }

    public File fileName() {
        return this.fileName;
    }

    public Dimension scaledSize() {
        Dimension dimension = this.mapObject().extent();
        return new Dimension((int)Math.round((double)dimension.width * this.scalePoint().x()), (int)Math.round((double)dimension.height * this.scalePoint().y()));
    }

    public JunDrawingMapController getDrawingMapController() {
        JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
        if (junDrawingMapView == null) {
            return null;
        }
        return junDrawingMapView.getDrawingMapController();
    }

    public JunDrawingMapView getDrawingMapView() {
        return (JunDrawingMapView)this.getView();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    protected File defaultFile() {
        return new File(this.defaultBaseName() + ".drw");
    }

    public String defaultHeader() {
        return DefaultHeader;
    }

    public StView defaultView() {
        if (JunDrawingMapModel.GetDefaultViewMode() == 0) {
            return new JunDrawingMapViewAwt(this);
        }
        return new JunDrawingMapViewSwing(this);
    }

    protected String windowTitle() {
        return JunDrawingMapModel.$String((String)"Drawing");
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        super.noticeOfWindowClose(windowEvent);
        this.mapObject_(null);
    }

    public void updateMenuIndication() {
        this.updateFileMenuIndication();
        this.updateElementMenuIndication();
        this.updateMiscMenuIndication();
    }

    public void updateFileMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunDrawingMapModel.$((String)"fileMenu"));
        StMenuItem stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"saveMap"));
        if (stMenuItem != null) {
            if (this.mapObject().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"saveAsMap"))) != null) {
            if (this.mapObject().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
    }

    public void updateElementMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunDrawingMapModel.$((String)"elementMenu"));
        StMenuItem stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"addMenu"));
        if (stMenuItem != null) {
            StMenuItem stMenuItem2 = ((StMenu)stMenuItem).atNameKey_(JunDrawingMapModel.$((String)"addLinkElement"));
            if (stMenuItem2 != null) {
                if (this.mapObject().selectedElements().isEmpty()) {
                    stMenuItem2.beEnabled(false);
                } else {
                    stMenuItem2.beEnabled(true);
                }
            }
            if ((stMenuItem2 = ((StMenu)stMenuItem).atNameKey_(JunDrawingMapModel.$((String)"addLabelElement"))) != null) {
                JunDrawingElement junDrawingElement = this.mapObject().currentElement();
                if (junDrawingElement != null && junDrawingElement.isLink()) {
                    stMenuItem2.beEnabled(true);
                } else {
                    stMenuItem2.beEnabled(false);
                }
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"copyElement"))) != null) {
            if (this.mapObject().selectedElements().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"cutElement"))) != null) {
            if (this.mapObject().selectedElements().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"clearElement"))) != null) {
            if (this.mapObject().selectedElements().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"selectAll"))) != null) {
            if (this.mapObject().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"orderMenu"))) != null) {
            if (this.mapObject().selectedElements().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"openProperties"))) != null) {
            if (!this.mapObject().selectedElements().isEmpty() && this.mapObject().currentElement().propertiesModel() != null) {
                stMenuItem.beEnabled(true);
            } else {
                stMenuItem.beEnabled(false);
            }
        }
    }

    public void updateMiscMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunDrawingMapModel.$((String)"miscMenu"));
        StMenuItem stMenuItem = stMenu.atNameKey_(JunDrawingMapModel.$((String)"fitInSpace"));
        if (stMenuItem != null) {
            if (this.mapObject().isEmpty()) {
                stMenuItem.beEnabled(false);
            } else {
                stMenuItem.beEnabled(true);
            }
        }
    }

    public JunDrawingMapModel newMap() {
        JunDrawingMapModel junDrawingMapModel = new JunDrawingMapModel(new JunDrawingMap());
        junDrawingMapModel.open();
        return junDrawingMapModel;
    }

    public void openMap() {
        JunDrawingMapModel junDrawingMapModel = JunDrawingMapModel.FromUser_(this.fileName());
        if (junDrawingMapModel == null) {
            return;
        }
        this.fileName_(junDrawingMapModel.fileName());
        this.mapObject_(junDrawingMapModel.mapObject());
        this.changed_(JunDrawingMapModel.$((String)"redisplay"));
    }

    public void saveMap() {
        if (this.mapObject().isEmpty()) {
            return;
        }
        if (this.fileName() == null) {
            this.saveAsMap();
            return;
        }
        JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
        BufferedWriter bufferedWriter = null;
        try {
            junCursors._show();
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.fileName()), System.getProperty("file.encoding")));
            bufferedWriter.write(this.defaultHeader());
            bufferedWriter.write(32);
            bufferedWriter.write(40);
            bufferedWriter.write(JunCalendarModel.StringFromDateAndTime_(new Date()));
            bufferedWriter.write(41);
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            this.mapObject().toLispList().saveOn_(bufferedWriter);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                    bufferedWriter = null;
                }
                catch (IOException iOException) {
                    throw new SmalltalkException((Exception)iOException);
                }
            }
            junCursors._restore();
        }
    }

    public void saveAsMap() {
        if (this.mapObject().isEmpty()) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunDrawingMapModel.$String((String)"<1p> files", null, (Object)"DRW"), new String[]{"*.drw", "*.DRW"})};
        File file = this.fileName() == null ? this.defaultFile() : this.fileName();
        file = JunFileRequesterDialog.RequestNewFile(JunDrawingMapModel.$String((String)"Input a <1p> file.", null, (Object)"DRW"), file, fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        this.fileName_(file);
        this.saveMap();
    }

    public void quitDoing() {
        this.closeRequest();
    }

    public void zoomIn() {
        this.scalePoint_(this.scalePoint().x() + 0.1);
    }

    public void zoomOut() {
        this.scalePoint_(this.scalePoint().x() - 0.1);
    }

    public void zoomX1() {
        this.scalePoint_(1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyElement() {
        JunDrawingElement[] junDrawingElementArray;
        if (this.mapObject().isEmpty() || this.mapObject().selectedElements().isEmpty()) {
            return;
        }
        JunDrawingMap junDrawingMap = (JunDrawingMap)JunDrawingMapModel._New(this.mapObject().getClass());
        JunDrawingElement[] junDrawingElementArray2 = this.mapObject()._selectedElements();
        try {
            Object object;
            for (int i = 0; i < junDrawingElementArray2.length; ++i) {
                junDrawingMap.addElement_(junDrawingElementArray2[i]);
                if (!junDrawingElementArray2[i].isLink() || !((JunLinkElement)(object = (JunLinkElement)junDrawingElementArray2[i])).hasLabel() || this.mapObject().selectedElements().contains(((JunLinkElement)object).labelElement())) continue;
                junDrawingMap.addElement_(((JunLinkElement)object).labelElement());
            }
            junDrawingElementArray = new StringWriter();
            object = new PrintWriter((Writer)junDrawingElementArray);
            try {
                ((PrintWriter)object).print(this.defaultHeader());
                ((PrintWriter)object).print(' ');
                ((PrintWriter)object).print('(');
                ((PrintWriter)object).print(JunCalendarModel.StringFromDateAndTime_(new Date()));
                ((PrintWriter)object).print(')');
                ((PrintWriter)object).println();
                ((PrintWriter)object).println();
                junDrawingMap.toLispList().saveOn_((Writer)object);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            finally {
                if (object != null) {
                    ((PrintWriter)object).flush();
                    ((PrintWriter)object).close();
                    object = null;
                }
                if (junDrawingElementArray != null) {
                    try {
                        junDrawingElementArray.close();
                        junDrawingElementArray.flush();
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException.getMessage());
                        iOException.printStackTrace();
                    }
                }
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(junDrawingElementArray.toString());
            clipboard.setContents(stringSelection, this);
        }
        finally {
            junDrawingElementArray = junDrawingMap._componentElements();
            for (int i = 0; i < junDrawingElementArray.length; ++i) {
                junDrawingElementArray[i].parent_(this.mapObject());
            }
        }
    }

    public void cutElement() {
        this.copyElement();
        this.mapObject().removeSelectedElements();
        this.mapObject().changed_(JunDrawingMapModel.$((String)"redisplay"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pasteElement() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        BufferedReader bufferedReader = null;
        try {
            int n;
            bufferedReader = new BufferedReader(new StringReader((String)transferable.getTransferData(DataFlavor.stringFlavor)));
            String string = bufferedReader.readLine();
            if (string.length() < this.defaultHeader().length()) {
                JunDialog.Warn_(JunDrawingMapModel.$String((String)"The contents of copy buffer is not <1p>.", null, (Object)JunDrawingMapModel.$String((String)"Element")));
                return;
            }
            String string2 = string.substring(0, this.defaultHeader().length());
            if (!string2.equals(this.defaultHeader())) {
                JunDialog.Warn_(JunDrawingMapModel.$String((String)"The contents of copy buffer is not <1p>.", null, (Object)JunDrawingMapModel.$String((String)"Element")));
                return;
            }
            bufferedReader.close();
            bufferedReader = null;
            JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_(new StReadStream((String)transferable.getTransferData(DataFlavor.stringFlavor))));
            JunDrawingMap junDrawingMap = (JunDrawingMap)JunDrawingMapModel._New(this.mapObject().getClass(), (Object)((Object)junLispCons));
            JunDrawingElement[] junDrawingElementArray = junDrawingMap._componentElements();
            if (junDrawingElementArray == null || junDrawingElementArray.length == 0) {
                return;
            }
            JunLinkElement[] junLinkElementArray = junDrawingMap._linkElements();
            JunLabelElement[] junLabelElementArray = junDrawingMap._labelElements();
            for (n = 0; n < junDrawingElementArray.length; ++n) {
                int n2;
                long l = junDrawingElementArray[n].id();
                if (this.mapObject().findElement_(l) == null) continue;
                long l2 = junDrawingElementArray[n].assignId();
                if (junDrawingElementArray[n].isNode()) {
                    for (n2 = 0; n2 < junLinkElementArray.length; ++n2) {
                        if (junLinkElementArray[n2].fromElementId() == l) {
                            junLinkElementArray[n2].fromElement_(null);
                            junLinkElementArray[n2].fromElementId_(l2);
                        }
                        if (junLinkElementArray[n2].toElementId() == l) {
                            junLinkElementArray[n2].toElement_(null);
                            junLinkElementArray[n2].toElementId_(l2);
                        }
                        if (junLinkElementArray[n2].labelElementId() != l) continue;
                        junLinkElementArray[n2].labelElement_(null);
                        junLinkElementArray[n2].labelElementId_(l2);
                    }
                    continue;
                }
                if (!junDrawingElementArray[n].isLink()) continue;
                for (n2 = 0; n2 < junLabelElementArray.length; ++n2) {
                    if (junLabelElementArray[n2].baseElementId() != l) continue;
                    junLabelElementArray[n2].baseElement_(null);
                    junLabelElementArray[n2].baseElementId_(l2);
                }
            }
            for (n = 0; n < junDrawingElementArray.length; ++n) {
                this.mapObject().addElement_(junDrawingElementArray[n]);
            }
            for (n = 0; n < junLinkElementArray.length; ++n) {
                if (!junLinkElementArray[n].checkElement()) {
                    this.mapObject().removeElement_(junLinkElementArray[n]);
                    continue;
                }
                junLinkElementArray[n].updateFromToPoint();
            }
            for (n = 0; n < junLabelElementArray.length; ++n) {
                if (!junLabelElementArray[n].checkElement() || junLabelElementArray[n].baseElement().hasLabel() && junLabelElementArray[n].baseElement().labelElement() != junLabelElementArray[n]) {
                    this.mapObject().removeElement_(junLabelElementArray[n]);
                    continue;
                }
                junLabelElementArray[n].baseElement().labelElement_(junLabelElementArray[n]);
            }
            this.mapObject().clearSelectedElements();
            for (n = 0; n < junDrawingElementArray.length; ++n) {
                this.mapObject().addSelectedElement_(junDrawingElementArray[n]);
            }
            this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (IOException iOException) {
                    throw new SmalltalkException((Exception)iOException);
                }
            }
        }
    }

    public void clearElement() {
        if (this.mapObject().selectedElements().isEmpty()) {
            return;
        }
        if (JunDialog.Confirm_(JunDrawingMapModel.$String((String)"Really clear?"), true)) {
            this.mapObject().removeSelectedElements();
            this.mapObject().changed_(JunDrawingMapModel.$((String)"redisplay"));
        }
    }

    public void selectAll() {
        JunDrawingMap junDrawingMap = this.mapObject();
        junDrawingMap.flushSelectedElements();
        JunDrawingElement[] junDrawingElementArray = this.mapObject()._componentElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junDrawingMap.addSelectedElement_(junDrawingElementArray[i]);
        }
        junDrawingMap.changed_(JunDrawingMapModel.$((String)"selection"));
    }

    public void topElement() {
        JunDrawingMap junDrawingMap = this.mapObject();
        if (junDrawingMap.selectedElements().isEmpty()) {
            return;
        }
        JunDrawingElement[] junDrawingElementArray = junDrawingMap._selectedElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junDrawingMap.removeElement_(junDrawingElementArray[i]);
            junDrawingMap.addElement_(junDrawingElementArray[i]);
            junDrawingMap.addSelectedElement_(junDrawingElementArray[i]);
        }
        junDrawingMap.changed_(JunDrawingMapModel.$((String)"selection"));
    }

    public void forwardElement() {
        JunDrawingMap junDrawingMap = this.mapObject();
        if (junDrawingMap.selectedElements().isEmpty()) {
            return;
        }
        ArrayList arrayList = junDrawingMap.componentElements();
        JunDrawingElement[] junDrawingElementArray = junDrawingMap._selectedElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            JunDrawingElement junDrawingElement = junDrawingElementArray[i];
            int n = junDrawingMap.componentElementIndexOf_(junDrawingElement);
            if (n + 1 >= junDrawingMap.componentElementSize() || junDrawingMap.selectedElements().contains(arrayList.get(n + 1))) continue;
            junDrawingMap.removeElement_(junDrawingElement);
            junDrawingMap.addElement_beforeIndex_(junDrawingElement, n + 1);
            junDrawingMap.addSelectedElement_(junDrawingElement);
        }
        junDrawingMap.changed_(JunDrawingMapModel.$((String)"selection"));
    }

    public void backwardElement() {
        JunDrawingMap junDrawingMap = this.mapObject();
        if (junDrawingMap.selectedElements().isEmpty()) {
            return;
        }
        ArrayList arrayList = junDrawingMap.componentElements();
        JunDrawingElement[] junDrawingElementArray = junDrawingMap._selectedElements();
        for (int i = junDrawingElementArray.length - 1; i >= 0; --i) {
            JunDrawingElement junDrawingElement = junDrawingElementArray[i];
            int n = junDrawingMap.componentElementIndexOf_(junDrawingElement);
            if (n <= 0 || junDrawingMap.selectedElements().contains(arrayList.get(n - 1))) continue;
            junDrawingMap.removeElement_(junDrawingElement);
            junDrawingMap.addElement_beforeIndex_(junDrawingElement, n - 1);
            junDrawingMap.addSelectedElement_(junDrawingElement);
        }
        junDrawingMap.changed_(JunDrawingMapModel.$((String)"selection"));
    }

    public void bottomElement() {
        JunDrawingMap junDrawingMap = this.mapObject();
        if (junDrawingMap.selectedElements().isEmpty()) {
            return;
        }
        JunDrawingElement[] junDrawingElementArray = junDrawingMap._selectedElements();
        for (int i = 0; i < junDrawingElementArray.length; ++i) {
            junDrawingMap.removeElement_(junDrawingElementArray[i]);
            junDrawingMap.addElement_beforeIndex_(junDrawingElementArray[i], 0);
            junDrawingMap.addSelectedElement_(junDrawingElementArray[i]);
        }
        junDrawingMap.changed_(JunDrawingMapModel.$((String)"selection"));
    }

    public void openProperties() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null) {
            return;
        }
        junDrawingElement.openProperties();
    }

    public void addEllipseElement() {
        JunEllipseElement junEllipseElement = new JunEllipseElement();
        this.addElement_(junEllipseElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junEllipseElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addImageElement() {
        JunImageElement junImageElement = new JunImageElement();
        this.addElement_(junImageElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junImageElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addLabelElement() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null) {
            return;
        }
        if (!junDrawingElement.isLink()) {
            JunDialog.Warn_(JunDrawingMapModel.$String((String)"The selected element cannot create a <1p>.", null, (Object)JunDrawingMapModel.$String((String)"Label")));
            return;
        }
        JunLinkElement junLinkElement = (JunLinkElement)junDrawingElement;
        if (junLinkElement.hasLabel()) {
            JunDialog.Warn_(JunDrawingMapModel.$String((String)"The selected element cannot create a <1p>.", null, (Object)JunDrawingMapModel.$String((String)"Label")));
            return;
        }
        JunLabelElement junLabelElement = new JunLabelElement();
        junLinkElement.labelElement_(junLabelElement);
        this.addElement_(junLabelElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junLabelElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addLinkElement() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null) {
            return;
        }
        if (!junDrawingElement.isNode()) {
            JunDialog.Warn_(JunDrawingMapModel.$String((String)"The selected element cannot create a <1p>.", null, (Object)JunDrawingMapModel.$String((String)"Link")));
            return;
        }
        JunNodeElement junNodeElement = (JunNodeElement)junDrawingElement;
        JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
        if (junDrawingMapView == null || !junDrawingMapView.toComponent().isShowing()) {
            return;
        }
        JunDrawingMapController junDrawingMapController = junDrawingMapView.getDrawingMapController();
        junDrawingMapController.displayLinkPointFrom_to_(junNodeElement.center(), junDrawingMapController.cursorPointInModel());
    }

    public void addPathElement() {
        JunPathElement junPathElement = new JunPathElement();
        this.addElement_(junPathElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junPathElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addRectangleElement() {
        JunRectangleElement junRectangleElement = new JunRectangleElement();
        this.addElement_(junRectangleElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junRectangleElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addRoundRectangleElement() {
        JunRoundRectangleElement junRoundRectangleElement = new JunRoundRectangleElement();
        this.addElement_(junRoundRectangleElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junRoundRectangleElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addTextElement() {
        JunTextElement junTextElement = new JunTextElement();
        this.addElement_(junTextElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junTextElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addTextboxElement() {
        JunTextboxElement junTextboxElement = new JunTextboxElement();
        this.addElement_(junTextboxElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junTextboxElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addFreehandElement(ArrayList arrayList) {
        JunFreehandElement junFreehandElement = new JunFreehandElement();
        junFreehandElement.points_(arrayList);
        this.addElement_(junFreehandElement);
        this.mapObject().clearSelectedElements();
        this.mapObject().addSelectedElement_(junFreehandElement);
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public void addElement_(JunDrawingElement junDrawingElement) {
        if (junDrawingElement == null) {
            return;
        }
        Point point = null;
        JunDrawingMapView junDrawingMapView = this.getDrawingMapView();
        if (junDrawingMapView != null && !junDrawingElement.isLink()) {
            point = junDrawingMapView.getDrawingMapController().cursorPoint();
            point = new Point((int)((double)point.x / this.scalePoint().x()), (int)((double)point.y / this.scalePoint().y()));
        } else {
            point = new Point(100, 100);
        }
        if (!junDrawingElement.isLink()) {
            if (junDrawingElement.isVertexes()) {
                JunVertexesElement junVertexesElement = (JunVertexesElement)junDrawingElement;
                if (junVertexesElement.points().isEmpty()) {
                    ArrayList<Point> arrayList = new ArrayList<Point>();
                    arrayList.add(new Point(point.x - 50, point.y));
                    arrayList.add(new Point(point.x + 50, point.y));
                    junVertexesElement.points_(arrayList);
                }
            } else if (junDrawingElement.isLabel()) {
                JunLabelElement junLabelElement = (JunLabelElement)junDrawingElement;
                int n = 0;
                n = junLabelElement.text() != null && junLabelElement.text().length() > 0 ? this.getDrawingMapView().toComponent().getFontMetrics(junLabelElement.font()).stringWidth(junLabelElement.text()) : junLabelElement.defaultExtent().width;
                junLabelElement.extent_(n, junLabelElement.defaultExtent().height);
                Point point2 = junLabelElement.baseElement().center();
                junLabelElement.location_(point2.x - n / 2, point2.y - junLabelElement.height() / 2);
            } else if (junDrawingElement.isRectangular()) {
                Dimension dimension = junDrawingElement.defaultExtent();
                junDrawingElement.location_(point.x - dimension.width / 2, point.y - dimension.height / 2);
                junDrawingElement.extent_(dimension);
            }
        }
        this.mapObject().addElement_(junDrawingElement);
    }

    public void addVertex() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null || !(junDrawingElement.isLink() || junDrawingElement.isPath())) {
            return;
        }
        JunDrawingMapController junDrawingMapController = this.getDrawingMapController();
        if (junDrawingMapController == null) {
            return;
        }
        Point point = junDrawingMapController.popupMenuPoint();
        if (!junDrawingElement.containsPoint_(point)) {
            return;
        }
        if (junDrawingElement.isPath()) {
            ((JunPathElement)junDrawingElement).addOnLine_(point);
        } else if (junDrawingElement.isLink()) {
            ((JunLinkElement)junDrawingElement).addOnLine_(point);
        }
        this.mapObject().changed_with_(JunDrawingMapModel.$((String)"redisplay"), junDrawingElement.bounds());
    }

    public void removeVertex() {
        Point point;
        JunDrawingElement junDrawingElement;
        JunDrawingElement junDrawingElement2 = this.mapObject().currentElement();
        if (junDrawingElement2 == null || !(junDrawingElement2.isLink() || junDrawingElement2.isPath())) {
            return;
        }
        JunDrawingMapController junDrawingMapController = this.getDrawingMapController();
        if (junDrawingMapController == null) {
            return;
        }
        Rectangle rectangle = new Rectangle(junDrawingElement2.bounds());
        if (junDrawingElement2.isPath()) {
            junDrawingElement = (JunPathElement)junDrawingElement2;
            point = ((JunVertexesElement)junDrawingElement).pointInControllPoint_(junDrawingMapController.popupMenuPoint());
            if (point == null) {
                return;
            }
            ((JunVertexesElement)junDrawingElement).remove_(point);
        }
        if (junDrawingElement2.isLink()) {
            junDrawingElement = (JunLinkElement)junDrawingElement2;
            point = ((JunLinkElement)junDrawingElement).pathElement().pointInControllPoint_(junDrawingMapController.popupMenuPoint());
            if (point == null) {
                return;
            }
            ((JunLinkElement)junDrawingElement).remove_(point);
        }
        rectangle.add(junDrawingElement2.bounds());
        rectangle.grow(3, 3);
        this.mapObject().changed_with_(JunDrawingMapModel.$((String)"redisplay"), rectangle);
    }

    public void imageFromFile() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null || !junDrawingElement.isImage()) {
            return;
        }
        JunImageElement junImageElement = (JunImageElement)junDrawingElement;
        File file = junImageElement.file() != null ? junImageElement.file() : new File(JunSystem.DefaultBaseName() + "." + JunSystem.DefaultImageExtension());
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunDrawingMapModel.$String((String)"Image files"), JunSystem.DefaultImageExtensionPatterns())};
        file = JunFileRequesterDialog.Request(JunDrawingMapModel.$String((String)"Select a <1p> file.", null, (Object)JunDrawingMapModel.$String((String)"Image files")), file, fileTypeArray, fileTypeArray[0], null, null);
        if (file == null || file.equals(junImageElement.file())) {
            return;
        }
        junImageElement.file_(file);
        this.mapObject().changed_with_(JunDrawingMapModel.$((String)"redisplay"), junImageElement.bounds());
    }

    public void imageFromUser() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null || !junDrawingElement.isImage()) {
            return;
        }
        JunImageElement junImageElement = (JunImageElement)junDrawingElement;
        junImageElement.image_(StImage._FromUser());
        this.mapObject().changed_with_(JunDrawingMapModel.$((String)"redisplay"), junImageElement.bounds());
    }

    public void imageTakeAway() {
        JunDrawingElement junDrawingElement = this.mapObject().currentElement();
        if (junDrawingElement == null || !junDrawingElement.isImage()) {
            return;
        }
        JunImageElement junImageElement = (JunImageElement)junDrawingElement;
        junImageElement.image_(null);
        this.mapObject().changed_with_(JunDrawingMapModel.$((String)"redisplay"), junImageElement.bounds());
    }

    public void fitInSpace() {
        this.mapObject().flushBounds();
        this.mapObject().changed_(JunDrawingMapModel.$((String)"bounds"));
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createElementMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    public StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"File"), JunDrawingMapModel.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"New"), JunDrawingMapModel.$((String)"newMap"), (MenuListener)new MenuPerformer((StObject)this, "newMap"), 78, 2));
        stMenu.add(new StMenuItem((Object)(JunDrawingMapModel.$String((String)"Open") + "..."), JunDrawingMapModel.$((String)"openMap"), (MenuListener)new MenuPerformer((StObject)this, "openMap"), 79, 2));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)(JunDrawingMapModel.$String((String)"Save") + "..."), JunDrawingMapModel.$((String)"saveMap"), (MenuListener)new MenuPerformer((StObject)this, "saveMap"), 83, 8));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Save as..."), JunDrawingMapModel.$((String)"saveAsMap"), (MenuListener)new MenuPerformer((StObject)this, "saveAsMap")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Close"), JunDrawingMapModel.$((String)"quitDoing"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    public StMenu _createViewMenu() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"View Menu", (String)"View"), JunDrawingMapModel.$((String)"viewMenu"));
        StMenu stMenu2 = new StMenu((Object)JunDrawingMapModel.$String((String)"Zooming"), JunDrawingMapModel.$((String)"zoomMenu"));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Zoom in"), JunDrawingMapModel.$((String)"zoomIn"), (MenuListener)new MenuPerformer((StObject)this, "zoomIn")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"x 1"), JunDrawingMapModel.$((String)"zoomX1"), (MenuListener)new MenuPerformer((StObject)this, "zoomX1")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Zoom out"), JunDrawingMapModel.$((String)"zoomOut"), (MenuListener)new MenuPerformer((StObject)this, "zoomOut")));
        stMenu.add((StMenuItem)stMenu2);
        return stMenu;
    }

    public StMenu _createElementMenu() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"Element"), JunDrawingMapModel.$((String)"elementMenu"));
        StMenu stMenu2 = new StMenu((Object)JunDrawingMapModel.$String((String)"Add"), JunDrawingMapModel.$((String)"addMenu"));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Text"), JunDrawingMapModel.$((String)"addTextElement"), (MenuListener)new MenuPerformer((StObject)this, "addTextElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Ellipse"), JunDrawingMapModel.$((String)"addEllipseElement"), (MenuListener)new MenuPerformer((StObject)this, "addEllipseElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Rectangle"), JunDrawingMapModel.$((String)"addRectangleElement"), (MenuListener)new MenuPerformer((StObject)this, "addRectangleElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Round Rectangle"), JunDrawingMapModel.$((String)"addRoundRectangleElement"), (MenuListener)new MenuPerformer((StObject)this, "addRoundRectangleElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Path"), JunDrawingMapModel.$((String)"addPathElement"), (MenuListener)new MenuPerformer((StObject)this, "addPathElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Textbox"), JunDrawingMapModel.$((String)"addTextboxElement"), (MenuListener)new MenuPerformer((StObject)this, "addTextboxElement")));
        stMenu2.addSeparator();
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Link"), JunDrawingMapModel.$((String)"addLinkElement"), (MenuListener)new MenuPerformer((StObject)this, "addLinkElement")));
        stMenu2.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Label"), JunDrawingMapModel.$((String)"addLabelElement"), (MenuListener)new MenuPerformer((StObject)this, "addLabelElement")));
        stMenu.add((StMenuItem)stMenu2);
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Cut"), JunDrawingMapModel.$((String)"cutElement"), (MenuListener)new MenuPerformer((StObject)this, "cutElement"), 88, 2));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Copy"), JunDrawingMapModel.$((String)"copyElement"), (MenuListener)new MenuPerformer((StObject)this, "copyElement"), 67, 2));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Paste"), JunDrawingMapModel.$((String)"pasteElement"), (MenuListener)new MenuPerformer((StObject)this, "pasteElement"), 86, 2));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Clear"), JunDrawingMapModel.$((String)"clearElement"), (MenuListener)new MenuPerformer((StObject)this, "clearElement")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Select all"), JunDrawingMapModel.$((String)"selectAll"), (MenuListener)new MenuPerformer((StObject)this, "selectAll"), 65, 2));
        stMenu.addSeparator();
        StMenu stMenu3 = new StMenu((Object)JunDrawingMapModel.$String((String)"Order"), JunDrawingMapModel.$((String)"orderMenu"));
        stMenu3.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Bring to Front"), JunDrawingMapModel.$((String)"topElement"), (MenuListener)new MenuPerformer((StObject)this, "topElement")));
        stMenu3.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Bring Forward"), JunDrawingMapModel.$((String)"frontElement"), (MenuListener)new MenuPerformer((StObject)this, "forwardElement")));
        stMenu3.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Send Backward"), JunDrawingMapModel.$((String)"backElement"), (MenuListener)new MenuPerformer((StObject)this, "backwardElement")));
        stMenu3.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Send to Back"), JunDrawingMapModel.$((String)"bottomElement"), (MenuListener)new MenuPerformer((StObject)this, "bottomElement")));
        stMenu.add((StMenuItem)stMenu3);
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Properties"), JunDrawingMapModel.$((String)"openProperties"), (MenuListener)new MenuPerformer((StObject)this, "openProperties")));
        return stMenu;
    }

    public StMenu[] _createElementMenuForImageElement() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"Image"), JunDrawingMapModel.$((String)"imageMenu"));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"From file..."), JunDrawingMapModel.$((String)"imageFromFile"), (MenuListener)new MenuPerformer((StObject)this, "imageFromFile")));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"From user..."), JunDrawingMapModel.$((String)"imageFromUser"), (MenuListener)new MenuPerformer((StObject)this, "imageFromUser")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Take away"), JunDrawingMapModel.$((String)"imageTakeAway"), (MenuListener)new MenuPerformer((StObject)this, "imageTakeAway")));
        return new StMenu[]{stMenu};
    }

    public StMenu[] _createElementMenuForPathElement() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"Vertex"), JunDrawingMapModel.$((String)"vertexMenu"));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Add"), JunDrawingMapModel.$((String)"addVertex"), (MenuListener)new MenuPerformer((StObject)this, "addVertex")));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Remove"), JunDrawingMapModel.$((String)"removeVertex"), (MenuListener)new MenuPerformer((StObject)this, "removeVertex")));
        return new StMenu[]{stMenu};
    }

    public StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunDrawingMapModel.$String((String)"Misc"), JunDrawingMapModel.$((String)"miscMenu"));
        stMenu.add(new StMenuItem((Object)JunDrawingMapModel.$String((String)"Fit in space"), JunDrawingMapModel.$((String)"fitInSpace"), (MenuListener)new MenuPerformer((StObject)this, "fitInSpace")));
        return stMenu;
    }

    public HashMap popupMenuTable() {
        if (this.popupMenuTable == null) {
            this.popupMenuTable = new HashMap();
        }
        return this.popupMenuTable;
    }

    public StPopupMenu popupMenuFor_(JunDrawingElement junDrawingElement) {
        StSymbol stSymbol;
        StSymbol stSymbol2 = stSymbol = junDrawingElement != null ? junDrawingElement._className() : null;
        if (!this.popupMenuTable().containsKey(stSymbol)) {
            StMenu[] stMenuArray;
            int n;
            StMenu[] stMenuArray2;
            StPopupMenu stPopupMenu = new StPopupMenu();
            StMenuItem[] stMenuItemArray = ((StMenu)this._menuBar().atNameKey_(JunDrawingMapModel.$((String)JunDrawingMapModel.$String((String)"elementMenu")))).menuItems();
            for (int i = 0; i < stMenuItemArray.length; ++i) {
                stPopupMenu.add(stMenuItemArray[i]);
            }
            if (junDrawingElement != null && (junDrawingElement.isPath() || junDrawingElement.isLink()) && (stMenuArray2 = this._createElementMenuForPathElement()) != null && stMenuArray2.length > 0) {
                for (n = 0; n < stMenuArray2.length; ++n) {
                    stPopupMenu.add((StMenuItem)stMenuArray2[n]);
                }
            }
            if (junDrawingElement != null && junDrawingElement.isImage() && (stMenuArray = this._createElementMenuForImageElement()) != null && stMenuArray.length > 0) {
                for (n = 0; n < stMenuArray.length; ++n) {
                    stPopupMenu.add((StMenuItem)stMenuArray[n]);
                }
            }
            this.popupMenuTable().put(stSymbol, stPopupMenu);
        }
        return (StPopupMenu)this.popupMenuTable().get(stSymbol);
    }

    public boolean isZooming() {
        return !Jun2dPoint.Unity().equal_((Object)this.scalePoint());
    }

    public void update_(DependentEvent dependentEvent) {
        super.update_(dependentEvent);
        this.changed_(dependentEvent);
    }

    protected void fileName_(File file) {
        this.fileName = file;
    }
}

