/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.files;

import java.awt.Choice;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.files.JunFileView;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunFileViewAwt
extends JunAbstractViewPanel
implements JunFileView {
    protected Label fileLabel;
    protected TextField fileName;
    protected List fileList;
    protected Label fileTypeLabel;
    protected Choice fileType;
    protected Label directoryLabel;
    protected Label currentDirectoryLabel;
    protected List directoryList;
    protected Label driveLabel;
    protected Choice currentDrive;

    public JunFileViewAwt(JunFileModel junFileModel) {
        super(junFileModel);
    }

    protected void buildComponent() {
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(this.fileLabel(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)4));
        this.add(this.fileName(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)32, (float)0.5f, (int)-4, (float)0.0f, (int)60));
        this.add(this.fileList(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)0.0f, (int)68, (float)0.5f, (int)-4, (float)1.0f, (int)-72));
        this.add(this.fileTypeLabel(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)1.0f, (int)-62));
        this.add(this.fileType(), WindowSpecLayout.Position((float)0.0f, (int)8, (float)1.0f, (int)-36, (float)0.5f, (int)-4, (float)1.0f, (int)-8));
        this.add(this.directoryLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)4));
        this.add(this.currentDirectoryLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)32, (float)1.0f, (int)-8, (float)0.0f, (int)60));
        this.add(this.directoryList(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)0.0f, (int)68, (float)1.0f, (int)-8, (float)1.0f, (int)-72));
        this.add(this.driveLabel(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)1.0f, (int)-62));
        this.add(this.currentDrive(), WindowSpecLayout.Position((float)0.5f, (int)4, (float)1.0f, (int)-36, (float)1.0f, (int)-8, (float)1.0f, (int)-8));
        this.setSize(500, 300);
        this.getFileModel().currentDirectory();
        this.getFileModel().updateCurrentDirectoryLabel();
        this.getFileModel().updateDirectoryAndFileList();
        this.getFileModel().updateCurrentDrive();
    }

    public JunFileModel getFileModel() {
        return (JunFileModel)this.model();
    }

    protected Label currentDirectoryLabel() {
        if (this.currentDirectoryLabel == null) {
            this.currentDirectoryLabel = new Label();
            this.getFileModel().currentDirectoryLabel().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileViewAwt.this.currentDirectoryLabel.setText((String)object);
                    return null;
                }
            });
        }
        return this.currentDirectoryLabel;
    }

    protected Choice currentDrive() {
        if (this.currentDrive == null) {
            this.currentDrive = new Choice();
            File[] fileArray = this.getFileModel().drives();
            for (int i = 0; i < fileArray.length; ++i) {
                this.currentDrive.addItem(fileArray[i].getPath().toUpperCase());
            }
            this.getFileModel();
            this.currentDrive.addItem(JunFileModel.DefaultDirectoryItem);
            this.currentDrive.select(((File)this.getFileModel().currentDrive().value()).getPath().toUpperCase());
            this.currentDrive.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        JunFileViewAwt.this.getFileModel().currentDriveChanged(JunFileViewAwt.this.currentDrive.getSelectedItem());
                    }
                }
            });
            this.getFileModel().currentDrive().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    String string = ((File)object).getPath().toUpperCase();
                    if (!string.equals(JunFileViewAwt.this.currentDrive.getSelectedItem())) {
                        JunFileViewAwt.this.currentDrive.select(string);
                    }
                    return null;
                }
            });
        }
        return this.currentDrive;
    }

    protected Label directoryLabel() {
        if (this.directoryLabel == null) {
            this.directoryLabel = new BoldLabel(JunSystem.$String((String)"Directory") + ":");
        }
        return this.directoryLabel;
    }

    protected List directoryList() {
        if (this.directoryList == null) {
            this.directoryList = new List();
            this.directoryList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JunFileViewAwt.this.getFileModel().directoryListDoubleClicked(JunFileViewAwt.this.directoryList.getSelectedIndex(), actionEvent.getActionCommand());
                }
            });
            this.getFileModel().directoryList().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    Object[] objectArray = (Object[])object;
                    int n = JunFileViewAwt.this.getFileModel().currentDirectoryLevel();
                    String string = "";
                    JunFileViewAwt.this.directoryList.removeAll();
                    for (int i = 0; i < objectArray.length; ++i) {
                        JunFileViewAwt.this.directoryList.add(string + objectArray[i]);
                        if (i >= n) continue;
                        string = string + "  ";
                    }
                    return null;
                }
            });
        }
        return this.directoryList;
    }

    protected Label driveLabel() {
        if (this.driveLabel == null) {
            this.driveLabel = new BoldLabel(JunSystem.$String((String)"Drive") + ":");
        }
        return this.driveLabel;
    }

    protected Label fileLabel() {
        if (this.fileLabel == null) {
            this.fileLabel = new BoldLabel(JunSystem.$String((String)"File") + ":");
        }
        return this.fileLabel;
    }

    protected List fileList() {
        if (this.fileList == null) {
            this.fileList = new List();
            this.fileList.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (JunFileViewAwt.this.fileList.getSelectedIndex() < 0) {
                        return;
                    }
                    JunFileViewAwt.this.getFileModel().fileListChanged(JunFileViewAwt.this.fileList.getSelectedItem());
                }
            });
            this.getFileModel().fileList().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    Object[] objectArray = (Object[])object;
                    JunFileViewAwt.this.fileList.removeAll();
                    for (int i = 0; i < objectArray.length; ++i) {
                        JunFileViewAwt.this.fileList.add((String)objectArray[i]);
                    }
                    return null;
                }
            });
            this.getFileModel().fileName().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    String[] stringArray = JunFileViewAwt.this.fileList.getItems();
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!stringArray[i].equals(object)) continue;
                        JunFileViewAwt.this.fileList.select(i);
                        return null;
                    }
                    JunFileViewAwt.this.fileList.deselect(JunFileViewAwt.this.fileList.getSelectedIndex());
                    return null;
                }
            });
        }
        return this.fileList;
    }

    protected TextField fileName() {
        if (this.fileName == null) {
            this.fileName = new TextField();
            this.fileName.setText((String)this.getFileModel().fileName().value());
            this.fileName.selectAll();
            this.fileName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!JunFileViewAwt.this.fileName.getText().equals(JunFileViewAwt.this.getFileModel().fileName())) {
                        JunFileViewAwt.this.getFileModel().fileNameChanged(JunFileViewAwt.this.fileName.getText());
                    }
                }
            });
            this.fileName.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (!JunFileViewAwt.this.fileName.getText().equals(JunFileViewAwt.this.getFileModel().fileName())) {
                        JunFileViewAwt.this.getFileModel().fileNameChanged(JunFileViewAwt.this.fileName.getText());
                    }
                }
            });
            this.getFileModel().fileName().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunFileViewAwt.this.fileName.setText((String)object);
                    return null;
                }
            });
        }
        return this.fileName;
    }

    protected Choice fileType() {
        if (this.fileType == null) {
            this.fileType = new Choice();
            JunFileModel.FileType[] fileTypeArray = this.getFileModel().fileTypes();
            for (int i = 0; i < fileTypeArray.length; ++i) {
                this.fileType.addItem(fileTypeArray[i].name());
            }
            this.fileType.select(((JunFileModel.FileType)this.getFileModel().fileType().value()).name());
            this.fileType.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        JunFileViewAwt.this.getFileModel().fileTypeChanged(JunFileViewAwt.this.fileType.getSelectedIndex());
                    }
                }
            });
            this.getFileModel().fileType().compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    String string = ((JunFileModel.FileType)object).name();
                    if (!string.equals(JunFileViewAwt.this.fileType.getSelectedItem())) {
                        JunFileViewAwt.this.fileType.select(string);
                    }
                    return null;
                }
            });
        }
        return this.fileType;
    }

    protected Label fileTypeLabel() {
        if (this.fileTypeLabel == null) {
            this.fileTypeLabel = new BoldLabel(JunSystem.$String((String)"File Type") + ":");
        }
        return this.fileTypeLabel;
    }

    class BoldLabel
    extends Label {
        public BoldLabel(String string) {
            super(string);
        }

        public void addNotify() {
            super.addNotify();
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

