/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunSraGifImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StImage;
import org.w3c.dom.Node;

public class JunGifAnimationStream
extends JunSraGifImageStream {
    protected boolean firstTime;
    protected int delayTime;
    protected int loopCount;
    private ImageReader _imageReader;
    private int _imageIndex;
    private ImageReadParam _imageReadParam;
    private ReadableByteChannel _byteChannel;
    private ByteBuffer _byteBuffer;
    private static int _ByteBufferSize = 256;

    public static JunImageStream On_(InputStream inputStream) throws IOException {
        return JunGifAnimationStream.On_((JunImageStream)new JunGifAnimationStream(), inputStream);
    }

    public static JunImageStream On_(OutputStream outputStream) throws IOException {
        return JunGifAnimationStream.On_((JunImageStream)new JunGifAnimationStream(), outputStream);
    }

    protected void initialize() {
        this.firstTime = true;
        this.delayTime = 0;
        this.loopCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void on_(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream;
        this.initialize();
        super.on_(inputStream);
        if (inputStream instanceof FileInputStream) {
            this._byteChannel = ((FileInputStream)inputStream).getChannel();
            try {
                this.readHeader();
                this.readApplicationExtensionBlock();
            }
            finally {
                ((FileChannel)this._byteChannel).position(0L);
            }
        } else {
            this._byteChannel = Channels.newChannel(inputStream);
        }
        if ((imageInputStream = ImageIO.createImageInputStream(inputStream)) == null) {
            throw new IOException("Failed to create an image input stream.");
        }
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            imageInputStream.close();
            throw new IOException("No image readers are available.");
        }
        this._imageReader = iterator.next();
        this._imageReader.setInput(imageInputStream);
        this._imageIndex = this._imageReader.getMinIndex();
        this._imageReadParam = this._imageReader.getDefaultReadParam();
    }

    protected void on_(OutputStream outputStream) throws IOException {
        this.initialize();
        super.on_(outputStream);
    }

    public int loop() {
        return this.loopCount;
    }

    public void loop_(int n) {
        this.loopCount = n < 0 ? 0 : Math.max(0, Math.min(n, 65535));
    }

    public int tick() {
        return this.delayTime * 10;
    }

    public void tick_(int n) {
        this.delayTime = Math.max(0, Math.min(n / 10, 65535));
    }

    public StImage nextImage() throws IOException {
        try {
            Node node;
            Object object;
            IIOMetadata iIOMetadata = this._imageReader.getImageMetadata(this._imageIndex);
            String string = iIOMetadata.getNativeMetadataFormatName();
            Node node2 = iIOMetadata.getAsTree(string);
            for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if ("ImageDescriptor".equals(node2.getNodeName())) {
                    object = node2.getAttributes();
                    node = object.getNamedItem("imageLeftPosition");
                    Node node3 = object.getNamedItem("imageTopPosition");
                    if (node == null || node3 == null) continue;
                    int n = Integer.parseInt(node.getNodeValue());
                    int n2 = Integer.parseInt(node3.getNodeValue());
                    this._imageReadParam.setDestinationOffset(new Point(n, n2));
                    continue;
                }
                if (!"GraphicControlExtension".equals(node2.getNodeName()) || (node = (object = node2.getAttributes()).getNamedItem("delayTime")) == null) continue;
                this.delayTime = Integer.parseInt(node.getNodeValue());
            }
            object = this._imageReader.read(this._imageIndex, this._imageReadParam);
            ++this._imageIndex;
            this._imageReadParam.setDestination((BufferedImage)object);
            node = new StImage((Image)object);
            node = (StImage)node.clone();
            return node;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("image index at " + this._imageIndex);
            return null;
        }
    }

    protected void readHeader() throws IOException {
        if (!this.hasMagicNumber_("GIF89a".getBytes())) {
            throw SmalltalkException.Error((String)"can't read the image");
        }
        this.readWord();
        this.readWord();
        byte by = this.next();
        boolean bl = (by & 0x80) != 0;
        this.bitsPerPixel = (by & 7) + 1;
        this.next();
        this.next();
        if (bl) {
            int n = 1 << this.bitsPerPixel;
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.next();
                byArray2[i] = this.next();
                byArray3[i] = this.next();
            }
            this.colorModel = new IndexColorModel(this.bitsPerPixel, n, byArray, byArray2, byArray3);
        } else {
            System.err.println("GIF file does not have a color table.");
            this.colorModel = JunImageProcessor._BlackWhitePalette();
        }
    }

    protected void readApplicationExtensionBlock() throws IOException {
        if (this.next() != 33) {
            return;
        }
        if (this.next() != -1) {
            return;
        }
        if (this.next() != 11) {
            return;
        }
        byte[] byArray = "NETSCAPE".getBytes();
        if (!Arrays.equals(byArray, this.next_(byArray.length))) {
            return;
        }
        byArray = "2.0".getBytes();
        if (!Arrays.equals(byArray, this.next_(byArray.length))) {
            return;
        }
        if (this.next() != 3) {
            // empty if block
        }
        if (this.next() != 1) {
            // empty if block
        }
        this.loopCount = this.readWord();
        if (this.next() != 0) {
            // empty if block
        }
    }

    protected int readWord() throws IOException {
        return (this.next() & 0xFF) + (this.next() << 8);
    }

    protected boolean hasMagicNumber_(byte[] byArray) throws IOException {
        int n = this._fillBuffer(byArray.length);
        if (n < byArray.length) {
            return false;
        }
        this._byteBuffer.mark();
        byte[] byArray2 = new byte[byArray.length];
        this._byteBuffer.get(byArray2);
        if (Arrays.equals(byArray, byArray2)) {
            return true;
        }
        this._byteBuffer.reset();
        return false;
    }

    protected int _fillBuffer(int n) throws IOException {
        ByteBuffer byteBuffer;
        if (this._byteBuffer == null) {
            this._byteBuffer = ByteBuffer.allocate(Math.max(n, _ByteBufferSize));
            n = this._byteChannel.read(this._byteBuffer);
            this._byteBuffer.clear();
            return n;
        }
        int n2 = this._byteBuffer.limit() - this._byteBuffer.position();
        if (n2 >= n) {
            return n2;
        }
        if (this._byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(Math.max(n, _ByteBufferSize));
            byteBuffer.put(this._byteBuffer);
            this._byteBuffer = byteBuffer;
        } else {
            this._byteBuffer.compact();
        }
        byteBuffer = ByteBuffer.allocate(this._byteBuffer.limit() - this._byteBuffer.position());
        this._byteChannel.read(byteBuffer);
        byteBuffer.clear();
        this._byteBuffer.put(byteBuffer);
        this._byteBuffer.flip();
        return this._byteBuffer.limit() - this._byteBuffer.position();
    }

    public void nextPutImage_(StImage stImage) throws IOException {
        byte[] byArray = this.bitsFor_(stImage);
        if (this.firstTime) {
            this.writeHeader();
            this.writeApplicationExtensionBlock();
            this.firstTime = false;
        }
        this.writeGraphicControlExtensionBlock();
        this.writeImageBlock_(byArray);
    }

    protected void writeApplicationExtensionBlock() throws IOException {
        this.nextPut_(33);
        this.nextPut_(-1);
        this.nextPut_(11);
        this.nextPutAll_("NETSCAPE".getBytes());
        this.nextPutAll_("2.0".getBytes());
        this.nextPut_(3);
        this.nextPut_(1);
        this.writeWord_(this.loopCount);
        this.nextPut_(0);
    }

    protected void writeGraphicControlExtensionBlock() throws IOException {
        this.nextPut_(33);
        this.nextPut_(-7);
        this.nextPut_(4);
        if (this.transparentColorIndex >= 0) {
            this.nextPut_(1);
        } else {
            this.nextPut_(0);
        }
        this.writeWord_(this.delayTime);
        if (this.transparentColorIndex >= 0) {
            this.nextPut_(this.transparentColorIndex);
        } else {
            this.nextPut_(0);
        }
        this.nextPut_(0);
    }

    protected void writeImageBlock_(byte[] byArray) throws IOException {
        this.nextPut_(44);
        this.writeWord_(0);
        this.writeWord_(0);
        this.writeWord_(this.width);
        this.writeWord_(this.height);
        this.nextPut_(this.interlace ? 64 : 0);
        this.writeBitData_(byArray);
    }

    public boolean atEnd() throws IOException {
        return this._fillBuffer(1) == 0;
    }

    public byte next() throws IOException {
        this._fillBuffer(1);
        return this._byteBuffer.get();
    }

    public byte[] next_(int n) throws IOException {
        if (this._fillBuffer(n) < n) {
            return null;
        }
        byte[] byArray = new byte[n];
        this._byteBuffer.get(byArray);
        return byArray;
    }

    public void close() throws IOException {
        if (this.outStream != null) {
            this.nextPut_(59);
        }
        if (this._imageReader != null) {
            ImageInputStream imageInputStream = (ImageInputStream)this._imageReader.getInput();
            imageInputStream.close();
            this._imageReader.dispose();
            this._imageReader = null;
        }
        if (this._byteChannel != null) {
            this._byteChannel.close();
            this._byteChannel = null;
            this.inStream = null;
        }
        super.close();
    }
}

