/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.streams;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunBmpImageStream;
import jp.co.sra.jun.goodies.image.streams.JunGifImageStream;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.image.streams.JunPngImageStream;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StImage;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class JunImageStreamTestExamples
extends JunTestExamples {
    public static boolean Example0() {
        int n;
        String[] stringArray = ImageIO.getReaderFormatNames();
        System.out.println("ReaderFormatNames:");
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n]);
        }
        stringArray = ImageIO.getWriterFormatNames();
        System.out.println("WriterFormatNames:");
        for (n = 0; n < stringArray.length; ++n) {
            System.out.println(stringArray[n]);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example1_JPEG() {
        StImage stImage = StImage._FromUser();
        File file = JunImageStreamTestExamples.RequestFile("jpg");
        if (file == null) {
            return false;
        }
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunJpegImageStream.On_(new FileOutputStream(file));
            junImageStream.nextPutImage_(stImage);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.flush();
                    junImageStream.close();
                }
                catch (IOException iOException) {}
                junImageStream = null;
            }
        }
        JunImageStream junImageStream2 = null;
        try {
            junImageStream2 = JunJpegImageStream.On_(new FileInputStream(file));
            StImage stImage2 = junImageStream2.nextImage();
            stImage2._display();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream2 != null) {
                try {
                    junImageStream2.close();
                }
                catch (IOException iOException) {}
                junImageStream2 = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example2_PNG() {
        StImage stImage = StImage._FromUser();
        File file = JunImageStreamTestExamples.RequestFile("png");
        if (file == null) {
            return false;
        }
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunPngImageStream.On_(new FileOutputStream(file));
            junImageStream.nextPutImage_(stImage);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.flush();
                    junImageStream.close();
                }
                catch (IOException iOException) {}
                junImageStream = null;
            }
        }
        JunImageStream junImageStream2 = null;
        try {
            junImageStream2 = JunPngImageStream.On_(new FileInputStream(file));
            StImage stImage2 = junImageStream2.nextImage();
            stImage2._display();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream2 != null) {
                try {
                    junImageStream2.close();
                }
                catch (IOException iOException) {}
                junImageStream2 = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example3_BMP() {
        StImage stImage = StImage._FromUser();
        File file = JunImageStreamTestExamples.RequestFile(JunBmpImageStream.DefaultImageExtension);
        if (file == null) {
            return false;
        }
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunBmpImageStream.On_(new FileOutputStream(file));
            junImageStream.nextPutImage_(stImage);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.flush();
                    junImageStream.close();
                }
                catch (IOException iOException) {}
                junImageStream = null;
            }
        }
        JunImageStream junImageStream2 = null;
        try {
            junImageStream2 = JunBmpImageStream.On_(new FileInputStream(file));
            StImage stImage2 = junImageStream2.nextImage();
            stImage2._display();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream2 != null) {
                try {
                    junImageStream2.close();
                }
                catch (IOException iOException) {}
                junImageStream2 = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example4_GIF() {
        File file = JunImageStreamTestExamples.RequestFile("gif");
        if (file == null || !file.exists()) {
            return false;
        }
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunGifImageStream.On_(new FileInputStream(file));
            StImage stImage = junImageStream.nextImage();
            stImage._display();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.close();
                }
                catch (IOException iOException) {}
                junImageStream = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example5_GIF_Write() throws IOException {
        StImage stImage = StImage._FromUser();
        File file = new File("zzz.gif");
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunGifImageStream.On_(new FileOutputStream(file));
            JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
            try {
                junCursors._show();
                junImageStream.nextPutImage_(stImage);
            }
            finally {
                junCursors._restore();
            }
        }
        finally {
            if (junImageStream != null) {
                junImageStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Example6_GIF_Write() throws IOException {
        StImage stImage = JunImageStreamTestExamples.RequestImage("gif");
        if (stImage == null) {
            return false;
        }
        File file = new File("zzzzz.gif");
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunGifImageStream.On_(new FileOutputStream(file));
            JunCursors junCursors = new JunCursors(JunCursors.WriteCursor());
            try {
                junCursors._show();
                junImageStream.nextPutImage_(stImage);
            }
            finally {
                junCursors._restore();
            }
        }
        finally {
            if (junImageStream != null) {
                junImageStream.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean Test_ImageIO() throws IOException {
        File file = JunImageStreamTestExamples.RequestFile("gif");
        if (file == null || !file.exists()) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
        fileChannel.read(byteBuffer);
        fileChannel.position(0L);
        ImageInputStream imageInputStream = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(fileInputStream);
            ImageReader imageReader = null;
            try {
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                if (!iterator.hasNext()) {
                    boolean bl = false;
                    return bl;
                }
                imageReader = iterator.next();
                imageReader.setInput(imageInputStream);
                int n = imageReader.getNumImages(true);
                System.out.println(n);
                IIOMetadata iIOMetadata = imageReader.getStreamMetadata();
                String string = iIOMetadata.getNativeMetadataFormatName();
                Node node = iIOMetadata.getAsTree(string);
                JunImageStreamTestExamples.DisplayMetadata(node);
                iIOMetadata = imageReader.getImageMetadata(0);
                string = iIOMetadata.getNativeMetadataFormatName();
                node = iIOMetadata.getAsTree(string);
                JunImageStreamTestExamples.DisplayMetadata(node);
                ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                BufferedImage bufferedImage = imageReader.read(0, imageReadParam);
                StImage stImage = new StImage((Image)bufferedImage);
                stImage._display();
            }
            finally {
                if (imageReader != null) {
                    imageReader.dispose();
                }
            }
        }
        finally {
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        return true;
    }

    protected static File RequestFile(String string) {
        string = string.toLowerCase();
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunImageStreamTestExamples.$String((String)"<1p> files", null, (Object)string), new String[]{"*." + string, "*." + string.toUpperCase()})};
        return JunFileRequesterDialog.RequestFile(JunImageStreamTestExamples.$String((String)"Select a <1p> file.", null, (Object)string), new File(JunSystem.DefaultBaseName() + "." + string), fileTypeArray, fileTypeArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static StImage RequestImage(String string) {
        File file = JunImageStreamTestExamples.RequestFile(string);
        if (file == null || !file.exists()) {
            return null;
        }
        StImage stImage = null;
        JunImageStream junImageStream = null;
        try {
            junImageStream = JunGifImageStream.On_(new FileInputStream(file));
            stImage = junImageStream.nextImage();
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            StImage stImage2 = null;
            return stImage2;
        }
        finally {
            if (junImageStream != null) {
                try {
                    junImageStream.close();
                }
                catch (IOException iOException) {}
                junImageStream = null;
            }
        }
        return stImage;
    }

    private static void DisplayMetadata(Node node) {
        JunImageStreamTestExamples.DisplayMetadata(node, 0);
    }

    private static void DisplayMetadata(Node node, int n) {
        Node node2;
        JunImageStreamTestExamples.Indent(n);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                Node node3 = namedNodeMap.item(i);
                System.out.print(" " + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\"");
            }
        }
        if ((node2 = node.getFirstChild()) != null) {
            System.out.println(">");
            while (node2 != null) {
                JunImageStreamTestExamples.DisplayMetadata(node2, n + 1);
                node2 = node2.getNextSibling();
            }
            JunImageStreamTestExamples.Indent(n);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    private static void Indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
    }

    public static void main(String[] stringArray) {
        new JunImageStreamTestExamples();
    }
}

