/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.image.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

public class JunImageBorderDecorator
extends JunAbstractObject {
    protected StImage originalImage;
    protected Dimension imageExtent;
    protected boolean keepAspect;
    protected Color boxColor;
    protected Color borderColor;
    protected int borderWidth;

    public JunImageBorderDecorator() {
    }

    public JunImageBorderDecorator(Image image) {
        this(new StImage(image));
    }

    public JunImageBorderDecorator(StImage stImage) {
        this();
        this.originalImage_(stImage);
    }

    protected void initialize() {
        super.initialize();
        this.originalImage = null;
        this.imageExtent = null;
        this.keepAspect = true;
        this.boxColor = this.defaultBoxColor();
        this.borderColor = this.defaultBorderColor();
        this.borderWidth = this.defaultBorderWidth();
    }

    public StImage originalImage() {
        return this.originalImage;
    }

    public void originalImage_(StImage stImage) {
        this.originalImage = stImage;
    }

    public Dimension imageExtent() {
        if (this.imageExtent == null) {
            this.imageExtent = this.minimumImageExtent();
            if (this.originalImage() != null) {
                int n = Math.max(this.imageExtent.width, this.originalImage().width());
                int n2 = Math.max(this.imageExtent.height, this.originalImage().height());
                this.imageExtent = new Dimension(n, n2);
            }
        }
        return this.imageExtent;
    }

    public void imageExtent_(Dimension dimension) {
        this.imageExtent = dimension;
    }

    public boolean keepAspect() {
        return this.keepAspect;
    }

    public void keepAspect_(boolean bl) {
        this.keepAspect = bl;
    }

    public Color boxColor() {
        return this.boxColor;
    }

    public void boxColor_(Color color) {
        this.boxColor = color;
    }

    public Color borderColor() {
        return this.borderColor;
    }

    public void borderColor_(Color color) {
        this.borderColor = color;
    }

    public int borderWidth() {
        return this.borderWidth;
    }

    public void borderWidth_(int n) {
        this.borderWidth = n;
    }

    public StImage simpleImage() {
        return this.decoratedImage(this.originalImage(), this.imageExtent(), Color.white, 0, Color.white);
    }

    public StImage decoratedImage() {
        return this.decoratedImage(this.originalImage(), this.imageExtent(), this.boxColor(), this.borderWidth(), this.borderColor());
    }

    public StImage firstImage() {
        return this.decoratedImage(this.originalImage(), this.imageExtent(), this.defaultFirstBoxColor(), this.borderWidth(), this.defaultFirstBorderColor());
    }

    public StImage currentImage() {
        return this.decoratedImage(this.originalImage(), this.imageExtent(), this.defaultCurrentBoxColor(), this.borderWidth(), this.defaultCurrentBorderColor());
    }

    public StImage lastImage() {
        return this.decoratedImage(this.originalImage(), this.imageExtent(), this.defaultLastBoxColor(), this.borderWidth(), this.defaultLastBorderColor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage decoratedImage(StImage stImage, Dimension dimension, Color color, int n, Color color2) {
        if (stImage == null) {
            return this.oneColorImage(color, dimension);
        }
        StRectangle stRectangle = new StRectangle(dimension);
        Dimension dimension2 = stRectangle.insetBy_(n).extent();
        StImage stImage2 = JunImageAdjuster.AdjustImage_extent_keepAspect_(stImage, dimension2, this.keepAspect());
        StRectangle stRectangle2 = new StRectangle(stImage2.bounds());
        StImage stImage3 = new StImage(dimension);
        Graphics graphics = null;
        try {
            graphics = stImage3.image().getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, stRectangle.width(), stRectangle.height());
            StRectangle stRectangle3 = stRectangle2.expandedBy_(n);
            Point point = stRectangle3.align_with_(stRectangle3.center(), stRectangle.center()).origin();
            graphics.setColor(color2);
            graphics.fillRect(point.x, point.y, stRectangle3.width(), stRectangle3.height());
            point = stRectangle2.align_with_(stRectangle2.center(), stRectangle.center()).origin();
            stImage2.displayOn_at_(graphics, point);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return stImage3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage oneColorImage(Color color, Dimension dimension) {
        StImage stImage = new StImage(dimension.width, dimension.height);
        Graphics graphics = null;
        try {
            graphics = stImage.image().getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
        }
        return stImage;
    }

    protected Color defaultBoxColor() {
        return this.defaultBorderColor();
    }

    protected Color defaultBorderColor() {
        return Color.white;
    }

    protected int defaultBorderWidth() {
        return 1;
    }

    protected Color defaultFirstBoxColor() {
        return StColorValue.Blend((Color)Color.white, (Color)StColorValue.Blend((Color)Color.white, (Color)this.defaultFirstBorderColor()));
    }

    protected Color defaultFirstBorderColor() {
        return Color.blue;
    }

    protected Color defaultCurrentBoxColor() {
        return StColorValue.Blend((Color)Color.white, (Color)StColorValue.Blend((Color)Color.white, (Color)this.defaultCurrentBorderColor()));
    }

    protected Color defaultCurrentBorderColor() {
        return Color.green;
    }

    protected Color defaultLastBoxColor() {
        return StColorValue.Blend((Color)Color.white, (Color)StColorValue.Blend((Color)Color.white, (Color)this.defaultLastBorderColor()));
    }

    protected Color defaultLastBorderColor() {
        return Color.red;
    }

    protected Dimension minimumImageExtent() {
        StRectangle stRectangle = new StRectangle(0, 0, 30, 30);
        stRectangle = stRectangle.expandedBy_(this.borderWidth());
        return stRectangle.extent();
    }
}

