/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.lisp;

import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.system.support.JunTestExamples;

public class JunLispParserTestExamples
extends JunTestExamples {
    public static boolean Example_LongNumber() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("(2002112612345600000)"));
        System.out.println(junLispCons.printString());
        return junLispCons.head() instanceof Long && (Long)junLispCons.head() == 2002112612345600000L;
    }

    public static boolean Example1() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("(1 2 3 4 (5 6 7 8 9) 10)11 12"));
        System.out.println(junLispCons.printString());
        return junLispCons.printString().equals("(1 2 3 4 (5 6 7 8 9) 10)");
    }

    public static boolean Example2() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("\n(10 (1 2)\n20 (3 4 . 100)\n30 (5 6) . 200)\n"));
        System.out.println(junLispCons.printString());
        return junLispCons.printString().equals("(10 (1 2) 20 (3 4 . 100) 30 (5 6) . 200)");
    }

    public static boolean Example3() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("    \n(PetriNet JunAoki          \n\t(Place                  \n\t\t(p1 . {100@100})    \n\t\t(p2 . {200@200})    \n\t\t(p3 . {300@300})    \n\t\t(p4 . {400@400})    \n\t\t(p5 . {500@500}))   \n\t(Transition             \n\t\t(t1 . {100@100})    \n\t\t(t2 . {200@200})    \n\t\t(t3 . {300@300})    \n\t\t(t4 . {400@400})    \n\t\t(t5 . {500@500}))   \n\t(InputFunction          \n\t\t(t1 p1 p2 p3 p4 p5) \n\t\t(t2 . p4)           \n\t\t(t3 . p5))          \n\t(OutputFunction         \n\t\t(t1 p1 p2 p3 p4 p5) \n\t\t(t2 . p4)           \n\t\t(t3 . p5))          \n) "));
        System.out.println(junLispCons.saveString());
        junLispCons = (JunLispCons)((Object)JunLispParser.Parse_(junLispCons.saveString()));
        return true;
    }

    public static boolean Example4() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("(1 2 3 4 (5 6 7 ~ 8 9) 10)"));
        System.out.println(junLispCons.printString());
        return junLispCons.printString().equals("(1 2 3 4 (5 6 7 ~ 8 9) 10)");
    }

    public static boolean Example5() {
        try {
            JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("(1 2 3 4 (5 6 7 {100@100 8 9) 10)"));
            System.out.println(junLispCons.printString());
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean Example6() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_("(1 2 3 4 (5 6 7 'aaaaa 8 9) 10)"));
        System.out.println(junLispCons.printString());
        return junLispCons.printString().equals("(1 2 3 4 (5 6 7 (quote aaaaa) 8 9) 10)");
    }

    public static boolean Example7() {
        JunLispCons junLispCons = (JunLispCons)((Object)JunLispParser.Parse_(" `(`(1 2 `3) . `4) "));
        System.out.println(junLispCons.printString());
        return junLispCons.printString().equals("(quote ((quote (1 2 (quote 3))) quote 4))");
    }

    public static void main(String[] stringArray) {
        new JunLispParserTestExamples();
    }
}

