/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.lisp;

import java.io.StringWriter;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.goodies.lisp.JunLispScannerTable;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.support.JunSmallCompiler;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StNumber;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;

public class JunLispScanner
extends JunAbstractObject {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected StReadStream source;
    protected int mark;
    protected Object token;
    protected StSymbol tokenType;
    protected StBlockClosure failBlock;
    protected JunLispScannerTable typeTable;
    protected JunSmallCompiler compiler;

    public JunLispScanner() {
        this.initScanner();
    }

    public static String ContractTo(String string, int n) {
        int n2 = string.length();
        if (n2 <= n) {
            return string;
        }
        int n3 = n / 2 - 1;
        return string.substring(0, n3) + "..." + string.substring(n2 - n + n3 + 3);
    }

    public void xBinary() {
        this.failBlock.value_((Object)("Syntax error" + this.source.peek()));
    }

    public void xBrace() {
        this.tokenType = JunLispScanner.$((String)"object");
        this.token = this.objectFrom_(this.source);
    }

    public void xComment() {
        char c;
        while ((c = this.nextChar()) != '\r' && c != '!') {
        }
        this.nextToken();
    }

    public void xDigit() {
        this.tokenType = JunLispScanner.$((String)"number");
        this.token = this.numberFrom_(this.source);
    }

    public void xDoubleQuote() {
        this.tokenType = JunLispScanner.$((String)"string");
        this.token = this.stringFrom_(this.source);
    }

    public void xSign() {
        char c = this.nextChar();
        char c2 = this.peekChar();
        if (Character.isDigit(c2)) {
            this.tokenType = JunLispScanner.$((String)"number");
            this.token = this.numberFrom_(this.source);
            if (c == '-') {
                Number number = (Number)this.token;
                if (number instanceof Integer) {
                    this.token = new Integer(-number.intValue());
                    return;
                }
                if (number instanceof Float) {
                    this.token = new Float(-number.floatValue());
                    return;
                }
                if (number instanceof Double) {
                    this.token = new Double(-number.doubleValue());
                    return;
                }
                if (number instanceof Long) {
                    this.token = new Long(-number.longValue());
                    return;
                }
            }
        } else {
            this.unNextChar();
            this.tokenType = JunLispScanner.$((String)"symbol");
            this.token = this.symbolFrom_(this.source);
        }
    }

    public void xSymbol() {
        this.tokenType = JunLispScanner.$((String)"symbol");
        this.token = this.symbolFrom_(this.source);
    }

    protected void initScanner() {
        this.typeTable = JunLispScannerTable.ScannerTable();
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                String string = (String)object;
                String string2 = string + " near " + JunLispScanner.ContractTo(JunLispScanner.this.token.toString(), 10);
                String string3 = JunLispScanner.this.source.upToEnd();
                string3 = string3.length() == 0 ? "--> end of file" : "--> " + JunLispScanner.ContractTo(string3, 30);
                throw SmalltalkException.Error((String)(string2 + "\n" + string3));
            }
        };
        this.compiler = new JunSmallCompiler();
    }

    protected void multiChar_(String string) {
        try {
            this.perform_(string);
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    protected char nextChar() {
        char c = this.source.next();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            if (this.source.peek() == '\n') {
                this.source.next();
            }
            return '\r';
        }
        if (c == '\u0000') {
            return '!';
        }
        return c;
    }

    protected Object nextToken() {
        this.mark = this.source.position();
        char c = this.peekChar();
        this.tokenType = this.typeTable.at_(c);
        while (this.tokenType == JunLispScanner.$((String)"xDelimiter")) {
            this.nextChar();
            c = this.peekChar();
            this.tokenType = this.typeTable.at_(c);
        }
        String string = this.tokenType.toString();
        if (string.charAt(0) == 'x') {
            this.multiChar_(string);
        } else {
            this.singleChar_(string);
        }
        return this.token;
    }

    protected Number numberFrom_(StReadStream stReadStream) {
        return StNumber.ReadFrom_((StReadStream)stReadStream);
    }

    protected Object objectFrom_(StReadStream stReadStream) {
        StringWriter stringWriter = new StringWriter();
        char c = stReadStream.next();
        while ((c = stReadStream.next()) != '}') {
            if (stReadStream.atEnd()) {
                return this.failBlock.value_((Object)"Syntax error unmatched ${");
            }
            stringWriter.write(c);
        }
        return this.compiler.evaluate_in_to_notifying_ifFail_(stringWriter.toString(), null, null, null, new StBlockClosure());
    }

    protected void on_(StReadStream stReadStream) {
        this.source = stReadStream;
        this.mark = this.source.position();
    }

    protected char peekChar() {
        char c = this.source.peek();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            return '\r';
        }
        if (c == '\u0000') {
            return '!';
        }
        return c;
    }

    protected void singleChar_(Object object) {
        this.nextChar();
        this.token = object;
    }

    protected String stringFrom_(StReadStream stReadStream) {
        String string;
        StringWriter stringWriter = new StringWriter();
        char c = stReadStream.next();
        if (c == '\"') {
            while ((c = stReadStream.peek()) != '\u0000') {
                if (c == '\"') {
                    stReadStream.next();
                    c = stReadStream.peek();
                    if (c != '\"') {
                        return new String(stringWriter.toString());
                    }
                }
                stringWriter.write(stReadStream.next());
            }
        }
        if ((string = stReadStream.upToEnd()).length() > 100) {
            string = string.substring(0, 99);
        }
        return (String)this.failBlock.value_((Object)"Syntax error unmatched '\"'");
    }

    protected Object symbolFrom_(StReadStream stReadStream) {
        StSymbol stSymbol;
        StringWriter stringWriter = new StringWriter();
        char c = stReadStream.peek();
        while (c != '\u0000' && ((stSymbol = this.typeTable.at_(c)) == JunLispScanner.$((String)"xSymbol") || stSymbol == JunLispScanner.$((String)"xDigit") || stSymbol == JunLispScanner.$((String)"xSign"))) {
            stringWriter.write(stReadStream.next());
            c = stReadStream.peek();
        }
        String string = stringWriter.toString();
        if (string.equals("nil")) {
            return JunLispNil.NullList();
        }
        return JunLispScanner.$((String)string);
    }

    protected void unNextChar() {
        this.source.skip_(-1);
    }

    protected void unNextToken() {
        this.source.position_(this.mark);
    }
}

