/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.movie.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import jp.co.sra.jun.goodies.movie.support.JunScreenRecorder;
import jp.co.sra.jun.goodies.movie.support.JunScreenRecorderView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StPopupMenuViewSwing;

public class JunScreenRecorderViewSwing
extends JunAbstractViewJPanel
implements JunScreenRecorderView,
ActionListener {
    protected JButton recordButton;
    protected JButton areaButton;
    protected JButton sizeButton;
    protected JButton speedButton;
    protected JButton snapButton;
    protected JPopupMenu areaPopupMenu;
    protected JPopupMenu sizePopupMenu;
    protected JPopupMenu speedPopupMenu;

    public JunScreenRecorderViewSwing(JunScreenRecorder junScreenRecorder) {
        super(junScreenRecorder);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.recordButton) {
            this.getScreenRecorder().recordButtonPressed();
        } else if (actionEvent.getSource() == this.areaButton) {
            if (this.areaPopupMenu == null) {
                this.areaPopupMenu = new StPopupMenuViewSwing(this.getScreenRecorder()._createAreaPopupMenu()).toPopupMenu();
                this.add(this.areaPopupMenu);
            }
            this.areaPopupMenu.show(this.areaButton, 10, 10);
        } else if (actionEvent.getSource() == this.sizeButton) {
            if (this.sizePopupMenu == null) {
                this.sizePopupMenu = new StPopupMenuViewSwing(this.getScreenRecorder()._createSizePopupMenu()).toPopupMenu();
                this.add(this.sizePopupMenu);
            }
            this.sizePopupMenu.show(this.sizeButton, 10, 10);
        } else if (actionEvent.getSource() == this.speedButton) {
            if (this.speedPopupMenu == null) {
                this.speedPopupMenu = new StPopupMenuViewSwing(this.getScreenRecorder()._createSpeedPopupMenu()).toPopupMenu();
                this.add(this.speedPopupMenu);
            }
            this.speedPopupMenu.show(this.speedButton, 10, 10);
        } else if (actionEvent.getSource() == this.snapButton) {
            this.getScreenRecorder().snapButtonPressed();
        }
    }

    public Insets getInsets() {
        return new Insets(6, 6, 6, 6);
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 150);
    }

    public JunScreenRecorder getScreenRecorder() {
        return (JunScreenRecorder)this.model();
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunScreenRecorderViewSwing.$((String)"watchState")) {
            this.updateRecordButtonLabel();
        } else if (stSymbol == JunScreenRecorderViewSwing.$((String)"movieArea")) {
            this.updateAreaButtonLabel();
        } else if (stSymbol == JunScreenRecorderViewSwing.$((String)"movieExtent")) {
            this.updateSizeButtonLabel();
        } else if (stSymbol == JunScreenRecorderViewSwing.$((String)"watchTick")) {
            this.updateSpeedButtonLabel();
        } else {
            super.update_(dependentEvent);
        }
    }

    public void updateAreaButtonLabel() {
        this.areaButton.setText(this.getScreenRecorder().getAreaButtonLabel());
    }

    public void updateRecordButtonLabel() {
        this.recordButton.setText(this.getScreenRecorder().getRecordButtonLabel());
        this.areaButton.setEnabled(!this.getScreenRecorder().getWatchState());
        this.sizeButton.setEnabled(!this.getScreenRecorder().getWatchState());
        this.speedButton.setEnabled(!this.getScreenRecorder().getWatchState());
        this.snapButton.setEnabled(!this.getScreenRecorder().getWatchState());
    }

    public void updateSizeButtonLabel() {
        this.sizeButton.setText(this.getScreenRecorder().getSizeButtonLabel());
    }

    public void updateSpeedButtonLabel() {
        this.speedButton.setText(this.getScreenRecorder().getSpeedButtonLabel());
    }

    protected void buildComponent() {
        this.setBackground(new Color(255, 255, 191));
        this.setLayout(new GridLayout(0, 1, 2, 2));
        this.recordButton = new JButton(JunSystem.$String((String)"Record"));
        this.recordButton.setBackground(new Color(255, 191, 191));
        this.recordButton.addActionListener(this);
        this.add(this.recordButton);
        this.areaButton = new JButton(JunSystem.$String((String)"Snap Area"));
        this.areaButton.setBackground(new Color(191, 255, 191));
        this.areaButton.addActionListener(this);
        this.add(this.areaButton);
        this.sizeButton = new JButton(JunSystem.$String((String)"Snap Size"));
        this.sizeButton.setBackground(new Color(191, 255, 191));
        this.sizeButton.addActionListener(this);
        this.add(this.sizeButton);
        this.speedButton = new JButton(JunSystem.$String((String)"Recording Speed"));
        this.speedButton.setBackground(new Color(191, 255, 191));
        this.speedButton.addActionListener(this);
        this.add(this.speedButton);
        this.snapButton = new JButton(JunSystem.$String((String)"Snap"));
        this.snapButton.setBackground(new Color(191, 191, 255));
        this.snapButton.addActionListener(this);
        this.add(this.snapButton);
        this.updateRecordButtonLabel();
        this.updateAreaButtonLabel();
        this.updateSizeButtonLabel();
        this.updateSpeedButtonLabel();
    }
}

