/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.pen;

import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunPoint;
import jp.co.sra.jun.goodies.pen.JunPenGeometry;
import jp.co.sra.jun.goodies.pen.JunPenTransformation;

public class JunPenLocation
extends JunPenGeometry {
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;

    public JunPenLocation() {
    }

    public JunPenLocation(double d, double d2, double d3) {
        this();
        this.setX_(d);
        this.setY_(d2);
        this.setZ_(d3);
    }

    public static JunPenLocation Coerce_(double[] dArray) {
        return JunPenLocation.FromArray_(dArray);
    }

    public static JunPenLocation Coerce_(double d) {
        return JunPenLocation.FromNumber_(d);
    }

    public static JunPenLocation Coerce_(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz == JunPenLocation.class) {
            return (JunPenLocation)((Object)object);
        }
        if (clazz == Jun2dPoint.class) {
            return JunPenLocation.FromPoint_((Jun2dPoint)((Object)object));
        }
        if (clazz == Jun3dPoint.class) {
            return JunPenLocation.FromPoint_((Jun3dPoint)((Object)object));
        }
        if (clazz == Double.class) {
            return JunPenLocation.FromNumber_((Double)object);
        }
        Vector vector = (Vector)object;
        int n = vector.size();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (Double)vector.elementAt(i);
        }
        return JunPenLocation.FromArray_(dArray);
    }

    public static JunPenLocation FromArray_(double[] dArray) {
        int n = dArray.length;
        JunPenLocation junPenLocation = new JunPenLocation();
        if (n < 1) {
            return junPenLocation;
        }
        junPenLocation.setX_(dArray[0]);
        if (n < 2) {
            return junPenLocation;
        }
        junPenLocation.setY_(dArray[1]);
        if (n < 3) {
            return junPenLocation;
        }
        junPenLocation.setZ_(dArray[2]);
        return junPenLocation;
    }

    public static JunPenLocation FromNumber_(double d) {
        return JunPenLocation.X_y_z_(d, d, d);
    }

    public static JunPenLocation FromPoint_(JunPoint junPoint) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Class<?> clazz = ((Object)((Object)junPoint)).getClass();
        if (clazz == Jun3dPoint.class) {
            Jun3dPoint jun3dPoint = (Jun3dPoint)junPoint;
            d = jun3dPoint.x();
            d2 = jun3dPoint.y();
            d3 = jun3dPoint.z();
        } else if (clazz == Jun2dPoint.class) {
            Jun2dPoint jun2dPoint = (Jun2dPoint)junPoint;
            d = jun2dPoint.x();
            d2 = jun2dPoint.y();
        } else {
            return null;
        }
        return JunPenLocation.X_y_z_(d, d2, d3);
    }

    public static JunPenLocation Unity() {
        return JunPenLocation.X_y_z_(0.0, 0.0, 0.0);
    }

    public static JunPenLocation X_y_(double d, double d2) {
        JunPenLocation junPenLocation = new JunPenLocation();
        junPenLocation.setX_(d);
        junPenLocation.setY_(d2);
        return junPenLocation;
    }

    public static JunPenLocation X_y_z_(double d, double d2, double d3) {
        JunPenLocation junPenLocation = new JunPenLocation();
        junPenLocation.setX_(d);
        junPenLocation.setY_(d2);
        junPenLocation.setZ_(d3);
        return junPenLocation;
    }

    public static final JunPenLocation Zero() {
        return new JunPenLocation();
    }

    public Jun3dPoint _as3dPoint() {
        return new Jun3dPoint(this.x, this.y, this.z);
    }

    public JunPenLocation abs() {
        return JunPenLocation.X_y_z_(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    public double[] asArray() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public Jun2dPoint asPoint() {
        return new Jun2dPoint(this.x, this.y);
    }

    public JunPenLocation ceiling() {
        return JunPenLocation.X_y_z_(Math.ceil(this.x), Math.ceil(this.y), Math.ceil(this.z));
    }

    public JunPenLocation dividedBy_(Object object) {
        JunPenLocation junPenLocation = JunPenLocation.Coerce_(object);
        return JunPenLocation.X_y_z_(this.x / junPenLocation.x(), this.y / junPenLocation.y(), this.z / junPenLocation.z());
    }

    public JunPenLocation floor() {
        return JunPenLocation.X_y_z_(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public JunPenLocation minus_(Object object) {
        JunPenLocation junPenLocation = JunPenLocation.Coerce_(object);
        return JunPenLocation.X_y_z_(this.x - junPenLocation.x(), this.y - junPenLocation.y(), this.z - junPenLocation.z());
    }

    public JunPenLocation multipliedBy_(Object object) {
        JunPenLocation junPenLocation = JunPenLocation.Coerce_(object);
        return JunPenLocation.X_y_z_(this.x * junPenLocation.x(), this.y * junPenLocation.y(), this.z * junPenLocation.z());
    }

    public JunPenLocation negated() {
        return JunPenLocation.X_y_z_(this.x * -1.0, this.y * -1.0, this.z * -1.0);
    }

    public JunPenLocation plus_(Object object) {
        JunPenLocation junPenLocation = JunPenLocation.Coerce_(object);
        return JunPenLocation.X_y_z_(this.x + junPenLocation.x(), this.y + junPenLocation.y(), this.z + junPenLocation.z());
    }

    public JunPenLocation reciprocal() {
        return JunPenLocation.Unity().dividedBy_((Object)this);
    }

    public JunPenLocation rotatedBy_(Object object) {
        return this.transform_(JunPenTransformation.Rotate_(object));
    }

    public JunPenLocation rounded() {
        return JunPenLocation.X_y_z_(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public JunPenLocation roundTo_(JunPenLocation junPenLocation) {
        return this.dividedBy_((Object)junPenLocation).rounded().multipliedBy_((Object)junPenLocation);
    }

    public JunPenLocation scaledBy_(Object object) {
        return this.transform_(JunPenTransformation.Scale_(object));
    }

    public void setX_(double d) {
        this.x = d;
    }

    public void setY_(double d) {
        this.y = d;
    }

    public void setZ_(double d) {
        this.z = d;
    }

    public JunPenLocation transform_(JunPenTransformation junPenTransformation) {
        return junPenTransformation.applyToLocation_(this);
    }

    public JunPenLocation translatedBy_(Object object) {
        return this.transform_(JunPenTransformation.Translate_(object));
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }
}

