/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignController;
import jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.menu.StMenu;

public class JunSpiroDesignViewAwt
extends JunAbstractViewCanvas
implements JunSpiroDesignView {
    protected Point scrollAmount;
    protected transient Image offScreenImage;
    protected transient Dimension offScreenSize;

    public JunSpiroDesignViewAwt() {
    }

    public JunSpiroDesignViewAwt(JunSpiroDesignAbstractModel junSpiroDesignAbstractModel) {
        super(junSpiroDesignAbstractModel);
    }

    protected void initialize() {
        super.initialize();
        this.scrollAmount = null;
        this.offScreenImage = null;
        this.offScreenSize = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeOffScreen() {
        if (this.offScreenImage == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.offScreenImage.getGraphics().create();
        try {
            graphics2D.setColor(this.getBackground());
            graphics2D.setClip(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            graphics2D.fillRect(0, 0, this.offScreenSize.width, this.offScreenSize.height);
            this.displayOn_(graphics2D);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
                graphics2D = null;
            }
        }
    }

    protected void buildComponent() {
        this.setBackground(Color.white);
        this.setSize(new Dimension(480, 480));
    }

    protected StController defaultController() {
        return new JunSpiroDesignController();
    }

    public JunSpiroDesignController getSpiroDesignController() {
        return (JunSpiroDesignController)this.controller();
    }

    public Point convertModelPointToViewPoint_(Point point) {
        return new Point(point.x + this.scrollAmount().x, point.y + this.scrollAmount().y);
    }

    public Point convertViewPointToModelPoint_(Point point) {
        return new Point(point.x - this.scrollAmount().x, point.y - this.scrollAmount().y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_(Graphics graphics) {
        Image image = this.offScreen();
        if (image != null) {
            Graphics2D graphics2D = (Graphics2D)image.getGraphics();
            try {
                Rectangle rectangle = graphics.getClipBounds();
                if (rectangle != null) {
                    graphics2D.setBackground(this.getBackground());
                    graphics2D.setClip(rectangle);
                    graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.displayOn_at_(graphics2D, new Point(0, 0));
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                    graphics2D = null;
                }
            }
            graphics.drawImage(image, 0, 0, (ImageObserver)((Object)this));
        } else {
            this.displayOn_at_(graphics, new Point(0, 0));
        }
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.getModel().displayOn_at_(graphics, new Point(point.x + this.scrollAmount().x, point.y + this.scrollAmount().y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            Graphics graphics = this.getGraphics();
            try {
                graphics.setClip(n, n2, n3, n4);
                this.displayOn_(graphics);
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                    graphics = null;
                }
            }
        }
    }

    public Image createOffScreen() {
        this.initializeOffScreen();
        return this.offScreen();
    }

    public Image offScreen() {
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.offScreenSize) || this.offScreenImage == null) {
            this.offScreenImage = this.createImage(dimension.width, dimension.height);
            this.offScreenSize = dimension;
            this.initializeOffScreen();
        }
        return this.offScreenImage;
    }

    public JunSpiroDesignAbstractModel getModel() {
        return (JunSpiroDesignAbstractModel)this.model();
    }

    public void _showPopupMenu(int n, int n2) {
        PopupMenu popupMenu = this.popupMenuView();
        if (popupMenu != null) {
            this.getModel().updateMenuIndication_((StMenu)this.getModel()._popupMenu());
            popupMenu.show((Component)((Object)this), n, n2);
        }
    }

    public Point scrollAmount() {
        if (this.scrollAmount == null) {
            this.scrollAmount = this.isShowing() ? new Point((int)this.getBounds().getCenterX(), (int)this.getBounds().getCenterY()) : new Point(0, 0);
        }
        return this.scrollAmount;
    }

    public void scrollAmount_(Point point) {
        this.scrollAmount = point;
    }

    public void scrollBy_(Point point) {
        this.scrollAmount_(new Point(this.scrollAmount().x + point.x, this.scrollAmount().y + point.y));
        this.repaint();
    }

    public void scrollFor_(Point point) {
        this.scrollAmount_(new Point(0 - point.x / 2 + (int)this.getBounds().getCenterX(), 0 - point.y / 2 + (int)this.getBounds().getCenterY()));
        this.repaint();
    }

    public void scrollTo_(Point point) {
        this.scrollAmount_(point);
        this.repaint();
    }

    public void update_(DependentEvent dependentEvent) {
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunSpiroDesignViewAwt.$((String)"spiro")) {
            this.displayOn_(this.getGraphics());
            return;
        }
        if (stSymbol == JunSpiroDesignViewAwt.$((String)"spiroDesign")) {
            this.repaint();
            return;
        }
        if (stSymbol == JunSpiroDesignViewAwt.$((String)"invalidate")) {
            Rectangle rectangle = (Rectangle)dependentEvent.getParameter();
            rectangle.translate(this.scrollAmount().x, this.scrollAmount().y);
            this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        super.update_(dependentEvent);
    }
}

