/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.spirodesign;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

public abstract class JunSpiroObject
extends StObject
implements StDisplayable {
    protected Color spiroColor;
    protected int spiroWidth;

    public JunSpiroObject() {
        this.initialize();
    }

    protected void initialize() {
        this.spiroColor = null;
        this.spiroWidth = -1;
    }

    public Color color() {
        if (this.spiroColor == null) {
            this.spiroColor = this.defaultColor();
        }
        return this.spiroColor;
    }

    public void color_(Color color) {
        this.spiroColor = color;
    }

    public int width() {
        if (this.spiroWidth <= 0) {
            this.spiroWidth = this.defaultWidth();
        }
        return this.spiroWidth;
    }

    public void width_(int n) {
        this.spiroWidth = Math.max(n, 1);
    }

    public abstract Rectangle mark();

    public abstract Rectangle[] marks();

    public abstract Jun2dPoint[] points();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage() {
        Rectangle rectangle = this.bounds();
        StImage stImage = new StImage(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Graphics graphics = stImage.image().getGraphics();
        try {
            this.displayOn_(graphics);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        return stImage;
    }

    public Color defaultColor() {
        return Color.black;
    }

    public Dimension defaultMarkExtent() {
        return new Dimension(5, 5);
    }

    public int defaultWidth() {
        return 1;
    }

    public Rectangle boundingBox() {
        return new Rectangle(0, 0, 0, 0);
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public Rectangle preferredBounds() {
        Rectangle rectangle = this.boundingBox();
        rectangle.grow(Math.max(this.defaultMarkExtent().width, this.width()), Math.max(this.defaultMarkExtent().height, this.width()));
        return rectangle;
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_with_Marks_(graphics, new Point(0, 0), true);
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.displayOn_at_with_Marks_(graphics, point, true);
    }

    public abstract void displayOn_at_with_Marks_(Graphics var1, Point var2, boolean var3);

    protected void applyAttributesToGraphicsContext_(Graphics2D graphics2D) {
        graphics2D.setColor(this.color());
        graphics2D.setStroke(new BasicStroke(this.width(), 1, 1));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

