/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.texteditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;
import jp.co.sra.jun.goodies.texteditor.JunTextEditorView;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;

public class JunTextEditorViewSwing
extends JunAbstractViewJPanel
implements JunTextEditorView {
    protected JTextArea textArea;
    protected UndoManager undoManager;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public JunTextEditorViewSwing() {
    }

    public JunTextEditorViewSwing(JunTextEditor junTextEditor) {
        super(junTextEditor);
    }

    protected void initialize() {
        super.initialize();
        this.textArea = null;
        this.undoManager = null;
        this.undoAction = null;
        this.redoAction = null;
    }

    protected StModel defaultModel() {
        return new JunTextEditor();
    }

    public JunTextEditor getModel() {
        return (JunTextEditor)this.model();
    }

    protected void buildComponent() {
        this.getTextArea().setText(this.getModel().text());
        this.undoManager().discardAllEdits();
        JScrollPane jScrollPane = new JScrollPane(this.getTextArea());
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.setLayout((LayoutManager)new WindowSpecLayout());
        this.add(jScrollPane, WindowSpecLayout.Position((float)0.0f, (int)0, (float)0.0f, (int)0, (float)1.0f, (int)0, (float)1.0f, (int)0));
        this.setPreferredSize(new Dimension(480, 300));
    }

    protected void rebuildComponent(StModel stModel, StModel stModel2) {
        JunTextEditor junTextEditor = (JunTextEditor)stModel2;
        this.getTextArea().setText(junTextEditor.text());
    }

    public JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setFont(JunTextEditor.DefaultTextFont());
            this.textArea.setBackground(Color.white);
            this.textArea.setEditable(this.getModel().isEditable());
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.isMetaDown() || mouseEvent.isPopupTrigger()) {
                        JunTextEditorViewSwing.this._showPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.textArea.getDocument().putProperty("name", "textProperties");
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    JunTextEditorViewSwing junTextEditorViewSwing = JunTextEditorViewSwing.this;
                    String string = (String)documentEvent.getDocument().getProperty("name");
                    if (string.equals("textProperties") && !junTextEditorViewSwing.getText().equals(junTextEditorViewSwing.getModel().text())) {
                        junTextEditorViewSwing.getModel().text_(junTextEditorViewSwing.getText());
                    }
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    JunTextEditorViewSwing junTextEditorViewSwing = JunTextEditorViewSwing.this;
                    String string = (String)documentEvent.getDocument().getProperty("name");
                    if (string.equals("textProperties") && !junTextEditorViewSwing.getText().equals(junTextEditorViewSwing.getModel().text())) {
                        junTextEditorViewSwing.getModel().text_(junTextEditorViewSwing.getText());
                    }
                }
            });
            this.textArea.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(90, 2), new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JunTextEditorViewSwing.this.getModel().undoText();
                }
            });
            this.textArea.getKeymap().addActionForKeyStroke(KeyStroke.getKeyStroke(89, 2), new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JunTextEditorViewSwing.this.getModel().redoText();
                }
            });
            this.textArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    JunTextEditorViewSwing.this.undoManager().addEdit(undoableEditEvent.getEdit());
                    JunTextEditorViewSwing.this.undoAction().update();
                    JunTextEditorViewSwing.this.redoAction().update();
                }
            });
        }
        return this.textArea;
    }

    public String getText() {
        return this.getTextArea().getText();
    }

    public String getSelectedText() {
        String string = null;
        try {
            string = this.getTextArea().getSelectedText();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return string;
    }

    public void copyText() {
        this.getTextArea().copy();
    }

    public void cutText() {
        if (!this.getModel().isEditable()) {
            return;
        }
        this.getTextArea().cut();
    }

    public void pasteText() {
        if (!this.getModel().isEditable()) {
            return;
        }
        this.getTextArea().paste();
    }

    public void clearText() {
        if (!this.getModel().isEditable()) {
            return;
        }
        String string = this.getText();
        if (string != null && string.length() > 0) {
            this.getTextArea().setText("");
        }
    }

    public void undoText() {
        if (this.undoManager().canUndo()) {
            this.undoManager().undo();
        }
    }

    public void redoText() {
        if (this.undoManager().canRedo()) {
            this.undoManager().redo();
        }
    }

    public void update_(DependentEvent dependentEvent) {
        if (!this.isShowing()) {
            return;
        }
        this.getModel().updateMenuIndication();
        StSymbol stSymbol = dependentEvent.getAspect();
        if (stSymbol == JunTextEditorViewSwing.$((String)"text")) {
            if (!this.getModel().text().equals(this.getTextArea().getText())) {
                this.getTextArea().setText(this.getModel().text());
                this.getTextArea().setCaretPosition(0);
            }
            return;
        }
        if (stSymbol == JunTextEditorViewSwing.$((String)"editable")) {
            this.getTextArea().setEditable(this.getModel().isEditable());
            return;
        }
        super.update_(dependentEvent);
    }

    protected UndoManager undoManager() {
        if (this.undoManager == null) {
            this.undoManager = new UndoManager();
        }
        return this.undoManager;
    }

    protected UndoAction undoAction() {
        if (this.undoAction == null) {
            this.undoAction = new UndoAction();
        }
        return this.undoAction;
    }

    protected RedoAction redoAction() {
        if (this.redoAction == null) {
            this.redoAction = new RedoAction();
        }
        return this.redoAction;
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JunTextEditorViewSwing.this.undoManager().redo();
            }
            catch (CannotRedoException cannotRedoException) {
                System.out.println("Unable to redo: " + cannotRedoException);
                cannotRedoException.printStackTrace();
            }
            this.update();
            JunTextEditorViewSwing.this.undoAction().update();
        }

        protected void update() {
            if (JunTextEditorViewSwing.this.undoManager().canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", JunTextEditorViewSwing.this.undoManager().getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JunTextEditorViewSwing.this.undoManager().undo();
            }
            catch (CannotUndoException cannotUndoException) {
                System.out.println("Unable to undo: " + cannotUndoException);
                cannotUndoException.printStackTrace();
            }
            this.update();
            JunTextEditorViewSwing.this.redoAction().update();
        }

        protected void update() {
            if (JunTextEditorViewSwing.this.undoManager().canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", JunTextEditorViewSwing.this.undoManager().getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

