/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.goodies.track;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.track.JunTrackSliderModel;
import jp.co.sra.jun.goodies.track.JunTrackSliderView;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StView;

public class JunTrackSliderController
extends JunAbstractController
implements MouseListener,
MouseMotionListener {
    protected StSymbol _tracking;
    protected Cursor _savedCursor;
    protected Point _previousPoint;
    protected Point _offsetPoint;
    protected boolean _redisplayBoolean;
    protected Graphics _graphicsContext;
    protected double _savedValue;

    protected void buildListener(StView stView) {
        Component component = (Component)stView;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    public JunTrackSliderModel getTrackSliderModel() {
        return (JunTrackSliderModel)this.model();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            super.mousePressed(mouseEvent);
            return;
        }
        if (mouseEvent.isMetaDown()) {
            return;
        }
        Point point = mouseEvent.getPoint();
        this._tracking = this._trackingState(point);
        if (this._tracking == JunTrackSliderController.$((String)"slider")) {
            if (this.getTrackSliderView().sliderRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getTrackSliderView().sliderRectangle().center();
                this._offsetPoint = new Point(this._offsetPoint.x - point.x, this._offsetPoint.y - point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this._previousPoint = null;
            this._redisplayBoolean = false;
            this._trackSlider(point);
        } else if (this._tracking == JunTrackSliderController.$((String)"firstMarker")) {
            if (this.getTrackSliderView().firstMarkerRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getTrackSliderView().firstMarkerRectangle().rightCenter();
                this._offsetPoint = new Point(this._offsetPoint.x - point.x, this._offsetPoint.y - point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this.getTrackSliderView().notDisplaySlider_(true);
            this._savedValue = this.getTrackSliderModel().doubleValue();
            this._previousPoint = null;
            this._redisplayBoolean = false;
            this._trackFirstMarker(point);
        } else if (this._tracking == JunTrackSliderController.$((String)"lastMarker")) {
            if (this.getTrackSliderView().lastMarkerRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getTrackSliderView().lastMarkerRectangle().leftCenter();
                this._offsetPoint = new Point(this._offsetPoint.x - point.x, this._offsetPoint.y - point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this.getTrackSliderView().notDisplaySlider_(true);
            this._savedValue = this.getTrackSliderModel().doubleValue();
            this._previousPoint = null;
            this._redisplayBoolean = false;
            this._trackLastMarker(point);
        } else if (this._tracking == JunTrackSliderController.$((String)"interval")) {
            if (this.getTrackSliderView().anotherIntervalRectangle().containsPoint_(point)) {
                this._offsetPoint = this.getTrackSliderView().anotherIntervalRectangle().center();
                this._offsetPoint = new Point(this._offsetPoint.x - point.x, this._offsetPoint.y - point.y);
            } else {
                this._offsetPoint = new Point(0, 0);
            }
            this.getTrackSliderView().notDisplaySlider_(true);
            this._savedValue = this.getTrackSliderModel().doubleValue();
            this._previousPoint = null;
            this._redisplayBoolean = false;
            this._trackInterval(point);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            super.mouseReleased(mouseEvent);
            return;
        }
        if (this._tracking == JunTrackSliderController.$((String)"slider")) {
            if (this._redisplayBoolean) {
                this.getTrackSliderView().notDisplaySlider_(false);
                this.getTrackSliderView().displayOn_(this._graphicsContext());
            }
        } else if (this._tracking == JunTrackSliderController.$((String)"firstMarker")) {
            this.getTrackSliderView().notDisplaySlider_(false);
            this.getTrackSliderView().displayOn_(this._graphicsContext());
        } else if (this._tracking == JunTrackSliderController.$((String)"lastMarker")) {
            this.getTrackSliderView().notDisplaySlider_(false);
            this.getTrackSliderView().displayOn_(this._graphicsContext());
        } else if (this._tracking == JunTrackSliderController.$((String)"interval")) {
            this.getTrackSliderView().notDisplaySlider_(false);
            this.getTrackSliderView().displayOn_(this._graphicsContext());
        }
        this._tracking = null;
        this._offsetPoint = null;
        this._previousPoint = null;
        this._redisplayBoolean = false;
        if (this._graphicsContext != null) {
            this._graphicsContext.dispose();
            this._graphicsContext = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._tracking == JunTrackSliderController.$((String)"slider")) {
            this._trackSlider(mouseEvent.getPoint());
        } else if (this._tracking == JunTrackSliderController.$((String)"firstMarker")) {
            this._trackFirstMarker(mouseEvent.getPoint());
        } else if (this._tracking == JunTrackSliderController.$((String)"lastMarker")) {
            this._trackLastMarker(mouseEvent.getPoint());
        } else if (this._tracking == JunTrackSliderController.$((String)"interval")) {
            this._trackInterval(mouseEvent.getPoint());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        StSymbol stSymbol = this._trackingState(mouseEvent.getPoint());
        if (stSymbol == JunTrackSliderController.$((String)"slider")) {
            this.getComponent().setCursor(JunCursors.CrossCursor());
        } else if (stSymbol == JunTrackSliderController.$((String)"firstMarker")) {
            this.getComponent().setCursor(JunCursors.Corner3Cursor());
        } else if (stSymbol == JunTrackSliderController.$((String)"lastMarker")) {
            this.getComponent().setCursor(JunCursors.Corner1Cursor());
        } else if (stSymbol == JunTrackSliderController.$((String)"interval")) {
            this.getComponent().setCursor(JunCursors.BetweenCursor());
        } else {
            this.getComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void _trackFirstMarker(Point point) {
        if (new StRectangle(this.getComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                int n = point.x + this._offsetPoint.x;
                int n2 = point.y + this._offsetPoint.y;
                this.getTrackSliderView().setModelFirstMarker_(n, n2);
                this.getTrackSliderView().displaySliderForValue_on_withColor_(this._savedValue, this._graphicsContext(), Color.blue);
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
    }

    protected StSymbol _trackingState(Point point) {
        StSymbol stSymbol = null;
        if (this.getTrackSliderView().sliderArea().containsPoint_(point)) {
            stSymbol = JunTrackSliderController.$((String)"slider");
        }
        if (this.getTrackSliderView().sliderRectangle().containsPoint_(point)) {
            stSymbol = JunTrackSliderController.$((String)"slider");
        }
        if (this.getTrackSliderModel().parentTracker() == null && this.getTrackSliderModel().areMarkersActive()) {
            if (this.getTrackSliderView().firstMarkerRectangle().expandedBy_(new StRectangle(1, -2, 2, 2)).containsPoint_(point)) {
                stSymbol = JunTrackSliderController.$((String)"firstMarker");
            }
            if (this.getTrackSliderView().lastMarkerRectangle().expandedBy_(new StRectangle(1, -2, 2, 2)).containsPoint_(point)) {
                stSymbol = JunTrackSliderController.$((String)"lastMarker");
            }
            if (this.getTrackSliderView().anotherIntervalRectangle().containsPoint_(point)) {
                stSymbol = JunTrackSliderController.$((String)"interval");
            }
        }
        return stSymbol;
    }

    protected void _trackInterval(Point point) {
        if (new StRectangle(this.getComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                int n = point.x + this._offsetPoint.x;
                int n2 = point.y + this._offsetPoint.y;
                this.getTrackSliderView().setModelInterval_(n, n2);
                this.getTrackSliderView().displaySliderForValue_on_withColor_(this._savedValue, this._graphicsContext(), Color.green);
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
    }

    protected void _trackLastMarker(Point point) {
        if (new StRectangle(this.getComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                int n = point.x + this._offsetPoint.x;
                int n2 = point.y + this._offsetPoint.y;
                this.getTrackSliderView().setModelLastMarker_(n, n2);
                this.getTrackSliderView().displaySliderForValue_on_withColor_(this._savedValue, this._graphicsContext(), Color.red);
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
    }

    protected void _trackSlider(Point point) {
        if (new StRectangle(this.getComponent().getSize()).expandedBy_(16, 16).containsPoint_(point)) {
            if (!point.equals(this._previousPoint)) {
                this.getTrackSliderView().setModelValue_(point.x + this._offsetPoint.x, point.y + this._offsetPoint.y);
                this.getTrackSliderView().displaySliderOn_withColor_(this._graphicsContext(), JunTrackSliderView.Gray40);
                this._previousPoint = point;
            }
            this._redisplayBoolean = true;
        }
    }

    protected Graphics _graphicsContext() {
        if (this._graphicsContext == null) {
            this._graphicsContext = this.getComponent().getGraphics();
        }
        return this._graphicsContext;
    }

    protected Component getComponent() {
        return (Component)this.view();
    }

    public JunTrackSliderView getTrackSliderView() {
        return (JunTrackSliderView)this.view();
    }

    public JunTrackSliderView getView() {
        return (JunTrackSliderView)this.view();
    }
}

