/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.graphics.abstracts;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunAbstractVisual
extends StObject
implements StDisplayable {
    public static Color BackgroundColor() {
        return Color.white;
    }

    public static Color ForegroundColor() {
        return Color.black;
    }

    public static Color SelectionBackgroundColor() {
        return new Color(9, 35, 105);
    }

    public static Color SelectionForegroundColor() {
        return Color.white;
    }

    public static String ContractString_compositionWidth_textStyle_(String string, int n, FontMetrics fontMetrics) {
        String string2 = string;
        int n2 = string2.length();
        while (n2 > 3 && fontMetrics.stringWidth(string2) > n) {
            string2 = JunStringUtility._ContractString_to_(string2, --n2);
        }
        return string2;
    }

    public static long GenerateUniqueNumber() {
        long l = JunSystem.GenerateUniqueNumber();
        return l /= 10L;
    }

    public JunAbstractVisual() {
        this.initialize();
    }

    protected void initialize() {
    }

    public Color backgroundColor() {
        return JunAbstractVisual.BackgroundColor();
    }

    public Color foregroundColor() {
        return JunAbstractVisual.ForegroundColor();
    }

    public Color selectionBackgroundColor() {
        return JunAbstractVisual.SelectionBackgroundColor();
    }

    public Color selectionForegroundColor() {
        return JunAbstractVisual.SelectionForegroundColor();
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public Rectangle preferredBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StImage asImage() {
        int n = this.bounds().width;
        int n2 = this.bounds().height;
        StImage stImage = new StImage(n, n2);
        Graphics graphics = null;
        try {
            graphics = stImage.image().getGraphics();
            graphics.setClip(0, 0, n, n2);
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(Color.black);
            this.displayOn_(graphics);
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
                graphics = null;
            }
        }
        return stImage;
    }

    public abstract void displayOn_(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayOn_at_(Graphics graphics, Point point) {
        Graphics graphics2 = graphics.create();
        try {
            graphics2.translate(point.x, point.y);
            this.displayOn_(graphics2);
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    public Object itemsDo_(StBlockClosure stBlockClosure) {
        return this;
    }

    public Object allItemsDo_(StBlockClosure stBlockClosure) {
        return this.allItemsDo_nestLevel_(stBlockClosure, 0);
    }

    public Object allItemsDo_nestLevel_(final StBlockClosure stBlockClosure, final int n) {
        return this.itemsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                JunAbstractVisual junAbstractVisual = (JunAbstractVisual)((Object)object);
                if (stBlockClosure.numArgs() == 1) {
                    stBlockClosure.value_((Object)junAbstractVisual);
                }
                if (stBlockClosure.numArgs() == 2) {
                    stBlockClosure.value_value_((Object)junAbstractVisual, (Object)new Integer(n));
                }
                if (junAbstractVisual.isComposite()) {
                    junAbstractVisual.allItemsDo_nestLevel_(stBlockClosure, n + 1);
                }
                return null;
            }
        });
    }

    public Object withAllItemsDo_(StBlockClosure stBlockClosure) {
        return this.withAllItemsDo_nestLevel_(stBlockClosure, 0);
    }

    public Object withAllItemsDo_nestLevel_(StBlockClosure stBlockClosure, int n) {
        if (stBlockClosure.numArgs() == 1) {
            stBlockClosure.value_((Object)this);
        }
        if (stBlockClosure.numArgs() == 2) {
            stBlockClosure.value_value_((Object)this, (Object)new Integer(n));
        }
        return this.allItemsDo_nestLevel_(stBlockClosure, n + 1);
    }

    public boolean isComposite() {
        return false;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isMap() {
        return false;
    }

    public boolean isNetwork() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isSequence() {
        return false;
    }

    public boolean isSpatial() {
        return false;
    }

    protected StSymbol kindName() {
        return this._className();
    }

    protected JunLispCons lispCons() {
        return JunLispCons.Cell();
    }

    protected JunLispNil lispNil() {
        return JunLispNil.NullList();
    }

    public JunLispCons toLispList() {
        JunLispCons junLispCons = this.lispCons();
        junLispCons.head_(this.kindName());
        return junLispCons;
    }

    public void showLispList() {
        this.showLispList_(this.toLispList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showLispList_(JunLispList junLispList) {
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            junLispList.saveOn_(stringWriter);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        finally {
            if (stringWriter != null) {
                try {
                    ((Writer)stringWriter).flush();
                    ((Writer)stringWriter).close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    iOException.printStackTrace();
                }
            }
        }
        JunTextEditor junTextEditor = new JunTextEditor(((Object)stringWriter).toString());
        junTextEditor.beEditable(false);
        junTextEditor.openIn_(new Rectangle(100, 100, 340, 180));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOn_(Writer writer) throws IOException {
        JunCursors junCursors = new JunCursors(new Cursor(3));
        try {
            junCursors._show();
            this.toLispList().saveOn_(writer);
        }
        finally {
            junCursors._restore();
        }
    }
}

