/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.surfaces.JunSphereSurface;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLShowViewAwt;
import jp.co.sra.jun.opengl.display.JunOpenGLShowViewSwing;
import jp.co.sra.jun.opengl.lights.JunOpenGLLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolylineLoop;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLParallelProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSmallCompiler;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public class JunOpenGLShowModel
extends JunOpenGLDisplayModel {
    protected JunOpenGLDisplayModel displayModel;
    protected Jun3dPoint viewportSight;
    protected double viewportHeight;
    protected boolean useTransparency;

    public static JunOpenGLDisplayModel Show_(JunOpenGL3dObject junOpenGL3dObject) {
        return JunOpenGLShowModel.Show_eyePoint_(junOpenGL3dObject, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint) {
        return JunOpenGLShowModel.Show_eyePoint_sightPoint_(junOpenGL3dObject, jun3dPoint, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2) {
        return JunOpenGLShowModel.Show_eyePoint_sightPoint_upVector_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, null);
    }

    public static JunOpenGLDisplayModel Show_eyePoint_sightPoint_upVector_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3) {
        return JunOpenGLShowModel.Show_eyePoint_sightPoint_upVector_viewFactor_(junOpenGL3dObject, jun3dPoint, jun3dPoint2, jun3dPoint3, null);
    }

    public static JunOpenGLShowModel Show_eyePoint_sightPoint_upVector_viewFactor_(JunOpenGL3dObject junOpenGL3dObject, Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, Double d) {
        JunOpenGLShowModel junOpenGLShowModel = new JunOpenGLShowModel(junOpenGL3dObject);
        if (jun3dPoint != null) {
            junOpenGLShowModel.defaultEyePoint_(jun3dPoint);
        }
        if (jun3dPoint2 != null) {
            junOpenGLShowModel.defaultSightPoint_(jun3dPoint2);
        }
        if (jun3dPoint3 != null) {
            junOpenGLShowModel.defaultUpVector_(jun3dPoint3);
        }
        if (d != null) {
            junOpenGLShowModel.defaultViewFactor_(d);
        }
        junOpenGLShowModel.open();
        return junOpenGLShowModel;
    }

    public JunOpenGLShowModel() {
    }

    public JunOpenGLShowModel(JunOpenGLDisplayModel junOpenGLDisplayModel) {
        this.displayModel_(junOpenGLDisplayModel);
    }

    public JunOpenGLShowModel(JunOpenGL3dObject junOpenGL3dObject) {
        this.displayObject_(junOpenGL3dObject);
    }

    protected void initialize() {
        super.initialize();
        this.displayModel = null;
        this.viewportSight = null;
        this.viewportHeight = Double.NaN;
        this.useTransparency = true;
    }

    public JunOpenGLDisplayModel displayModel() {
        if (this.displayModel == null) {
            this.displayModel_(new JunOpenGLDisplayModel());
        }
        return this.displayModel;
    }

    public void displayModel_(JunOpenGLDisplayModel junOpenGLDisplayModel) {
        if (this.displayModel != junOpenGLDisplayModel) {
            this.displayModel = junOpenGLDisplayModel;
            if (this.displayModel.myDependents() == null || !this.displayModel.myDependents().contains(this)) {
                this.displayModel.addDependent_((DependentListener)this);
            }
        }
    }

    public JunOpenGL3dObject displayObject() {
        return this.displayModel().displayObject();
    }

    public void displayObject_(JunOpenGL3dObject junOpenGL3dObject) {
        this.displayModel().displayObject_(junOpenGL3dObject);
    }

    public JunOpenGL3dObject showObject() {
        JunOpenGLProjection junOpenGLProjection = this.displayModel().displayProjection();
        double d = this.computeViewportHeight();
        Jun3dPoint jun3dPoint = junOpenGLProjection.sightPoint();
        double d2 = 2.0 * junOpenGLProjection.sightPoint().distance_(junOpenGLProjection.nearCenter());
        if (d > d2) {
            d = d2;
        }
        if (this.openGL3dObject == null || Double.isNaN(this.viewportHeight) || Math.abs(d - this.viewportHeight) > 1.0E-12 || this.viewportSight == null || jun3dPoint.distance_(this.viewportSight) > 1.0E-12) {
            Object object;
            JunAbstractObject junAbstractObject;
            this.viewportHeight = d;
            this.viewportSight = jun3dPoint;
            JunOpenGL3dObject junOpenGL3dObject = JunOpenGL3dObject.Globe_radius_center_(15.0, this.viewportHeight / 2.0, this.viewportSight);
            junOpenGL3dObject.paint_(Color.cyan);
            if (this.useTransparency()) {
                junOpenGL3dObject.alpha_(0.25f);
            } else {
                junAbstractObject = JunOpenGLStipple.Halftone_(0.25);
                if (junOpenGL3dObject instanceof JunOpenGL3dCompoundObject) {
                    object = ((JunOpenGL3dCompoundObject)junOpenGL3dObject).components();
                    for (int i = 0; i < ((JunOpenGL3dObject[])object).length; ++i) {
                        object[i].stipple_((JunOpenGLStipple)junAbstractObject);
                    }
                } else {
                    junOpenGL3dObject.stipple_((JunOpenGLStipple)junAbstractObject);
                }
            }
            junAbstractObject = JunOpenGL3dObject.Axes2();
            junAbstractObject = ((JunOpenGL3dObject)junAbstractObject).scaledBy_(this.viewportHeight / 2.0);
            object = new JunOpenGL3dCompoundObject();
            if (this.displayObject() != null) {
                ((JunOpenGL3dCompoundObject)object).add_(this.displayObject());
            }
            ((JunOpenGL3dCompoundObject)object).add_(junOpenGL3dObject);
            ((JunOpenGL3dCompoundObject)object).add_((JunOpenGL3dObject)junAbstractObject);
            this.openGL3dObject = object;
        }
        return new JunOpenGL3dCompoundObject(this.openGL3dObject, this.viewportObject());
    }

    public JunOpenGLProjection showProjection() {
        return this.showProjector().projection();
    }

    public void showProjection_(JunOpenGLProjection junOpenGLProjection) {
        this.showProjector().projection_(junOpenGLProjection);
    }

    public JunOpenGLProjector showProjector() {
        if (this.openGLProjector == null) {
            this.openGLProjector = new JunOpenGLProjector();
            this.openGLProjector.eyePoint_(this.defaultEyePoint());
            this.openGLProjector.sightPoint_(this.defaultSightPoint());
            this.openGLProjector.upVector_(this.defaultUpVector());
            this.openGLProjector.viewFactor_(this.defaultViewFactor());
            this.openGLProjector.smoothShading();
        }
        return this.openGLProjector;
    }

    public boolean useTransparency() {
        return this.useTransparency;
    }

    public void useTransparency_(boolean bl) {
        if (this.useTransparency == bl) {
            return;
        }
        this.useTransparency = bl;
        this.flushObject();
        this.changed_(JunOpenGLShowModel.$((String)"object"));
    }

    public JunOpenGL3dObject viewportBeam() {
        JunOpenGL3dPolyline junOpenGL3dPolyline;
        JunOpenGLProjection junOpenGLProjection = this.displayModel().displayProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.farCenter();
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.sightPoint();
        Jun3dPoint jun3dPoint3 = junOpenGLProjection.nearCenter();
        Jun3dPoint jun3dPoint4 = junOpenGLProjection.eyePoint();
        Jun3dPoint[] jun3dPointArray = new Jun3dPoint[2];
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        if (jun3dPoint.distance_(jun3dPoint3) > jun3dPoint2.distance_(jun3dPoint3)) {
            jun3dPointArray[0] = jun3dPoint;
            jun3dPointArray[1] = jun3dPoint2;
            junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
            junOpenGL3dPolyline.paint_(Color.magenta);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        }
        jun3dPointArray[0] = jun3dPoint2;
        jun3dPointArray[1] = jun3dPoint3;
        junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
        junOpenGL3dPolyline.paint_(Color.blue);
        junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        if (jun3dPoint4.distance_(jun3dPoint2) > jun3dPoint3.distance_(jun3dPoint2)) {
            jun3dPointArray[0] = jun3dPoint3;
            jun3dPointArray[1] = jun3dPoint4;
            junOpenGL3dPolyline = new JunOpenGL3dPolyline(jun3dPointArray);
            junOpenGL3dPolyline.paint_(Color.yellow);
            junOpenGL3dCompoundObject.add_(junOpenGL3dPolyline);
        }
        junOpenGL3dCompoundObject.name_("viewport eye beam");
        return junOpenGL3dCompoundObject;
    }

    public JunOpenGL3dObject viewportObject() {
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = this.viewportPlate();
        JunOpenGLProjection junOpenGLProjection = this.displayModel().displayProjection();
        if (this.viewportHeight == Double.NaN) {
            this.viewportHeight = this.computeViewportHeight();
        }
        double d = this.viewportHeight / 2.0;
        double d2 = junOpenGLProjection.sightPoint().distance_(junOpenGLProjection.eyePoint());
        Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjection.sightPoint(), junOpenGLProjection.eyePoint());
        Jun3dPoint jun3dPoint = jun3dLine.atT_(d / d2);
        junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGL3dCompoundObject.translatedBy_(jun3dPoint);
        JunOpenGL3dObject[] junOpenGL3dObjectArray = junOpenGL3dCompoundObject.components();
        JunOpenGL3dPolylineLoop junOpenGL3dPolylineLoop = new JunOpenGL3dPolylineLoop(((JunOpenGL3dVertexesObject)junOpenGL3dObjectArray[junOpenGL3dObjectArray.length - 1]).vertexes());
        Jun3dPoint[] jun3dPointArray = junOpenGL3dPolylineLoop.vertexes();
        Jun3dPoint jun3dPoint2 = jun3dPointArray[0];
        Jun3dPoint jun3dPoint3 = jun3dPointArray[1];
        Jun3dPoint jun3dPoint4 = jun3dPointArray[2];
        Jun3dPoint jun3dPoint5 = jun3dPointArray[3];
        Jun3dLine jun3dLine2 = new Jun3dLine(jun3dPoint2.plus_(jun3dPoint5.minus_(jun3dPoint2).dividedBy_(2.0)), jun3dPoint3.plus_(jun3dPoint4.minus_(jun3dPoint3).dividedBy_(2.0)));
        Jun3dLine jun3dLine3 = new Jun3dLine(jun3dPoint2.plus_(jun3dPoint3.minus_(jun3dPoint2).dividedBy_(2.0)), jun3dPoint5.plus_(jun3dPoint4.minus_(jun3dPoint5).dividedBy_(2.0)));
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject2 = new JunOpenGL3dCompoundObject();
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[2];
        Jun3dPoint[] jun3dPointArray3 = new Jun3dPoint[4];
        jun3dPointArray2[0] = jun3dLine2.atT_(0.0);
        jun3dPointArray2[1] = jun3dLine2.atT_(1.0);
        junOpenGL3dCompoundObject2.add_(new JunOpenGL3dPolyline(jun3dPointArray2));
        jun3dPointArray3[0] = jun3dLine2.atT_(1.0);
        jun3dPointArray3[1] = jun3dLine2.atT_(0.9).minus_(jun3dLine3.atT_(1.0).minus_(jun3dLine3.atT_(0.9)).dividedBy_(4.0));
        jun3dPointArray3[2] = jun3dLine2.atT_(0.9).plus_(jun3dLine3.atT_(1.0).minus_(jun3dLine3.atT_(0.9)).dividedBy_(4.0));
        jun3dPointArray3[3] = jun3dLine2.atT_(1.0);
        junOpenGL3dCompoundObject2.add_(new JunOpenGL3dPolyline(jun3dPointArray3));
        junOpenGL3dCompoundObject2.paint_(Color.red);
        junOpenGL3dCompoundObject2.name_(junOpenGL3dCompoundObject.name() + " x axis");
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject3 = new JunOpenGL3dCompoundObject();
        jun3dPointArray2[0] = jun3dLine3.atT_(0.0);
        jun3dPointArray2[1] = jun3dLine3.atT_(1.0);
        junOpenGL3dCompoundObject3.add_(new JunOpenGL3dPolyline(jun3dPointArray2));
        jun3dPointArray3[0] = jun3dLine3.atT_(1.0);
        jun3dPointArray3[1] = jun3dLine3.atT_(0.9).minus_(jun3dLine2.atT_(1.0).minus_(jun3dLine2.atT_(0.9)).dividedBy_(4.0));
        jun3dPointArray3[2] = jun3dLine3.atT_(0.9).plus_(jun3dLine2.atT_(1.0).minus_(jun3dLine2.atT_(0.9)).dividedBy_(4.0));
        jun3dPointArray3[3] = jun3dLine3.atT_(1.0);
        junOpenGL3dCompoundObject3.add_(new JunOpenGL3dPolyline(jun3dPointArray3));
        junOpenGL3dCompoundObject3.paint_(Color.green);
        junOpenGL3dCompoundObject3.name_(junOpenGL3dCompoundObject.name() + " y axis");
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject4 = new JunOpenGL3dCompoundObject();
        junOpenGL3dCompoundObject4.add_(junOpenGL3dCompoundObject);
        junOpenGL3dCompoundObject4.add_(junOpenGL3dPolylineLoop);
        junOpenGL3dCompoundObject4.add_(junOpenGL3dCompoundObject2);
        junOpenGL3dCompoundObject4.add_(junOpenGL3dCompoundObject3);
        junOpenGL3dCompoundObject4.name_("viewport");
        return junOpenGL3dCompoundObject4;
    }

    public JunOpenGL3dCompoundObject viewportPlate() {
        Jun3dPoint[] jun3dPointArray;
        double d;
        Object object;
        Object object2;
        JunOpenGLProjection junOpenGLProjection = this.displayModel().displayProjection();
        if (Double.isNaN(this.viewportHeight)) {
            this.viewportHeight = this.computeViewportHeight();
        }
        double d2 = this.viewportHeight;
        if (this.displayModel().builder().windows().length > 0) {
            object2 = this.displayModel().getOpenGLView().toComponent();
            object = object2.getBounds();
            d = d2 * (double)((Rectangle)object).width / (double)((Rectangle)object).height;
        } else {
            d = d2;
        }
        object2 = new Jun3dPoint(0.0, 0.0, 0.0);
        object = junOpenGLProjection.unitRightVector().scaledBy_(new Jun3dPoint(d, d, d));
        Jun3dPoint jun3dPoint = junOpenGLProjection.unitUpVector().scaledBy_(new Jun3dPoint(d2, d2, d2));
        Jun3dPoint jun3dPoint2 = ((Jun3dPoint)((Object)object)).plus_(jun3dPoint.minus_((Jun3dPoint)((Object)object)).dividedBy_(2.0));
        jun3dPoint2 = jun3dPoint2.plus_(jun3dPoint2);
        Jun3dPoint[] jun3dPointArray2 = new Jun3dPoint[]{object2, object, jun3dPoint2, jun3dPoint};
        JunOpenGL3dCompoundObject junOpenGL3dCompoundObject = new JunOpenGL3dCompoundObject();
        if (this.useTransparency()) {
            jun3dPointArray = new Jun3dPoint[]{jun3dPoint, jun3dPoint2, object, object2};
            junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray));
        }
        junOpenGL3dCompoundObject.add_(new JunOpenGL3dPolygon(jun3dPointArray2));
        jun3dPointArray = ((Jun3dPoint)((Object)object)).plus_(jun3dPoint.minus_((Jun3dPoint)((Object)object)).dividedBy_(2.0));
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, 0.0, 0.0).minus_((Jun3dPoint)jun3dPointArray);
        junOpenGL3dCompoundObject = (JunOpenGL3dCompoundObject)junOpenGL3dCompoundObject.translatedBy_(jun3dPoint3);
        junOpenGL3dCompoundObject.paint_(Color.yellow);
        if (this.useTransparency()) {
            junOpenGL3dCompoundObject.alpha_(0.2f);
        } else {
            junOpenGL3dCompoundObject.components()[0].stipple_(JunOpenGLStipple.Halftone_(0.125));
        }
        junOpenGL3dCompoundObject.name_("viewport plate");
        return junOpenGL3dCompoundObject;
    }

    public JunButtonModel bullButton() {
        if (!this.pushButtons().containsKey(JunOpenGLShowModel.$((String)"bull"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.BullCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        JunOpenGLShowModel.this.dragButton().value_(false);
                        JunOpenGLShowModel.this.grabButton().value_(false);
                    }
                    JunOpenGLShowModel.this.changed_(1.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.pushButtons().put(JunOpenGLShowModel.$((String)"bull"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLShowModel.$((String)"bull")));
    }

    public JunButtonModel dragButton() {
        if (!this.pushButtons().containsKey(JunOpenGLShowModel.$((String)"drag"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.QuartersCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        JunOpenGLShowModel.this.grabButton().value_(false);
                        JunOpenGLShowModel.this.bullButton().value_(false);
                    }
                    JunOpenGLShowModel.this.changed_(2.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.pushButtons().put(JunOpenGLShowModel.$((String)"drag"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLShowModel.$((String)"drag")));
    }

    public JunButtonModel grabButton() {
        if (!this.pushButtons().containsKey(JunOpenGLShowModel.$((String)"grab"))) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(false);
            junButtonModel.visual_(JunCursors.HandCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    if (junButtonModel.value()) {
                        JunOpenGLShowModel.this.dragButton().value_(false);
                        JunOpenGLShowModel.this.bullButton().value_(false);
                    }
                    JunOpenGLShowModel.this.changed_(3.$((String)"state"));
                    return junButtonModel;
                }
            });
            this.pushButtons().put(JunOpenGLShowModel.$((String)"grab"), junButtonModel);
        }
        return (JunButtonModel)((Object)this.pushButtons().get(JunOpenGLShowModel.$((String)"grab")));
    }

    public Jun3dPoint defaultEyePoint() {
        return this.displayModel().defaultEyePoint();
    }

    public void defaultEyePoint_(Jun3dPoint jun3dPoint) {
        this.displayModel().defaultEyePoint_(jun3dPoint);
    }

    public Jun3dPoint defaultSightPoint() {
        return this.displayModel().defaultSightPoint();
    }

    public void defaultSightPoint_(Jun3dPoint jun3dPoint) {
        this.displayModel().defaultSightPoint_(jun3dPoint);
    }

    public Jun3dPoint defaultUpVector() {
        return this.displayModel().defaultUpVector();
    }

    public void defaultUpVector_(Jun3dPoint jun3dPoint) {
        this.displayModel().defaultUpVector_(jun3dPoint);
    }

    public double defaultViewFactor() {
        return this.displayModel().defaultViewFactor();
    }

    public void defaultViewFactor_(double d) {
        this.displayModel().defaultViewFactor_(d);
    }

    protected Frame allButOpenView_(StView stView) {
        Frame frame = super.allButOpenView_(stView);
        this.spawnViewfinder();
        return frame;
    }

    public StView defaultView() {
        if (JunOpenGLShowModel.GetDefaultViewMode() == 0) {
            return new JunOpenGLShowViewAwt(this);
        }
        return new JunOpenGLShowViewSwing(this);
    }

    protected String windowTitle() {
        return JunOpenGLShowModel.$String((String)"Viewport");
    }

    public void bull_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLDisplayModel junOpenGLDisplayModel = this.displayModel();
        JunOpenGLProjection junOpenGLProjection = junOpenGLDisplayModel.displayProjection();
        JunSphereSurface junSphereSurface = junOpenGLDisplayModel.grabSphere();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        JunAngle junAngle = new Jun3dLine(junSphereSurface.center(), jun3dPoint2).angleWithLine_(new Jun3dLine(junSphereSurface.center(), jun3dPoint));
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(junSphereSurface.center(), junSphereSurface.center().minus_(jun3dPoint.minus_(junSphereSurface.center()).product_(jun3dPoint2.minus_(junSphereSurface.center()))));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
            Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Rotate_around_(junAngle.mul_(-1.0), jun3dLine);
            Jun3dPoint jun3dPoint3 = junOpenGLProjection.sightPoint().plus_(junOpenGLProjection.unitUpVector());
            junOpenGLProjection.eyePoint_(jun3dTransformation2.applyTo_(junOpenGLProjection.eyePoint()));
            junOpenGLProjection.upVector_(jun3dTransformation.applyTo_(jun3dPoint3).minus_(junOpenGLProjection.sightPoint()));
            junOpenGLDisplayModel.displayProjection_(junOpenGLProjection);
            junOpenGLDisplayModel.changed_(JunOpenGLShowModel.$((String)"projection"));
        }
    }

    public void drag_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.showObject() == null) {
            return;
        }
        this.slide_xy_(jun2dPoint, jun2dPoint2);
    }

    public void grab_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.showProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        JunAngle junAngle = new Jun3dLine(junSphereSurface.center(), jun3dPoint2).angleWithLine_(new Jun3dLine(junSphereSurface.center(), jun3dPoint));
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(junSphereSurface.center(), junSphereSurface.center().minus_(jun3dPoint.minus_(junSphereSurface.center()).product_(jun3dPoint2.minus_(junSphereSurface.center()))));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
            Jun3dTransformation jun3dTransformation2 = Jun3dTransformation.Rotate_around_(junAngle.mul_(-1.0), jun3dLine);
            Jun3dPoint jun3dPoint3 = junOpenGLProjection.sightPoint().plus_(junOpenGLProjection.unitUpVector());
            junOpenGLProjection.eyePoint_(jun3dTransformation2.applyTo_(junOpenGLProjection.eyePoint()));
            junOpenGLProjection.upVector_(jun3dTransformation.applyTo_(jun3dPoint3).minus_(junOpenGLProjection.sightPoint()));
            this.showProjection_(junOpenGLProjection);
            this.changed_(JunOpenGLShowModel.$((String)"projection"));
        }
    }

    public void look_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.showProjection();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        this.showProjection_(junOpenGLProjection);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
    }

    public void slide_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjection junOpenGLProjection = this.showProjection();
        Jun3dPoint jun3dPoint = this.grab3dPoint_(new Jun2dPoint(jun2dPoint.x(), jun2dPoint.y()));
        Jun3dPoint jun3dPoint2 = this.grab3dPoint_(new Jun2dPoint(jun2dPoint2.x(), jun2dPoint2.y()));
        junOpenGLProjection.sightPoint_(junOpenGLProjection.sightPoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        junOpenGLProjection.eyePoint_(junOpenGLProjection.eyePoint().minus_(jun3dPoint2.minus_(jun3dPoint)));
        this.showProjection_(junOpenGLProjection);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateViewMenuIndication();
    }

    public void updateViewMenuIndication() {
        StMenu stMenu;
        StMenu stMenu2 = (StMenu)this._menuBar().atNameKey_(JunOpenGLShowModel.$((String)"viewMenu"));
        if (stMenu2 == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"zoomingMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"pointingMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"resetMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"presetMenu"))) != null) {
            stMenuItem.beEnabled(bl && this._presetProjections != null && this._presetProjections.length > 0);
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"projectionMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.showProjector().projection() instanceof JunOpenGLPerspectiveProjection) {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"perspectiveProjectionMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"parallelProjectionMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"presentationMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.showProjector().presentation() == JunOpenGLShowModel.$((String)"solidPresentation")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"solidPresentationMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else if (this.showProjector().presentation() == JunOpenGLShowModel.$((String)"wireframePresentation")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"wireframePresentationMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else if (this.showProjector().presentation() == JunOpenGLShowModel.$((String)"hiddenlinePresentation") && (stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"hiddenlinePresentationMenu"))) != null) {
                ((StRadioButtonMenuItem)stMenuItem).beOn();
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"shadingMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if (this.showProjector().shading() == JunOpenGLShowModel.$((String)"flatShading")) {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"flatShadingMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            } else {
                stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"smoothShadingMenu"));
                if (stMenuItem != null) {
                    ((StRadioButtonMenuItem)stMenuItem).beOn();
                }
            }
        }
        if ((stMenuItem = stMenu2.atNameKey_(JunOpenGLShowModel.$((String)"smoothingMenu"))) != null) {
            stMenu = (StMenu)stMenuItem;
            if ((stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"lineSmoothMenu"))) != null) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.showProjector().lineSmooth());
            }
            if ((stMenuItem = stMenu.atNameKey_(JunOpenGLShowModel.$((String)"polygonSmoothMenu"))) != null) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.showProjector().polygonSmooth());
            }
        }
    }

    public void changeEyePoint() {
        Jun3dPoint jun3dPoint = this.showProjector().eyePoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGLShowModel.$String((String)"Input a new eye point.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGLShowModel.$String((String)" is invalid point."));
        }
        this.eyePoint_(jun3dPoint);
    }

    public void changeSightPoint() {
        Jun3dPoint jun3dPoint = this.showProjector().sightPoint();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGLShowModel.$String((String)"Input a new sight point.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGLShowModel.$String((String)" is invalid point."));
        }
        this.sightPoint_(jun3dPoint);
    }

    public void changeUpVector() {
        Jun3dPoint jun3dPoint = this.showProjector().upVector();
        float f = (float)jun3dPoint.x();
        float f2 = (float)jun3dPoint.y();
        float f3 = (float)jun3dPoint.z();
        String string = JunDialog.Request_(JunOpenGLShowModel.$String((String)"Input a new up vector.") + " (x, y, z)", "(" + f + "," + f2 + "," + f3 + ")");
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            jun3dPoint = (Jun3dPoint)((Object)JunSmallCompiler.Evaluate_(string));
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGLShowModel.$String((String)" is invalid point."));
        }
        this.upVector_(jun3dPoint);
    }

    public void changeViewFactor() {
        double d = this.showProjector().viewFactor();
        String string = JunDialog.Request_(JunOpenGLShowModel.$String((String)"Input a new view factor."), String.valueOf((float)d));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGLShowModel.$String((String)" is invalid value."));
        }
        this.viewFactor_(d);
    }

    public void changeZoomHeight() {
        double d = this.showProjector().zoomHeight();
        String string = JunDialog.Request_(JunOpenGLShowModel.$String((String)"Input a new zoom height."), String.valueOf((float)d));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            d = Double.valueOf(string);
        }
        catch (Exception exception) {
            JunDialog.Warn_(string + JunOpenGLShowModel.$String((String)" is invalid value."));
        }
        this.zoomHeight_(d);
    }

    public void lineSmooth() {
        this.showProjector().lineSmooth_(!this.showProjector().lineSmooth());
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"smoothing"));
    }

    public void polygonSmooth() {
        this.showProjector().polygonSmooth_(!this.showProjector().polygonSmooth());
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"smoothing"));
    }

    public void spawnObject() {
        JunOpenGLDisplayModel junOpenGLDisplayModel = null;
        junOpenGLDisplayModel = StInputState.Default().shiftDown() ? new JunOpenGLDisplayModel(new JunOpenGL3dCompoundObject(this.showObject(), this.viewportBeam())) : new JunOpenGLDisplayModel(this.showObject());
        junOpenGLDisplayModel.displayProjection_((JunOpenGLProjection)this.showProjection().copy());
        StView stView = this.getView();
        if (stView == null) {
            junOpenGLDisplayModel.open();
        } else {
            StRectangle stRectangle = new StRectangle(stView.topComponent().getBounds());
            StRectangle stRectangle2 = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
            stRectangle2 = stRectangle2.align_with_(stRectangle2.topLeft(), new Point(stRectangle.right() + 5, stRectangle.top()));
            junOpenGLDisplayModel.openIn_(stRectangle2.toRectangle());
        }
        junOpenGLDisplayModel.changed_(JunOpenGLShowModel.$((String)"object"));
    }

    public void spawnViewfinder() {
        JunOpenGLDisplayModel junOpenGLDisplayModel = this.displayModel();
        if (junOpenGLDisplayModel.builder().windows().length > 0) {
            junOpenGLDisplayModel._windowExpandAndRaise();
        } else {
            junOpenGLDisplayModel.open();
        }
    }

    public void switchStippleAndTransparency() {
        this.useTransparency_(!this.useTransparency());
    }

    public void hiddenlinePresentation() {
        this.showProjector().hiddenlinePresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGLShowModel.$((String)"hiddenlinePresentation"));
        }
    }

    public void solidPresentation() {
        this.showProjector().solidPresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGLShowModel.$((String)"solidPresentation"));
        }
    }

    public void wireframePresentation() {
        this.showProjector().wireframePresentation();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"presentation"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"presentation"))) {
            this.defaultPresentation_(JunOpenGLShowModel.$((String)"wireframePresentation"));
        }
    }

    public void eyePoint_(Jun3dPoint jun3dPoint) {
        this.showProjector().eyePoint_(jun3dPoint);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"eyePoint"))) {
            this.defaultEyePoint_(jun3dPoint);
        }
    }

    public void fit() {
        if (this.showObject() == null) {
            return;
        }
        this.fitSilently();
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
    }

    public void fitSight() {
        if (this.showObject() == null) {
            return;
        }
        Jun3dPoint jun3dPoint = this.computeSightPoint();
        this.sightPoint_(jun3dPoint);
    }

    public void fitSilently() {
        if (this.showObject() == null) {
            return;
        }
        Jun3dPoint jun3dPoint = this.computeSightPoint();
        this.showProjector().sightPoint_(jun3dPoint);
        double d = this.computeZoomHeight();
        this.showProjector().zoomHeight_(d);
    }

    public void fitZoom() {
        if (this.showObject() == null) {
            return;
        }
        double d = this.computeZoomHeight();
        this.zoomHeight_(d);
    }

    public void parallelProjection() {
        this.showProjector().parallelProjection();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"projection"))) {
            this.defaultProjection_(JunOpenGLParallelProjection.Type);
        }
    }

    public void perspectiveProjection() {
        this.showProjector().perspectiveProjection();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"projection"))) {
            this.defaultProjection_(JunOpenGLPerspectiveProjection.Type);
        }
    }

    public void sightPoint_(Jun3dPoint jun3dPoint) {
        this.showProjector().sightPoint_(jun3dPoint);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"sightPoint"))) {
            this.defaultSightPoint_(jun3dPoint);
        }
    }

    public void upVector_(Jun3dPoint jun3dPoint) {
        this.showProjector().upVector_(jun3dPoint);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"upVector"))) {
            this.defaultUpVector_(jun3dPoint);
        }
    }

    public void viewFactor_(double d) {
        this.showProjector().viewFactor_(d);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"viewFactor"))) {
            this.defaultViewFactor_(d);
        }
    }

    public void zoom_(double d) {
        if (StInputState.Default().shiftDown()) {
            d = d >= 1.0 ? 1.0 + (d - 1.0) * 0.1 : 1.0 - (1.0 - d) * 0.1;
        }
        this.showProjector().zoom_(d);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
    }

    public void zoomHeight_(double d) {
        this.showProjector().zoomHeight_(d);
        this.changed_(JunOpenGLShowModel.$((String)"projection"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"zoomHeight"))) {
            this.defaultZoomHeight_(d);
        }
    }

    public void renderOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.clear();
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLLight[] junOpenGLLightArray = this.displayModel().displayLightCollection();
        this.showProjector().project_withLights_on_(this.showObject(), junOpenGLLightArray, junOpenGLRenderingContext);
        this.showProjector().project_on_(this.viewportBeam(), junOpenGLRenderingContext);
        junOpenGLRenderingContext.flush();
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Misc"), JunOpenGLShowModel.$((String)"miscMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Spawn"), JunOpenGLShowModel.$((String)"spawnMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnObject")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Viewport"), JunOpenGLShowModel.$((String)"viewportMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnViewport")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Stipple or Transparency"), (MenuListener)new MenuPerformer((StObject)this, "switchStippleAndTransparency")));
        return stMenu;
    }

    public void flatShading() {
        this.showProjector().flatShading();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"shading"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"shading"))) {
            this.defaultShading_(JunOpenGLShowModel.$((String)"flatShading"));
        }
    }

    public void smoothShading() {
        this.showProjector().smoothShading();
        this.updateViewMenuIndication();
        this.changed_(JunOpenGLShowModel.$((String)"shading"));
        if (!this.defaultProjectionTable().containsKey(JunOpenGLShowModel.$((String)"shading"))) {
            this.defaultShading_(JunOpenGLShowModel.$((String)"smoothShading"));
        }
    }

    public void update_(DependentEvent dependentEvent) {
        if (dependentEvent.getSource() == this.displayModel()) {
            this.changed_(dependentEvent.getAspect());
        }
    }

    protected Jun3dPoint computeSightPoint() {
        return this.displayModel().displayProjection().sightPoint();
    }

    protected double computeZoomHeight() {
        double d = this.showProjection().distance();
        Jun3dPoint jun3dPoint = this.showProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, -1.0), d);
        Jun3dPoint jun3dPoint2 = this.showProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(0.0, 1.0), d);
        Jun3dPoint jun3dPoint3 = this.showProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(1.0, 0.0), d);
        Jun3dPoint jun3dPoint4 = this.showProjection().translateTo3dPointFromPoint_depth_(new Jun2dPoint(-1.0, 0.0), d);
        final JunPlane junPlane = new JunPlane(this.showProjection().eyePoint(), jun3dPoint4, jun3dPoint3);
        final JunPlane junPlane2 = new JunPlane(this.showProjection().eyePoint(), jun3dPoint, jun3dPoint2);
        final double[] dArray = new double[]{0.0, 0.0};
        this.showObject().pointsDo_(new StBlockClosure(){

            public Object value_(Object object) {
                double d = junPlane2.distanceFromPoint_((Jun3dPoint)((Object)object));
                double d2 = junPlane.distanceFromPoint_((Jun3dPoint)((Object)object));
                if (d > dArray[0]) {
                    dArray[0] = d;
                }
                if (d2 > dArray[1]) {
                    dArray[1] = d2;
                }
                return null;
            }
        });
        double d2 = dArray[0];
        double d3 = dArray[1];
        double d4 = 2.5;
        return d2 > d3 ? d2 * d4 : d3 * d4;
    }

    protected double computeViewportHeight() {
        double d;
        JunOpenGLProjection junOpenGLProjection = this.displayModel().displayProjection();
        double d2 = junOpenGLProjection.regularHeight();
        if (d2 > (d = 2.0 * junOpenGLProjection.sightPoint().distance_(junOpenGLProjection.nearCenter()))) {
            d2 = d;
        }
        return d2;
    }

    protected Jun3dPoint grab3dPoint_(Jun2dPoint jun2dPoint) {
        JunOpenGLParallelProjection junOpenGLParallelProjection;
        Jun3dLine jun3dLine;
        JunOpenGLProjection junOpenGLProjection = this.showProjection();
        JunSphereSurface junSphereSurface = this.grabSphere();
        Jun3dPoint[] jun3dPointArray = junSphereSurface.crossPointsWithLine_(jun3dLine = new Jun3dLine((junOpenGLParallelProjection = junOpenGLProjection.asParallelProjection()).translateTo3dPointInNearBoundaryPlaneFromPoint_(jun2dPoint), junOpenGLParallelProjection.translateTo3dPointInFarBoundaryPlaneFromPoint_(jun2dPoint)));
        if (jun3dPointArray.length == 0) {
            return junOpenGLParallelProjection.translateTo3dPointFromPoint_(jun2dPoint);
        }
        return jun3dPointArray[0];
    }

    protected JunSphereSurface grabSphere() {
        JunOpenGLProjection junOpenGLProjection = this.showProjection();
        JunSphereSurface junSphereSurface = new JunSphereSurface(junOpenGLProjection.sightPoint(), junOpenGLProjection.regularHeight() / 2.0);
        return junSphereSurface;
    }
}

