/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.flux;

import java.util.ArrayList;
import java.util.Collection;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.flux.JunCoordinateAngles;
import jp.co.sra.jun.system.framework.JunAbstractObject;

public class JunOpenGLFluxMaker
extends JunAbstractObject {
    protected ArrayList lineSegments;
    protected JunCoordinateAngles originalCoordinateAngles;
    protected JunCoordinateAngles[] coordinateAnglesCollection;
    protected Jun3dTransformation[] rotationTransformations;
    protected Jun3dTransformation[] revisionTransformations;
    protected Jun3dTransformation[] scalingTransformations;
    protected Jun3dTransformation[] translationTransformations;
    protected Jun3dTransformation[] segmentTransformations;

    public JunOpenGLFluxMaker() {
    }

    public JunOpenGLFluxMaker(Jun3dPoint[][] jun3dPointArray) {
        this();
        this.lineSegments_(jun3dPointArray);
    }

    public JunOpenGLFluxMaker(Collection collection) {
        this((Jun3dPoint[][])collection.toArray((T[])new Jun3dPoint[collection.size()][]));
    }

    protected void initialize() {
        super.initialize();
        this.lineSegments = null;
        this.flushTransformations();
    }

    public Jun3dPoint[][] lineSegments() {
        return (Jun3dPoint[][])this._lineSegments().toArray((T[])new Jun3dPoint[this._lineSegments().size()][]);
    }

    public void lineSegments_(Jun3dPoint[][] jun3dPointArray) {
        if (jun3dPointArray == null) {
            return;
        }
        for (int i = 0; i < jun3dPointArray.length; ++i) {
            this.add_(jun3dPointArray[i]);
        }
    }

    protected ArrayList _lineSegments() {
        if (this.lineSegments == null) {
            this.lineSegments = new ArrayList();
        }
        return this.lineSegments;
    }

    public Jun3dPoint directionVector() {
        return new Jun3dPoint(1.0, 0.0, 0.0);
    }

    public Jun3dPoint unitVector() {
        return new Jun3dPoint(0.0, 0.0, 1.0);
    }

    public Jun3dTransformation[] segmentTransformations() {
        if (this.segmentTransformations == null) {
            this.computeTransformations();
        }
        return this.segmentTransformations;
    }

    public void add_(Jun3dPoint[] jun3dPointArray) {
        this._lineSegments().add(jun3dPointArray);
        this.flushTransformations();
    }

    public JunCoordinateAngles originalCoordinateAngles() {
        if (this.originalCoordinateAngles == null) {
            this.computeTransformations();
        }
        return this.originalCoordinateAngles;
    }

    public JunCoordinateAngles[] coordinateAnglesCollection() {
        if (this.coordinateAnglesCollection == null) {
            this.computeTransformations();
        }
        return this.coordinateAnglesCollection;
    }

    public Jun3dTransformation[] rotationTransformations() {
        if (this.rotationTransformations == null) {
            this.computeTransformations();
        }
        return this.rotationTransformations;
    }

    public Jun3dTransformation[] revisionTransformations() {
        if (this.revisionTransformations == null) {
            this.computeTransformations();
        }
        return this.revisionTransformations;
    }

    public Jun3dTransformation[] scalingTransformations() {
        if (this.scalingTransformations == null) {
            this.computeTransformations();
        }
        return this.scalingTransformations;
    }

    public Jun3dTransformation[] translationTransformations() {
        if (this.translationTransformations == null) {
            this.computeTransformations();
        }
        return this.translationTransformations;
    }

    protected void flushTransformations() {
        this.originalCoordinateAngles = null;
        this.coordinateAnglesCollection = null;
        this.rotationTransformations = null;
        this.revisionTransformations = null;
        this.scalingTransformations = null;
        this.translationTransformations = null;
        this.segmentTransformations = null;
    }

    protected void computeTransformations() {
        this.originalCoordinateAngles = JunCoordinateAngles.V1_v2_(this.unitVector(), this.directionVector());
        this.coordinateAnglesCollection = new JunCoordinateAngles[this._lineSegments().size()];
        this.rotationTransformations = new Jun3dTransformation[this._lineSegments().size()];
        this.revisionTransformations = new Jun3dTransformation[this._lineSegments().size()];
        this.scalingTransformations = new Jun3dTransformation[this._lineSegments().size()];
        this.translationTransformations = new Jun3dTransformation[this._lineSegments().size()];
        this.segmentTransformations = new Jun3dTransformation[this._lineSegments().size()];
        for (int i = 0; i < this._lineSegments().size(); ++i) {
            Jun3dTransformation jun3dTransformation;
            Jun3dTransformation jun3dTransformation2;
            JunCoordinateAngles junCoordinateAngles;
            Jun3dPoint[] jun3dPointArray = (Jun3dPoint[])this._lineSegments().get(i);
            Jun3dPoint jun3dPoint = jun3dPointArray[0];
            Jun3dPoint jun3dPoint2 = jun3dPointArray[1];
            double d = jun3dPoint.distance_(jun3dPoint2);
            this.coordinateAnglesCollection[i] = junCoordinateAngles = JunCoordinateAngles.V1_v2_(jun3dPoint2.minus_(jun3dPoint), this.directionVector());
            Jun3dTransformation jun3dTransformation3 = Jun3dTransformation.Unity();
            jun3dTransformation3 = jun3dTransformation3.product_(this.originalCoordinateAngles.asInverseTransformation());
            this.rotationTransformations[i] = jun3dTransformation3 = jun3dTransformation3.product_(junCoordinateAngles.asTransformation());
            Jun3dPoint jun3dPoint3 = this.directionVector().transform_(jun3dTransformation3);
            JunPlane junPlane = new JunPlane(new Jun3dPoint(0.0, 0.0, 0.0), this.unitVector(), this.directionVector());
            Jun3dLine jun3dLine = new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), this.unitVector().transform_(jun3dTransformation3));
            Jun3dTransformation jun3dTransformation4 = this.transformationToBeParallel_and_byRotationAround_(junPlane, jun3dPoint3, jun3dLine);
            jun3dPointArray = (Jun3dPoint[])this._lineSegments().get(i);
            jun3dPoint = jun3dPointArray[0];
            jun3dPoint2 = jun3dPointArray[1];
            if (jun3dPoint.z() < jun3dPoint2.z()) {
                jun3dTransformation2 = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(180.0), jun3dLine);
                jun3dTransformation4 = jun3dTransformation4.product_(jun3dTransformation2);
            }
            this.revisionTransformations[i] = jun3dTransformation4;
            this.scalingTransformations[i] = jun3dTransformation2 = Jun3dTransformation.Scale_(new Jun3dPoint(d, d, d));
            this.translationTransformations[i] = jun3dTransformation = Jun3dTransformation.Translate_(jun3dPoint);
            Jun3dTransformation jun3dTransformation5 = Jun3dTransformation.Unity();
            jun3dTransformation5 = jun3dTransformation5.product_(jun3dTransformation2);
            jun3dTransformation5 = jun3dTransformation5.product_(jun3dTransformation3);
            jun3dTransformation5 = jun3dTransformation5.product_(jun3dTransformation4);
            this.segmentTransformations[i] = jun3dTransformation5 = jun3dTransformation5.product_(jun3dTransformation);
        }
    }

    protected Jun3dTransformation transformationToBeParallel_and_byRotationAround_(JunPlane junPlane, Jun3dPoint jun3dPoint, Jun3dLine jun3dLine) {
        int n;
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Unity();
        JunAngle junAngle = JunAngle.FromDeg_(0.0);
        Jun3dPoint jun3dPoint2 = jun3dPoint;
        Jun3dLine jun3dLine2 = new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), jun3dPoint2);
        double[] dArray = new double[]{90.0, 45.0, 10.0, 5.0, 1.0, 0.5};
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray[n];
            while (Math.abs(junPlane.angleWithLine_(jun3dLine2).deg()) > d) {
                junAngle = JunAngle.FromDeg_(junAngle.deg() + d);
                jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
                jun3dPoint2 = jun3dPoint.transform_(jun3dTransformation);
                jun3dLine2 = new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), jun3dPoint2);
            }
        }
        n = (int)Math.round(Math.abs(Math.log(JunGeometry.Accuracy()) / Math.log(10.0))) - 1;
        for (int i = 1; i <= n; ++i) {
            double d = Math.pow(10.0, i);
            double[] dArray2 = new double[]{1.0, 0.5};
            for (int j = 0; j < dArray2.length; ++j) {
                double d2 = dArray2[j] / d;
                while (Math.abs(junPlane.angleWithLine_(jun3dLine2).deg()) > d2) {
                    junAngle = JunAngle.FromDeg_(junAngle.deg() + d2);
                    jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
                    jun3dPoint2 = jun3dPoint.transform_(jun3dTransformation);
                    jun3dLine2 = new Jun3dLine(new Jun3dPoint(0.0, 0.0, 0.0), jun3dPoint2);
                }
            }
        }
        if (jun3dPoint2.x() < 0.0) {
            junAngle = JunAngle.FromDeg_(180.0).minus_(junAngle).negated();
            jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
        }
        return jun3dTransformation;
    }
}

