/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.grapher;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.display.JunOpenGLShowModel;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dArc;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraph;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dGraphAbstract;
import jp.co.sra.jun.opengl.grapher.JunOpenGL3dNode;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;

public class JunOpenGL3dGrapher
extends JunOpenGLDisplayModel {
    public void addSelectedObject_(JunOpenGL3dObject junOpenGL3dObject) {
        JunOpenGL3dObject junOpenGL3dObject2 = this.displayObject();
        if (junOpenGL3dObject2 == null) {
            return;
        }
        if (junOpenGL3dObject2.isPrimitive()) {
            return;
        }
        JunOpenGL3dNode[] junOpenGL3dNodeArray = ((JunOpenGL3dGraph)junOpenGL3dObject2).nodes();
        int n = junOpenGL3dNodeArray.length;
        JunOpenGL3dNode junOpenGL3dNode = null;
        for (int i = 0; i < n; ++i) {
            JunOpenGL3dNode junOpenGL3dNode2 = junOpenGL3dNodeArray[i];
            if (junOpenGL3dNode2.displayObject() != junOpenGL3dObject) continue;
            junOpenGL3dNode = junOpenGL3dNode2;
        }
        if (junOpenGL3dNode == null) {
            return;
        }
        super.addSelectedObject_(junOpenGL3dObject);
    }

    public void arrangeGraph() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        this.clearSelectedObjects();
        junOpenGL3dGraph.arrange();
        this.resetView();
    }

    public void arrangeGraph2() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        this.clearSelectedObjects();
        junOpenGL3dGraph.arrange2();
        this.resetView();
    }

    public void arrangeGraphBalance() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        junOpenGL3dGraph.arrangeBalance_(!junOpenGL3dGraph.arrangeBalance());
        junOpenGL3dGraph.arrange();
        this.clearSelectedObjects();
        this.updateGraphMenuIndication();
        this.changed_(JunOpenGL3dGrapher.$((String)"object"));
    }

    public void arrangeGraphCrankArcs() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        boolean bl = !this.isCrankArcs();
        JunOpenGL3dArc[] junOpenGL3dArcArray = junOpenGL3dGraph.arcs();
        int n = junOpenGL3dArcArray.length;
        for (int i = 0; i < n; ++i) {
            junOpenGL3dArcArray[i].crank_(bl);
        }
        junOpenGL3dGraph.flushDisplayObject();
        this.updateGraphMenuIndication();
        this.changed_(JunOpenGL3dGrapher.$((String)"object"));
    }

    public void arrangeGraphInterval() {
        float f;
        float f2;
        float f3;
        Object object;
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        Jun3dPoint jun3dPoint = junOpenGL3dGraph.arrangeInterval();
        String string = new Double(jun3dPoint.x()).toString() + "," + new Double(jun3dPoint.y()).toString() + "," + new Double(jun3dPoint.z()).toString();
        string = JunDialog.Request_(JunSystem.$String((String)"Arrange interval?") + " (x , y , z)", string);
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        try {
            object = new StringTokenizer(string, "(), ");
            f3 = Float.valueOf(object.nextToken()).floatValue();
            f2 = Float.valueOf(object.nextToken()).floatValue();
            f = Float.valueOf(object.nextToken()).floatValue();
        }
        catch (Exception exception) {
            return;
        }
        object = new Jun3dPoint(f3, f2, f);
        junOpenGL3dGraph.arrangeInterval_((Jun3dPoint)((Object)object));
        junOpenGL3dGraph.arrange();
        this.clearSelectedObjects();
        this.changed_(JunOpenGL3dGrapher.$((String)"object"));
    }

    public void arrangeGraphWithInterim() {
        final JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        this.clearSelectedObjects();
        final JunOpenGL3dGrapher junOpenGL3dGrapher = this;
        junOpenGL3dGraph.arrange_(new StBlockClosure(){

            public Object value_(Object object) {
                junOpenGL3dGraph.flushDisplayObject();
                junOpenGL3dGrapher.resetView();
                return null;
            }
        });
        this.resetView();
    }

    public void arrangeProperties() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return;
        }
        System.out.print(junOpenGL3dGraph.arrangeFormat());
    }

    public void clearObject() {
        System.out.print("do nothing");
    }

    public void copyObject() {
        System.out.print("do nothing");
    }

    public void cutObject() {
        System.out.print("do nothing");
    }

    public boolean isArrangeBalance() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return new JunOpenGL3dGraph().arrangeBalance();
        }
        return junOpenGL3dGraph.arrangeBalance();
    }

    public boolean isCrankArcs() {
        JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject();
        if (junOpenGL3dGraph == null) {
            return new JunOpenGL3dArc().crank();
        }
        JunOpenGL3dArc[] junOpenGL3dArcArray = junOpenGL3dGraph.arcs();
        int n = junOpenGL3dArcArray.length;
        for (int i = 0; i < n; ++i) {
            boolean bl = junOpenGL3dArcArray[i].crank();
            if (!bl) continue;
            return bl;
        }
        return false;
    }

    public boolean isEmpty() {
        if (this.displayObject() == null) {
            return true;
        }
        if (!this.displayObject().isCompound()) {
            return false;
        }
        return ((JunOpenGL3dGraph)this.displayObject()).components().length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGL3dGraph loadFromLGT10_(BufferedReader bufferedReader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JunOpenGL3dGraph junOpenGL3dGraph = null;
        try {
            int n;
            while ((n = bufferedReader.read()) > 0) {
                stringWriter.write(n);
            }
            stringWriter.flush();
            junOpenGL3dGraph = (JunOpenGL3dGraph)JunOpenGL3dGraph.LoadFrom_(stringWriter.toString());
        }
        finally {
            stringWriter.close();
        }
        return junOpenGL3dGraph;
    }

    public void openLGT() {
        this.openLGT10();
    }

    public void openLGT10() {
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"LGT"), new String[]{"*.lgt", "*.LGT"})};
        File file = JunFileRequesterDialog.RequestFile(JunSystem.$String((String)"Select an <1p> file.", null, (Object)"LGT"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            JunOpenGL3dGraph junOpenGL3dGraph = this.readFromLGT10_(file);
            if (junOpenGL3dGraph == null) {
                return;
            }
            this.displayObject_(junOpenGL3dGraph);
            this.resetView();
            JunOpenGLShowModel junOpenGLShowModel = this.showModel();
            if (junOpenGLShowModel != null) {
                junOpenGLShowModel.resetView();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pasteObject() {
        System.out.print("do nothing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JunOpenGL3dGraph readFromLGT10_(File file) throws IOException {
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        JunOpenGL3dGraph junOpenGL3dGraph = null;
        try {
            junOpenGL3dGraph = this.loadFromLGT10_(bufferedReader);
        }
        finally {
            bufferedReader.close();
        }
        return junOpenGL3dGraph;
    }

    public void removeSelectedObject_(JunOpenGL3dObject junOpenGL3dObject) {
        JunOpenGL3dObject junOpenGL3dObject2 = this.displayObject();
        if (junOpenGL3dObject2 == null) {
            return;
        }
        if (junOpenGL3dObject2.isPrimitive()) {
            return;
        }
        JunOpenGL3dNode[] junOpenGL3dNodeArray = ((JunOpenGL3dGraph)junOpenGL3dObject2).nodes();
        int n = junOpenGL3dNodeArray.length;
        JunOpenGL3dNode junOpenGL3dNode = null;
        for (int i = 0; i < n; ++i) {
            JunOpenGL3dNode junOpenGL3dNode2 = junOpenGL3dNodeArray[i];
            if (junOpenGL3dNode2.displayObject() != junOpenGL3dObject) continue;
            junOpenGL3dNode = junOpenGL3dNode2;
        }
        if (junOpenGL3dNode == null) {
            return;
        }
        if (this.selectedObjects().contains((Object)junOpenGL3dObject)) {
            this.selectedObjects().removeElement((Object)junOpenGL3dObject);
        }
    }

    public void saveLGT() {
        this.saveLGT10();
    }

    public void saveLGT10() {
        JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract = (JunOpenGL3dGraphAbstract)this.displayObject();
        if (junOpenGL3dGraphAbstract == null) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"LGT"), new String[]{"*.lgt", "*.LGT"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunSystem.$String((String)"Input an <1p> file.", null, (Object)"LGT"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToLGT10_object_(file, junOpenGL3dGraphAbstract);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveToLGT10_object_(BufferedWriter bufferedWriter, JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract) throws IOException {
        bufferedWriter.write(this.defaultStampForLGT10());
        junOpenGL3dGraphAbstract.saveOn_(bufferedWriter);
    }

    public void saveWRL10() {
        JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract = (JunOpenGL3dGraphAbstract)this.displayObject();
        if (junOpenGL3dGraphAbstract == null) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunSystem.$String((String)"Input a <1p> file.", null, (Object)"WRL"), new File(junOpenGL3dGraphAbstract.name() + ".wrl"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        try {
            this.writeToWRL20_object_(file, junOpenGL3dGraphAbstract.displayObject());
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void saveWRL20() {
        JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract = (JunOpenGL3dGraphAbstract)this.displayObject();
        if (junOpenGL3dGraphAbstract == null) {
            return;
        }
        JunFileModel.FileType[] fileTypeArray = new JunFileModel.FileType[]{new JunFileModel.FileType(JunSystem.$String((String)"<1p> files", null, (Object)"VRML"), new String[]{"*.wrl", "*.WRL"})};
        File file = JunFileRequesterDialog.RequestNewFile(JunSystem.$String((String)"Input a <1p> file.", null, (Object)"WRL"), new File(junOpenGL3dGraphAbstract.name() + ".wrl"), fileTypeArray, fileTypeArray[0]);
        if (file == null) {
            return;
        }
        Jun3dBoundingBox jun3dBoundingBox = junOpenGL3dGraphAbstract.boundingBox();
        Jun3dPoint jun3dPoint = jun3dBoundingBox.center();
        Jun3dTransformation jun3dTransformation = Jun3dTransformation.Translate_(new Jun3dPoint(0.0 - jun3dPoint.x(), 0.0 - jun3dPoint.y(), 0.0 - jun3dPoint.z()));
        JunOpenGL3dObject junOpenGL3dObject = junOpenGL3dGraphAbstract.displayObject().transform_(jun3dTransformation);
        try {
            this.writeToWRL20_object_(file, junOpenGL3dObject);
        }
        catch (IOException iOException) {
            throw new SmalltalkException((Exception)iOException);
        }
    }

    public void selectAll() {
        JunOpenGL3dObject junOpenGL3dObject = this.displayObject();
        if (junOpenGL3dObject == null) {
            return;
        }
        if (junOpenGL3dObject.isPrimitive()) {
            return;
        }
        Vector vector = this.selectedObjects();
        this.clearSelectedObjects();
        JunOpenGL3dNode[] junOpenGL3dNodeArray = ((JunOpenGL3dGraph)junOpenGL3dObject).nodes();
        int n = junOpenGL3dNodeArray.length;
        for (int i = 0; i < n; ++i) {
            vector.addElement(junOpenGL3dNodeArray[i]);
        }
        this.changed_(JunOpenGL3dGrapher.$((String)"selection"));
    }

    public Vector selectedNodes() {
        Vector<JunOpenGL3dNode> vector = new Vector<JunOpenGL3dNode>();
        Vector vector2 = this.selectedObjects();
        for (int i = 0; i < vector2.size(); ++i) {
            JunOpenGL3dGraph junOpenGL3dGraph = (JunOpenGL3dGraph)vector2.elementAt(i);
            JunOpenGL3dNode[] junOpenGL3dNodeArray = ((JunOpenGL3dGraph)junOpenGL3dGraph.displayObject()).nodes();
            int n = junOpenGL3dNodeArray.length;
            for (int j = 0; j < n; ++j) {
                JunOpenGL3dNode junOpenGL3dNode = junOpenGL3dNodeArray[i];
                if (junOpenGL3dNode.displayObject() != junOpenGL3dGraph) continue;
                vector.addElement(junOpenGL3dNode);
            }
        }
        return vector;
    }

    public JunOpenGL3dObject spawningObject() {
        JunOpenGL3dGraph junOpenGL3dGraph;
        Vector vector = this.selectedObjects();
        if (vector.isEmpty()) {
            junOpenGL3dGraph = (JunOpenGL3dGraph)this.displayObject().copy();
        } else {
            junOpenGL3dGraph = new JunOpenGL3dGraph();
            Vector vector2 = this.selectedNodes();
            for (int i = 0; i < vector2.size(); ++i) {
                junOpenGL3dGraph.addNode_((JunOpenGL3dNode)((Object)vector2.elementAt(i)));
            }
        }
        return junOpenGL3dGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToLGT10_object_(File file, JunOpenGL3dGraphAbstract junOpenGL3dGraphAbstract) throws IOException {
        if (file == null) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            this.saveToLGT10_object_(bufferedWriter, junOpenGL3dGraphAbstract);
        }
        finally {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    private String defaultStampForLGT10() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("%LGT V1.0 List Grapher Transmission (Lisp S Expression)");
        printWriter.println("% This file was created by " + JunSystem.System() + JunSystem.Version());
        printWriter.println("% " + DateFormat.getInstance().format(new Date()));
        printWriter.println();
        printWriter.flush();
        return stringWriter.toString();
    }

    protected String windowTitle() {
        return JunSystem.$String((String)"Grapher");
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createEditMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createGraphMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"File"), JunOpenGL3dGrapher.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"New"), (MenuListener)new MenuPerformer((StObject)this, "newModel")));
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Open") + "..."), (MenuListener)new MenuPerformer((StObject)this, "openLST")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Save") + "..."), JunOpenGL3dGrapher.$((String)"saveMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveLST")));
        StMenu stMenu2 = new StMenu((Object)JunSystem.$String((String)"Save as..."), JunOpenGL3dGrapher.$((String)"saveAsMenu"));
        stMenu2.add(new StMenuItem((Object)"VRML1.0...", (MenuListener)new MenuPerformer((StObject)this, "saveWRL10")));
        stMenu2.add(new StMenuItem((Object)"VRML97...", (MenuListener)new MenuPerformer((StObject)this, "saveWRL97")));
        stMenu.add((StMenuItem)stMenu2);
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Save as image..."), JunOpenGL3dGrapher.$((String)"saveAsImageMenu"), (MenuListener)new MenuPerformer((StObject)this, "saveAsImage")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    protected StMenu _createGraphMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Graph"), JunOpenGL3dGrapher.$((String)"graphMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Arrange"), JunOpenGL3dGrapher.$((String)"arrangeMenu"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGraph")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Arrange2"), JunOpenGL3dGrapher.$((String)"arrange2Menu"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGraph2")));
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Interval"), JunOpenGL3dGrapher.$((String)"intervalMenu"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGraphInterval")));
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Balance"), JunOpenGL3dGrapher.$((String)"balanceMenu"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGraphBalance")));
        stMenu.addSeparator();
        stMenu.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Crank arcs"), JunOpenGL3dGrapher.$((String)"crankArcsMenu"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGraphCrankArcs")));
        return stMenu;
    }

    protected StMenu _createMiscMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"Misc"), JunOpenGL3dGrapher.$((String)"miscMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Spawn"), JunOpenGL3dGrapher.$((String)"spawnMenu"), (MenuListener)new MenuPerformer((StObject)this, "spawnObject")));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Bounds"), JunOpenGL3dGrapher.$((String)"boundsMenu"), (MenuListener)new MenuPerformer((StObject)this, "showBounds")));
        return stMenu;
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateGraphMenuIndication();
    }

    public void updateGraphMenuIndication() {
        StMenu stMenu = (StMenu)this._menuBar().atNameKey_(JunOpenGL3dGrapher.$((String)"graphMenu"));
        if (stMenu == null) {
            return;
        }
        boolean bl = !this.isEmpty();
        StMenuItem stMenuItem = stMenu.atNameKey_(JunOpenGL3dGrapher.$((String)"arrangeMenu"));
        if (stMenuItem != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dGrapher.$((String)"arrange2Menu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dGrapher.$((String)"intervalMenu"))) != null) {
            stMenuItem.beEnabled(bl);
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dGrapher.$((String)"balanceMenu"))) != null) {
            stMenuItem.beEnabled(bl);
            if (bl) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.isArrangeBalance());
            }
        }
        if ((stMenuItem = stMenu.atNameKey_(JunOpenGL3dGrapher.$((String)"crankArcsMenu"))) != null) {
            stMenuItem.beEnabled(bl);
            if (bl) {
                ((StCheckBoxMenuItem)stMenuItem).beSelected(this.isCrankArcs());
            }
        }
    }
}

