/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.projection;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.projection.JunOpenGLPerspectiveProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.smalltalk.StSymbol;

public class JunOpenGLParallelProjection
extends JunOpenGLProjection {
    protected double height;
    public static StSymbol Type = JunOpenGLParallelProjection.$((String)"parallelProjection");
    public static double DefaultHeight = 13.681728885883;

    public JunOpenGLParallelProjection() {
        this.setEyePoint_sightPoint_upVector_height_near_far_(DefaultEyePoint, DefaultSightPoint, DefaultUpVector, DefaultHeight, DefaultNear, DefaultFar);
    }

    public JunOpenGLParallelProjection(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        this.setEyePoint_sightPoint_upVector_height_near_far_(jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, d3);
    }

    public static JunOpenGLParallelProjection EyePoint_sightPoint_upVector_height_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        return new JunOpenGLParallelProjection(jun3dPoint, jun3dPoint2, jun3dPoint3, d, d2, d3);
    }

    public static JunOpenGLProjection Default() {
        return new JunOpenGLParallelProjection();
    }

    protected void initialize() {
        super.initialize();
    }

    public StSymbol type() {
        return Type;
    }

    public double height() {
        return this.height;
    }

    public void height_(double d) {
        this.height = d;
    }

    public double regularHeight() {
        return this.height();
    }

    public JunOpenGLParallelProjection asParallelProjection() {
        return (JunOpenGLParallelProjection)this.copy();
    }

    public JunOpenGLPerspectiveProjection asPerspectiveProjection() {
        JunAngle junAngle = JunAngle.FromRad_(Math.atan(this.height() / 2.0 / this.distance()) * 2.0);
        return new JunOpenGLPerspectiveProjection(this.eyePoint(), this.sightPoint(), this.upVector(), junAngle, this.near(), this.far());
    }

    public Jun3dTransformation asTransformation() {
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 1.0);
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, 0.0, 0.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, 1.0, 0.0);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(1.0, 0.0, 0.0);
        double d = Math.abs(this.height()) / 2.0;
        Jun3dPoint[][] jun3dPointArray = new Jun3dPoint[][]{{this.sightPoint(), jun3dPoint}, {this.eyePoint(), jun3dPoint2}, {this.sightPoint().plus_(this.unitUpVector().multipliedBy_(d)), jun3dPoint3}, {this.sightPoint().plus_(this.unitRightVector().multipliedBy_(d)), jun3dPoint4}};
        return Jun3dTransformation.AlignPoints_(jun3dPointArray);
    }

    public Jun3dTransformation asEyeTransformation() {
        Jun3dPoint jun3dPoint = new Jun3dPoint(0.0, 0.0, 0.0);
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(0.0, 0.0, 1.0);
        Jun3dPoint jun3dPoint3 = new Jun3dPoint(0.0, 1.0, 0.0);
        Jun3dPoint jun3dPoint4 = new Jun3dPoint(1.0, 0.0, 0.0);
        double d = Math.abs(this.height()) / 2.0;
        Jun3dPoint[][] jun3dPointArray = new Jun3dPoint[][]{{this.sightPoint(), jun3dPoint}, {this.sightPoint().minus_(this.unitSightVector().multipliedBy_(d)), jun3dPoint2}, {this.sightPoint().plus_(this.unitUpVector().multipliedBy_(d)), jun3dPoint3}, {this.sightPoint().plus_(this.unitRightVector().multipliedBy_(d)), jun3dPoint4}};
        return Jun3dTransformation.AlignPoints_(jun3dPointArray);
    }

    public void projectOn_(JunOpenGLRenderingContext junOpenGLRenderingContext) {
        junOpenGLRenderingContext.parallelProjection_(this);
    }

    public boolean isParallel() {
        return true;
    }

    public void pan_(double d) {
        this.height *= d;
    }

    public void zoom_(double d) {
        this.height /= d;
    }

    public double zoomHeight() {
        return this.height();
    }

    public void zoomHeight_(double d) {
        this.setZoomHeight_(d);
    }

    public Jun3dPoint translateTo3dPointFromPoint_depth_(Jun2dPoint jun2dPoint, double d) {
        double d2 = Math.abs(this.height()) / 2.0;
        Jun3dPoint jun3dPoint = this.unitSightVector().multipliedBy_(d);
        Jun3dPoint jun3dPoint2 = this.unitRightVector().multipliedBy_(jun2dPoint.x()).multipliedBy_(d2);
        Jun3dPoint jun3dPoint3 = this.unitUpVector().multipliedBy_(jun2dPoint.y()).multipliedBy_(d2);
        return this.eyePoint().plus_(jun3dPoint).plus_(jun3dPoint2).plus_(jun3dPoint3);
    }

    protected void setEyePoint_sightPoint_upVector_height_near_far_(Jun3dPoint jun3dPoint, Jun3dPoint jun3dPoint2, Jun3dPoint jun3dPoint3, double d, double d2, double d3) {
        this.eyePoint = jun3dPoint;
        this.sightPoint = jun3dPoint2;
        this.upVector = jun3dPoint3;
        this.height = d;
        this.near = d2;
        this.far = d3;
        this.normalizeUpVector();
    }

    protected void setZoomHeight_(double d) {
        this.height_(d);
    }
}

