/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.opengl.rotation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.curves.Jun2dLine;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationController;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationModel;
import jp.co.sra.jun.opengl.rotation.JunOpenGLRotationView;
import jp.co.sra.jun.system.framework.JunAbstractViewCanvas;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;

public class JunOpenGLRotationViewAwt
extends JunAbstractViewCanvas
implements JunOpenGLRotationView {
    protected static final Color _DarkGreenColor = new Color(0, 127, 0);
    protected static final Color _RoyalBlueColor = new Color(127, 127, 255);
    protected PopupMenu _popupMenu;

    public JunOpenGLRotationViewAwt(JunOpenGLRotationModel junOpenGLRotationModel) {
        super(junOpenGLRotationModel);
    }

    public Jun2dPoint descaledPoint_(Point point) {
        Point point2 = this.centerPoint();
        return this.getModel().descaledPoint_(new Point(point.x - point2.x, point.y - point2.y));
    }

    public void displayOn_(final Graphics graphics) {
        if (!this.isShowing()) {
            return;
        }
        this.displayAxesOn_(graphics);
        this.getModel().edgesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dLine jun2dLine = (Jun2dLine)((Object)object);
                graphics.setColor(JunOpenGLRotationViewAwt.this.edgeColorFor_(jun2dLine));
                Point point = JunOpenGLRotationViewAwt.this.scaledPoint_(jun2dLine.from());
                Point point2 = JunOpenGLRotationViewAwt.this.scaledPoint_(jun2dLine.to());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
                return null;
            }
        });
        this.getModel().verticesDo_(new StBlockClosure(){

            public Object value_(Object object) {
                Jun2dPoint jun2dPoint = (Jun2dPoint)((Object)object);
                graphics.setColor(JunOpenGLRotationViewAwt.this.vertexColorFor_(jun2dPoint));
                Point point = JunOpenGLRotationViewAwt.this.scaledPoint_(jun2dPoint);
                graphics.fillRect(point.x - 1, point.y - 1, 3, 3);
                return null;
            }
        });
    }

    public JunOpenGLRotationModel getModel() {
        return (JunOpenGLRotationModel)this.model();
    }

    public Point scaledPoint_(Jun2dPoint jun2dPoint) {
        Point point = this.centerPoint();
        Point point2 = this.getModel().scaledPoint_(jun2dPoint);
        point2.x += point.x;
        point2.y += point.y;
        return point2;
    }

    public Point scaledVertexAt_(int n) {
        return this.scaledPoint_(this.getModel().vertexAt_(n));
    }

    public int scaledVertexIndex_(Point point) {
        int n = this.getModel().numVertices();
        for (int i = 0; i < n; ++i) {
            Point point2 = this.scaledVertexAt_(i);
            if (Math.abs(point.x - point2.x) >= 4 || Math.abs(point.y - point2.y) >= 4) continue;
            return i;
        }
        return -1;
    }

    public void setModel(JunOpenGLRotationModel junOpenGLRotationModel) {
        this.model_((StModel)junOpenGLRotationModel);
    }

    protected void buildComponent() {
        this.setSize(192, 192);
    }

    protected Point centerPoint() {
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (this.getModel().swapXY()) {
            return new Point(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 2);
        }
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height * 3 / 4);
    }

    protected StController defaultController() {
        return new JunOpenGLRotationController();
    }

    protected StModel defaultModel() {
        return new JunOpenGLRotationModel();
    }

    protected void displayAxesOn_(Graphics graphics) {
        JunOpenGLRotationModel junOpenGLRotationModel = this.getModel();
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Point point = this.centerPoint();
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        if (!Double.isNaN(junOpenGLRotationModel.grid())) {
            graphics.setColor(this.gridColor());
            double d = junOpenGLRotationModel.grid() * (double)junOpenGLRotationModel.scale();
            int n5 = 1;
            while (true) {
                int n6;
                boolean bl = false;
                int n7 = (int)((double)n5 * d);
                int n8 = point.x - n7;
                if (n8 >= n) {
                    graphics.drawLine(n8, n3, n8, n4);
                    bl = true;
                }
                if ((n8 = point.x + n7) <= n2) {
                    graphics.drawLine(n8, n3, n8, n4);
                    bl = true;
                }
                if ((n6 = point.y - n7) >= n3) {
                    graphics.drawLine(n, n6, n2, n6);
                    bl = true;
                }
                if ((n6 = point.y + n7) <= n4) {
                    graphics.drawLine(n, n6, n2, n6);
                    bl = true;
                }
                if (!bl) break;
                ++n5;
            }
        }
        if (this.getModel().showXAxis()) {
            graphics.setColor(this.xAxisColor());
            graphics.drawLine(n, point.y, n2, point.y);
        }
        if (this.getModel().showYAxis()) {
            graphics.setColor(this.yAxisColor());
            graphics.drawLine(point.x, n3, point.x, n4);
        }
    }

    protected Color edgeColor() {
        return Color.black;
    }

    protected Color edgeColorFor_(Jun2dLine jun2dLine) {
        if (jun2dLine.to().equals((Object)this.getModel().firstVertex())) {
            return this.loopEdgeColor();
        }
        if (jun2dLine.from().equals((Object)this.getModel().lastVertex())) {
            return this.loopEdgeColor();
        }
        return this.edgeColor();
    }

    protected Color firstVertexColor() {
        return _RoyalBlueColor;
    }

    protected Color gridColor() {
        return Color.lightGray;
    }

    protected Color lastVertexColor() {
        return _DarkGreenColor;
    }

    protected Color loopEdgeColor() {
        return Color.gray;
    }

    protected Color selectedVertexColor() {
        return Color.red;
    }

    protected Color vertexColor() {
        return Color.black;
    }

    protected Color vertexColorFor_(Jun2dPoint jun2dPoint) {
        JunOpenGLRotationModel junOpenGLRotationModel = this.getModel();
        if (junOpenGLRotationModel.vertexSelected_(jun2dPoint)) {
            return this.selectedVertexColor();
        }
        if (jun2dPoint.equals((Object)junOpenGLRotationModel.firstVertex())) {
            return this.firstVertexColor();
        }
        if (jun2dPoint.equals((Object)junOpenGLRotationModel.lastVertex())) {
            return this.lastVertexColor();
        }
        return this.vertexColor();
    }

    protected Color xAxisColor() {
        if (this.getModel().swapXY()) {
            return _DarkGreenColor;
        }
        return Color.blue;
    }

    protected Color yAxisColor() {
        if (this.getModel().swapXY()) {
            return Color.blue;
        }
        return _DarkGreenColor;
    }
}

