/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.terrain.display;

import java.awt.Color;
import java.awt.Point;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.button.JunButtonModel;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.cosmos.JunOpenGLMicrocosmModel;
import jp.co.sra.jun.opengl.display.JunOpenGL3dView;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayLight;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjection;
import jp.co.sra.jun.opengl.projection.JunOpenGLProjector;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.terrain.display.JunTerrainDisplayController;
import jp.co.sra.jun.terrain.display.JunTerrainProjection;
import jp.co.sra.jun.terrain.support.JunTerrainField;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuBar;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StRadioButtonGroup;
import jp.co.sra.smalltalk.menu.StRadioButtonMenuItem;

public class JunTerrainDisplayModel
extends JunOpenGLMicrocosmModel {
    protected JunTerrainField terrainField;
    protected double inches;
    protected double defaultZoomHeight;

    public JunTerrainDisplayModel(JunTerrainField junTerrainField) {
        this.terrainField = junTerrainField;
    }

    protected void initialize() {
        super.initialize();
        this.terrainField = null;
        this.inches = 1.0;
        this.defaultZoomHeight = 1.0;
    }

    public double inches() {
        return this.inches;
    }

    public void inches_(double d) {
        this.inches = d;
        this.moveTo_(this.displayProjector().eyePoint());
    }

    public JunOpenGL3dObject displayObject() {
        if (this.openGL3dObject == null) {
            this.openGL3dObject = this.computeDisplayObject();
        }
        return this.openGL3dObject;
    }

    public JunOpenGLProjector displayProjector() {
        if (this.openGLProjector == null) {
            this.openGLProjector = new JunOpenGLProjector();
            this.openGLProjector.projection_(new JunTerrainProjection());
            this.openGLProjector.eyePoint_(this.defaultEyePoint());
            this.openGLProjector.sightPoint_(this.defaultSightPoint());
            this.openGLProjector.upVector_(this.defaultUpVector());
            this.openGLProjector.viewFactor_(this.defaultViewFactor());
            this.openGLProjector.far_(this.defaultFar());
            this.openGLProjector.near_(this.defaultNear());
        }
        return this.openGLProjector;
    }

    public JunOpenGLDisplayLight[] displayLights() {
        if (this.displayLights == null) {
            this.displayLights = new JunOpenGLDisplayLight[5];
            this.displayLights[0] = JunOpenGLDisplayLight.ParallelLight_color_position_(true, this.defaultLightColor(), this.defaultLightPoint());
            this.displayLights[1] = new JunOpenGLDisplayLight();
            this.displayLights[2] = new JunOpenGLDisplayLight();
            this.displayLights[3] = new JunOpenGLDisplayLight();
            this.displayLights[4] = JunOpenGLDisplayLight.AmbientLight_color_(false, this.defaultLightColor());
            for (int i = 0; i < this.displayLights.length; ++i) {
                this.displayLights[i].compute_(new StBlockClosure(){

                    public Object value() {
                        JunTerrainDisplayModel.this.updateLightMenuIndication();
                        this.changed_(1.$((String)"light"));
                        return null;
                    }
                });
            }
        }
        return this.displayLights;
    }

    public void grab_xy_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        this.grab_x_(jun2dPoint, jun2dPoint2);
        this.grab_y_(jun2dPoint, jun2dPoint2);
        this.changed_(JunTerrainDisplayModel.$((String)"projection"));
    }

    protected void grab_x_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        JunAngle junAngle = JunAngle.FromRad_((jun2dPoint2.x() - jun2dPoint.x()) / 2.0);
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjector.eyePoint(), junOpenGLProjector.eyePoint().plus_(new Jun3dPoint(0.0, 0.0, 1.0)));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle.mul_(-1.0), jun3dLine);
            junOpenGLProjector.sightPoint_(jun3dTransformation.applyTo_(junOpenGLProjector.sightPoint()));
            junOpenGLProjector.upVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        }
    }

    protected void grab_y_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        JunOpenGLProjection junOpenGLProjection = junOpenGLProjector.projection();
        JunAngle junAngle = JunAngle.FromRad_((jun2dPoint2.y() - jun2dPoint.y()) / 2.0);
        if (Math.abs(junAngle.rad()) > 0.001) {
            Jun3dLine jun3dLine = new Jun3dLine(junOpenGLProjection.eyePoint(), junOpenGLProjection.eyePoint().plus_(junOpenGLProjection.rightVector()));
            Jun3dTransformation jun3dTransformation = Jun3dTransformation.Rotate_around_(junAngle, jun3dLine);
            junOpenGLProjector.sightPoint_(jun3dTransformation.applyTo_(junOpenGLProjection.sightPoint()));
            junOpenGLProjector.upVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        }
    }

    public void dolly_(double d) {
        double d2 = d;
        JunOpenGLProjection junOpenGLProjection = this.displayProjection();
        Jun3dPoint jun3dPoint = junOpenGLProjection.sightVector().negated().multipliedBy_(d2);
        Jun3dPoint jun3dPoint2 = junOpenGLProjection.eyePoint();
        this.moveTo_(new Jun2dPoint(jun3dPoint2.x() + jun3dPoint.x(), jun3dPoint2.y() + jun3dPoint.y()));
    }

    public void fitSilently() {
        if (this.displayObject() == null) {
            return;
        }
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        junOpenGLProjector.sightPoint_(this.defaultSightPoint());
        junOpenGLProjector.eyePoint_(this.defaultEyePoint());
        junOpenGLProjector.upVector_(this.defaultUpVector());
        junOpenGLProjector.viewFactor_(this.defaultViewFactor());
        junOpenGLProjector.far_(this.defaultFar());
        junOpenGLProjector.near_(this.defaultNear());
        junOpenGLProjector.zoomHeight_(this.defaultZoomHeight());
    }

    public StView defaultView() {
        StView stView = super.defaultView();
        stView.controller_((StController)new JunTerrainDisplayController());
        ((JunOpenGL3dView)stView).getOpenGLDrawable().toComponent().setBackground(Color.getHSBColor(0.5f, 0.5f, 1.0f));
        return stView;
    }

    protected String windowTitle() {
        return JunTerrainDisplayModel.$String((String)"Terrain");
    }

    protected double defaultFar() {
        return this.defaultEyePoint().distance_(this.defaultSightPoint()) * this.defaultViewFactor();
    }

    protected double defaultNear() {
        return this.defaultFar() / 10000.0;
    }

    public Color defaultLightColor() {
        return Color.getHSBColor(0.19f, 0.5f, 1.0f);
    }

    public Jun3dPoint defaultLightPoint() {
        return new Jun3dPoint(0.0, 0.5, 1.0);
    }

    public double defaultViewFactor() {
        return 5.0;
    }

    public double defaultZoomHeight() {
        return this.defaultZoomHeight;
    }

    public void defaultZoomHeight_(double d) {
        this.defaultZoomHeight = d;
    }

    public JunButtonModel dollyButton() {
        if (this.dollyButton == null) {
            JunButtonModel junButtonModel = new JunButtonModel();
            junButtonModel.value_(true);
            junButtonModel.visual_(JunCursors.DollyCursorImage());
            junButtonModel.action_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunButtonModel junButtonModel;
                    junButtonModel.value_(!(junButtonModel = (JunButtonModel)((Object)object)).value());
                    return junButtonModel;
                }
            });
            this.dollyButton = junButtonModel;
        }
        return this.dollyButton;
    }

    public StMenuBar _menuBar() {
        if (this._menuBar == null) {
            this._menuBar = new StMenuBar();
            this._menuBar.add(this._createFileMenu());
            this._menuBar.add(this._createViewMenu());
            this._menuBar.add(this._createLightMenu());
            this._menuBar.add(this._createMiscMenu());
        }
        return this._menuBar;
    }

    protected StMenu _createFileMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"File"), JunTerrainDisplayModel.$((String)"fileMenu"));
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Quit"), (MenuListener)new MenuPerformer((StObject)this, "quitDoing")));
        return stMenu;
    }

    protected StMenu _createViewMenu() {
        StMenu stMenu = new StMenu((Object)JunSystem.$String((String)"View"), JunTerrainDisplayModel.$((String)"viewMenu"));
        stMenu.add(new StMenuItem((Object)(JunSystem.$String((String)"Inch", (String)"Inches") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeInches")));
        stMenu.addSeparator();
        StMenu stMenu2 = new StMenu((Object)JunSystem.$String((String)"Zooming"), JunTerrainDisplayModel.$((String)"zoomingMenu"));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"Fit zoom"), (MenuListener)new MenuPerformer((StObject)this, "fitZoom")));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"Close up"), (MenuListener)new MenuPerformer((StObject)this, "closeUp")));
        stMenu2.addSeparator();
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"Zoom"), (MenuListener)new MenuPerformer((StObject)this, "zoom")));
        stMenu2.add(new StMenuItem((Object)JunSystem.$String((String)"Pan"), (MenuListener)new MenuPerformer((StObject)this, "pan")));
        stMenu.add((StMenuItem)stMenu2);
        StMenu stMenu3 = new StMenu((Object)JunSystem.$String((String)"Pointing"));
        stMenu3.add(new StMenuItem((Object)JunSystem.$String((String)"Fit sight"), (MenuListener)new MenuPerformer((StObject)this, "fitSight")));
        stMenu3.addSeparator();
        stMenu3.add(new StMenuItem((Object)(JunSystem.$String((String)"Eye point") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeEyePoint")));
        stMenu3.add(new StMenuItem((Object)(JunSystem.$String((String)"Sight point") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeSightPoint")));
        stMenu3.add(new StMenuItem((Object)(JunSystem.$String((String)"Up vector") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeUpVector")));
        stMenu3.addSeparator();
        stMenu3.add(new StMenuItem((Object)(JunSystem.$String((String)"Zoom height") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeZoomHeight")));
        stMenu3.add(new StMenuItem((Object)(JunSystem.$String((String)"View factor") + "..."), (MenuListener)new MenuPerformer((StObject)this, "changeViewFactor")));
        stMenu.add((StMenuItem)stMenu3);
        stMenu.addSeparator();
        StMenu stMenu4 = new StMenu((Object)JunSystem.$String((String)"Projection"), JunTerrainDisplayModel.$((String)"projectionMenu"));
        StRadioButtonGroup stRadioButtonGroup = new StRadioButtonGroup();
        stMenu4.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Perspective Projection", (String)"Perspective"), JunTerrainDisplayModel.$((String)"perspectiveProjectionMenu"), stRadioButtonGroup, (MenuListener)new MenuPerformer((StObject)this, "perspectiveProjection")));
        stMenu4.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Parallel Projection", (String)"Parallel"), JunTerrainDisplayModel.$((String)"parallelProjectionMenu"), stRadioButtonGroup, (MenuListener)new MenuPerformer((StObject)this, "parallelProjection")));
        stMenu.add((StMenuItem)stMenu4);
        StMenu stMenu5 = new StMenu((Object)JunSystem.$String((String)"Presentation"), JunTerrainDisplayModel.$((String)"presentationMenu"));
        StRadioButtonGroup stRadioButtonGroup2 = new StRadioButtonGroup();
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Solid Presentation", (String)"Solid"), JunTerrainDisplayModel.$((String)"solidPresentationMenu"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "solidPresentation")));
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Wireframe Presentation", (String)"Wireframe"), JunTerrainDisplayModel.$((String)"wireframePresentationMenu"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "wireframePresentation")));
        stMenu5.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Hidden-line Presentation", (String)"Hidden-line"), JunTerrainDisplayModel.$((String)"hiddenlinePresentation"), stRadioButtonGroup2, (MenuListener)new MenuPerformer((StObject)this, "hiddenlinePresentation")));
        stMenu.add((StMenuItem)stMenu5);
        StMenu stMenu6 = new StMenu((Object)JunSystem.$String((String)"Shading"), JunTerrainDisplayModel.$((String)"shadingMenu"));
        StRadioButtonGroup stRadioButtonGroup3 = new StRadioButtonGroup();
        stMenu6.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Flat Shading", (String)"Flat"), JunTerrainDisplayModel.$((String)"flatShadingMenu"), stRadioButtonGroup3, (MenuListener)new MenuPerformer((StObject)this, "flatShading")));
        stMenu6.add((StMenuItem)new StRadioButtonMenuItem((Object)JunSystem.$String((String)"Smooth Shading", (String)"Smooth"), JunTerrainDisplayModel.$((String)"smoothShadingMenu"), stRadioButtonGroup3, (MenuListener)new MenuPerformer((StObject)this, "smoothShading")));
        stMenu.add((StMenuItem)stMenu6);
        StMenu stMenu7 = new StMenu((Object)JunSystem.$String((String)"Smoothing"), JunTerrainDisplayModel.$((String)"smoothingMenu"));
        stMenu7.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Line smooth"), JunTerrainDisplayModel.$((String)"lineSmoothMenu"), (MenuListener)new MenuPerformer((StObject)this, "lineSmooth")));
        stMenu7.add((StMenuItem)new StCheckBoxMenuItem((Object)JunSystem.$String((String)"Polygon smooth"), JunTerrainDisplayModel.$((String)"polygonSmoothMenu"), (MenuListener)new MenuPerformer((StObject)this, "polygonSmooth")));
        stMenu.add((StMenuItem)stMenu7);
        stMenu.addSeparator();
        stMenu.add(new StMenuItem((Object)JunSystem.$String((String)"Reset"), JunTerrainDisplayModel.$((String)"resetMenu"), (MenuListener)new MenuPerformer((StObject)this, "resetView")));
        stMenu.add((StMenuItem)this._createPresetProjectionMenu());
        return stMenu;
    }

    public void changeInches() {
        String string = JunDialog.Request_(JunSystem.$String((String)"Input your inches."), String.valueOf(this.inches()));
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            double d = Double.parseDouble(string);
            this.inches_(d);
        }
        catch (NumberFormatException numberFormatException) {
            JunDialog.Warn_(string + JunSystem.$String((String)" is invalid value."));
        }
    }

    public void showDisplayObject() {
        this.displayObject().show();
    }

    public void spawnObject() {
        JunTerrainDisplayModel junTerrainDisplayModel = new JunTerrainDisplayModel(this.terrainField);
        junTerrainDisplayModel.defaultSightPoint_(this.displayProjection().sightPoint());
        junTerrainDisplayModel.defaultEyePoint_(this.displayProjection().eyePoint());
        junTerrainDisplayModel.defaultZoomHeight_(this.defaultZoomHeight());
        junTerrainDisplayModel.defaultUpVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        junTerrainDisplayModel.inches_(this.inches());
        StView stView = this.getView();
        if (stView == null) {
            junTerrainDisplayModel.open();
        } else {
            StRectangle stRectangle = new StRectangle(stView.topComponent().getBounds());
            StRectangle stRectangle2 = new StRectangle(0, 0, stRectangle.width(), stRectangle.height());
            stRectangle2 = stRectangle2.align_with_(stRectangle2.topLeft(), new Point(stRectangle.right() + 5, stRectangle.top()));
            junTerrainDisplayModel.openIn_(stRectangle2.toRectangle());
        }
        junTerrainDisplayModel.resetView();
        junTerrainDisplayModel.changed_(JunTerrainDisplayModel.$((String)"object"));
    }

    protected JunOpenGL3dObject computeDisplayObject() {
        if (this.terrainField == null) {
            return null;
        }
        JunOpenGL3dObject junOpenGL3dObject = this.terrainField.asJunOpenGL3dObject();
        junOpenGL3dObject.paint_(Color.green);
        return junOpenGL3dObject;
    }

    protected double eyeHeightAtPoint_(Jun2dPoint jun2dPoint) {
        double d = this.terrainField.zAt2dPoint_(jun2dPoint);
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d + this.inches();
    }

    protected void moveTo_(Jun2dPoint jun2dPoint) {
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        Jun3dPoint jun3dPoint = junOpenGLProjector.eyePoint();
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun2dPoint, this.eyeHeightAtPoint_(jun2dPoint));
        Jun3dPoint jun3dPoint3 = junOpenGLProjector.sightPoint().plus_(jun3dPoint2).minus_(jun3dPoint);
        junOpenGLProjector.sightPoint_(jun3dPoint3);
        junOpenGLProjector.eyePoint_(jun3dPoint2);
        junOpenGLProjector.upVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        this.changed_(JunTerrainDisplayModel.$((String)"projection"));
    }

    protected void moveTo_(Jun3dPoint jun3dPoint) {
        this.moveTo_(new Jun2dPoint(jun3dPoint.x(), jun3dPoint.y()));
    }

    public void moveTo_sight_(Jun2dPoint jun2dPoint, Jun2dPoint jun2dPoint2) {
        JunOpenGLProjector junOpenGLProjector = this.displayProjector();
        Jun3dPoint jun3dPoint = new Jun3dPoint(jun2dPoint, this.eyeHeightAtPoint_(jun2dPoint));
        Jun3dPoint jun3dPoint2 = new Jun3dPoint(jun2dPoint2, this.terrainField.zAt2dPoint_(jun2dPoint2));
        junOpenGLProjector.sightPoint_(jun3dPoint2);
        junOpenGLProjector.eyePoint_(jun3dPoint);
        junOpenGLProjector.upVector_(new Jun3dPoint(0.0, 0.0, 1.0));
        this.changed_(JunTerrainDisplayModel.$((String)"projection"));
    }
}

