/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.topology.grapher;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.pluralities.Jun2dBoundingBoxes;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.topology.graph.JunElementalArc;
import jp.co.sra.jun.topology.graph.JunElementalArcSettings;
import jp.co.sra.jun.topology.graph.JunElementalGraph;
import jp.co.sra.jun.topology.graph.JunElementalGraphSettings;
import jp.co.sra.jun.topology.graph.JunElementalNode;
import jp.co.sra.jun.topology.graph.JunElementalNodeSettings;
import jp.co.sra.jun.topology.grapher.JunGrapherView;
import jp.co.sra.jun.topology.grapher.JunGrapherViewAwt;
import jp.co.sra.jun.topology.grapher.JunGrapherViewSwing;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuListener;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

public class JunGrapher
extends JunApplicationModel {
    protected JunElementalGraph elementalGraph;
    protected StRectangle focusBoundingBox;
    protected StValueHolder selectedNodesHolder;
    protected StPopupMenu graphMenu;
    protected StPopupMenu nodeMenu;
    protected JunElementalGraphSettings graphSettings;
    protected JunElementalNodeSettings nodeSettings;
    protected JunElementalArcSettings arcSettings;
    private Point _popupMenuPoint;

    public static JunGrapher DefaultNewGrapher(JunElementalGraph junElementalGraph) {
        return new JunGrapher(junElementalGraph);
    }

    public JunGrapher() {
    }

    public JunGrapher(JunElementalGraph junElementalGraph) {
        this.graph_(junElementalGraph);
    }

    protected void initialize() {
        super.initialize();
        this.elementalGraph = null;
        this.focusBoundingBox = null;
        this.selectedNodesHolder = null;
        this.graphMenu = null;
        this.nodeMenu = null;
        this.graphSettings = null;
        this.nodeSettings = null;
        this.arcSettings = null;
    }

    public JunElementalGraph graph() {
        if (this.elementalGraph == null) {
            this.elementalGraph = this.defaultGraph();
        }
        return this.elementalGraph;
    }

    public void graph_(JunElementalGraph junElementalGraph) {
        this.elementalGraph = junElementalGraph;
        this.selectedNodesHolder().value_((Object)junElementalGraph.selections());
        this.changed_(JunGrapher.$((String)"graph"));
        this.graphSettings().closeRequest();
        this.nodeSettings().closeRequest();
        this.arcSettings().closeRequest();
        this.graphSettings = null;
        this.nodeSettings = null;
        this.arcSettings = null;
    }

    public StRectangle focusBoundingBox() {
        if (this.focusBoundingBox == null) {
            JunGrapherView junGrapherView = (JunGrapherView)this.getView();
            if (junGrapherView == null) {
                return this.boundingBox();
            }
            StRectangle stRectangle = new StRectangle(junGrapherView.toComponent().getBounds());
            this.focusBoundingBox = StRectangle.Origin_corner_((Point)junGrapherView.convertViewPointToModelPoint_(stRectangle.origin()), (Point)junGrapherView.convertViewPointToModelPoint_(stRectangle.corner()));
        }
        return this.focusBoundingBox;
    }

    public void focusBoundingBox_(StRectangle stRectangle) {
        this.focusBoundingBox = stRectangle;
    }

    public StRectangle boundingBox() {
        return this.graph().boundingBox();
    }

    protected JunElementalGraphSettings graphSettings() {
        if (this.graphSettings == null) {
            this.graphSettings = this.defaultGraphSettings();
            this.graphSettings.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunGrapher.this.flushAll();
                    JunGrapher.this.arrangeGrapher();
                    JunGrapher.this.updateGrapher();
                    return null;
                }
            });
        }
        return this.graphSettings;
    }

    protected JunElementalGraphSettings graphSettingsFor_(JunElementalGraph junElementalGraph) {
        if (junElementalGraph == null) {
            return this.defaultGraphSettings();
        }
        JunElementalGraphSettings junElementalGraphSettings = this.graphSettings();
        junElementalGraphSettings.stuff_(junElementalGraph);
        return junElementalGraphSettings;
    }

    protected JunElementalNodeSettings nodeSettings() {
        if (this.nodeSettings == null) {
            this.nodeSettings = this.defaultNodeSettings();
            this.nodeSettings.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunGrapher.this.updateGrapher();
                    return null;
                }
            });
        }
        return this.nodeSettings;
    }

    protected JunElementalNodeSettings nodeSettingsFor_(JunElementalNode junElementalNode) {
        if (junElementalNode == null) {
            return this.defaultNodeSettings();
        }
        JunElementalNodeSettings junElementalNodeSettings = this.nodeSettings();
        junElementalNodeSettings.stuff_(junElementalNode);
        return junElementalNodeSettings;
    }

    protected JunElementalArcSettings arcSettings() {
        if (this.arcSettings == null) {
            this.arcSettings = this.defaultArcSettings();
            this.arcSettings.compute_(new StBlockClosure(){

                public Object value_(Object object) {
                    JunGrapher.this.updateGrapher();
                    return null;
                }
            });
        }
        return this.arcSettings;
    }

    protected JunElementalArcSettings arcSettingsFor_(JunElementalArc junElementalArc) {
        if (junElementalArc == null) {
            return this.defaultArcSettings();
        }
        JunElementalArcSettings junElementalArcSettings = this.arcSettings();
        junElementalArcSettings.stuff_(junElementalArc);
        return junElementalArcSettings;
    }

    public void flushAll() {
        this.graph().flushBoundingBox();
        this.graph().flushCachedAll();
        JunElementalNode[] junElementalNodeArray = this.graph().nodes();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            junElementalNodeArray[i].flushVisualObject();
        }
    }

    public void flushBoundingBox() {
        this.graph().flushBoundingBox();
    }

    public StView defaultView() {
        if (JunGrapher.GetDefaultViewMode() == 0) {
            return new JunGrapherViewAwt(this);
        }
        return new JunGrapherViewSwing(this);
    }

    protected JunElementalGraph defaultGraph() {
        return new JunElementalGraph();
    }

    protected JunElementalGraphSettings defaultGraphSettings() {
        return new JunElementalGraphSettings();
    }

    protected JunElementalNode defaultNode(String string) {
        return new JunElementalNode(string);
    }

    protected JunElementalNodeSettings defaultNodeSettings() {
        return new JunElementalNodeSettings();
    }

    protected JunElementalArcSettings defaultArcSettings() {
        return new JunElementalArcSettings();
    }

    public boolean isNoneArrangement() {
        return this.graph().isNoneArrangement();
    }

    public boolean isConcentricArrangement() {
        return this.graph().isConcentricArrangement();
    }

    public boolean isForestArrangement() {
        return this.graph().isForestArrangement();
    }

    public boolean isTreeArrangement() {
        return this.graph().isTreeArrangement();
    }

    public boolean isHierarchicalArrangement() {
        return this.isForestArrangement() || this.isTreeArrangement();
    }

    public boolean hasConnections_with_(JunElementalNode junElementalNode, Collection collection) {
        JunElementalArc[] junElementalArcArray = this.graph().arcsOf_(junElementalNode);
        for (int i = 0; i < junElementalArcArray.length; ++i) {
            if (!collection.contains((Object)junElementalArcArray[i].lastNode())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAllConnections_with_(JunElementalNode junElementalNode, Collection collection) {
        JunElementalArc[] junElementalArcArray = this.graph().arcsOf_(junElementalNode);
        if (junElementalArcArray.length == 0) {
            return false;
        }
        for (int i = 0; i < junElementalArcArray.length; ++i) {
            if (collection.contains((Object)junElementalArcArray[i].lastNode())) continue;
            return false;
        }
        return true;
    }

    public void postOpenWith_(StView stView) {
        super.postOpenWith_(stView);
        this.fitViewpoint();
    }

    protected String windowTitle() {
        return JunGrapher.$String((String)"Grapher");
    }

    protected boolean _viewOnBorderedPanel() {
        return true;
    }

    public void noticeOfWindowClose(WindowEvent windowEvent) {
        if (this.graphSettings != null) {
            this.graphSettings.closeRequest();
        }
        if (this.nodeSettings != null) {
            this.nodeSettings.closeRequest();
        }
        if (this.arcSettings != null) {
            this.arcSettings.closeRequest();
        }
        super.noticeOfWindowClose(windowEvent);
    }

    public StPopupMenu _popupMenuAt(Point point) {
        StPopupMenu stPopupMenu = null;
        this._popupMenuPoint = point;
        JunElementalNode junElementalNode = this.whichAt_(point);
        stPopupMenu = junElementalNode == null ? this.graphMenu() : this.nodeMenuFor_(junElementalNode);
        return stPopupMenu;
    }

    protected StPopupMenu graphMenu() {
        if (this.graphMenu == null) {
            this.graphMenu = new StPopupMenu();
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"New node"), (MenuListener)new MenuPerformer((StObject)this, "newNode")));
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Search node..."), (MenuListener)new MenuPerformer((StObject)this, "searchNode")));
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Select all nodes"), (MenuListener)new MenuPerformer((StObject)this, "selectAllNodes")));
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Remove selected nodes"), JunGrapher.$((String)"RemoveNodes"), (MenuListener)new MenuPerformer((StObject)this, "removeNodes")));
            this.graphMenu.addSeparator();
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Graph settings"), (MenuListener)new MenuPerformer((StObject)this, "inspectGraphAttributes")));
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Arrange"), (MenuListener)new MenuPerformer((StObject)this, "arrangeGrapher")));
            this.graphMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Update"), (MenuListener)new MenuPerformer((StObject)this, "updateGrapher")));
        }
        this.updateGraphMenuIndication();
        return this.graphMenu;
    }

    protected StPopupMenu nodeMenuFor_(JunElementalNode junElementalNode) {
        if (this.nodeMenu == null) {
            this.nodeMenu = new StPopupMenu();
            this.nodeMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Node settings"), (MenuListener)new MenuPerformer((StObject)this, "inspectNodeAttributes")));
            this.nodeMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Centering"), (MenuListener)new MenuPerformer((StObject)this, "centeringNode")));
            this.nodeMenu.add((StMenuItem)new StMenu((Object)JunGrapher.$String((String)"Neighbor nodes"), JunGrapher.$((String)"NeighborNodes")));
            this.nodeMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Remove"), (MenuListener)new MenuPerformer((StObject)this, "removeNode")));
            this.nodeMenu.addSeparator();
            this.nodeMenu.add((StMenuItem)new StMenu((Object)JunGrapher.$String((String)"Arc settings"), JunGrapher.$((String)"ArcSettings")));
            this.nodeMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Connect with selections"), JunGrapher.$((String)"ConnectWithSelections"), (MenuListener)new MenuPerformer((StObject)this, "connectWithSelections")));
            this.nodeMenu.add(new StMenuItem((Object)JunGrapher.$String((String)"Disconnect with selections"), JunGrapher.$((String)"DisconnectWithSelections"), (MenuListener)new MenuPerformer((StObject)this, "disconnectWithSelections")));
        }
        this.updateNodeMenuIndicationFor_(junElementalNode);
        return this.nodeMenu;
    }

    public void updateMenuIndication() {
        super.updateMenuIndication();
        this.updateGraphMenuIndication();
        this.updateNodeMenuIndication();
    }

    protected void updateGraphMenuIndication() {
        if (this.graphMenu == null) {
            return;
        }
        StMenuItem stMenuItem = this.graphMenu.atNameKey_(JunGrapher.$((String)"RemoveNodes"));
        if (stMenuItem != null) {
            if (this.selections().isEmpty()) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
    }

    protected void updateNodeMenuIndication() {
        this.updateNodeMenuIndicationFor_(null);
    }

    protected void updateNodeMenuIndicationFor_(JunElementalNode junElementalNode) {
        StMenuItem stMenuItem;
        int n;
        if (this.nodeMenu == null) {
            return;
        }
        JunElementalArc[] junElementalArcArray = this.graph().downArcsOfNode_(junElementalNode);
        JunElementalNode[] junElementalNodeArray = new JunElementalNode[junElementalArcArray.length];
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            junElementalNodeArray[i] = junElementalArcArray[i].lastNode();
        }
        JunElementalArc[] junElementalArcArray2 = this.graph().upArcsOfNode_(junElementalNode);
        JunElementalNode[] junElementalNodeArray2 = new JunElementalNode[junElementalArcArray2.length];
        for (int i = 0; i < junElementalNodeArray2.length; ++i) {
            junElementalNodeArray2[i] = junElementalArcArray2[i].firstNode();
        }
        StMenu stMenu = (StMenu)this.nodeMenu.atNameKey_(JunGrapher.$((String)"NeighborNodes"));
        if (stMenu != null) {
            stMenu.removeAll();
            if (junElementalNode == null || junElementalNodeArray.length + junElementalNodeArray2.length == 0) {
                stMenu.disable();
            } else {
                stMenu.enable();
                for (n = 0; n < junElementalNodeArray2.length; ++n) {
                    stMenu.add(new StMenuItem((Object)junElementalNodeArray2[n].labelString(), (MenuListener)new MenuPerformer((StObject)this, "selectAndScrollFor_", (Object)junElementalNodeArray2[n])));
                }
                stMenu.addSeparator();
                for (n = 0; n < junElementalNodeArray.length; ++n) {
                    stMenu.add(new StMenuItem((Object)junElementalNodeArray[n].labelString(), (MenuListener)new MenuPerformer((StObject)this, "selectAndScrollFor_", (Object)junElementalNodeArray[n])));
                }
            }
        }
        if ((stMenu = (StMenu)this.nodeMenu.atNameKey_(JunGrapher.$((String)"ArcSettings"))) != null) {
            stMenu.removeAll();
            if (junElementalNode == null || junElementalArcArray.length + junElementalArcArray2.length == 0) {
                stMenu.disable();
            } else {
                stMenu.enable();
                for (n = 0; n < junElementalArcArray2.length; ++n) {
                    stMenu.add(new StMenuItem((Object)("<- " + junElementalArcArray2[n].firstNode().labelString()), (MenuListener)new MenuPerformer((StObject)this, "inspectArcAttributes_", (Object)junElementalArcArray2[n])));
                }
                stMenu.addSeparator();
                for (n = 0; n < junElementalArcArray.length; ++n) {
                    stMenu.add(new StMenuItem((Object)("-> " + junElementalArcArray[n].lastNode().labelString()), (MenuListener)new MenuPerformer((StObject)this, "inspectArcAttributes_", (Object)junElementalArcArray[n])));
                }
            }
        }
        if ((stMenuItem = this.nodeMenu.atNameKey_(JunGrapher.$((String)"ConnectWithSelections"))) != null) {
            if (this.selections().isEmpty()) {
                stMenuItem.disable();
            } else if (this.selections().size() == 1 && this.selection() == junElementalNode) {
                stMenuItem.disable();
            } else if (this.hasAllConnections_with_(junElementalNode, this.selections())) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
        if ((stMenuItem = this.nodeMenu.atNameKey_(JunGrapher.$((String)"DisconnectWithSelections"))) != null) {
            if (this.selections().isEmpty()) {
                stMenuItem.disable();
            } else if (this.selections().size() == 1 && this.selection() == junElementalNode) {
                stMenuItem.disable();
            } else if (!this.hasConnections_with_(junElementalNode, this.selections())) {
                stMenuItem.disable();
            } else {
                stMenuItem.enable();
            }
        }
    }

    public void arrangeGrapher() {
        this.graph().arrange();
        this.fitViewpoint();
        this.nodeSettingsFor_((JunElementalNode)this.nodeSettings().stuff());
    }

    public void centeringNode() {
        JunElementalNode junElementalNode = this.whichAt_(this._popupMenuPoint);
        if (junElementalNode == null) {
            return;
        }
        this.selectAndArrangeAndScrollFor_(junElementalNode);
    }

    public void connectWithSelections() {
        JunElementalNode junElementalNode = this.whichAt_(this._popupMenuPoint);
        if (junElementalNode == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.selections());
        if (arrayList.contains((Object)junElementalNode)) {
            arrayList.remove((Object)junElementalNode);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JunElementalNode junElementalNode2 = (JunElementalNode)((Object)arrayList.get(i));
            this.graph().connect_with_(junElementalNode, junElementalNode2);
        }
        this.updateGrapher();
    }

    public void disconnectWithSelections() {
        JunElementalNode junElementalNode = this.whichAt_(this._popupMenuPoint);
        if (junElementalNode == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.selections());
        if (arrayList.contains((Object)junElementalNode)) {
            arrayList.remove((Object)junElementalNode);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            JunElementalNode junElementalNode2 = (JunElementalNode)((Object)arrayList.get(i));
            this.graph().disconnect_with_(junElementalNode, junElementalNode2);
        }
        this.updateGrapher();
    }

    public void freehandConnect_with_(JunElementalNode junElementalNode, JunElementalNode junElementalNode2) {
        if (junElementalNode != null && junElementalNode2 != null) {
            this.graph().connect_with_(junElementalNode, junElementalNode2);
            this.updateGrapher();
        } else {
            this.changed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freehandPoints_(Point[] pointArray, MouseEvent mouseEvent) {
        int n;
        JunElementalNode[] junElementalNodeArray;
        Object object;
        if (pointArray == null || pointArray.length == 0) {
            this.changed();
            return;
        }
        Jun2dBoundingBoxes jun2dBoundingBoxes = Jun2dBoundingBoxes.FromPolyline_bitSize_(pointArray, new Dimension(32, 32));
        Rectangle[] rectangleArray = jun2dBoundingBoxes.asRectangles();
        if (mouseEvent.isControlDown()) {
            object = (JunGrapherView)this.getView();
            junElementalNodeArray = object.scrollAmount();
            Graphics2D graphics2D = null;
            try {
                graphics2D = (Graphics2D)object.toComponent().getGraphics();
                graphics2D.setColor(Color.orange);
                graphics2D.setStroke(new BasicStroke(1.0f));
                for (n = 0; n < rectangleArray.length; ++n) {
                    int n2 = rectangleArray[n].x + junElementalNodeArray.x;
                    int n3 = rectangleArray[n].y + junElementalNodeArray.y;
                    int n4 = rectangleArray[n].width;
                    int n5 = rectangleArray[n].height;
                    graphics2D.drawRect(n2, n3, n4, n5);
                }
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                if (graphics2D != null) {
                    graphics2D.dispose();
                }
            }
        }
        object = new HashSet();
        junElementalNodeArray = this.graph().nodes();
        block6: for (int i = 0; i < junElementalNodeArray.length; ++i) {
            for (n = 0; n < rectangleArray.length; ++n) {
                if (!rectangleArray[n].intersects(junElementalNodeArray[i].bounds())) continue;
                ((HashSet)object).add(junElementalNodeArray[i]);
                continue block6;
            }
        }
        Jun2dBoundingBox jun2dBoundingBox = jun2dBoundingBoxes.boundingBox();
        if (((HashSet)object).isEmpty() && jun2dBoundingBox.area() >= 64.0) {
            this.newNodeAt_(jun2dBoundingBox.center()._toPoint());
        } else {
            this.changed();
            if (mouseEvent.isShiftDown()) {
                ((AbstractCollection)object).addAll(this.selections());
            }
            this.selections_((Collection)object);
        }
    }

    public void inspectArcAttributes_(JunElementalArc junElementalArc) {
        if (junElementalArc == null) {
            return;
        }
        JunElementalArcSettings junElementalArcSettings = this.arcSettingsFor_(junElementalArc);
        junElementalArcSettings._show();
        junElementalArcSettings.updateWindowTitle();
    }

    public void inspectGraphAttributes() {
        JunElementalGraph junElementalGraph = this.graph();
        if (junElementalGraph == null) {
            return;
        }
        JunElementalGraphSettings junElementalGraphSettings = this.graphSettingsFor_(junElementalGraph);
        junElementalGraphSettings._show();
        junElementalGraphSettings.updateWindowTitle();
    }

    public void inspectNodeAttributes() {
        JunElementalNode junElementalNode = this.whichAt_(this._popupMenuPoint);
        if (junElementalNode == null) {
            return;
        }
        JunElementalNodeSettings junElementalNodeSettings = this.nodeSettingsFor_(junElementalNode);
        junElementalNodeSettings._show();
        junElementalNodeSettings.updateWindowTitle();
    }

    public void newNode() {
        Point point = this._popupMenuPoint;
        if (point == null) {
            point = new Point(0, 0);
        }
        this.newNodeAt_(point);
    }

    public void newNodeAt_(Point point) {
        String string = JunGrapher.$String((String)"Untitled");
        JunElementalNode junElementalNode = this.defaultNode(string);
        junElementalNode.center_(point);
        this.graph().add_(junElementalNode);
        this.changed();
    }

    public void removeNode() {
        JunElementalNode junElementalNode = this.whichAt_(this._popupMenuPoint);
        if (junElementalNode == null) {
            return;
        }
        if (!JunDialog.Confirm_(JunGrapher.$String((String)"Really remove '<1p>'?", null, (Object)junElementalNode.labelString()))) {
            return;
        }
        this.graph().remove_(junElementalNode);
        this.graph().flushCachedAll();
        this.changed_(JunGrapher.$((String)"graph"));
    }

    public void removeNodes() {
        if (this.selections().isEmpty()) {
            return;
        }
        if (!JunDialog.Confirm_(JunGrapher.$String((String)"Really remove?"))) {
            return;
        }
        JunElementalNode[] junElementalNodeArray = this.selections().toArray(new JunElementalNode[this.selections().size()]);
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            this.graph().remove_(junElementalNodeArray[i]);
        }
        this.graph().flushCachedAll();
        this.changed_(JunGrapher.$((String)"graph"));
    }

    public void searchNode() {
        String string = JunDialog.Request_(JunGrapher.$String((String)"Input wild card to search."), "*");
        if (string == null || string.length() == 0) {
            return;
        }
        ArrayList<JunElementalNode> arrayList = new ArrayList<JunElementalNode>();
        JunElementalNode[] junElementalNodeArray = this.graph().nodes();
        for (int i = 0; i < junElementalNodeArray.length; ++i) {
            if (!JunStringUtility.StringMatch_and_(junElementalNodeArray[i].labelString(), string)) continue;
            arrayList.add(junElementalNodeArray[i]);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        JunElementalNode[] junElementalNodeArray2 = arrayList.toArray(new JunElementalNode[arrayList.size()]);
        String[] stringArray = new String[junElementalNodeArray2.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = junElementalNodeArray2[i].labelString();
        }
        JunElementalNode junElementalNode = (JunElementalNode)((Object)JunDialog.Choose_(JunGrapher.$String((String)"Choose one."), stringArray, (Object[])junElementalNodeArray2, 10, new StBlockClosure()));
        if (junElementalNode == null) {
            return;
        }
        this.selectAndScrollFor_(junElementalNode);
    }

    public void selectAllNodes() {
        this.selections_(Arrays.asList(this.graph().nodes()));
        this.changed();
    }

    public void displayOn_(Graphics graphics) {
        this.displayOn_at_(graphics, new Point(0, 0));
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.graph().displayOn_at_(graphics, point);
    }

    public void displayOn_at_scaledBy_(Graphics graphics, Point point, Jun2dPoint jun2dPoint) {
        this.graph().displayOn_at_scaledBy_(graphics, point, jun2dPoint);
    }

    public void redisplay() {
        JunGrapherView junGrapherView = (JunGrapherView)this.getView();
        if (junGrapherView != null) {
            junGrapherView.redisplay();
        }
    }

    public StRectangle viewBounds() {
        StView stView = this.getView();
        if (stView == null) {
            return new StRectangle(0, 0, 0, 0);
        }
        return new StRectangle(stView.toComponent().getBounds());
    }

    protected void fitViewpoint() {
        if (this.selection() == null) {
            StRectangle stRectangle = this.viewBounds();
            if (this.isConcentricArrangement()) {
                this.scrollTo_(stRectangle.center());
            } else if (this.isHierarchicalArrangement()) {
                Point point = stRectangle.leftCenter();
                Point point2 = this.boundingBox().leftCenter();
                this.scrollTo_(new Point(point.x - point2.x, point.y - point2.y));
            } else {
                Point point = stRectangle.center();
                Point point3 = this.boundingBox().center();
                this.scrollTo_(new Point(point.x - point3.x, point.y - point3.y));
            }
        } else {
            this.scrollFor_(this.selection());
        }
    }

    public Point scrollAmount() {
        JunGrapherView junGrapherView = (JunGrapherView)this.getView();
        if (junGrapherView == null) {
            return new Point(0, 0);
        }
        return junGrapherView.scrollAmount();
    }

    public void scrollTo_(Point point) {
        JunGrapherView junGrapherView = (JunGrapherView)this.getView();
        if (junGrapherView == null) {
            return;
        }
        junGrapherView.scrollTo_(point);
        this.focusBoundingBox_(null);
        this.focusBoundingBox();
    }

    public void scrollFor_(JunElementalNode junElementalNode) {
        JunGrapherView junGrapherView = (JunGrapherView)this.getView();
        if (junGrapherView == null) {
            return;
        }
        junGrapherView.scrollFor_(junElementalNode);
        this.focusBoundingBox_(null);
        this.focusBoundingBox();
    }

    public void selectAndArrangeAndScrollFor_(JunElementalNode junElementalNode) {
        this.selection_(junElementalNode);
        this.arrangeAndScrollFor_(junElementalNode);
    }

    public void selectAndScrollFor_(JunElementalNode junElementalNode) {
        this.selection_(junElementalNode);
        this.scrollFor_(junElementalNode);
    }

    public void arrangeAndScrollFor_(JunElementalNode junElementalNode) {
        if (junElementalNode == null) {
            this.arrangeGrapher();
        } else {
            this.graph().arrangeWithAnimation_(this);
            this.scrollFor_(junElementalNode);
            this.nodeSettingsFor_((JunElementalNode)this.nodeSettings().stuff());
        }
    }

    public Collection selections() {
        return this.graph().selections();
    }

    public void selections_(Collection collection) {
        ArrayList arrayList = new ArrayList(this.selections());
        this.graph().selections_(collection);
        this.changed_with_(JunGrapher.$((String)"selections"), arrayList);
        this.selectedNodesHolder().value_((Object)collection);
    }

    public JunElementalNode selection() {
        return this.graph().selection();
    }

    public void selection_(JunElementalNode junElementalNode) {
        ArrayList<JunElementalNode> arrayList = new ArrayList<JunElementalNode>();
        arrayList.add(junElementalNode);
        this.selections_(arrayList);
    }

    public Color selectionBorderColor() {
        return this.graph().selectionBorderColor();
    }

    public int selectionBorderWidth() {
        return this.graph().selectionBorderWidth();
    }

    public JunElementalNode whichAt_(Point point) {
        return this.graph().whichAt_(point);
    }

    protected StValueHolder selectedNodesHolder() {
        if (this.selectedNodesHolder == null) {
            this.selectedNodesHolder = new StValueHolder((Object)this.selections());
        }
        return this.selectedNodesHolder;
    }

    public void updateGrapher() {
        this.flushAll();
        this.changed_(JunGrapher.$((String)"graph"));
        this.graphSettingsFor_((JunElementalGraph)this.graphSettings().stuff());
        this.nodeSettingsFor_((JunElementalNode)this.nodeSettings().stuff());
        this.arcSettingsFor_((JunElementalArc)this.arcSettings().stuff());
    }
}

