/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.voronoi.twoD.diagram.JunDelaunay2dDiagram;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dProcessor;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StRectangle;

public class JunVoronoi2dDiagram
implements StDisplayable {
    protected Dimension diagramExtent;
    protected ArrayList diagramPoints;
    protected StImage diagramImage;
    protected JunVoronoi2dProcessor voronoiProcessor;
    protected boolean processingCondition;

    public JunVoronoi2dDiagram(int n, int n2) {
        this.initialize();
        this.extent_(n, n2);
    }

    public JunVoronoi2dDiagram(Dimension dimension) {
        this(dimension.width, dimension.height);
    }

    protected void initialize() {
        this.diagramExtent = new Dimension(100, 100);
        this.diagramPoints = new ArrayList();
        this.diagramImage = null;
        this.voronoiProcessor = null;
        this.processingCondition = true;
    }

    public Dimension extent() {
        return this.diagramExtent;
    }

    public void extent_(int n, int n2) {
        this.diagramExtent = new Dimension(Math.max(n, 1), Math.max(n2, 1));
        this.flushImage();
    }

    public int width() {
        return this.extent().width;
    }

    public int height() {
        return this.extent().height;
    }

    public Jun2dPoint[] points() {
        double d = (double)(this.width() + 1) / (double)this.width();
        double d2 = (double)(this.height() + 1) / (double)this.height();
        Jun2dPoint jun2dPoint = new Jun2dPoint(d, d2);
        Jun2dPoint[] jun2dPointArray = this.diagramPoints.toArray(new Jun2dPoint[this.diagramPoints.size()]);
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = jun2dPointArray[i].scaledBy_(jun2dPoint);
        }
        return jun2dPointArray;
    }

    public StImage diagram() {
        if (this.diagramImage == null) {
            this.diagramImage = this.makeImage();
        }
        return this.diagramImage;
    }

    public JunVoronoi2dProcessor processor() {
        this.diagram();
        return this.voronoiProcessor;
    }

    public boolean condition() {
        return this.processingCondition;
    }

    public double area() {
        if (!this.condition()) {
            return 0.0;
        }
        return this.processor().area();
    }

    public Rectangle bounds() {
        return this.preferredBounds();
    }

    public Rectangle preferredBounds() {
        return new Rectangle(0, 0, this.width(), this.height());
    }

    public void add_(Jun2dPoint jun2dPoint) {
        if (!this.condition()) {
            return;
        }
        double d = (double)this.width() / (double)(this.width() + 1);
        double d2 = (double)this.height() / (double)(this.height() + 1);
        Jun2dPoint jun2dPoint2 = new Jun2dPoint(d, d2);
        Jun2dPoint jun2dPoint3 = jun2dPoint.scaledBy_(jun2dPoint2);
        Jun2dBoundingBox jun2dBoundingBox = new Jun2dBoundingBox(this.bounds());
        if (jun2dBoundingBox.containsPoint_(jun2dPoint3) && !this.diagramPoints.contains((Object)jun2dPoint3)) {
            this.diagramPoints.add(jun2dPoint3);
            this.flushImage();
        }
    }

    public void addAll_(Jun2dPoint[] jun2dPointArray) {
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            this.add_(jun2dPointArray[i]);
        }
    }

    public StImage asImage() {
        return this.diagram();
    }

    public JunVoronoi2dDiagram asVoronoiDiagram() {
        return this;
    }

    public JunDelaunay2dDiagram asDelaunayDiagram() {
        JunDelaunay2dDiagram junDelaunay2dDiagram = new JunDelaunay2dDiagram(this.extent());
        junDelaunay2dDiagram.addAll_(this.points());
        return junDelaunay2dDiagram;
    }

    public void displayOn_(Graphics graphics) {
        this.asImage().displayOn_(graphics);
    }

    public void displayOn_at_(Graphics graphics, Point point) {
        this.asImage().displayOn_at_(graphics, point);
    }

    public void show() {
        JunDisplayModel.OpenVisual_label_(this, this.labelString());
    }

    protected String labelString() {
        return "Voronoi Diagram";
    }

    protected void flushImage() {
        this.diagramImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StImage makeImage() {
        this.voronoiProcessor = new JunVoronoi2dProcessor(this.points());
        this.processingCondition = this.voronoiProcessor.compute();
        StImage stImage = new StImage(this.extent());
        Graphics2D graphics2D = null;
        try {
            graphics2D = (Graphics2D)stImage.image().getGraphics();
            graphics2D.setBackground(Color.white);
            Rectangle rectangle = this.bounds();
            double d = (double)rectangle.width / (double)(rectangle.width + 1);
            double d2 = (double)rectangle.height / (double)(rectangle.height + 1);
            Jun2dPoint jun2dPoint = new Jun2dPoint(d, d2);
            graphics2D.setColor(this.borderColor());
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics2D.setColor(this.dotColor());
            Jun2dPoint[] jun2dPointArray = this.voronoiProcessor.dots();
            for (int i = 0; i < jun2dPointArray.length; ++i) {
                StRectangle stRectangle = new StRectangle(jun2dPointArray[i].scaledBy_(jun2dPoint)._toPoint(), new Dimension(1, 1));
                stRectangle = stRectangle.expandedBy_(new StRectangle(1, 1, 1, 1));
                this.voronoiProcessor.displayBoxOn_box_clip_(graphics2D, stRectangle, rectangle);
            }
            graphics2D.setColor(this.sideColor());
            Jun2dPoint[][] jun2dPointArray2 = this.voronoiProcessor.sides();
            for (int i = 0; i < jun2dPointArray2.length; ++i) {
                Point point = jun2dPointArray2[i][0].scaledBy_(jun2dPoint)._toPoint();
                Point point2 = jun2dPointArray2[i][1].scaledBy_(jun2dPoint)._toPoint();
                this.voronoiProcessor.displayLineOn_from_to_clip_(graphics2D, point, point2, rectangle);
            }
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
        return stImage;
    }

    protected Color borderColor() {
        return Color.green;
    }

    protected Color sideColor() {
        return Color.red;
    }

    protected Color dotColor() {
        return Color.blue;
    }
}

