/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dLine;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide;
import jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dTriangle;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;

public class JunVoronoi2dProcessor
extends JunVoronoi2dObject {
    protected JunVoronoi2dDot[] originalDots;
    protected JunVoronoi2dDot[] normalizedDots;
    protected JunVoronoi2dDot translationDelta;
    protected JunVoronoi2dDot scalingFactor;
    protected ArrayList voronoiDots;
    protected ArrayList voronoiPoints;
    protected ArrayList voronoiSides;
    protected double processingPrecision;
    protected boolean traceBoolean;
    private JPanel _traceCanvas;

    public JunVoronoi2dProcessor(Jun2dPoint[] jun2dPointArray) {
        this.dots_(jun2dPointArray);
    }

    protected void initialize() {
        super.initialize();
        this.originalDots = null;
        this.normalizedDots = null;
        this.translationDelta = null;
        this.scalingFactor = null;
        this.voronoiDots = null;
        this.voronoiPoints = null;
        this.voronoiSides = null;
        this.processingPrecision = this.accuracy();
        this.traceBoolean = false;
    }

    protected synchronized void initializeVoronoiDiagram() {
        JunVoronoi2dDot junVoronoi2dDot = new JunVoronoi2dDot(this.bigSize() * -1.0, this.bigSize() * -1.0);
        JunVoronoi2dDot junVoronoi2dDot2 = new JunVoronoi2dDot(10.0, this.bigSize());
        JunVoronoi2dDot junVoronoi2dDot3 = new JunVoronoi2dDot(this.bigSize(), this.bigSize() * -1.0);
        JunVoronoi2dPoint junVoronoi2dPoint = new JunVoronoi2dPoint((junVoronoi2dDot.x() + junVoronoi2dDot2.x()) * 0.5, (junVoronoi2dDot.y() + junVoronoi2dDot2.y()) * 0.5);
        JunVoronoi2dPoint junVoronoi2dPoint2 = new JunVoronoi2dPoint((junVoronoi2dDot2.x() + junVoronoi2dDot3.x()) * 0.5, (junVoronoi2dDot2.y() + junVoronoi2dDot3.y()) * 0.5);
        JunVoronoi2dPoint junVoronoi2dPoint3 = new JunVoronoi2dPoint((junVoronoi2dDot3.x() + junVoronoi2dDot.x()) * 0.5, (junVoronoi2dDot3.y() + junVoronoi2dDot.y()) * 0.5);
        JunVoronoi2dLine junVoronoi2dLine = junVoronoi2dDot.bisector_(junVoronoi2dDot2);
        JunVoronoi2dLine junVoronoi2dLine2 = junVoronoi2dDot2.bisector_(junVoronoi2dDot3);
        JunVoronoi2dPoint junVoronoi2dPoint4 = junVoronoi2dLine.intersectingPointWithLine_(junVoronoi2dLine2);
        junVoronoi2dPoint = new JunVoronoi2dLine(junVoronoi2dPoint, junVoronoi2dPoint4).pointAtX_(this.bigNumber() * -1.0);
        junVoronoi2dPoint2 = new JunVoronoi2dLine(junVoronoi2dPoint2, junVoronoi2dPoint4).pointAtX_(this.bigNumber());
        junVoronoi2dPoint3 = new JunVoronoi2dLine(junVoronoi2dPoint3, junVoronoi2dPoint4).pointAtY_(this.bigNumber() * -1.0);
        JunVoronoi2dSide junVoronoi2dSide = new JunVoronoi2dSide(junVoronoi2dPoint, junVoronoi2dPoint4);
        junVoronoi2dSide.dot1_(junVoronoi2dDot);
        junVoronoi2dSide.dot2_(junVoronoi2dDot2);
        JunVoronoi2dSide junVoronoi2dSide2 = new JunVoronoi2dSide(junVoronoi2dPoint2, junVoronoi2dPoint4);
        junVoronoi2dSide2.dot1_(junVoronoi2dDot2);
        junVoronoi2dSide2.dot2_(junVoronoi2dDot3);
        JunVoronoi2dSide junVoronoi2dSide3 = new JunVoronoi2dSide(junVoronoi2dPoint3, junVoronoi2dPoint4);
        junVoronoi2dSide3.dot1_(junVoronoi2dDot3);
        junVoronoi2dSide3.dot2_(junVoronoi2dDot);
        junVoronoi2dPoint.side1_(junVoronoi2dSide);
        junVoronoi2dPoint2.side1_(junVoronoi2dSide2);
        junVoronoi2dPoint3.side1_(junVoronoi2dSide3);
        junVoronoi2dPoint4.side1_(junVoronoi2dSide);
        junVoronoi2dPoint4.side2_(junVoronoi2dSide2);
        junVoronoi2dPoint4.side3_(junVoronoi2dSide3);
        this.voronoiDots = new ArrayList();
        this.voronoiDots.add(junVoronoi2dDot);
        this.voronoiDots.add(junVoronoi2dDot2);
        this.voronoiDots.add(junVoronoi2dDot3);
        this.voronoiPoints = new ArrayList();
        this.voronoiPoints.add(junVoronoi2dPoint);
        this.voronoiPoints.add(junVoronoi2dPoint2);
        this.voronoiPoints.add(junVoronoi2dPoint3);
        this.voronoiPoints.add(junVoronoi2dPoint4);
        this.voronoiSides = new ArrayList();
        this.voronoiSides.add(junVoronoi2dSide);
        this.voronoiSides.add(junVoronoi2dSide2);
        this.voronoiSides.add(junVoronoi2dSide3);
    }

    protected synchronized void finalizeVoronoiDiagram() {
        JunVoronoi2dObject junVoronoi2dObject;
        int n;
        ArrayList<JunVoronoi2dObject> arrayList = new ArrayList<JunVoronoi2dObject>();
        for (n = 0; n < this.voronoiPoints.size(); ++n) {
            junVoronoi2dObject = (JunVoronoi2dPoint)((Object)this.voronoiPoints.get(n));
            if (!((JunVoronoi2dPoint)junVoronoi2dObject).isInvalid() || this.startIndex() > n) continue;
            arrayList.add(junVoronoi2dObject);
        }
        this.voronoiPoints.removeAll(arrayList);
        arrayList = new ArrayList();
        for (n = 0; n < this.voronoiSides.size(); ++n) {
            junVoronoi2dObject = (JunVoronoi2dSide)((Object)this.voronoiSides.get(n));
            if (!((JunVoronoi2dSide)junVoronoi2dObject).isInvalid() || this.startIndex() > n) continue;
            arrayList.add(junVoronoi2dObject);
        }
        this.voronoiSides.removeAll(arrayList);
    }

    public Jun2dPoint[] dots() {
        if (this.normalizedDots == null) {
            return new Jun2dPoint[0];
        }
        Jun2dPoint[] jun2dPointArray = new Jun2dPoint[this.normalizedDots.length];
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            jun2dPointArray[i] = this.restoreDot_(this.normalizedDots[i]);
        }
        return jun2dPointArray;
    }

    public void dots_(Jun2dPoint[] jun2dPointArray) {
        ArrayList<JunVoronoi2dDot> arrayList = new ArrayList<JunVoronoi2dDot>();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            JunVoronoi2dDot junVoronoi2dDot = null;
            for (int j = 0; j < arrayList.size(); ++j) {
                JunVoronoi2dDot junVoronoi2dDot2 = (JunVoronoi2dDot)((Object)arrayList.get(j));
                if (!(Math.abs(junVoronoi2dDot2.x() - jun2dPointArray[i].x()) < this.accuracy()) || !(Math.abs(junVoronoi2dDot2.y() - jun2dPointArray[i].y()) < this.accuracy())) continue;
                junVoronoi2dDot = junVoronoi2dDot2;
                break;
            }
            if (junVoronoi2dDot != null) continue;
            arrayList.add(new JunVoronoi2dDot(jun2dPointArray[i].x(), jun2dPointArray[i].y()));
        }
        if (arrayList.isEmpty()) {
            return;
        }
        this.originalDots = arrayList.toArray(new JunVoronoi2dDot[arrayList.size()]);
        this.normalizedDots = this.normalizedDots_(this.originalDots);
    }

    public Jun2dPoint[] points() {
        if (this.voronoiPoints == null) {
            return new Jun2dPoint[0];
        }
        ArrayList<Jun2dPoint> arrayList = new ArrayList<Jun2dPoint>();
        for (int i = this.startIndex(); i < this.voronoiPoints.size(); ++i) {
            JunVoronoi2dPoint junVoronoi2dPoint = (JunVoronoi2dPoint)((Object)this.voronoiPoints.get(i));
            arrayList.add(this.restorePoint_(junVoronoi2dPoint));
        }
        return arrayList.toArray(new Jun2dPoint[arrayList.size()]);
    }

    public Jun2dPoint[][] sides() {
        if (this.voronoiSides == null) {
            return new Jun2dPoint[0][2];
        }
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        for (int i = this.startIndex(); i < this.voronoiSides.size(); ++i) {
            JunVoronoi2dSide junVoronoi2dSide = (JunVoronoi2dSide)((Object)this.voronoiSides.get(i));
            arrayList.add(this.restoreSide_(junVoronoi2dSide));
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][2]);
    }

    public Jun2dPoint[][] triangles() {
        if (this.voronoiPoints == null) {
            return new Jun2dPoint[0][3];
        }
        ArrayList<Jun2dPoint[]> arrayList = new ArrayList<Jun2dPoint[]>();
        for (int i = this.startIndex(); i < this.voronoiPoints.size(); ++i) {
            JunVoronoi2dPoint junVoronoi2dPoint = (JunVoronoi2dPoint)((Object)this.voronoiPoints.get(i));
            int[] nArray = this.triangleIndexesAtPoint_(junVoronoi2dPoint);
            if (nArray == null) continue;
            JunVoronoi2dDot junVoronoi2dDot = this.originalDots[nArray[0]];
            JunVoronoi2dDot junVoronoi2dDot2 = this.originalDots[nArray[1]];
            JunVoronoi2dDot junVoronoi2dDot3 = this.originalDots[nArray[2]];
            Jun2dPoint jun2dPoint = new Jun2dPoint(junVoronoi2dDot.x(), junVoronoi2dDot.y());
            Jun2dPoint jun2dPoint2 = new Jun2dPoint(junVoronoi2dDot2.x(), junVoronoi2dDot2.y());
            Jun2dPoint jun2dPoint3 = new Jun2dPoint(junVoronoi2dDot3.x(), junVoronoi2dDot3.y());
            arrayList.add(new Jun2dPoint[]{jun2dPoint, jun2dPoint2, jun2dPoint3});
        }
        return (Jun2dPoint[][])arrayList.toArray((T[])new Jun2dPoint[arrayList.size()][3]);
    }

    public double area() {
        double d = 0.0;
        Jun2dPoint[][] jun2dPointArray = this.triangles();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            JunVoronoi2dTriangle junVoronoi2dTriangle = new JunVoronoi2dTriangle(jun2dPointArray[i][0], jun2dPointArray[i][1], jun2dPointArray[i][2]);
            d += junVoronoi2dTriangle.area();
        }
        return d;
    }

    public StSymbol precision() {
        if (this.processingPrecision > this.accuracy() * 10.0) {
            return JunVoronoi2dProcessor.$((String)"lowPrecision");
        }
        return JunVoronoi2dProcessor.$((String)"highPrecision");
    }

    protected double processingPrecision() {
        return this.processingPrecision;
    }

    protected int startIndex() {
        return 3;
    }

    protected Jun2dPoint restoreDot_(JunVoronoi2dDot junVoronoi2dDot) {
        double d = junVoronoi2dDot.x() * this.scalingFactor.x() + this.translationDelta.x();
        double d2 = junVoronoi2dDot.y() * this.scalingFactor.y() + this.translationDelta.y();
        return new Jun2dPoint(d, d2);
    }

    protected Jun2dPoint restorePoint_(JunVoronoi2dPoint junVoronoi2dPoint) {
        double d = junVoronoi2dPoint.x() * this.scalingFactor.x() + this.translationDelta.x();
        double d2 = junVoronoi2dPoint.y() * this.scalingFactor.y() + this.translationDelta.y();
        return new Jun2dPoint(d, d2);
    }

    protected Jun2dPoint[] restoreSide_(JunVoronoi2dSide junVoronoi2dSide) {
        Jun2dPoint jun2dPoint = this.restorePoint_(junVoronoi2dSide.from());
        Jun2dPoint jun2dPoint2 = this.restorePoint_(junVoronoi2dSide.to());
        return new Jun2dPoint[]{jun2dPoint, jun2dPoint2};
    }

    protected int[] triangleIndexesAtPoint_(JunVoronoi2dPoint junVoronoi2dPoint) {
        JunVoronoi2dDot[] junVoronoi2dDotArray = this.dotsAtPoint_(junVoronoi2dPoint);
        int n = this.voronoiDots.indexOf((Object)junVoronoi2dDotArray[0]);
        int n2 = this.voronoiDots.indexOf((Object)junVoronoi2dDotArray[1]);
        int n3 = this.voronoiDots.indexOf((Object)junVoronoi2dDotArray[2]);
        if (n < this.startIndex()) {
            return null;
        }
        if (n2 < this.startIndex()) {
            return null;
        }
        if (n3 < this.startIndex()) {
            return null;
        }
        return new int[]{n - this.startIndex(), n2 - this.startIndex(), n3 - this.startIndex()};
    }

    protected JunVoronoi2dDot[] dotsAtPoint_(JunVoronoi2dPoint junVoronoi2dPoint) {
        JunVoronoi2dSide junVoronoi2dSide = junVoronoi2dPoint.side1();
        JunVoronoi2dSide junVoronoi2dSide2 = junVoronoi2dPoint.side2();
        JunVoronoi2dSide junVoronoi2dSide3 = junVoronoi2dPoint.side3();
        int[] nArray = new int[]{this.voronoiDots.indexOf((Object)junVoronoi2dSide.dot1()), this.voronoiDots.indexOf((Object)junVoronoi2dSide.dot2()), this.voronoiDots.indexOf((Object)junVoronoi2dSide2.dot1()), this.voronoiDots.indexOf((Object)junVoronoi2dSide2.dot2()), this.voronoiDots.indexOf((Object)junVoronoi2dSide3.dot1()), this.voronoiDots.indexOf((Object)junVoronoi2dSide3.dot2())};
        Arrays.sort(nArray);
        if (nArray[0] != nArray[1]) {
            throw SmalltalkException.Error((String)"unexpected error.");
        }
        if (nArray[2] != nArray[3]) {
            throw SmalltalkException.Error((String)"unexpected error.");
        }
        if (nArray[4] != nArray[5]) {
            throw SmalltalkException.Error((String)"unexpected error.");
        }
        return new JunVoronoi2dDot[]{(JunVoronoi2dDot)((Object)this.voronoiDots.get(nArray[0])), (JunVoronoi2dDot)((Object)this.voronoiDots.get(nArray[2])), (JunVoronoi2dDot)((Object)this.voronoiDots.get(nArray[4]))};
    }

    public boolean compute() {
        boolean bl = this.computeFirst();
        if (!bl) {
            bl = this.computeSecond();
        }
        return bl;
    }

    protected boolean computeFirst() {
        if (this.normalizedDots == null) {
            return true;
        }
        this.initializeVoronoiDiagram();
        if (this.trace() && this._traceCanvas == null) {
            this._traceCanvas = new JPanel(){

                public void paint(Graphics graphics) {
                    JunVoronoi2dProcessor.this.traceDisplayOn_(graphics);
                }
            };
            this._traceCanvas.setPreferredSize(new Dimension(400, 400));
            JFrame jFrame = new JFrame();
            jFrame.setTitle("JunVoronoi2dProcessor");
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getWindow().dispose();
                    JunVoronoi2dProcessor.this._traceCanvas = null;
                }
            });
            jFrame.getContentPane().add(this._traceCanvas);
            jFrame.pack();
            StApplicationModel._ShowAtMousePoint((Window)jFrame);
        }
        boolean bl = true;
        for (int i = 0; bl && i < this.normalizedDots.length; ++i) {
            JunVoronoi2dDot junVoronoi2dDot = this.normalizedDots[i];
            bl = this.insertDot_(junVoronoi2dDot);
            if (this._traceCanvas == null) continue;
            this._traceCanvas.paintImmediately(this._traceCanvas.getBounds());
        }
        this.finalizeVoronoiDiagram();
        return bl;
    }

    protected boolean computeSecond() {
        int n;
        this.processingPrecision = Math.pow(10.0, Math.round(Math.log(this.accuracy()) / Math.log(10.0) / 2.0));
        for (n = 0; n < this.normalizedDots.length; ++n) {
            JunVoronoi2dDot junVoronoi2dDot = this.normalizedDots[n];
            double d = Math.random() - 0.5;
            double d2 = Math.max(0.0, Math.min(junVoronoi2dDot.x() + d * this.processingPrecision, 1.0));
            double d3 = Math.max(0.0, Math.min(junVoronoi2dDot.y() + d * this.processingPrecision, 1.0));
            junVoronoi2dDot.x_(d2);
            junVoronoi2dDot.y_(d3);
        }
        n = this.computeFirst() ? 1 : 0;
        if (n == 0) {
            throw SmalltalkException.Error((String)"Error: infinite loop, because all points on a lattice, or no intersecintgpoint, or too many intersecting points.");
        }
        return n != 0;
    }

    protected boolean insertDot_(JunVoronoi2dDot junVoronoi2dDot) {
        int n;
        JunVoronoi2dObject junVoronoi2dObject;
        JunVoronoi2dObject junVoronoi2dObject2;
        Object object;
        Object[] objectArray;
        int n2;
        ArrayList<JunVoronoi2dObject> arrayList = new ArrayList<JunVoronoi2dObject>();
        ArrayList<JunVoronoi2dSide> arrayList2 = new ArrayList<JunVoronoi2dSide>();
        HashSet<JunVoronoi2dPoint> hashSet = new HashSet<JunVoronoi2dPoint>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>();
        JunVoronoi2dDot junVoronoi2dDot2 = this.nearestDot_(junVoronoi2dDot);
        JunVoronoi2dSide junVoronoi2dSide = this.bisectorSideBetween_and_(junVoronoi2dDot2, junVoronoi2dDot);
        JunVoronoi2dSide[] junVoronoi2dSideArray = this.searchSides_(junVoronoi2dDot2);
        for (n2 = 0; n2 < junVoronoi2dSideArray.length; ++n2) {
            objectArray = junVoronoi2dSideArray[n2];
            if (hashSet2.contains(objectArray)) continue;
            object = null;
            hashSet2.add(objectArray);
            junVoronoi2dObject2 = objectArray.intersectingPointWithSide_(junVoronoi2dSide);
            if (junVoronoi2dObject2 == null) continue;
            junVoronoi2dObject = junVoronoi2dObject2;
            JunVoronoi2dPoint junVoronoi2dPoint = this.removingPoint_with_with_with_((JunVoronoi2dPoint)junVoronoi2dObject2, junVoronoi2dSide.from(), junVoronoi2dDot, (JunVoronoi2dSide)objectArray);
            hashSet.add(junVoronoi2dPoint);
            JunVoronoi2dDot junVoronoi2dDot3 = this.nearerDot_except_in_(junVoronoi2dPoint, junVoronoi2dDot2, (JunVoronoi2dSide)objectArray);
            JunVoronoi2dSide junVoronoi2dSide2 = new JunVoronoi2dSide((JunVoronoi2dPoint)((Object)object), (JunVoronoi2dPoint)junVoronoi2dObject);
            junVoronoi2dSide2.dot1_(junVoronoi2dDot);
            junVoronoi2dSide2.dot2_(junVoronoi2dDot2);
            JunVoronoi2dDot junVoronoi2dDot4 = junVoronoi2dDot3;
            int n3 = 1;
            while (!((Object)((Object)junVoronoi2dDot2)).equals((Object)junVoronoi2dDot3)) {
                JunVoronoi2dSide junVoronoi2dSide3 = this.bisectorSideBetween_and_(junVoronoi2dDot3, junVoronoi2dDot);
                JunVoronoi2dSide[] junVoronoi2dSideArray2 = this.searchSides_(junVoronoi2dDot3);
                for (int i = 0; i < junVoronoi2dSideArray2.length; ++i) {
                    JunVoronoi2dSide junVoronoi2dSide4 = junVoronoi2dSideArray2[i];
                    if (hashSet2.contains((Object)junVoronoi2dSide4)) continue;
                    object = junVoronoi2dObject;
                    hashSet2.add((Object)junVoronoi2dSide4);
                    JunVoronoi2dPoint junVoronoi2dPoint2 = junVoronoi2dSide4.intersectingPointWithSide_(junVoronoi2dSide3);
                    if (junVoronoi2dPoint2 == null) continue;
                    junVoronoi2dObject = junVoronoi2dPoint2;
                    JunVoronoi2dPoint junVoronoi2dPoint3 = this.removingPoint_with_with_with_(junVoronoi2dPoint2, junVoronoi2dSide3.from(), junVoronoi2dDot, junVoronoi2dSide4);
                    hashSet.add(junVoronoi2dPoint3);
                    junVoronoi2dDot3 = this.nearerDot_except_in_(junVoronoi2dPoint3, junVoronoi2dDot3, junVoronoi2dSide4);
                    JunVoronoi2dSide junVoronoi2dSide5 = new JunVoronoi2dSide((JunVoronoi2dPoint)((Object)object), (JunVoronoi2dPoint)junVoronoi2dObject);
                    junVoronoi2dSide5.dot1_(junVoronoi2dDot);
                    junVoronoi2dSide5.dot2_(junVoronoi2dDot4);
                    if (((Object)((Object)junVoronoi2dSide4.from())).equals((Object)junVoronoi2dPoint3)) {
                        arrayList3.add(new Object[]{junVoronoi2dSide4, JunVoronoi2dProcessor.$((String)"from"), junVoronoi2dPoint2});
                    } else {
                        arrayList3.add(new Object[]{junVoronoi2dSide4, JunVoronoi2dProcessor.$((String)"to"), junVoronoi2dPoint2});
                    }
                    junVoronoi2dPoint2.side1_(junVoronoi2dSide4);
                    junVoronoi2dPoint2.side2_(junVoronoi2dSide5);
                    junVoronoi2dDot4 = junVoronoi2dDot3;
                    arrayList.add(junVoronoi2dPoint2);
                    arrayList2.add(junVoronoi2dSide5);
                }
                if (++n3 > this.loopMax()) {
                    return false;
                }
                Thread.yield();
            }
            if (((Object)((Object)objectArray.from())).equals((Object)junVoronoi2dPoint)) {
                arrayList3.add(new Object[]{objectArray, JunVoronoi2dProcessor.$((String)"from"), junVoronoi2dObject2});
            } else {
                arrayList3.add(new Object[]{objectArray, JunVoronoi2dProcessor.$((String)"to"), junVoronoi2dObject2});
            }
            junVoronoi2dSide2.from_((JunVoronoi2dPoint)junVoronoi2dObject);
            ((JunVoronoi2dPoint)junVoronoi2dObject2).side1_((JunVoronoi2dSide)objectArray);
            ((JunVoronoi2dPoint)junVoronoi2dObject2).side2_(junVoronoi2dSide2);
            arrayList.add(junVoronoi2dObject2);
            arrayList2.add(junVoronoi2dSide2);
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            objectArray = (Object[])arrayList3.get(n2);
            object = (JunVoronoi2dSide)((Object)objectArray[0]);
            junVoronoi2dObject2 = (StSymbol)objectArray[1];
            junVoronoi2dObject = (JunVoronoi2dPoint)((Object)objectArray[2]);
            if (junVoronoi2dObject2 == JunVoronoi2dProcessor.$((String)"from")) {
                object.from_((JunVoronoi2dPoint)junVoronoi2dObject);
                continue;
            }
            if (junVoronoi2dObject2 != JunVoronoi2dProcessor.$((String)"to")) continue;
            object.to_((JunVoronoi2dPoint)junVoronoi2dObject);
        }
        if (arrayList.size() > 0 && arrayList2.size() > 0) {
            n2 = 1;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                if (n2 >= arrayList2.size()) {
                    n2 = 0;
                }
                object = (JunVoronoi2dPoint)((Object)arrayList.get(n4));
                junVoronoi2dObject2 = (JunVoronoi2dSide)((Object)arrayList2.get(n2));
                ((JunVoronoi2dPoint)((Object)object)).side3_((JunVoronoi2dSide)junVoronoi2dObject2);
                ++n4;
                ++n2;
            }
        }
        HashSet[] hashSetArray = this.removePoints_andSides_inside_(hashSet, hashSet2, arrayList2);
        HashSet hashSet3 = hashSetArray[0];
        object = hashSetArray[1];
        this.voronoiDots.add(junVoronoi2dDot);
        for (n = 0; n < arrayList.size(); ++n) {
            junVoronoi2dObject = (JunVoronoi2dPoint)((Object)arrayList.get(n));
            if (hashSet3.contains((Object)junVoronoi2dObject)) continue;
            this.voronoiPoints.add(junVoronoi2dObject);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            junVoronoi2dObject = (JunVoronoi2dSide)((Object)arrayList2.get(n));
            if (((HashSet)object).contains((Object)junVoronoi2dObject)) continue;
            this.voronoiSides.add(junVoronoi2dObject);
        }
        return true;
    }

    private JunVoronoi2dDot nearestDot_(JunVoronoi2dDot junVoronoi2dDot) {
        double d = this.bigNumber();
        JunVoronoi2dDot junVoronoi2dDot2 = null;
        for (int i = 0; i < this.voronoiDots.size(); ++i) {
            JunVoronoi2dDot junVoronoi2dDot3 = (JunVoronoi2dDot)((Object)this.voronoiDots.get(i));
            double d2 = junVoronoi2dDot.distance_(junVoronoi2dDot3);
            if (!(d > d2)) continue;
            d = d2;
            junVoronoi2dDot2 = junVoronoi2dDot3;
        }
        return junVoronoi2dDot2;
    }

    private JunVoronoi2dSide bisectorSideBetween_and_(JunVoronoi2dDot junVoronoi2dDot, JunVoronoi2dDot junVoronoi2dDot2) {
        JunVoronoi2dPoint junVoronoi2dPoint;
        JunVoronoi2dPoint junVoronoi2dPoint2;
        JunVoronoi2dLine junVoronoi2dLine = junVoronoi2dDot.bisector_(junVoronoi2dDot2);
        if (junVoronoi2dLine.isVertical()) {
            junVoronoi2dPoint2 = junVoronoi2dLine.pointAtY_(this.bigNumber() * -1.0);
            junVoronoi2dPoint = junVoronoi2dLine.pointAtY_(this.bigNumber());
        } else {
            junVoronoi2dPoint2 = junVoronoi2dLine.pointAtX_(this.bigNumber() * -1.0);
            junVoronoi2dPoint = junVoronoi2dLine.pointAtX_(this.bigNumber());
        }
        return new JunVoronoi2dSide(junVoronoi2dPoint2, junVoronoi2dPoint);
    }

    private JunVoronoi2dSide[] searchSides_(JunVoronoi2dDot junVoronoi2dDot) {
        ArrayList<JunVoronoi2dSide> arrayList = new ArrayList<JunVoronoi2dSide>();
        ArrayList<JunVoronoi2dSide> arrayList2 = new ArrayList<JunVoronoi2dSide>();
        for (int i = 0; i < this.voronoiSides.size(); ++i) {
            JunVoronoi2dSide junVoronoi2dSide = (JunVoronoi2dSide)((Object)this.voronoiSides.get(i));
            if (!((Object)((Object)junVoronoi2dSide.dot1())).equals((Object)junVoronoi2dDot) && !((Object)((Object)junVoronoi2dSide.dot2())).equals((Object)junVoronoi2dDot)) continue;
            if (junVoronoi2dSide.isInvalid() && this.startIndex() <= i) {
                arrayList2.add(junVoronoi2dSide);
                continue;
            }
            arrayList.add(junVoronoi2dSide);
        }
        this.voronoiSides.removeAll(arrayList2);
        return arrayList.toArray(new JunVoronoi2dSide[arrayList.size()]);
    }

    private JunVoronoi2dPoint removingPoint_with_with_with_(JunVoronoi2dPoint junVoronoi2dPoint, JunVoronoi2dDot junVoronoi2dDot, JunVoronoi2dDot junVoronoi2dDot2, JunVoronoi2dSide junVoronoi2dSide) {
        JunVoronoi2dTriangle junVoronoi2dTriangle = new JunVoronoi2dTriangle(junVoronoi2dPoint, junVoronoi2dDot, junVoronoi2dDot2);
        JunVoronoi2dTriangle junVoronoi2dTriangle2 = new JunVoronoi2dTriangle(junVoronoi2dPoint, junVoronoi2dDot, junVoronoi2dSide.from());
        return junVoronoi2dTriangle.areaWithSign() * junVoronoi2dTriangle2.areaWithSign() > 0.0 ? junVoronoi2dSide.from() : junVoronoi2dSide.to();
    }

    private JunVoronoi2dDot nearerDot_except_in_(JunVoronoi2dPoint junVoronoi2dPoint, JunVoronoi2dDot junVoronoi2dDot, JunVoronoi2dSide junVoronoi2dSide) {
        JunVoronoi2dDot[] junVoronoi2dDotArray = this.dotsAtPoint_(junVoronoi2dPoint);
        for (int i = 0; i < junVoronoi2dDotArray.length; ++i) {
            JunVoronoi2dDot junVoronoi2dDot2 = junVoronoi2dDotArray[i];
            if (((Object)((Object)junVoronoi2dDot2)).equals((Object)junVoronoi2dDot) || !((Object)((Object)junVoronoi2dSide.dot1())).equals((Object)junVoronoi2dDot2) && !((Object)((Object)junVoronoi2dSide.dot2())).equals((Object)junVoronoi2dDot2)) continue;
            return junVoronoi2dDot2;
        }
        return null;
    }

    private HashSet[] removePoints_andSides_inside_(HashSet hashSet, HashSet hashSet2, ArrayList arrayList) {
        JunVoronoi2dObject junVoronoi2dObject;
        HashSet<JunVoronoi2dObject> hashSet3 = new HashSet<JunVoronoi2dObject>();
        HashSet<JunVoronoi2dObject> hashSet4 = new HashSet<JunVoronoi2dObject>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            junVoronoi2dObject = (JunVoronoi2dPoint)((Object)iterator.next());
            ((JunVoronoi2dPoint)junVoronoi2dObject).side1_(null);
            ((JunVoronoi2dPoint)junVoronoi2dObject).side2_(null);
            ((JunVoronoi2dPoint)junVoronoi2dObject).side3_(null);
            if (!this.voronoiPoints.remove((Object)junVoronoi2dObject)) continue;
            hashSet3.add(junVoronoi2dObject);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            junVoronoi2dObject = (JunVoronoi2dSide)((Object)iterator.next());
            if (hashSet.contains((Object)((JunVoronoi2dSide)junVoronoi2dObject).from()) || hashSet.contains((Object)((JunVoronoi2dSide)junVoronoi2dObject).to())) {
                JunVoronoi2dSide junVoronoi2dSide = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    JunVoronoi2dSide junVoronoi2dSide2 = (JunVoronoi2dSide)((Object)arrayList.get(i));
                    if (((JunVoronoi2dSide)junVoronoi2dObject).intersectingPointWithSide_(junVoronoi2dSide2) == null) continue;
                    junVoronoi2dSide = junVoronoi2dSide2;
                    break;
                }
                if (junVoronoi2dSide == null) {
                    if (this.voronoiPoints.remove((Object)((JunVoronoi2dSide)junVoronoi2dObject).from())) {
                        hashSet3.add(((JunVoronoi2dSide)junVoronoi2dObject).from());
                    }
                    if (this.voronoiPoints.remove((Object)((JunVoronoi2dSide)junVoronoi2dObject).to())) {
                        hashSet3.add(((JunVoronoi2dSide)junVoronoi2dObject).to());
                    }
                    ((JunVoronoi2dSide)junVoronoi2dObject).from_(null);
                    ((JunVoronoi2dSide)junVoronoi2dObject).to_(null);
                    ((JunVoronoi2dSide)junVoronoi2dObject).dot1_(null);
                    ((JunVoronoi2dSide)junVoronoi2dObject).dot2_(null);
                    if (!this.voronoiSides.remove((Object)junVoronoi2dObject)) continue;
                    hashSet4.add(junVoronoi2dObject);
                    continue;
                }
                if (!((JunVoronoi2dSide)junVoronoi2dObject).isInvalid() || this.startIndex() > this.voronoiSides.indexOf((Object)junVoronoi2dObject) || !this.voronoiSides.remove((Object)junVoronoi2dObject)) continue;
                hashSet4.add(junVoronoi2dObject);
                continue;
            }
            if (!((JunVoronoi2dSide)junVoronoi2dObject).isInvalid() || this.startIndex() > this.voronoiSides.indexOf((Object)junVoronoi2dObject) || !this.voronoiSides.remove((Object)junVoronoi2dObject)) continue;
            hashSet4.add(junVoronoi2dObject);
        }
        return new HashSet[]{hashSet3, hashSet4};
    }

    public boolean trace() {
        return this.traceBoolean;
    }

    public void trace_(boolean bl) {
        this.traceBoolean = bl;
    }

    protected void traceDisplayOn_(Graphics graphics) {
        StRectangle stRectangle;
        int n;
        int n2;
        JunVoronoi2dObject junVoronoi2dObject;
        int n3;
        if (this._traceCanvas == null || !this._traceCanvas.isShowing()) {
            return;
        }
        Rectangle rectangle = new Rectangle(this._traceCanvas.getSize());
        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
        int n4 = 200;
        point.x = (int)((double)point.x - (double)n4 * 0.5);
        point.y = (int)((double)point.y - (double)n4 * 0.5);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(Color.red);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        for (n3 = 0; n3 < this.voronoiDots.size(); ++n3) {
            junVoronoi2dObject = (JunVoronoi2dDot)((Object)this.voronoiDots.get(n3));
            n2 = (int)Math.round(((JunVoronoi2dDot)junVoronoi2dObject).x() * (double)n4 + (double)point.x);
            n = (int)Math.round(((JunVoronoi2dDot)junVoronoi2dObject).y() * (double)n4 + (double)point.y);
            stRectangle = StRectangle.Origin_extent_((Point)new Point(n2, n), (Point)new Point(1, 1)).expandedBy_(2);
            this.displayBoxOn_box_clip_(graphics2D, stRectangle, rectangle);
        }
        for (n3 = 0; n3 < this.voronoiPoints.size(); ++n3) {
            junVoronoi2dObject = (JunVoronoi2dPoint)((Object)this.voronoiPoints.get(n3));
            n2 = (int)Math.round(((JunVoronoi2dDot)junVoronoi2dObject).x() * (double)n4 + (double)point.x);
            n = (int)Math.round(((JunVoronoi2dDot)junVoronoi2dObject).y() * (double)n4 + (double)point.y);
            stRectangle = StRectangle.Origin_extent_((Point)new Point(n2, n), (Point)new Point(1, 1)).expandedBy_(3);
            graphics2D.setColor(Color.green);
            this.displayBoxOn_box_clip_(graphics2D, stRectangle, rectangle);
            ArrayList<JunVoronoi2dSide> arrayList = new ArrayList<JunVoronoi2dSide>(3);
            if (((JunVoronoi2dPoint)junVoronoi2dObject).side1() != null) {
                arrayList.add(((JunVoronoi2dPoint)junVoronoi2dObject).side1());
            }
            if (((JunVoronoi2dPoint)junVoronoi2dObject).side2() != null) {
                arrayList.add(((JunVoronoi2dPoint)junVoronoi2dObject).side2());
            }
            if (((JunVoronoi2dPoint)junVoronoi2dObject).side3() != null) {
                arrayList.add(((JunVoronoi2dPoint)junVoronoi2dObject).side3());
            }
            graphics2D.setColor(Color.blue);
            graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
            for (int i = 0; i < arrayList.size(); ++i) {
                JunVoronoi2dSide junVoronoi2dSide = (JunVoronoi2dSide)((Object)arrayList.get(i));
                if (!junVoronoi2dSide.isValid()) continue;
                int n5 = (int)Math.round(junVoronoi2dSide.from().x() * (double)n4 + (double)point.x);
                int n6 = (int)Math.round(junVoronoi2dSide.from().y() * (double)n4 + (double)point.y);
                int n7 = (int)Math.round(junVoronoi2dSide.to().x() * (double)n4 + (double)point.x);
                int n8 = (int)Math.round(junVoronoi2dSide.to().y() * (double)n4 + (double)point.y);
                this.displayLineOn_from_to_clip_(graphics2D, new Point(n5, n6), new Point(n7, n8), rectangle);
            }
        }
        graphics2D.setColor(Color.cyan);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        for (n3 = 0; n3 < this.voronoiSides.size(); ++n3) {
            junVoronoi2dObject = (JunVoronoi2dSide)((Object)this.voronoiSides.get(n3));
            n2 = (int)Math.round(((JunVoronoi2dSide)junVoronoi2dObject).from().x() * (double)n4 + (double)point.x);
            n = (int)Math.round(((JunVoronoi2dSide)junVoronoi2dObject).from().y() * (double)n4 + (double)point.y);
            int n9 = (int)Math.round(((JunVoronoi2dSide)junVoronoi2dObject).to().x() * (double)n4 + (double)point.x);
            int n10 = (int)Math.round(((JunVoronoi2dSide)junVoronoi2dObject).to().y() * (double)n4 + (double)point.y);
            this.displayLineOn_from_to_clip_(graphics2D, new Point(n2, n), new Point(n9, n10), rectangle);
        }
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        StRectangle stRectangle2 = StRectangle.Origin_extent_((Point)new Point(0, 0), (Point)new Point(1, 1)).scaledBy_((double)n4, (double)n4).translatedBy_(point.x, point.y);
        graphics2D.drawRect(stRectangle2.x(), stRectangle2.y(), stRectangle2.width(), stRectangle2.height());
    }

    protected void displayBoxOn_box_clip_(Graphics2D graphics2D, StRectangle stRectangle, Rectangle rectangle) {
        if (stRectangle.intersects_(new StRectangle(rectangle))) {
            graphics2D.fillRect(stRectangle.x(), stRectangle.y(), stRectangle.width(), stRectangle.height());
        }
    }

    protected void displayLineOn_from_to_clip_(Graphics2D graphics2D, Point point, Point point2, Rectangle rectangle) {
        double d = (double)Math.abs(point2.y - point.y) / Math.max((double)Math.abs(point2.x - point.x), this.accuracy());
        StRectangle stRectangle = new StRectangle(rectangle);
        stRectangle.expandedBy_(new StRectangle(0, 0, 1, 1));
        boolean bl = stRectangle.containsPoint_(point);
        boolean bl2 = stRectangle.containsPoint_(point2);
        stRectangle.insetBy_(new StRectangle(0, 0, 1, 1));
        if (bl && bl2) {
            graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
        } else if (!bl && !bl2) {
            boolean bl3 = false;
            JunVoronoi2dSide junVoronoi2dSide = new JunVoronoi2dSide(point, point2);
            if (junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topLeft(), stRectangle.bottomLeft())) != null) {
                bl3 = true;
            }
            if (junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topRight(), stRectangle.bottomRight())) != null) {
                bl3 = true;
            }
            if (junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topLeft(), stRectangle.topRight())) != null) {
                bl3 = true;
            }
            if (junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.bottomLeft(), stRectangle.bottomRight())) != null) {
                bl3 = true;
            }
            if (bl3) {
                JunVoronoi2dPoint junVoronoi2dPoint;
                JunVoronoi2dPoint junVoronoi2dPoint2;
                JunVoronoi2dLine junVoronoi2dLine = new JunVoronoi2dLine(point, point2);
                if (d > 1.0) {
                    junVoronoi2dPoint2 = junVoronoi2dLine.pointAtY_(stRectangle.top());
                    junVoronoi2dPoint = junVoronoi2dLine.pointAtY_(stRectangle.bottom());
                } else {
                    junVoronoi2dPoint2 = junVoronoi2dLine.pointAtX_(stRectangle.top());
                    junVoronoi2dPoint = junVoronoi2dLine.pointAtX_(stRectangle.bottom());
                }
                graphics2D.drawLine((int)Math.round(junVoronoi2dPoint2.x()), (int)Math.round(junVoronoi2dPoint2.y()), (int)Math.round(junVoronoi2dPoint.x()), (int)Math.round(junVoronoi2dPoint.y()));
            }
        } else {
            JunVoronoi2dPoint junVoronoi2dPoint;
            JunVoronoi2dPoint junVoronoi2dPoint3;
            if (bl) {
                junVoronoi2dPoint3 = new JunVoronoi2dPoint(point);
                junVoronoi2dPoint = new JunVoronoi2dPoint(point2);
            } else {
                junVoronoi2dPoint3 = new JunVoronoi2dPoint(point2);
                junVoronoi2dPoint = new JunVoronoi2dPoint(point);
            }
            JunVoronoi2dSide junVoronoi2dSide = new JunVoronoi2dSide(point, point2);
            JunVoronoi2dPoint junVoronoi2dPoint4 = junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topLeft(), stRectangle.bottomLeft()));
            if (junVoronoi2dPoint4 != null) {
                junVoronoi2dPoint = junVoronoi2dPoint4;
            }
            if ((junVoronoi2dPoint4 = junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topRight(), stRectangle.bottomRight()))) != null) {
                junVoronoi2dPoint = junVoronoi2dPoint4;
            }
            if ((junVoronoi2dPoint4 = junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.topLeft(), stRectangle.topRight()))) != null) {
                junVoronoi2dPoint = junVoronoi2dPoint4;
            }
            if ((junVoronoi2dPoint4 = junVoronoi2dSide.intersectingPointWithSide_(new JunVoronoi2dSide(stRectangle.bottomLeft(), stRectangle.bottomRight()))) != null) {
                junVoronoi2dPoint = junVoronoi2dPoint4;
            }
            graphics2D.drawLine((int)Math.round(junVoronoi2dPoint3.x()), (int)Math.round(junVoronoi2dPoint3.y()), (int)Math.round(junVoronoi2dPoint.x()), (int)Math.round(junVoronoi2dPoint.y()));
        }
    }

    protected void displayLoopOn_points_clip_(Graphics2D graphics2D, Point[] pointArray, Rectangle rectangle) {
        if (pointArray == null || pointArray.length < 3) {
            return;
        }
        for (int i = 1; i < pointArray.length; ++i) {
            Point point = pointArray[i - 1];
            Point point2 = pointArray[i];
            this.displayLineOn_from_to_clip_(graphics2D, point, point2, rectangle);
        }
        if (!pointArray[0].equals(pointArray[pointArray.length - 1])) {
            this.displayLineOn_from_to_clip_(graphics2D, pointArray[pointArray.length - 1], pointArray[0], rectangle);
        }
    }

    public void printOn_(Writer writer) throws IOException {
        PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        printWriter.println("diagram ( ");
        Jun2dPoint[] jun2dPointArray = this.dots();
        for (int i = 0; i < jun2dPointArray.length; ++i) {
            printWriter.print('\t');
            jun2dPointArray[i].printOn_(writer);
            printWriter.println();
        }
        printWriter.println(")");
    }

    protected double bigSize() {
        return 100.0;
    }

    protected double bigFactor() {
        return 100.0;
    }

    protected double bigNumber() {
        return this.bigSize() * this.bigFactor();
    }

    protected int loopMax() {
        return 5000;
    }

    protected JunVoronoi2dDot[] normalizedDots_(JunVoronoi2dDot[] junVoronoi2dDotArray) {
        JunVoronoi2dDot[] junVoronoi2dDotArray2 = new JunVoronoi2dDot[junVoronoi2dDotArray.length];
        System.arraycopy(junVoronoi2dDotArray, 0, junVoronoi2dDotArray2, 0, junVoronoi2dDotArray2.length);
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        for (int i = 0; i < junVoronoi2dDotArray2.length; ++i) {
            d = Math.min(d, junVoronoi2dDotArray2[i].x());
            d2 = Math.min(d2, junVoronoi2dDotArray2[i].y());
            d3 = Math.max(d3, junVoronoi2dDotArray2[i].x());
            d4 = Math.max(d4, junVoronoi2dDotArray2[i].y());
        }
        if (0.0 <= d && d3 <= 1.0 && 0.0 <= d2 && d4 <= 1.0) {
            this.translationDelta = new JunVoronoi2dDot(0.0, 0.0);
            this.scalingFactor = new JunVoronoi2dDot(1.0, 1.0);
            return junVoronoi2dDotArray2;
        }
        JunVoronoi2dDot junVoronoi2dDot = new JunVoronoi2dDot(d, d2);
        for (int i = 0; i < junVoronoi2dDotArray2.length; ++i) {
            junVoronoi2dDotArray2[i] = new JunVoronoi2dDot(junVoronoi2dDotArray2[i].x() - junVoronoi2dDot.x(), junVoronoi2dDotArray2[i].y() - junVoronoi2dDot.y());
        }
        double d5 = Math.max(d3 - d, this.accuracy());
        double d6 = Math.max(d4 - d2, this.accuracy());
        double d7 = Math.max(d5, d6);
        for (int i = 0; i < junVoronoi2dDotArray2.length; ++i) {
            junVoronoi2dDotArray2[i] = new JunVoronoi2dDot(junVoronoi2dDotArray2[i].x() / d7, junVoronoi2dDotArray2[i].y() / d7);
        }
        this.translationDelta = junVoronoi2dDot;
        this.scalingFactor = new JunVoronoi2dDot(d7, d7);
        return junVoronoi2dDotArray2;
    }
}

