/*
 * Decompiled with CFR 0.152.
 */
package jp.co.sra.jun.vrml.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.support.JunVrmlKeywordTable;
import jp.co.sra.jun.vrml.support.JunVrmlScannerTable;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StReadStream;
import jp.co.sra.smalltalk.StSymbol;

public abstract class JunVrmlScanner
extends JunAbstractObject {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    protected StReadStream source = null;
    protected int mark;
    protected Object token = null;
    protected char hereChar = '\u0000';
    protected StSymbol tokenType;
    protected JunVrmlKeywordTable keywordTable = null;
    protected JunVrmlScannerTable typeTable = null;
    protected StBlockClosure failBlock = null;

    public JunVrmlScanner() {
        this.initScanner();
    }

    public Integer hexNumberFromString_(String string) {
        int n = string.length();
        int n2 = 0;
        String string2 = string;
        for (int i = 0; i < n; ++i) {
            int n3;
            switch (string2.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n3 = string2.charAt(i) - 48;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n3 = string2.charAt(i) - 65 + 10;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            for (int j = 0; j < n - 1 - i; ++j) {
                n3 *= 16;
            }
            n2 += n3;
        }
        int n4 = n2;
        return new Integer(n4);
    }

    protected void initScanner() {
        this.typeTable = this.defaultScannerTable();
        this.keywordTable = this.defaultKeywordTable();
        this.failBlock = new StBlockClosure(){

            public Object value_(Object object) {
                String string = (String)object;
                String string2 = string + "near " + JunVrmlScanner.this.token.toString();
                String string3 = JunVrmlScanner.this.source.upToEnd().toString();
                string3 = string3.length() == 0 ? "--> end of file" : (string3.length() > 30 ? "--> " + string3.substring(0, 30) : "-->" + string3);
                throw SmalltalkException.Error((String)(string2 + " : " + string3));
            }
        };
    }

    public void multiChar_(StSymbol stSymbol) {
        try {
            this.perform_(stSymbol.toString());
        }
        catch (Exception exception) {
            throw new SmalltalkException(exception);
        }
    }

    public char nextChar() {
        char c = this.source.next();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            if (this.source.peek() == '\n') {
                this.source.next();
            }
            return '\r';
        }
        if (this.source.atEnd()) {
            return this.typeTable.endChar();
        }
        return c;
    }

    public Object nextToken() {
        this.mark = this.source.position();
        char c = this.peekChar();
        this.tokenType = (StSymbol)this.typeTable.at(c);
        while (this.tokenType == JunVrmlScanner.$((String)"xDelimiter")) {
            this.nextChar();
            c = this.peekChar();
            this.tokenType = (StSymbol)this.typeTable.at(c);
        }
        c = this.tokenType.toString().charAt(0);
        if (c == 'x') {
            this.multiChar_(this.tokenType);
        } else {
            this.singleChar_(this.tokenType);
        }
        return this.token;
    }

    public String numberFrom_(StReadStream stReadStream) {
        StringBuffer stringBuffer = new StringBuffer();
        while ((this.hereChar = stReadStream.next()) != '\u0000' && this.hereChar >= '0' && this.hereChar <= '9') {
            stringBuffer.append(this.hereChar);
        }
        this.token = stringBuffer.toString();
        return (String)this.token;
    }

    public void on_(StReadStream stReadStream) {
        this.source = stReadStream;
        this.mark = this.source.position();
    }

    public char peekChar() {
        char c = this.source.peek();
        if (c == '\n') {
            return '\r';
        }
        if (c == '\r') {
            return '\r';
        }
        if (c == '\u0000') {
            return this.typeTable.endChar();
        }
        return c;
    }

    public void singleChar_(StSymbol stSymbol) {
        this.nextChar();
        this.token = stSymbol;
    }

    public char step() {
        char c;
        do {
            c = this.hereChar;
            this.hereChar = this.source.next();
        } while (this.hereChar == '\\' && this.source.peek() == '\r');
        return c;
    }

    public String stringFrom_(StReadStream stReadStream) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        char c = stReadStream.next();
        if (c == '\"') {
            while ((c = stReadStream.peek()) != '\u0000') {
                if (c == '\\') {
                    stReadStream.next();
                    c = stReadStream.peek();
                    if (c != '\"') {
                        stringBuffer.append('\\');
                    }
                } else if (c == '\"') {
                    stReadStream.next();
                    return stringBuffer.toString();
                }
                stringBuffer.append(stReadStream.next());
            }
        }
        if ((string = stReadStream.upToEnd()).length() > 100) {
            string = string.substring(0, 100);
        }
        try {
            return (String)this.failBlock.value_((Object)"Syntax error unmatched $\"");
        }
        catch (Exception exception) {
            this.error_("failBlock value error");
            return "";
        }
    }

    public StSymbol symbolFrom_(StReadStream stReadStream) {
        StSymbol stSymbol;
        StringBuffer stringBuffer = new StringBuffer();
        char c = stReadStream.peek();
        while (c != '\u0000' && ((stSymbol = (StSymbol)this.typeTable.at(c)) == JunVrmlScanner.$((String)"xSymbol") || stSymbol == JunVrmlScanner.$((String)"xDigit") || stSymbol == JunVrmlScanner.$((String)"xSign"))) {
            stringBuffer.append(stReadStream.next());
            c = stReadStream.peek();
        }
        if (stringBuffer.toString().compareTo("nil") == 0) {
            return null;
        }
        return JunVrmlScanner.$((String)stringBuffer.toString());
    }

    public Object token() {
        return this.token();
    }

    public StSymbol tokenType() {
        return this.tokenType;
    }

    public void unNextChar() {
        this.source.skip_(-1);
    }

    public void unNextToken() {
        this.source.position_(this.mark);
    }

    public void xBinary() {
        this.failBlock.value_((Object)("Syntax error : " + this.source.peek()));
    }

    public void xComment() {
        char c = this.nextChar();
        while (c != '\r') {
            if (c == this.typeTable.endChar()) {
                this.nextToken();
                return;
            }
            c = this.nextChar();
        }
        this.nextToken();
    }

    public void xDigit() {
        String string = this.numberFrom_(this.source);
        if (string.compareTo("0") == 0 && this.hereChar == 'x') {
            this.xHexadecimal();
            return;
        }
        if (string.charAt(0) == '0' && this.hereChar != '.' && string.length() != 1) {
            this.xOctal();
            return;
        }
        if (this.hereChar != '\u0000') {
            if (Character.toUpperCase(this.hereChar) == 'U') {
                this.hereChar = this.source.next();
                if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'L') {
                    this.hereChar = this.source.next();
                }
            } else if (Character.toUpperCase(this.hereChar) == 'L') {
                this.hereChar = this.source.next();
                if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'U') {
                    this.hereChar = this.source.next();
                }
            }
        }
        if (this.hereChar != '\u0000') {
            switch (this.hereChar) {
                case '.': 
                case 'D': 
                case 'E': 
                case 'd': 
                case 'e': {
                    this.token = this.xLimitedPrecisionReal_(string);
                    break;
                }
                default: {
                    this.token = new Integer(string);
                }
            }
        }
        this.tokenType = JunVrmlScanner.$((String)"number");
        this.unNextChar();
    }

    public void xDoubleQuote() {
        this.tokenType = JunVrmlScanner.$((String)"string");
        this.token = this.stringFrom_(this.source);
    }

    public void xHexadecimal() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            bl = false;
            this.hereChar = this.source.next();
            if (this.hereChar == '\u0000') break;
            switch (this.hereChar) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    bl = true;
                    stringBuffer.append(this.hereChar);
                    break;
                }
            }
        } while (bl);
        if (this.hereChar != '\u0000') {
            if (Character.toUpperCase(this.hereChar) == 'U') {
                this.hereChar = this.source.next();
                if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'L') {
                    this.hereChar = this.source.next();
                }
            }
        } else if (Character.toUpperCase(this.hereChar) == 'L') {
            this.hereChar = this.source.next();
            if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'U') {
                this.hereChar = this.source.next();
            }
        }
        this.token = this.hexNumberFromString_(stringBuffer.toString());
        this.tokenType = JunVrmlScanner.$((String)"number");
        if (this.hereChar == '\u0000') {
            this.step();
        } else {
            this.unNextChar();
        }
    }

    public Number xLimitedPrecisionReal_(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.hereChar == '.' || stringBuffer.length() == 0) {
            boolean bl = false;
            if (this.hereChar == '.') {
                c = this.hereChar;
                stringBuffer.append(this.hereChar);
                this.hereChar = this.source.next();
            } else {
                stringBuffer = new StringBuffer("0.");
            }
            while (this.hereChar != '\u0000' && this.hereChar >= '0' && this.hereChar <= '9') {
                bl = true;
                stringBuffer.append(this.hereChar);
                this.hereChar = this.source.next();
            }
            if (!bl) {
                stringBuffer.append('0');
            }
        }
        if (this.hereChar != '\u0000' && (this.hereChar == 'e' || this.hereChar == 'E' || this.hereChar == 'd' || this.hereChar == 'D')) {
            stringBuffer.append('e');
            c = this.hereChar;
            this.hereChar = this.source.next();
            if (this.hereChar != '\u0000' && (this.hereChar == '+' || this.hereChar == '-') && (this.hereChar != '+' || c != 'd' && c != 'D')) {
                if (this.hereChar != '+') {
                    stringBuffer.append(this.hereChar);
                }
                this.hereChar = this.source.next();
            }
            while (this.hereChar != '\u0000' && this.hereChar >= '0' && this.hereChar <= '9') {
                stringBuffer = stringBuffer.append(this.hereChar);
                this.hereChar = this.source.next();
            }
        }
        if (this.hereChar != '\u0000' && (this.hereChar == 'f' || this.hereChar == 'F')) {
            this.hereChar = this.source.next();
            return new Double(stringBuffer.toString());
        }
        if (this.hereChar != '\u0000' && (this.hereChar == 'l' || this.hereChar == 'L')) {
            this.hereChar = this.source.next();
        }
        return new Double(stringBuffer.toString());
    }

    public void xOctal() {
        int n;
        if (this.hereChar != '\u0000') {
            if (Character.toUpperCase(this.hereChar) == 'U') {
                this.hereChar = this.source.next();
                if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'L') {
                    this.hereChar = this.source.next();
                }
            } else if (Character.toUpperCase(this.hereChar) == 'L') {
                this.hereChar = this.source.next();
                if (this.hereChar != '\u0000' && Character.toUpperCase(this.hereChar) == 'U') {
                    this.hereChar = this.source.next();
                }
            }
        }
        String string = (String)this.token;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            if (string.charAt(n) >= '0' && string.charAt(n) <= '7') continue;
            this.error_("Expected Octal Constant");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i) - 48;
            for (int j = 0; j < n2 - 1 - i; ++j) {
                n *= 8;
            }
            n3 += n;
        }
        this.token = new Integer(n3);
        this.tokenType = JunVrmlScanner.$((String)"number");
        this.unNextChar();
    }

    public void xPeriod() {
        this.hereChar = this.nextChar();
        char c = this.peekChar();
        if (Character.isDigit(c)) {
            this.token = this.xLimitedPrecisionReal_("");
            this.tokenType = JunVrmlScanner.$((String)"number");
            return;
        }
        this.token = new Character('.');
        this.tokenType = JunVrmlScanner.$((String)"period");
    }

    public void xSign() {
        char c = this.nextChar();
        char c2 = this.peekChar();
        if (Character.isDigit(c2)) {
            this.xDigit();
            if (c == '-') {
                Number number = (Number)this.token;
                if (this.token instanceof Double) {
                    this.token = new Double(-number.doubleValue());
                }
                if (this.token instanceof Float) {
                    this.token = new Float(-number.floatValue());
                }
                if (this.token instanceof Integer) {
                    this.token = new Integer(-number.intValue());
                }
                if (this.token instanceof Long) {
                    this.token = new Long(-number.longValue());
                }
            }
            return;
        }
        if (c2 == '.') {
            this.xPeriod();
            if (this.tokenType == JunVrmlScanner.$((String)"number") && c == '-') {
                Number number = (Number)this.token;
                if (this.token instanceof Double) {
                    this.token = new Double(-number.doubleValue());
                }
                if (this.token instanceof Float) {
                    this.token = new Float(-number.floatValue());
                }
                if (this.token instanceof Integer) {
                    this.token = new Integer(-number.intValue());
                }
                if (this.token instanceof Long) {
                    this.token = new Long(-number.longValue());
                }
            }
            return;
        }
        this.unNextChar();
        this.tokenType = JunVrmlScanner.$((String)"symbol");
        this.token = this.symbolFrom_(this.source);
    }

    public void xSymbol() {
        this.token = this.symbolFrom_(this.source);
        this.tokenType = this.keywordTable.hasSymbol_((StSymbol)this.token) ? (StSymbol)this.token : JunVrmlScanner.$((String)"identifier");
    }

    protected abstract JunVrmlKeywordTable defaultKeywordTable();

    protected abstract JunVrmlScannerTable defaultScannerTable();
}

