package jp.co.sra.gl4jun;

import java.awt.*;

/**
 * GLjImageSource class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/08/19 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: GLjImageSource.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class GLjImageSource {
	protected int width;
	protected int height;
	protected Color background;
	protected Image image;

	/**
	 * Create a image source for GL rendering.
	 * 
	 * @param aWidth int
	 * @param aHeight int
	 */
	public GLjImageSource(int aWidth, int aHeight) {
		this(aWidth, aHeight, Color.white);
	}

	/**
	 * Create a image source for GL rendering.
	 * 
	 * @param aWidth int
	 * @param aHeight int
	 * @param aBackground java.awt.Color
	 */
	public GLjImageSource(int aWidth, int aHeight, Color aBackground) {
		super();
		width = aWidth;
		height = aHeight;
		background = aBackground;
	}

	/**
	 * Creates a new GLjImageSource object.
	 */
	private GLjImageSource() {
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Color
	 */
	public Color getBackground() {
		return background;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Image
	 */
	public Image getImage() {
		return image;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return java.awt.Dimension
	 */
	public Dimension getSize() {
		return new Dimension(width, height);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anImage java.awt.Image
	 */
	void setImage(Image anImage) {
		image = anImage;
	}
}
