package jp.co.sra.gl4jun.test;

import javax.swing.*;
import jp.co.sra.gl4jun.*;

/**
 * GLjJCanvasTest class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/09/01 (by MATSUDA Ryouichi)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: GLjJCanvasTest.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class GLjJCanvasTest extends GLjJCanvas {

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		JMenuBar menuBar = new JMenuBar();
		frame.setJMenuBar(menuBar);

		JMenu fileMenu = new JMenu("File");
		menuBar.add(fileMenu);
		fileMenu.add(new JMenuItem("Exit"));

		GLjJCanvasTest glCanvas = new GLjJCanvasTest();
		glCanvas.setRenderingMode(GLjRenderingMode.DIRECT);
		frame.getContentPane().add("Center", glCanvas);
		frame.getContentPane().add("East", new JButton("East"));
		frame.getContentPane().add("West", new JButton("West"));
		frame.pack();
		frame.setVisible(true);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param gl jp.co.sra.gl4jun.GLjInterface
	 */
	protected void render(GLjInterface gl) {
		gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
		gl.glClear(gl.GL_COLOR_BUFFER_BIT);
		gl.glColor3f(1.0f, 0.0f, 0.0f);
		gl.glPolygonMode(gl.GL_FRONT, gl.GL_LINE);
		gl.glPolygonMode(gl.GL_BACK, gl.GL_FILL);
		gl.glFrontFace(gl.GL_CW);
		gl.glBegin(gl.GL_POLYGON);
		gl.glVertex2f(-0.5f, 0.5f);
		gl.glVertex2f(-0.5f, -0.5f);
		gl.glVertex2f(0.5f, -0.5f);
		gl.glVertex2f(0.5f, 0.5f);
		gl.glEnd();
	}
}
