package jp.co.sra.jun.collections.linkedlist;

/**
 * JunDoubleLink class
 * 
 *  @author    nisinaka
 *  @created   2002/01/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDoubleLink.java,v 8.10 2008/02/20 06:30:52 nisinaka Exp $
 */
public class JunDoubleLink extends JunSingleLink {
	/** The link to the previous entity. */
	protected JunDoubleLink backLink = null;

	/**
	 * Create a new instance of JunDoubleLink and initialize it with the entity
	 * object.
	 * 
	 * @param anObject java.lang.Object
	 */
	public JunDoubleLink(Object anObject) {
		this(anObject, null, null);
	}

	/**
	 * Create a new instance of JunDoubleLink and initialize it with the entity
	 * object and the next link.
	 * 
	 * @param anObject java.lang.Object
	 * @param nextLink jp.co.sra.jun.collections.linkedlist.JunDoubleLink
	 */
	public JunDoubleLink(Object anObject, JunDoubleLink nextLink) {
		this(anObject, nextLink, null);
	}

	/**
	 * Create a new instance of JunDoubleLink and initialize it with the entity
	 * object, the next link, and the back link.
	 * 
	 * @param anObject java.lang.Object
	 * @param nextLink jp.co.sra.jun.collections.linkedlist.JunDoubleLink
	 * @param backLink jp.co.sra.jun.collections.linkedlist.JunDoubleLink
	 */
	public JunDoubleLink(Object anObject, JunDoubleLink nextLink, JunDoubleLink backLink) {
		this.entityObject_(anObject);
		this.nextLink_(nextLink);
		this.backLink_(backLink);
	}

	/**
	 * Answer the back link.
	 * 
	 * @return jp.co.sra.jun.collections.linkedlist.JunDoubleLink
	 */
	public JunDoubleLink backLink() {
		return backLink;
	}

	/**
	 * Set the back link.
	 * 
	 * @param aLink jp.co.sra.jun.collections.linkedlist.JunDoubleLink
	 */
	public void backLink_(JunDoubleLink aLink) {
		backLink = aLink;
	}
}
