package jp.co.sra.jun.collections.sequences;

import java.awt.Point;
import java.util.Vector;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunLinearEquations class
 * 
 *  @author    nisinaka
 *  @created   1998/10/30 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLinearEquations.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunLinearEquations extends JunDoubleMatrix {
	/** The array of row index for the solution. */
	int[] solutionLocations = null;

	/**
	 * Create a new instance of matrix and initialize it with collection.
	 * 
	 * @param rowSize int
	 * @param columnSize int
	 * @param collection double[]
	 */
	public JunLinearEquations(int rowSize, int columnSize, double[] collection) {
		super(rowSize, columnSize, collection);
	}

	/**
	 * Answer true if the receiver equation is already solved, otherwise false.
	 * 
	 * @return boolean
	 */
	public boolean isSolved() {
		return (solutionLocations != null);
	}

	/**
	 * Answer the solution of the receiver.
	 * 
	 * @return double[]
	 */
	public double[] solution() {
		int size = this.unknownSize();
		double[] solution = new double[size];

		for (int i = 0; i < size; i++) {
			solution[i] = this.solutionAt_(i);
		}

		return solution;
	}

	/**
	 * Answer the unknown number at the place specified with the index. Note:
	 * The index starts with 0, while the Smalltalk version starts with 1.
	 * 
	 * @param index int
	 * 
	 * @return double
	 */
	public double solutionAt_(int index) {
		this.solve();

		return -this._doubleValueAt(solutionLocations[index], columnSize - 1);
	}

	/**
	 * Solve the receiver equation.
	 */
	public void solve() {
		if (this.isSolved()) {
			return;
		}

		int unknownSize = this.unknownSize();
		Vector rowsToBeProcessed = new Vector(rowSize);

		for (int i = 0; i < rowSize; i++) {
			rowsToBeProcessed.addElement(new Integer(i));
		}

		Vector columnsToBeProcessed = new Vector(unknownSize);

		for (int i = 0; i < unknownSize; i++) {
			columnsToBeProcessed.addElement(new Integer(i));
		}

		final Vector rowsToBeProcessed_ = rowsToBeProcessed;
		final Vector columnsToBeProcessed_ = columnsToBeProcessed;
		final JunLinearEquations this_ = this;
		StBlockClosure nextPivotBlock = new StBlockClosure() {
			public Object value() {
				Point nextPivot = null;
				double nextPivotValue = -1.0d;
				int row;
				int column;

				for (int i = 0; i < rowsToBeProcessed_.size(); i++) {
					row = ((Integer) rowsToBeProcessed_.elementAt(i)).intValue();

					for (int j = 0; j < columnsToBeProcessed_.size(); j++) {
						column = ((Integer) columnsToBeProcessed_.elementAt(j)).intValue();

						double cellValue = Math.abs(this_._doubleValueAt(row, column));

						if (cellValue >= nextPivotValue) {
							nextPivot = new Point(row, column);
							nextPivotValue = cellValue;
						}
					}
				}

				if (nextPivot != null) {
					rowsToBeProcessed_.removeElement(new Integer(nextPivot.x));
					columnsToBeProcessed_.removeElement(new Integer(nextPivot.y));
				}

				return nextPivot;
			}
		};

		StBlockClosure sweepBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				Point pivot = (Point) anObject;
				double pivotRatio;

				for (int row = 0; row < this_.rowSize(); row++) {
					pivotRatio = this_._doubleValueAt(row, pivot.y) / this_._doubleValueAt(pivot.x, pivot.y);

					if ((row != pivot.x) && (pivotRatio != 0)) {
						for (int column = 0; column < pivot.y; column++) {
							this_._doubleValuePut(row, column, this_._doubleValueAt(row, column) - (this_._doubleValueAt(pivot.x, column) * pivotRatio));
						}

						this_._doubleValuePut(row, pivot.y, 0);

						for (int column = pivot.y + 1; column < this_.columnSize(); column++) {
							this_._doubleValuePut(row, column, this_._doubleValueAt(row, column) - (this_._doubleValueAt(pivot.x, column) * pivotRatio));
						}
					}
				}

				return null;
			}
		};

		// Start calculations from here.
		solutionLocations = new int[unknownSize];

		for (int i = 0; i < unknownSize; i++) {
			solutionLocations[i] = -1;
		}

		for (int i = 0; i < unknownSize; i++) {
			Point pivot = (Point) nextPivotBlock.value();

			if (pivot != null) {
				if (this._doubleValueAt(pivot.x, pivot.y) != 0) {
					sweepBlock.value_(pivot);
					solutionLocations[pivot.y] = pivot.x;
				}
			}
		}

		for (int pivotColumn = 0; pivotColumn < unknownSize; pivotColumn++) {
			int pivotRow = solutionLocations[pivotColumn];

			if (pivotRow >= 0) {
				this._doubleValuePut(pivotRow, columnSize - 1, (this._doubleValueAt(pivotRow, columnSize - 1) / this._doubleValueAt(pivotRow, pivotColumn)));
				this._doubleValuePut(pivotRow, pivotColumn, 1);
			}
		}
	}

	/**
	 * Answer the number of the unknowns.
	 * 
	 * @return int
	 */
	public int unknownSize() {
		return columnSize - 1;
	}
}
