package jp.co.sra.jun.csg.abstracts;

import jp.co.sra.jun.csg.atoms.JunTransformedCSG;
import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.boundaries.*;
import jp.co.sra.jun.geometry.boundaries.JunBorderGenerator;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.octree.basic.JunOctree;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.solid.abstracts.JunSolidModel;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.smalltalk.*;

/**
 * JunCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public abstract class JunCSG extends JunSolidModel {

	/**
	 * Convert to a JunBody.
	 * 
	 * @param xInterval jp.co.sra.smalltalk.StInterval
	 * @param yInterval jp.co.sra.smalltalk.StInterval
	 * @param zInterval jp.co.sra.smalltalk.StInterval
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public JunBody asJunBodyXInterval_yInterval_zInterval_(StInterval xInterval, StInterval yInterval, StInterval zInterval) {
		final JunCSG self = this;

		return JunBorderGenerator.ContourBodyFrom_at_sign_xInterval_yInterval_zInterval_interim_(new StBlockClosure() {
			public Object value_value_value_(Object x, Object y, Object z) {
				return new Double(self.valueAt_(new Jun3dPoint(((Number) x).doubleValue(), ((Number) y).doubleValue(), ((Number) z).doubleValue())));
			}
		}, 0, 1, xInterval, yInterval, zInterval, new StBlockClosure());
	}

	/**
	 * Convert as a boxel octree with the specified conditions.
	 * 
	 * @param anInteger int
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree
	 */
	public JunOctree asJunBoxelOctreeDepth_bounds_(int anInteger, Jun3dBoundingBox aJun3dBoundingBox) {
		JunOctree octree = JunOctree.Bounds_(aJun3dBoundingBox);
		final JunCSG self = this;
		octree.block_depth_(new StBlockClosure() {
			public Object value_(Object point) {
				return new Double(self.valueAt_((Jun3dPoint) point));
			}
		}, anInteger);

		return octree;
	}

	/**
	 * Convert as a b-reps octree with the specified conditions.
	 * 
	 * @param anInteger int
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree
	 */
	public JunOctree asJunBrepsOctreeDepth_bounds_(int anInteger, Jun3dBoundingBox aJun3dBoundingBox) {
		JunOctree octree = JunOctree.Bounds_(aJun3dBoundingBox);
		final JunCSG self = this;
		octree.brepsBlock_depth_(new StBlockClosure() {
			public Object value_(Object point) {
				return new Double(self.valueAt_((Jun3dPoint) point));
			}
		}, anInteger);

		return octree;
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @param xInterval jp.co.sra.smalltalk.StInterval
	 * @param yInterval jp.co.sra.smalltalk.StInterval
	 * @param zInterval jp.co.sra.smalltalk.StInterval
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObjectXInterval_yInterval_zInterval_(StInterval xInterval, StInterval yInterval, StInterval zInterval) {
		return this.asJunBodyXInterval_yInterval_zInterval_(xInterval, yInterval, zInterval).asJunOpenGL3dObject();
	}

	/**
	 * Answer true if the receiver contains the specified point, otherwise
	 * false.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return boolean
	 */
	public boolean containsPoint_(Jun3dPoint a3dPoint) {
		return this.valueAt_(a3dPoint) >= 0;
	}

	/**
	 * Answer the JunCSG which is applied the specified transformation.
	 * 
	 * @param aJun3dTransformation
	 *        jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * 
	 * @return jp.co.sra.jun.csg.abstracts.JunCSG
	 */
	public JunCSG transform_(Jun3dTransformation aJun3dTransformation) {
		return JunTransformedCSG.On_transform_(this, aJun3dTransformation);
	}
}
