package jp.co.sra.jun.csg.abstracts;

import jp.co.sra.jun.solid.abstracts.JunSolidModel;

/**
 * JunUnaryCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunUnaryCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public abstract class JunUnaryCSG extends JunCSG {
	protected JunSolidModel solid;

	/**
	 * Create a new instance of JunBinaryCSG.
	 * 
	 * @param aSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunUnaryCSG(JunSolidModel aSolid) {
		this.solid_(aSolid);
	}

	/**
	 * Answer the solid.
	 * 
	 * @return jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public JunSolidModel solid() {
		return solid;
	}

	/**
	 * Set the solid.
	 * 
	 * @param aSolid jp.co.sra.jun.solid.abstracts.JunSolid
	 */
	public void solid_(JunSolidModel aSolid) {
		solid = aSolid;
	}
}
