package jp.co.sra.jun.csg.atoms;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;

/**
 * JunBlockCSG class
 * 
 *  @author    nisinaka
 *  @created   1998/10/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBlockCSG.java,v 8.10 2008/02/20 06:30:53 nisinaka Exp $
 */
public class JunBlockCSG extends jp.co.sra.jun.csg.abstracts.JunCSG {
	protected StBlockClosure block;

	/**
	 * Create a new instance of JunBlockCSG.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public JunBlockCSG(StBlockClosure aBlock) {
		this.setBlock_(aBlock);
	}

	/**
	 * Create a new instance of JunBlockCSG.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return jp.co.sra.jun.csg.atoms.JunBlockCSG
	 */
	public static JunBlockCSG On_(StBlockClosure aBlock) {
		return new JunBlockCSG(aBlock);
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return ((Number) block.value_(aJun3dPoint)).doubleValue();
	}

	/**
	 * Set the block closure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	protected void setBlock_(StBlockClosure aBlock) {
		block = aBlock;
	}
}
