package jp.co.sra.jun.geometry.coordinate;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;

/**
 * Jun3dCoordinateSystemTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/09 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2006/10/11 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dCoordinateSystemTestExamples.java,v 8.11 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dCoordinateSystemTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: 
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		Jun3dLine line1 = Jun3dLine.Unity();
		Jun3dCoordinateSystem coordinateSystem1 = Jun3dCoordinateSystem.Scale_(0.25);
		Jun3dCoordinateSystem coordinateSystem2 = Jun3dCoordinateSystem.Translate_(new Jun3dPoint(1, 1, 1));
		JunLocalGeometry line2 = line1.asLocalGeometryIn_(coordinateSystem1);
		JunLocalGeometry line3 = line2.asLocalGeometryIn_(coordinateSystem2);
		return line1.equals(line2.asGlobalGeometry()) && ((Jun3dLine) line2.asGlobalGeometry()).equals(line3.asGlobalGeometry());
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		Jun3dCoordinateSystem coordinateSystem1 = Jun3dCoordinateSystem.Translate_(new Jun3dPoint(1, 1, 1));
		Jun3dCoordinateSystem coordinateSystem2 = Jun3dCoordinateSystem.Scale_(0.25);
		Jun3dCoordinateSystem coordinateSystem3 = coordinateSystem2.asLocalCoordinateSystemOf_(coordinateSystem1);
		return coordinateSystem2.globalTransformation().equals(coordinateSystem3.globalTransformation());
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		Jun3dCoordinateSystem coordinateSystem1 = Jun3dCoordinateSystem.Translate_(new Jun3dPoint(1, 1, 1));
		Jun3dCoordinateSystem coordinateSystem2 = coordinateSystem1.newLocalCoordinateSystemScale_(0.25);
		Jun3dTransformation transformation1 = coordinateSystem2.globalTransformation();
		coordinateSystem1.transformation_(Jun3dTransformation.Scale_(4));
		Jun3dTransformation transformation2 = coordinateSystem2.globalTransformation();
		double[] array1 = { 0.25d, 0.0d, 0.0d, 0.0d, 0.0d, 0.25d, 0.0d, 0.0d, 0.0d, 0.0d, 0.25d, 0.0d, 1.0d, 1.0d, 1.0d, 1.0d };
		double[] array2 = { 1.0d, 0.0d, 0.0d, 0.0d, 0.0d, 1.0d, 0.0d, 0.0d, 0.0d, 0.0d, 1.0d, 0.0d, 0.0d, 0.0d, 0.0d, 1.0d };
		return transformation1.equals(Jun3dTransformation.FromArray_(array1)) && transformation2.equals(Jun3dTransformation.FromArray_(array2));
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new Jun3dCoordinateSystemTestExamples();
	}

}
