package jp.co.sra.jun.geometry.curves;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.surfaces.Jun3dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.surfaces.JunPlane;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dVertex;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * Jun3dPolylineTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/08/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dPolylineTestExamples.java,v 8.11 2008/02/20 06:30:57 nisinaka Exp $
 */
public class Jun3dPolylineTestExamples extends JunTestExamples {

	/**
	 * Example1: Create an example polyline and convert it as JunOpenGL3dObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		Jun3dPolyline aPolyline = ExamplePolyline1();
		aBody.add_(aPolyline.asJunOpenGL3dObject());
		aBody.show();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Jun3dPolyline aPolyline = ExamplePolyline2();

		HashMap projectionTable = new HashMap();
		projectionTable.put($("upVector"), new Jun3dPoint(0, 1, 0));
		projectionTable.put($("zoomHeight"), new Double(300));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("eyePoint"), aPolyline.from().plus_(new Jun3dPoint(0, 0, 10000)));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("presentation"), $("soldPresentation"));
		projectionTable.put($("sightPoint"), aPolyline.from());

		double scaleFactor = 0;
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().origin().x() - aPolyline.from().x()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().corner().x() - aPolyline.from().x()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().origin().y() - aPolyline.from().y()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().corner().y() - aPolyline.from().y()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().origin().z() - aPolyline.from().z()));
		scaleFactor = Math.max(scaleFactor, Math.abs(aPolyline.boundingBox().corner().z() - aPolyline.from().z()));

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		JunOpenGL3dPolyline anOpenGL3dPolyline = (JunOpenGL3dPolyline) aPolyline.asJunOpenGL3dObjectColor_(Color.black);
		anOpenGL3dPolyline.lineWidth_(1);
		aBody.add_(anOpenGL3dPolyline.translatedBy_(new Jun3dPoint(0, 0, 0.1)));
		aBody.add_(JunOpenGL3dObject.Axes().scaledBy_(scaleFactor * 1.2).translatedBy_(aPolyline.from().as3dPoint()));
		aBody.showProjectionTable_in_(projectionTable, new Rectangle(80 - 4, 300 - 23, 300 + 8, 300 + 26));

		JunOpenGL3dCompoundObject interBody = (JunOpenGL3dCompoundObject) aBody.transform_(Jun3dTransformation.Unity());
		Object[] anArray = aPolyline.asArrayOf2dPointsAndTableOn_(JunPlane.On_normalVector_(aPolyline.from(), aPolyline.normalVector()));
		Map aTable = (Map) anArray[1];
		Jun2dPoint[] points = (Jun2dPoint[]) anArray[0];
		for (int i = 0; i < points.length; i++) {
			Jun3dPoint fromPoint = (Jun3dPoint) aTable.get(points[i]);
			Jun3dPoint toPoint = points[i].as3dPoint();
			Color color = Color.getHSBColor((float) i / points.length, 1, 1);
			interBody.add_(toPoint.asJunOpenGL3dObjectColor_(color));

			JunOpenGL3dPolyline polyline = new JunOpenGL3dPolyline(new Jun3dPoint[] { fromPoint, toPoint });
			polyline.paint_(color);
			polyline.halftone_(0.5);
			interBody.add_(polyline);
		}
		JunOpenGL3dObject anObject = new Jun3dCircle(aPolyline.from(), scaleFactor * 1.2, aPolyline.normalVector()).asJunOpenGL3dObject();
		anObject.flushAllPaints();
		anObject.flushAllAlphas();
		anObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dObject object = (JunOpenGL3dObject) each;
				object.paint_(Color.cyan);
				object.halftone_(0.5);
				return null;
			}
		});
		interBody.add_(anObject);
		interBody.add_(JunOpenGL3dObject.Axes().scaledBy_(scaleFactor * 1.2));
		anObject = new Jun3dCircle(new Jun3dPoint(0, 0, 0), scaleFactor * 1.2, new Jun3dPoint(0, 0, 1)).asJunOpenGL3dObject();
		anObject.flushAllPaints();
		anObject.flushAllAlphas();
		anObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dObject object = (JunOpenGL3dObject) each;
				object.paint_(Color.cyan);
				object.halftone_(0.5);
				return null;
			}
		});
		interBody.add_(anObject);
		interBody.showProjectionTable_in_(projectionTable, new Rectangle(390 - 4, 300 - 23, 300 + 8, 300 + 26)).resetView();

		aBody = (JunOpenGL3dCompoundObject) aBody.copy();
		Jun3dTriangle[] arrayOfTriangles = aPolyline.asArrayOfTriangles();
		for (int i = 0; i < arrayOfTriangles.length; i++) {
			aBody.add_(arrayOfTriangles[i].asJunOpenGL3dObjectColor_(Color.getHSBColor((float) i / arrayOfTriangles.length, 1, 1)));
		}
		aBody.showProjectionTable_in_(projectionTable, new Rectangle(700 - 4, 300 - 23, 300 + 8, 300 + 26));

		return true;
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final Jun3dPolyline aPolyline1 = ExamplePolyline31();
		final Jun3dPolyline aPolyline2 = ExamplePolyline32();

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();

		HashMap projectionTable = new HashMap();
		projectionTable.put($("sightPoint"), new Jun3dPoint(99.5, 159.5, 0.0));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(0, -1, 0));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("presentation"), $("soldPresentation"));
		projectionTable.put($("zoomHeight"), new Double(370));
		projectionTable.put($("eyePoint"), new Jun3dPoint(0, 0, -10000));

		final JunOpenGLDisplayModel aModel = aBody.showProjectionTable_(projectionTable);

		final StBlockClosure aBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dCompoundObject aBody = (JunOpenGL3dCompoundObject) anObject;

				Jun3dPoint[] points = aPolyline1.points();
				for (int i = 0; i < points.length; i++) {
					JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) points[i].plus_(new Jun3dPoint(0, 0, -0.1)).asJunOpenGL3dObject();
					vertex.size_(5);
					aBody.add_(vertex);
				}

				points = aPolyline2.points();
				for (int i = 0; i < points.length; i++) {
					JunOpenGL3dVertex vertex = (JunOpenGL3dVertex) points[i].plus_(new Jun3dPoint(0, 0, -0.1)).asJunOpenGL3dObject();
					vertex.size_(5);
					aBody.add_(vertex);
				}

				JunOpenGL3dPolyline polyline = (JunOpenGL3dPolyline) aPolyline1.asJunOpenGL3dObject();
				polyline.lineWidth_(3);
				aBody.add_(polyline);

				polyline = (JunOpenGL3dPolyline) aPolyline2.asJunOpenGL3dObject();
				polyline.lineWidth_(3);
				aBody.add_(polyline);

				return aBody;
			}
		};

		Jun3dTriangle[] triangles = aPolyline1.sew_interim_(aPolyline2, new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				Jun3dPoint[] points = (Jun3dPoint[]) o1;
				StSymbol symbol = (StSymbol) o2;

				JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
				aBlock.value_(aBody);

				Jun3dPoint[] _3dPoints = new Jun3dPoint[points.length];
				for (int i = 0; i < _3dPoints.length; i++) {
					_3dPoints[i] = new Jun3dPoint(points[i].x(), points[i].y(), points[i].z() + 0.1);
				}
				JunOpenGL3dObject aPolygon = Jun3dPolygon.Points_(_3dPoints).asJunOpenGL3dObject();
				Color aColor = (symbol == $("pending")) ? Color.cyan : Color.magenta;
				aPolygon.paint_(aColor);

				aBody.add_(aPolygon);

				aModel.displayObject_(aBody);
				aModel.changed_($("object"));

				try {
					int time = (symbol == $("pending")) ? 300 : 900;
					Thread.sleep(time);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

				return null;
			}
		});

		aBody = new JunOpenGL3dCompoundObject();
		aBlock.value_(aBody);
		for (int i = 0; i < triangles.length; i++) {
			Jun3dPoint[] points = new Jun3dPoint[] { triangles[i].p3().plus_(new Jun3dPoint(0, 0, 0.1)), triangles[i].p2().plus_(new Jun3dPoint(0, 0, 0.1)), triangles[i].p1().plus_(new Jun3dPoint(0, 0, 0.1)) };
			JunOpenGL3dObject aPolygon = Jun3dPolygon.Points_(points).asJunOpenGL3dObject();
			aPolygon.paint_(Color.magenta);
			aBody.add_(aPolygon);
		}

		aModel.hiddenlinePresentation();
		aModel.displayObject_(aBody);
		aModel.changed_($("object"));

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Jun3dPolyline aPolyline = ExamplePolyline();
		//aPolyline.showWithUnitArrows();
		aPolyline.subdivideAsSpline().showWithUnitArrows();

		return true;
	}

	/**
	 * Example5:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Jun3dPolyline aPolyline = new Jun3dPolyline(ExamplePointCollectionOf3dSinCurve()).subdivideAsSpline();
		aPolyline.showWithAxes();

		return true;
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dPolyline
	 * @category Examples
	 */
	protected static Jun3dPolyline ExamplePolyline() {
		Jun3dPolyline lines = new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(1, 1, 1)).subdivideLevel_(2);
		double delta = 0.1;
		Jun3dLine line = new Jun3dPoint(0, 0, 0).to_(new Jun3dPoint(-1, 1, 0));
		Jun3dPoint[] points = lines.points();
		points[1] = line.translatedBy_(points[1]).atT_(-delta);
		points[3] = line.translatedBy_(points[3]).atT_(delta);
		return new Jun3dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dPolyline
	 * @category Examples
	 */
	protected static Jun3dPolyline ExamplePolyline1() {
		Jun3dPoint[] points = new Jun3dPoint[5];
		points[0] = new Jun3dPoint(50, 50, -25);
		points[1] = new Jun3dPoint(-50, 50, 25);
		points[2] = new Jun3dPoint(-50, -50, -25);
		points[3] = new Jun3dPoint(50, -50, 25);
		points[4] = points[0];
		return new Jun3dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dPolyline
	 * @category Examples
	 */
	protected static Jun3dPolyline ExamplePolyline2() {
		ArrayList aList = new ArrayList();
		aList.add(new Jun3dPoint(115, 142, 25));
		aList.add(new Jun3dPoint(109, 136, -25));
		aList.add(new Jun3dPoint(97, 119, 25));
		aList.add(new Jun3dPoint(92, 111, -25));
		aList.add(new Jun3dPoint(90, 100, 25));
		aList.add(new Jun3dPoint(95, 78, -25));
		aList.add(new Jun3dPoint(102, 64, 25));
		aList.add(new Jun3dPoint(116, 50, -25));
		aList.add(new Jun3dPoint(132, 49, 25));
		aList.add(new Jun3dPoint(142, 55, -25));
		aList.add(new Jun3dPoint(154, 66, 25));
		aList.add(new Jun3dPoint(160, 83, -25));
		aList.add(new Jun3dPoint(160, 99, 25));
		aList.add(new Jun3dPoint(156, 110, -25));
		aList.add(new Jun3dPoint(153, 123, 25));
		aList.add(new Jun3dPoint(152, 131, -25));
		aList.add(new Jun3dPoint(156, 137, 25));
		aList.add(new Jun3dPoint(165, 141, -25));
		aList.add(new Jun3dPoint(180, 144, 25));
		aList.add(new Jun3dPoint(198, 149, -25));
		aList.add(new Jun3dPoint(210, 158, 25));
		aList.add(new Jun3dPoint(215, 168, -25));
		aList.add(new Jun3dPoint(215, 182, 25));
		aList.add(new Jun3dPoint(210, 191, -25));
		aList.add(new Jun3dPoint(199, 194, 25));
		aList.add(new Jun3dPoint(183, 190, -25));
		aList.add(new Jun3dPoint(170, 184, 25));
		aList.add(new Jun3dPoint(162, 183, -25));
		aList.add(new Jun3dPoint(149, 187, 25));
		aList.add(new Jun3dPoint(140, 193, -25));
		aList.add(new Jun3dPoint(132, 199, 25));
		aList.add(new Jun3dPoint(122, 206, -25));
		aList.add(new Jun3dPoint(110, 210, 25));
		aList.add(new Jun3dPoint(96, 210, -25));
		aList.add(new Jun3dPoint(83, 207, 25));
		aList.add(new Jun3dPoint(74, 203, -25));
		aList.add(new Jun3dPoint(71, 195, 25));
		aList.add(new Jun3dPoint(73, 185, -25));
		aList.add(new Jun3dPoint(81, 178, 25));
		aList.add(new Jun3dPoint(94, 173, -25));
		aList.add(new Jun3dPoint(106, 172, 25));
		aList.add(new Jun3dPoint(112, 170, -25));
		aList.add(new Jun3dPoint(117, 169, 25));
		aList.add(new Jun3dPoint(124, 165, -25));
		aList.add(new Jun3dPoint(125, 162, 25));
		aList.add(new Jun3dPoint(125, 159, -25));

		Jun3dTransformation aTransformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-45)).product_(Jun3dTransformation.Translate_(new Jun3dPoint(100, 100, 0)));
		Jun3dPoint[] points = (Jun3dPoint[]) aList.toArray(new Jun3dPoint[aList.size()]);
		for (int i = 0; i < points.length; i++) {
			points[i] = points[i].transform_(aTransformation);
		}

		return new Jun3dPolyline(points);
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dPolyline
	 * @category Examples
	 */
	protected static Jun3dPolyline ExamplePolyline31() {
		return new Jun3dPolyline(new Jun3dPoint[] { new Jun3dPoint(59, 5, 0), new Jun3dPoint(41, 50, 0), new Jun3dPoint(113, 149, 0), new Jun3dPoint(5, 221, 0), new Jun3dPoint(5, 257, 0), new Jun3dPoint(32, 314, 0) });
	}

	/**
	 * Create an example polyline.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun2dPolyline
	 * @category Examples
	 */
	protected static Jun3dPolyline ExamplePolyline32() {
		return new Jun3dPolyline(new Jun3dPoint[] { new Jun3dPoint(194, 50, 0), new Jun3dPoint(185, 122, 0), new Jun3dPoint(149, 172, 0), new Jun3dPoint(185, 275, 0) });
	}

	/**
	 * Answer the example point collection of 3D sin curve.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Examples
	 */
	protected static Jun3dPoint[] ExamplePointCollectionOf3dSinCurve() {
		int numberOfPoints = 501;
		Collection pointCollection = new ArrayList(numberOfPoints);
		for (int i = 0; i < numberOfPoints; i++) {
			double x = i / (double) numberOfPoints;
			double y = 0.4 * Math.sin(10 * 2 * Math.PI * x);
			pointCollection.add(new Jun3dPoint(x, y, 0));
		}

		JunOpenGL3dPolyline aPolyline = new JunOpenGL3dPolyline(pointCollection);
		aPolyline = (JunOpenGL3dPolyline) JunOpenGL3dObject.From_to_with_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(3, 2, 1), aPolyline);
		Jun3dPoint[] pointArray = aPolyline.vertexes();
		return pointArray;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new Jun3dPolylineTestExamples();
	}

}
