package jp.co.sra.jun.geometry.surfaces;

import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;

/**
 * JunSphereSurface class
 * 
 *  @author    nisinaka
 *  @created   1998/11/13 (by nisinaka)
 *  @updated   2006/10/10 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun610 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSphereSurface.java,v 8.11 2008/02/20 06:30:59 nisinaka Exp $
 */
public class JunSphereSurface extends JunSurface {

	/** The center point. */
	protected Jun3dPoint center = null;

	/** The radius. */
	protected double radius = 0.0d;

	/**
	 * Create a new instance of JunSphereSurface and initialize it.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * @return jp.co.sra.jun.geometry.surfaces.JunSphereSurface
	 * @category Instance creation
	 */
	public JunSphereSurface(Jun3dPoint aPoint, double aNumber) {
		super();
		this.center_(aPoint);
		this.radius_(aNumber);
	}

	/**
	 * Create a new instance of JunSphereSurface and initialize it.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aNumber double
	 * @return jp.co.sra.jun.geometry.surfaces.JunSphereSurface
	 * @deprecated since Jun482a, use the constructor.
	 * @category Instance creation
	 */
	public static JunSphereSurface Center_radius_(Jun3dPoint aPoint, double aNumber) {
		return new JunSphereSurface(aPoint, aNumber);
	}

	/**
	 * Answer the center point of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public Jun3dPoint center() {
		return center;
	}

	/**
	 * Set the center point of the receiver.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category accessing
	 */
	public void center_(Jun3dPoint aPoint) {
		center = aPoint;
	}

	/**
	 * Answer the radius of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double radius() {
		return radius;
	}

	/**
	 * Set the radius of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void radius_(double aNumber) {
		radius = aNumber;
	}

	/**
	 * Answer true if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunSphereSurface aSphereSurface = (JunSphereSurface) anObject;
		return this.isEqualNumber_to_(this.radius(), aSphereSurface.radius()) && this.center().equal_(aSphereSurface.center());
	}

	/**
	 * Answer true if the Object is equal to the receiver, otherwise false.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunSphereSurface aSphereSurface = (JunSphereSurface) anObject;
		return this.radius() == aSphereSurface.radius() && this.center().equals(aSphereSurface.center());
	}

	/**
	 * Answer the cross points on the receiver with the specified Line.
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category functions
	 */
	public Jun3dPoint[] crossPointsWithLine_(Jun3dLine aLine) {
		Jun3dPoint nearestPointOnLine = aLine.nearestPointFromPoint_(center);
		double distance = center.distance_(nearestPointOnLine);
		if (distance > radius) {
			return new Jun3dPoint[0];
		}
		if (this.isEqualNumber_to_(distance, radius)) {
			Jun3dPoint[] points = { nearestPointOnLine };
			return points;
		}
		double shift = Math.sqrt((radius * radius) - (distance * distance));
		Jun3dPoint shiftVector = (Jun3dPoint) aLine.to().minus_(aLine.from()).unitVector().multipliedBy_(shift);
		Jun3dPoint[] points = { (Jun3dPoint) nearestPointOnLine.plus_(shiftVector), (Jun3dPoint) nearestPointOnLine.minus_(shiftVector) };
		return points;
	}

}
