package jp.co.sra.jun.geometry.transformations;

import java.awt.Color;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * Jun3dTransformationTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1998/10/30 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun3dTransformationTestExamples.java,v 8.11 2008/02/20 06:31:11 nisinaka Exp $
 */
public class Jun3dTransformationTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Jun3dPoint[][] elements = { { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, -1, 0) }, { new Jun3dPoint(1, 0, 0), new Jun3dPoint(-1, 0, 0) }, { new Jun3dPoint(0, 2, 0), new Jun3dPoint(0, 1, 0) }, { new Jun3dPoint(0, 0, 1), new Jun3dPoint(0, 0, 1) } };
		Jun3dTransformation aTransformation = Jun3dTransformation.AlignPoints_(elements);
		System.out.println(aTransformation.printString());
		System.out.println(aTransformation.storeString());

		return (aTransformation.a == -1) && (aTransformation.b == 1) && (aTransformation.c == 0) && (aTransformation.p == 0) && (aTransformation.d == 0) && (aTransformation.e == 1) && (aTransformation.f == 0) && (aTransformation.q == 0)
				&& (aTransformation.g == 0) && (aTransformation.h == 1) && (aTransformation.i == 1) && (aTransformation.r == 0) && (aTransformation.l == 0) && (aTransformation.m == -1) && (aTransformation.n == 0) && (aTransformation.s == 1);
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new Jun3dTransformationTestExamples();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1a() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1b() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.Scale_(new Jun3dPoint(1.5, 1.5, 1.5));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1c() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.Scale_(new Jun3dPoint(0.5, 0.5, 0.5));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample1d() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.Scale_(new Jun3dPoint(-1, -1, 1));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2a() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample2b() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 1.2));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3a() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3b() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3c() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.RotateY_(JunAngle.FromDeg_(30));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3d() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(30));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3e() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(30))).product_(Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(30)));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3f() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.RotateZ_(JunAngle.FromDeg_(30)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(30))).product_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(30)));
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample3g() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dLine aLine;
		Jun3dTransformation aTransformation;
		JunOpenGL3dPolyline aPolyline;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aLine = new Jun3dLine(new Jun3dPoint(0, 0, 0), characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.Rotate_around_(JunAngle.FromDeg_(30), aLine);
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		aPolyline = new JunOpenGL3dPolyline(new Jun3dPoint[] { (Jun3dPoint) aLine.atT_(-2), (Jun3dPoint) aLine.atT_(2) });
		aPolyline.paint_(Color.cyan);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.add_(aPolyline);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample4a() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ManualExample4b() {
		JunOpenGL3dObject characterN;
		JunOpenGL3dObject pointP;
		JunOpenGL3dObject xyzAxes;
		Jun3dTransformation aTransformation;
		JunOpenGL3dCompoundObject compoundObject;

		characterN = JunOpenGL3dObject.CharacterN();
		characterN.paint_(Color.magenta);
		characterN = characterN.translatedBy_(characterN.boundingBox().corner());
		pointP = JunOpenGL3dObject.Cube();
		pointP = pointP.scaledBy_(0.1);
		pointP = pointP.translatedBy_(characterN.boundingBox().corner());
		aTransformation = Jun3dTransformation.FromArray_(new double[] { 1, 0, 0, 0, 0, 1, 0, 0, 0, 0.5, 1, 0, 0, 0, 0, 1 });
		characterN = characterN.transform_(aTransformation);
		pointP = pointP.transform_(aTransformation);
		xyzAxes = JunOpenGL3dObject.Axes();
		xyzAxes = xyzAxes.scaledBy_(3.5);
		compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(characterN);
		compoundObject.add_(xyzAxes);
		compoundObject.add_(pointP);
		compoundObject.show();
		System.out.println(pointP.boundingBox().center().printString());

		return true;
	}
}
