package jp.co.sra.jun.goodies.bulletinboard;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunBulletinBoardTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2002/11/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun629 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBulletinBoardTestExamples.java,v 8.12 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunBulletinBoardTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		aBulletinBoard.color_(Color.red);
		aBulletinBoard.add_(" Java ");
		aBulletinBoard.color_(Color.green);
		aBulletinBoard.add_(" Applet ");
		aBulletinBoard.color_(Color.blue);
		aBulletinBoard.add_(" Swing ");

		Frame aFrame = new Frame();
		aFrame.setTitle("JunBulletinBoard");
		Canvas aCanvas = new Canvas();
		aCanvas.setBounds(0, 0, 200, aBulletinBoard.height());
		aFrame.add(aCanvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		Graphics aGraphics = aCanvas.getGraphics();
		try {
			int width = aBulletinBoard.width();
			for (int x = 0; x <= width; x++) {
				aGraphics.drawImage(aBulletinBoard.imageLocation_width_(x, 200), 0, 0, null);

				try {
					Thread.sleep(10);
				} catch (InterruptedException e) {
				}
			}
		} finally {
			aGraphics.dispose();
			aFrame.dispose();
		}

		return true;
	}

	/**
	 * Example2: Open a bulletin board.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		aBulletinBoard.color_(Color.red);
		aBulletinBoard.add_(" Java ");
		aBulletinBoard.color_(Color.green);
		aBulletinBoard.add_(" Applet ");
		aBulletinBoard.color_(Color.blue);
		aBulletinBoard.add_(" Swing ");

		aBulletinBoard.open();

		return true;
	}

	/**
	 * Example2: Open an AWT view on a model of bulletin board.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2_Awt() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		aBulletinBoard.color_(Color.red);
		aBulletinBoard.add_(" Java ");
		aBulletinBoard.color_(Color.green);
		aBulletinBoard.add_(" Applet ");
		aBulletinBoard.color_(Color.blue);
		aBulletinBoard.add_(" Swing ");

		JunBulletinBoardViewAwt.OpenOn_(aBulletinBoard);

		return true;
	}

	/**
	 * Example2: Open a Swing view on a model of bulletin board.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2_Swing() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		aBulletinBoard.color_(Color.red);
		aBulletinBoard.add_(" Java ");
		aBulletinBoard.color_(Color.green);
		aBulletinBoard.add_(" Applet ");
		aBulletinBoard.color_(Color.blue);
		aBulletinBoard.add_(" Swing ");

		JunBulletinBoardViewSwing.OpenOn_(aBulletinBoard);

		return true;
	}

	/**
	 * Example3: Open a bulletin board.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		String aString = "Java Applet Swing";
		int length = aString.length();
		for (int i = 0; i < length; i++) {
			aBulletinBoard.color_(Color.getHSBColor((float) i / length, 1, 1));
			aBulletinBoard.add_(aString.charAt(i));
		}

		aBulletinBoard.open();

		return true;
	}

	/**
	 * Example3: Open an AWT view on a model of bulletin board.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3_Awt() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		String aString = "Java Applet Swing";
		int length = aString.length();
		for (int i = 0; i < length; i++) {
			aBulletinBoard.color_(Color.getHSBColor((float) i / length, 1, 1));
			aBulletinBoard.add_(aString.charAt(i));
		}

		JunBulletinBoardViewAwt.OpenOn_(aBulletinBoard);

		return true;
	}

	/**
	 * Example3: Open a Swing view on a model of bulletin board.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3_Swing() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();
		String aString = "Java Applet Swing";
		int length = aString.length();
		for (int i = 0; i < length; i++) {
			aBulletinBoard.color_(Color.getHSBColor((float) i / length, 1, 1));
			aBulletinBoard.add_(aString.charAt(i));
		}

		JunBulletinBoardViewSwing.OpenOn_(aBulletinBoard);

		return true;
	}

	/**
	 * Example4: Open a bulletin board.
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunBulletinBoard aBulletinBoard = new JunBulletinBoard();

		StringWriter sw = new StringWriter();
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(new BufferedWriter(sw));
			pw.println("Jun for Java");
			pw.println();
			pw.println();
			pw.println(" \"Jun for Java\" is a Java class library that supports 3D");
			pw.println(" geometry, topology, and multimedia.  Current commercially");
			pw.println(" available 3D graphic libraries have almost exclusively focused");
			pw.println(" on geometry in order to increase rendering performance, and do");
			pw.println(" not handle topology well.  A few 3D graphic libraries that can");
			pw.println(" handle both geometry and topology do exist but are very");
			pw.println(" expensive and thus limited to professional usage.  The goal of");
			pw.println(" Jun is to allow regular programmers to create, modify, and");
			pw.println(" combine 3D objects without having to learn the complexities of");
			pw.println(" mathematics and rendering.  In addition, Jun supports");
			pw.println(" multimedia data such as movies and sound.  A user can write a");
			pw.println(" program that plays multiple movies concurrently and places");
			pw.println(" movie frames in a 3D space.");
		} finally {
			if (pw != null) {
				pw.flush();
				pw.close();
			}
		}
		String aString = JunBulletinBoard.ConvertToFlatString_(sw.toString());
		int length = aString.length();
		for (int i = 0; i < length; i++) {
			aBulletinBoard.color_(Color.getHSBColor((float) i / length, 1, 1));
			aBulletinBoard.add_(aString.charAt(i));
		}

		aBulletinBoard.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunBulletinBoardTestExamples();
	}
}
