package jp.co.sra.jun.goodies.button;

import java.awt.Color;
import java.awt.Graphics;

import jp.co.sra.smalltalk.StController;

/**
 * JunButtonWithMenuViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/01/27 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun541 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunButtonWithMenuViewSwing.java,v 8.10 2008/02/20 06:31:11 nisinaka Exp $
 */
public class JunButtonWithMenuViewSwing extends JunButtonViewSwing implements JunButtonWithMenuView {

	/**
	 * Create a new instance of JunButtonWithMenuViewSwing and initialize it.
	 *
	 * @param aButtonWithMenuModel jp.co.sra.jun.goodies.JunButtonWithMenuModel
	 * @category Instance creation
	 */
	public JunButtonWithMenuViewSwing(JunButtonWithMenuModel aButtonWithMenuModel) {
		super(aButtonWithMenuModel);
	}

	/**
	 * Answer my model as JunButtonWithMenuModel.
	 * 
	 * @return jp.co.sra.jun.goodies.JunButtonWithMenuModel
	 * @see jp.co.sra.jun.goodies.button.JunButtonWithMenuView#getButtonWithMenuModel()
	 * @category model accessing
	 */
	public JunButtonWithMenuModel getButtonWithMenuModel() {
		return (JunButtonWithMenuModel) this.model();
	}

	/**
	 * Answer my default controller
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewCanvas#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunButtonWithMenuController();
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.isShowing() == false) {
			return;
		}

		super.displayOn_(aGraphics);

		if (this.getButtonWithMenuModel().markerDisplaying()) {
			if (this.getButtonWithMenuModel().menu() != null) {
				this.displayMarkerOn_(aGraphics);
			}
		}
	}

	/**
	 * Display the marker on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayMarkerOn_(Graphics aGraphics) {
		if (this.getButtonWithMenuModel().value()) {
			aGraphics.setColor(Color.white);
		} else {
			aGraphics.setColor(Color.black);
		}

		int x = this.getSize().width;
		int y = 0;
		int[] xPoints = new int[] { x - 6, x - 2, x - 2 };
		int[] yPoints = new int[] { y + 2, y + 2, y + 6 };
		aGraphics.fillPolygon(xPoints, yPoints, 3);
	}

	/**
	 * Show the popup menu at the specified point on the view.
	 *
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.smalltalk.StView#_showPopupMenu(int, int)
	 * @category popup menu
	 */
	public void _showPopupMenu(int x, int y) {
		if (this.isShowing()) {
			super._showPopupMenu(this.getWidth(), 0);
		}
	}

}
