package jp.co.sra.jun.goodies.calendar;

import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunCalendarClockTimeViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarClockTimeViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarClockTimeViewAwt extends JunAbstractViewPanel implements JunCalendarClockTimeView {

	protected JunCalendarTimeViewAwt timeView;

	/**
	 * Create a new instance of <code>JunCalendarClockTimeViewAwt</code> and initialize it.
	 * 
	 * @param aCalendarClockTime JunCalendarClockTime
	 * @category Instance creation
	 */
	public JunCalendarClockTimeViewAwt(JunCalendarClockTime aCalendarClockTime) {
		super(aCalendarClockTime);
	}

	/**
	 * Answer my date view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	public JunCalendarTimeViewAwt timeView() {
		if (timeView == null) {
			timeView = new JunCalendarTimeViewAwt(this.getModel().calendarTimeModel());
		}
		return timeView;
	}

	/**
	 * Get model.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarClockTime getModel() {
		return (JunCalendarClockTime) this.model();
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.timeView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
		this.setSize(150, 200);
	}

}
