package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateAndTimeDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeDialogTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeDialogTestExamples extends JunTestExamples {
	/**
	 * Example1: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateAndTimeModel dateAndTime = JunCalendarDateAndTimeDialog.Request();
		System.out.println(dateAndTime);
		return true;
	}

	/**
	 * Example2: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarDateAndTimeModel answer = JunCalendarDateAndTimeDialog.Request_(JunSystem.$String("Select date and time."));
		if (answer != null) {
			System.out.println(answer);
		}
		return true;
	}

	/**
	 * Example3: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		Calendar[] dateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		dateAndTime[0].add(Calendar.DATE, 7);
		dateAndTime[1].add(Calendar.SECOND, 60 * 60);
		JunCalendarDateAndTimeModel answer = JunCalendarDateAndTimeDialog.Request_initialDateAndTime_(JunSystem.$String("Select date and time."), dateAndTime);
		if (answer != null) {
			System.out.println(answer);
		}
		return true;
	}

	/**
	 * Example4: Call Request().
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		Calendar[] dateAndTime = { Calendar.getInstance(), Calendar.getInstance() };
		dateAndTime[0].add(Calendar.DATE, 7);
		dateAndTime[1].add(Calendar.SECOND, 60 * 60);
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateAndTimeModel dateAndTimeModel = (JunCalendarDateAndTimeModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + dateAndTimeModel);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarDateAndTimeModel dateAndTimeModel = (JunCalendarDateAndTimeModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + dateAndTimeModel);
				return (Object) Boolean.TRUE;
			}
		};
		JunCalendarDateAndTimeModel answer = JunCalendarDateAndTimeDialog.Request_initialDateAndTime_onAccept_onCancel_(JunSystem.$String("Select date and time."), dateAndTime, acceptBlock, cancelBlock);
		if (answer != null) {
			System.out.println(answer);
		}
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarDateAndTimeDialogTestExamples();
	}
}
