package jp.co.sra.jun.goodies.calendar;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Calendar;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;

/**
 * JunCalendarDateAndTimeModel class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeModel.java,v 8.14 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeModel extends JunCalendarModel {
	protected JunCalendarDateModel calendarDateModel;
	protected JunCalendarTimeModel calendarTimeModel;
	protected StBlockClosure validateBlock;

	/**
	 * Create a new instance of <code>JunCalendarDateAndTimeModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarDateAndTimeModel() {
		Calendar[] dateAndTime = new Calendar[2];
		dateAndTime[0] = Calendar.getInstance();
		dateAndTime[1] = Calendar.getInstance();
		this.dateAndTime_(dateAndTime);
	}

	/**
	 * Create instance and set date aDate.
	 *
	 * @param aDate java.util.Calendar
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Date_(Calendar aDate) {
		return JunCalendarDateAndTimeModel.Date_time_(aDate, Calendar.getInstance());
	}

	/**
	 * Ceate instance and set date aDate set time aTime.
	 *
	 * @param aDate java.util.Calendar
	 * @param aTime java.util.Calendar
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Date_time_(Calendar aDate, Calendar aTime) {
		JunCalendarDateAndTimeModel calendarDateAndTimeModel = new JunCalendarDateAndTimeModel();
		calendarDateAndTimeModel.calendarDateModel().date_(aDate);
		calendarDateAndTimeModel.calendarTimeModel().time_(aTime);
		return calendarDateAndTimeModel;
	}

	/**
	 * Create instance and set date and time of aDate.
	 *
	 * @param dateAndTime java.util.Calendar[]
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel DateAndTime_(Calendar[] dateAndTime) {
		return JunCalendarDateAndTimeModel.Date_time_(dateAndTime[0], dateAndTime[1]);
	}

	/**
	 * Create instance and set hour, minute and second.
	 *
	 * @param hour int
	 * @param minute int
	 * @param second int
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Hours_minutes_seconds_(int hour, int minute, int second) {
		Calendar aTime = (JunCalendarTimeModel.Hours_minutes_seconds_(hour, minute, second)).time();
		return JunCalendarDateAndTimeModel.Time_(aTime);
	}

	/**
	 * Create instance and set time aTime.
	 *
	 * @param aTime java.util.Calendar
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Time_(Calendar aTime) {
		return JunCalendarDateAndTimeModel.Date_time_(Calendar.getInstance(), aTime);
	}

	/**
	 * Create instance and set year, month and day.
	 *
	 * @param year int
	 * @param month int
	 * @param day int
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Year_month_day_(int year, int month, int day) {
		Calendar aDate = (JunCalendarDateModel.Year_month_day_(year, month, day)).date();
		return JunCalendarDateAndTimeModel.Date_(aDate);
	}

	/**
	 * Create instance and set year, month, day, hour, minute and second.
	 *
	 * @param year int
	 * @param month int
	 * @param day int
	 * @param hour int
	 * @param minute int
	 * @param second int
	 * @return JunCalendarDateAndTimeModel
	 * @category Utilities
	 */
	public static JunCalendarDateAndTimeModel Year_month_day_hours_minutes_seconds_(int year, int month, int day, int hour, int minute, int second) {
		Calendar aDate = (JunCalendarDateModel.Year_month_day_(year, month, day)).date();
		Calendar aTime = (JunCalendarTimeModel.Hours_minutes_seconds_(hour, minute, second)).time();
		return JunCalendarDateAndTimeModel.Date_time_(aDate, aTime);
	}

	/**
	 * Return JunCalendarDateModel.
	 *
	 * @return JunCalendarDateModel
	 * @category accessing
	 */
	public JunCalendarDateModel calendarDateModel() {
		if (calendarDateModel == null) {
			calendarDateModel = new JunCalendarDateModel();
			final JunCalendarDateAndTimeModel this_ = this;
			calendarDateModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldDate, Object newDate) {
					return this_.validateDate_with_((Calendar) oldDate, (Calendar) newDate);
				}
			});
		}
		return calendarDateModel;
	}

	/**
	 * Return JunCalendarTimeModel.
	 *
	 * @return JunCalendarTimeModel
	 * @category accessing
	 */
	public JunCalendarTimeModel calendarTimeModel() {
		if (calendarTimeModel == null) {
			calendarTimeModel = new JunCalendarTimeModel();
			final JunCalendarDateAndTimeModel this_ = this;
			calendarTimeModel.validateBlock_(new StBlockClosure() {
				public Object value_value_(Object oldTime, Object newTime) {
					return this_.validateTime_with_((Calendar) oldTime, (Calendar) newTime);
				}
			});
		}
		return calendarTimeModel;
	}

	/**
	 * Return date and time.
	 *
	 * @return Object[]
	 * @category accessing
	 */
	public Calendar[] dateAndTime() {
		Calendar[] aDateAndTime = new Calendar[2];
		aDateAndTime[0] = this.calendarDateModel().date();
		aDateAndTime[1] = this.calendarTimeModel().time();
		return aDateAndTime;
	}

	/**
	 * Set date and time.
	 *
	 * @param dateAndTime Object[]
	 * @category accessing
	 */
	public void dateAndTime_(Calendar[] dateAndTime) {
		Calendar[] oldDateAndTime = (Calendar[]) this.dateAndTime().clone();
		Calendar[] newDateAndTime = (Calendar[]) this.validateBlock().value_value_(oldDateAndTime, dateAndTime);
		if (newDateAndTime == null) {
			return;
		}
		oldDateAndTime = this.dateAndTime();
		this.setDate_((Calendar) dateAndTime[0]);
		this.setTime_((Calendar) dateAndTime[1]);
		if (oldDateAndTime != this.dateAndTime()) {
			this.changed_($("dateAndTime"));
			this.updateDateModel_((Calendar) oldDateAndTime[0]);
			this.updateTimeModel_((Calendar) oldDateAndTime[1]);
		}
	}

	/**
	 * Return a validate block.
	 *
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public StBlockClosure validateBlock() {
		if (validateBlock == null) {
			validateBlock = new StBlockClosure() {
				public Object value_value_(Object oldDateAndTime, Object newDateAndTime) {
					return newDateAndTime;
				}
			};
		}
		return validateBlock;
	}

	/**
	 * Set aBlock.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void validateBlock_(StBlockClosure aBlock) {
		validateBlock = aBlock;
	}

	/**
	 * Menu message.
	 * @category menu messages
	 */
	public void copyDateAndTime() {
		StringBuffer buf = new StringBuffer();
		Calendar aDate = (Calendar) this.dateAndTime()[0];
		Calendar aTime = (Calendar) this.dateAndTime()[1];
		buf.append(aDate.get(Calendar.MONTH));
		buf.append(" ");
		buf.append(aDate.get(Calendar.DATE));
		buf.append(", ");
		buf.append(aDate.get(Calendar.YEAR));
		buf.append(" ");
		buf.append(aTime.get(Calendar.HOUR));
		buf.append(":");
		buf.append(aTime.get(Calendar.MINUTE));
		buf.append(":");
		buf.append(aTime.get(Calendar.SECOND));
		buf.append(" ");
		if (aTime.get(Calendar.AM_PM) == 1) {
			buf.append("PM");
		} else {
			buf.append("AM");
		}
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(buf.toString()), null);
	}

	/**
	 * Set date aDate.
	 *
	 * @param aDate java.util.Calendar
	 * @category private
	 */
	private void setDate_(Calendar aDate) {
		this.calendarDateModel().date_(aDate);
	}

	/**
	 * Set time aTime.
	 *
	 * @param aTime java.util.Calendar
	 * @category private
	 */
	private void setTime_(Calendar aTime) {
		this.calendarTimeModel().setTime_(aTime);
	}

	/**
	 * Update a dateModel.
	 *
	 * @param oldDate java.util.Calendar
	 * @category private
	 */
	private void updateDateModel_(Calendar oldDate) {
		if (oldDate.get(Calendar.YEAR) != this.calendarDateModel().year()) {
			this.calendarDateModel().changed_($("year"));
			return;
		}
		if (oldDate.get(Calendar.MONTH) != this.calendarDateModel().month() - 1) {
			this.calendarDateModel().changed_($("month"));
			return;
		}
		if (oldDate.get(Calendar.DATE) != this.calendarDateModel().day()) {
			this.calendarDateModel().changed_($("day"));
			return;
		}
	}

	/**
	 * Uptime a timeModel.
	 *
	 * @param oldTime java.util.Calendar
	 * @category private
	 */
	private void updateTimeModel_(Calendar oldTime) {
		if (oldTime.get(Calendar.HOUR) != this.calendarTimeModel().hours()) {
			this.calendarTimeModel().changed_($("hours"));
			return;
		}
		if (oldTime.get(Calendar.MINUTE) != this.calendarTimeModel().minutes()) {
			this.calendarTimeModel().changed_($("minutes"));
			return;
		}
		if (oldTime.get(Calendar.SECOND) != this.calendarTimeModel().seconds()) {
			this.calendarTimeModel().changed_($("seconds"));
			return;
		}
	}

	/**
	 * Validate date old date with new date.
	 *
	 * @param oldDate java.util.Calendar
	 * @param newDate java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateDate_with_(Calendar oldDate, Calendar newDate) {
		Calendar[] oldArray = { oldDate, this.calendarTimeModel.time() };
		Calendar[] newArray = { newDate, this.calendarTimeModel.time() };
		Calendar[] dateAndTime = (Calendar[]) this.validateBlock.value_value_((Object) oldArray, (Object) newArray);
		this.calendarDateModel().setDate_(dateAndTime[0]);
		this.calendarTimeModel().setTime_(dateAndTime[1]);
		this.changed_($("dateAndTime"));
		this.updateDateModel_(dateAndTime[0]);
		this.updateTimeModel_(dateAndTime[1]);
		return dateAndTime[0];
	}

	/**
	 * Validate time old time with new time.
	 *
	 * @param oldTime java.util.Calendar
	 * @param newTime java.util.Calendar
	 * @return java.util.Calendar
	 * @category private
	 */
	private Calendar validateTime_with_(Calendar oldTime, Calendar newTime) {
		Calendar[] oldArray = { this.calendarDateModel.date(), oldTime };
		Calendar[] newArray = { this.calendarDateModel.date(), newTime };
		Calendar[] dateAndTime = (Calendar[]) this.validateBlock.value_value_((Object) oldArray, (Object) newArray);
		this.changed_($("dateAndTime"));
		this.updateDateModel_(dateAndTime[0]);
		this.updateTimeModel_(dateAndTime[1]);
		return dateAndTime[1];
	}

	/**
	 * Default view.
	 *
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarDateAndTimeView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarDateAndTimeViewAwt(this);
		} else {
			aView = new JunCalendarDateAndTimeViewSwing(this);
		}
		return aView;
	}

	/**
	 * Return Window title.
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Date and Time");
	}

	/**
	 * Return date and time to string
	 * @return java.lang.String
	 * @category printing
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(this.calendarDateModel());
		buf.append(" ");
		buf.append(this.calendarTimeModel());
		return buf.toString();
	}
}
