package jp.co.sra.jun.goodies.calendar;

import java.awt.Toolkit;
import java.awt.datatransfer.*;
import java.io.IOException;
import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateAndTimeModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateAndTimeModelTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateAndTimeModelTestExamples extends JunTestExamples {
	/**
	 * Example2: Set up and open a JunCalendarDateAndTime.
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		JunCalendarDateAndTimeModel cal = JunCalendarDateAndTimeModel.Year_month_day_hours_minutes_seconds_(1999, 11, 11, 23, 59, 59);
		cal.open();
		return true;
	}

	/**
	 * Example2: Create a instance of JunCalendarDateAndTimeModel.
	 * And print standard out self. Copy date and time and print out standard out.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarDateAndTimeModel calendarDateAndTimeModel = new JunCalendarDateAndTimeModel();
		System.out.println(calendarDateAndTimeModel);
		calendarDateAndTimeModel.copyDateAndTime();
		Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
		try {
			System.out.println((String) (clip.getContents(null).getTransferData(DataFlavor.stringFlavor)));
		} catch (IOException e) {
			throw new SmalltalkException(e);
		} catch (UnsupportedFlavorException e) {
			throw new SmalltalkException(e);
		}
		return true;
	}

	/**
	 * Example1: Open a JunCalendarDateAndTime.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateAndTimeModel cal = new JunCalendarDateAndTimeModel();
		cal.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(String args[]) {
		new JunCalendarDateAndTimeModelTestExamples();
	}
}
