package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarTimeIntervalDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeIntervalDialogTestExamples.java,v 8.10 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeIntervalDialogTestExamples extends JunTestExamples {
	/**
	 * Example1
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarTimeModel[] answer = JunCalendarTimeIntervalDialog.Request();
		if (answer == null) {
			return true;
		}
		System.out.println(answer[0]);
		System.out.println(answer[1]);
		return true;
	}

	/**
	 * Example2
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		JunCalendarTimeModel[] answer = JunCalendarTimeIntervalDialog.Request_(JunSystem.$String("Select period."));
		if (answer == null) {
			return true;
		}
		System.out.println(answer[0]);
		System.out.println(answer[1]);
		return true;
	}

	/**
	 * Example3
	 *
	 * @return boolean
	 */
	public static boolean Example3() {
		Calendar[] times = new Calendar[2];
		times[0] = Calendar.getInstance();
		times[1] = Calendar.getInstance();
		times[1].add(Calendar.SECOND, 14);
		JunCalendarTimeModel[] answer = JunCalendarTimeIntervalDialog.Request_initialTime_(JunSystem.$String("Select period."), times);
		if (answer == null) {
			return true;
		}
		System.out.println(answer[0]);
		System.out.println(answer[1]);
		return true;
	}

	/**
	 * Example4
	 *
	 * @return boolean
	 */
	public static boolean Example4() {
		Calendar[] times = new Calendar[2];
		times[0] = Calendar.getInstance();
		times[0].add(Calendar.SECOND, -100);
		times[1] = Calendar.getInstance();
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarTimeIntervalModel timeIntervalModel = (JunCalendarTimeIntervalModel) aModel;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println("	" + timeIntervalModel.times()[0] + " " + timeIntervalModel.times()[1]);
				return (Object) Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object aModel) {
				JunCalendarTimeIntervalModel timeIntervalModel = (JunCalendarTimeIntervalModel) aModel;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println("	" + timeIntervalModel.times()[0] + " " + timeIntervalModel.times()[1]);
				return (Object) Boolean.TRUE;
			}
		};
		JunCalendarTimeModel[] answer = JunCalendarTimeIntervalDialog.Request_initialTime_onAccept_onCancel_(JunSystem.$String("Select period."), times, acceptBlock, cancelBlock);
		if (answer == null) {
			return true;
		}
		System.out.println(answer[0]);
		System.out.println(answer[1]);
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line argumetns
	 */
	public static void main(java.lang.String[] args) {
		new JunCalendarTimeIntervalDialogTestExamples();
	}
}
